/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Buttons;
import board.Capture;
import board.Main;
import board.MainPanel;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class MyMenuBar
extends MenuBar
implements ActionListener {
    MainPanel panel;

    public MyMenuBar(MainPanel _panel) {
        Menu menu;
        this.panel = _panel;
        this.setFont(Buttons.font);
        if (Main.isEnglish) {
            menu = new Menu("File");
            menu.add(new MyMenuItem("load", this));
            menu.add(new MyMenuItem("save", this));
            menu.add(new MyMenuItem("exit", this));
            this.add(menu);
        }
        if (Main.isEnglish) {
            menu = new Menu("Display");
            menu.add(new MyMenuItem("ChangeMode", this));
            this.add(menu);
        }
        if (Main.isEnglish) {
            menu = new Menu("Option");
            menu.add(new MyMenuItem("textile", this));
            menu.add(new MyMenuItem("texture", this));
            this.add(menu);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (!(object instanceof MyMenuItem)) {
            return;
        }
        String label = ((MenuItem)object).getLabel();
        if (label.equals("load") || label.equals("\u958b\u304f")) {
            this.panel.load();
        } else if (label.equals("save") || label.equals("\u4fdd\u5b58")) {
            this.panel.save();
        } else if (label.equals("exit")) {
            System.exit(0);
        } else if (label.equals("load image") || label.equals("\u753b\u50cf\u8aad\u8fbc")) {
            this.panel.load_image();
        } else if (label.equals("clear image") || label.equals("\u753b\u50cf\u6d88\u53bb")) {
            this.panel.clear_image();
        } else if (label.equals("textile")) {
            Main.textilePanel.construct_textile();
        } else if (label.equals("texture")) {
            Main.textilePanel.change_texture_or_not();
        } else if (label.equals("capture") || label.equals("\u753b\u50cf\u4fdd\u5b58")) {
            try {
                Capture.run();
            }
            catch (Exception exception) {}
        } else if (label.equals("ChangeMode")) {
            MainPanel.change_mode();
        } else if (label.equals("color/BF")) {
            MainPanel.change_colorful_or_boolean();
        }
        this.panel.repaint_all();
    }

    class MyMenuItem
    extends MenuItem {
        MyMenuItem(String label, ActionListener listener) {
            this.setLabel(label);
            this.addActionListener(listener);
        }
    }
}

