/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Card;
import board.File;
import board.Main;
import board.MainPanel;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class HowToMakeCanvas {
    static String filename = "./images/blend_line7.jpg";
    static List<Card> paint_order_cards = new ArrayList<Card>();
    static Point prev;
    static Card pickedCard;

    static void init() {
        HowToMakeCanvas.load_image();
    }

    public static void load_image() {
        Image image = File.load_image(filename);
        int new_width = Main.mainPanel.getSize().width;
        int new_height = Main.mainPanel.getSize().height;
        Image new_image = Main.mainPanel.createImage(new_width, new_height);
        new_image.getGraphics().drawImage(image.getScaledInstance(image.getWidth(null), image.getHeight(null), 16), 0, 0, new_width, new_height, null);
        MainPanel.bg_image = new_image;
        Main.mainPanel.repaint_all();
    }

    static void paint_cards(Graphics g) {
        int i = 0;
        while (i < paint_order_cards.size()) {
            Card card = paint_order_cards.get(i);
            card.paint(g);
            if (card.direction == 1) {
                card.paint_through_yarn_down(g);
            } else if (card.direction == 0) {
                card.paint_through_yarn_up(g);
            }
            ++i;
        }
    }

    static Card picked_card(Point p) {
        int i = paint_order_cards.size() - 1;
        while (i >= 0) {
            Card card = paint_order_cards.get(i);
            boolean inside = card.bbox.contains(p);
            if (inside) {
                return card;
            }
            --i;
        }
        return null;
    }

    public static void mousePressed(Point p) {
        pickedCard = HowToMakeCanvas.picked_card(p);
        if (pickedCard != null) {
            paint_order_cards.remove(pickedCard);
            paint_order_cards.add(pickedCard);
        }
        prev = p;
        Main.mainPanel.repaint();
    }

    public static void mouseDragged(Point p) {
        if (pickedCard == null) {
            return;
        }
        pickedCard.move(p.x - HowToMakeCanvas.prev.x, p.y - HowToMakeCanvas.prev.y);
        prev = p;
        Main.mainPanel.repaint();
    }

    public static void mouseReleased(Point _p) {
        Main.mainPanel.repaint();
    }
}

