/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Capture;
import board.Card;
import board.ColorPalette;
import board.DesignCanvas;
import board.ToolPanel;
import board.Yarn;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Finish {
    static int[] color_count = new int[ColorPalette.colors.length];
    static boolean paint = false;

    public static void run() {
        System.out.println("Finish.run");
        Capture.run();
        Finish.calc_the_number_of_yarn();
        paint = true;
    }

    public static void calc_the_number_of_yarn() {
        color_count = new int[ColorPalette.colors.length];
        int i = 0;
        while (i < color_count.length) {
            Finish.color_count[i] = 0;
            ++i;
        }
        i = 0;
        while (i < DesignCanvas.cards.size()) {
            Card card = DesignCanvas.cards.get(i);
            int j = 0;
            while (j < card.yarns.size()) {
                int color_index;
                Yarn yarn = card.yarns.get(j);
                int n = color_index = ColorPalette.get_color_index(yarn.color);
                color_count[n] = color_count[n] + 1;
                ++j;
            }
            ++i;
        }
    }

    public static void paint(Graphics g) {
        if (!paint) {
            return;
        }
        g.setColor(new Color(250, 250, 250, 250));
        Rectangle rect = new Rectangle(200, 400, 300, 50);
        g.fillRoundRect(rect.x, rect.y, rect.width, rect.height, 5, 5);
        int count = 0;
        int oval_size = 10;
        int i = 0;
        while (i < color_count.length) {
            if (color_count[i] != 0) {
                Color color = ColorPalette.colors[i];
                g.setColor(color);
                g.fillOval(rect.x + 20 + 20 * (3 * count + 0) - oval_size, rect.y + 30 - oval_size, oval_size * 2, oval_size * 2);
                if (ToolPanel.nearWhite(color)) {
                    g.setColor(Color.black);
                    g.drawOval(rect.x + 20 + 20 * (3 * count + 0) - oval_size, rect.y + 30 - oval_size, oval_size * 2, oval_size * 2);
                }
                g.setColor(Color.black);
                g.drawString("" + color_count[i], rect.x + 20 + 20 * (3 * count + 1), rect.y + 30);
                ++count;
            }
            ++i;
        }
    }
}

