/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Card;
import board.Cursors;
import board.DesignCanvas;
import board.Main;
import board.Util;
import board.Yarn;
import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Point2D;

public class Fill {
    static boolean[][] visited = new boolean[DesignCanvas.cards.size()][DesignCanvas.number_of_holes];
    static Color prev_color;

    public static void fill(Point p) {
        if (Main.boolean_mode) {
            Fill.fill_BF(p);
        } else {
            Fill.fill_DesignCanvas(p);
        }
    }

    public static void fill_DesignCanvas(Point p) {
        Main.f.setCursor(Cursors.busyCursor);
        visited = new boolean[DesignCanvas.cards.size()][4];
        int i = 0;
        while (i < DesignCanvas.cards.size()) {
            int j = 0;
            while (j < 4) {
                Fill.visited[i][j] = false;
                ++j;
            }
            ++i;
        }
        Yarn yarn = DesignCanvas.pick_yarn(p);
        prev_color = yarn.color;
        Fill.fill_spread_8(yarn);
        Main.f.setCursor(Cursors.bucketCursor);
    }

    static void fill_spread_4(Yarn yarn) {
        int index = yarn.card.index;
        int label = yarn.label;
        Fill.visited[index][label] = true;
        if (yarn.color != prev_color) {
            return;
        }
        yarn.change_color();
        if (!yarn.visible) {
            yarn = yarn.parent_yarn;
        }
        if (index != 0) {
            Card left_card = DesignCanvas.cards.get(index - 1);
            Yarn left_yarn = left_card.getYarn(label);
            Fill.fill_spread_4(left_yarn);
        }
        if (index != DesignCanvas.cards.size() - 1) {
            Card right_card = DesignCanvas.cards.get(index + 1);
            Yarn right_yarn = right_card.getYarn(label);
            Fill.fill_spread_4(right_yarn);
        }
        Yarn top_yarn = yarn.card.getYarn(Util.mod(label - 1, 4));
        Fill.fill_spread_4(top_yarn);
        Yarn bottom_yarn = yarn.card.getYarn(Util.mod(label + 1, 4));
        Fill.fill_spread_4(bottom_yarn);
    }

    static void fill_spread_8(Yarn yarn) {
        int i;
        int index = yarn.card.index;
        int label = yarn.label;
        if (yarn.color != prev_color) {
            return;
        }
        yarn.change_color();
        if (!yarn.visible) {
            yarn = yarn.parent_yarn;
        }
        if (index != 0) {
            Card left_card = DesignCanvas.cards.get(index - 1);
            i = -1;
            while (i <= 1) {
                Yarn left_yarn = left_card.getYarn(Util.mod(label + i, DesignCanvas.number_of_holes));
                Fill.fill_spread_8(left_yarn);
                ++i;
            }
        }
        if (index != DesignCanvas.cards.size() - 1) {
            Card right_card = DesignCanvas.cards.get(index + 1);
            i = -1;
            while (i <= 1) {
                Yarn right_yarn = right_card.getYarn(Util.mod(label + i, DesignCanvas.number_of_holes));
                Fill.fill_spread_8(right_yarn);
                ++i;
            }
        }
        Yarn top_yarn = yarn.card.getYarn(Util.mod(label - 1, DesignCanvas.number_of_holes));
        Fill.fill_spread_8(top_yarn);
        Yarn bottom_yarn = yarn.card.getYarn(Util.mod(label + 1, DesignCanvas.number_of_holes));
        Fill.fill_spread_8(bottom_yarn);
    }

    static void fill_spread_BFmode(Yarn yarn) {
        int i;
        int index = yarn.card.index;
        int label = yarn.label;
        System.out.println("FILL  index " + index + ", label" + label);
        if (index != 0) {
            Card left_card = DesignCanvas.cards.get(index - 1);
            i = -1;
            while (i <= 1) {
                Yarn left_yarn;
                if (label + i >= 0 && label + i < DesignCanvas.number_of_holes && Fill.isNext(left_yarn = left_card.getYarn(label + i), yarn)) {
                    if (yarn.back && !left_yarn.back) {
                        left_yarn.back = true;
                        Fill.fill_spread_BFmode(left_yarn);
                    } else if (!yarn.back && left_yarn.back) {
                        left_yarn.back = false;
                        Fill.fill_spread_BFmode(left_yarn);
                    }
                }
                ++i;
            }
        }
        if (index != DesignCanvas.cards.size() - 1) {
            Card right_card = DesignCanvas.cards.get(index + 1);
            i = -1;
            while (i <= 1) {
                Yarn right_yarn;
                if (label + i >= 0 && label + i < DesignCanvas.number_of_holes && Fill.isNext(right_yarn = right_card.getYarn(label + i), yarn)) {
                    if (yarn.back && !right_yarn.back) {
                        right_yarn.back = true;
                        Fill.fill_spread_BFmode(right_yarn);
                    } else if (!yarn.back && right_yarn.back) {
                        right_yarn.back = false;
                        Fill.fill_spread_BFmode(right_yarn);
                    }
                }
                ++i;
            }
        }
        if (label != 0) {
            Yarn top_yarn = yarn.card.getYarn(label - 1);
            if (yarn.back && !top_yarn.back) {
                top_yarn.back = true;
                Fill.fill_spread_BFmode(top_yarn);
            } else if (!yarn.back && top_yarn.back) {
                top_yarn.back = false;
                Fill.fill_spread_BFmode(top_yarn);
            }
        }
        if (label != DesignCanvas.number_of_holes - 1) {
            Yarn bottom_yarn = yarn.card.getYarn(label + 1);
            if (yarn.back && !bottom_yarn.back) {
                bottom_yarn.back = true;
                Fill.fill_spread_BFmode(bottom_yarn);
            } else if (!yarn.back && bottom_yarn.back) {
                bottom_yarn.back = false;
                Fill.fill_spread_BFmode(bottom_yarn);
            }
        }
    }

    public static void fill_BF_test() {
        Polygon p = new Polygon();
        p.addPoint(10, 0);
        p.addPoint(10, 10);
        p.addPoint(0, 10);
        System.out.println("p.contains(10,10) " + p.contains(10, 10));
        System.out.println("p.contains(0,5) " + p.contains(0, 5));
        System.out.println("p.contains(5,5) " + p.contains(5, 5));
        Point2D.Double point = new Point2D.Double(10.0, 10.0);
        System.out.println("p.contains(point) " + p.contains(point));
    }

    public static void fill_BF(Point p) {
        Main.f.setCursor(Cursors.busyCursor);
        Yarn yarn = DesignCanvas.pick_yarn(p);
        yarn.back = !yarn.back;
        System.out.println("-------------");
        Fill.fill_spread_BFmode(yarn);
        Main.f.setCursor(Cursors.bucketCursor);
    }

    public static boolean isNext(Yarn yarn0, Yarn yarn1) {
        Polygon polygon0 = yarn0.polygon;
        Polygon polygon1 = yarn1.polygon;
        int i = 0;
        while (i < polygon0.npoints) {
            int x = polygon0.xpoints[i];
            int y = polygon0.ypoints[i];
            boolean inside = Fill.contain(polygon1, x, y);
            if (inside) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean contain(Polygon polygon, int px, int py) {
        int min_y = Integer.MAX_VALUE;
        int max_y = -2147483647;
        int i = 0;
        while (i < polygon.npoints) {
            int x = polygon.xpoints[i];
            int y = polygon.ypoints[i];
            if (x == px) {
                if (y < min_y) {
                    min_y = y;
                }
                if (max_y < y) {
                    max_y = y;
                }
            }
            ++i;
        }
        return min_y < py && py < max_y;
    }

    public static boolean _isNext(Yarn yarn0, Yarn yarn1) {
        Polygon polygon0 = yarn0.polygon;
        Polygon polygon1 = yarn1.polygon;
        int i = 0;
        while (i < polygon1.npoints) {
            int x = polygon1.xpoints[i];
            int y = polygon1.ypoints[i];
            if (polygon0.contains(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

