/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Arrow;
import board.BFDesignCanvas;
import board.Card;
import board.ColorPalette;
import board.HowToMakeCanvas;
import board.Main;
import board.Vector2D;
import board.Yarn;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DesignCanvas {
    public static List<Card> cards = new ArrayList<Card>();
    public static int number_of_holes = 4;
    public static Font font = new Font("Helvetica", 0, 20);
    public static final int FORWARD = 0;
    public static final int BACKWARD = 1;
    static int direction = 0;
    public static final int UP = 0;
    public static final int DOWN = 1;
    static Arrow up_arrow;
    static Arrow down_arrow;
    static String textfiled;
    static ColorPalette colorPalette;
    static double scale;
    public static List<Integer[]> direction_list;
    static int pixel_size_width;
    static int pixel_size_height;
    static Vector2D start_v;
    static String[] name;
    static Yarn picked_yarn;

    static {
        textfiled = "";
        colorPalette = null;
        scale = 0.5;
        direction_list = new ArrayList<Integer[]>();
        pixel_size_width = 50;
        pixel_size_height = 50;
        start_v = new Vector2D(100.0, 100.0);
        name = new String[]{"A", "B", "C", "D"};
        picked_yarn = null;
    }

    static void init() {
        DesignCanvas.set_create_arrow();
        Card.set_polygons();
        cards = new ArrayList<Card>();
        HowToMakeCanvas.paint_order_cards = new ArrayList<Card>();
        int i = 0;
        while (i < 8) {
            Card card = new Card();
            cards.add(card);
            HowToMakeCanvas.paint_order_cards.add(card);
            ++i;
        }
        Card.set_hole_center_vertices();
        direction_list = new ArrayList<Integer[]>();
        Main.mainPanel.scrollBar.setVisible(false);
        Main.mainPanel.label.setText("");
    }

    static void init_colorPalette() {
        colorPalette = new ColorPalette(Main.f);
        ColorPalette.set_colors_list();
        System.out.println("color Palette " + colorPalette);
    }

    static void clear() {
        cards = new ArrayList<Card>();
        HowToMakeCanvas.paint_order_cards = new ArrayList<Card>();
        int i = 0;
        while (i < 8) {
            Card card = new Card();
            cards.add(card);
            ++i;
        }
        DesignCanvas.set_paint_order_cards();
        direction_list = new ArrayList<Integer[]>();
        Main.textilePanel.construct_textile();
    }

    static void set_paint_order_cards() {
        int i = 0;
        while (i < cards.size()) {
            HowToMakeCanvas.paint_order_cards.add(cards.get(i));
            ++i;
        }
    }

    static void clear_for_load() {
        cards = new ArrayList<Card>();
        HowToMakeCanvas.paint_order_cards = new ArrayList<Card>();
    }

    static String paint_direction_en(int label) {
        if (label == 0) {
            return "Forward";
        }
        if (label == 1) {
            return "Backward";
        }
        return "";
    }

    static String paint_direction_ja(int label) {
        if (label == 0) {
            return "\u307e\u3048";
        }
        if (label == 1) {
            return "\u3046\u3057\u308d";
        }
        return "";
    }

    static void paint_direction(Graphics g) {
        g.setColor(Color.black);
        g.setFont(font);
        int i = 0;
        while (i < direction_list.size()) {
            Integer[] d = direction_list.get(i);
            String direction = Main.isEnglish ? DesignCanvas.paint_direction_en(d[0]) : DesignCanvas.paint_direction_ja(d[0]);
            g.drawString(direction + ": " + d[1], 50, 400 + 20 * i);
            ++i;
        }
    }

    static void set_create_arrow() {
        Vector2D start = new Vector2D((double)(-1 * pixel_size_width) * scale / 2.0, (double)pixel_size_height * scale / 2.0);
        Vector2D end = new Vector2D((double)pixel_size_width * scale / 2.0, (double)(-1 * pixel_size_height) * scale / 2.0);
        up_arrow = new Arrow(start, end);
        start = new Vector2D((double)(-1 * pixel_size_width) * scale / 2.0, (double)(-1 * pixel_size_height) * scale / 2.0);
        end = new Vector2D((double)pixel_size_width * scale / 2.0, (double)pixel_size_height * scale / 2.0);
        down_arrow = new Arrow(start, end);
    }

    static void set_direction_list() {
        Integer[] _direction_list = new Integer[]{direction, Integer.parseInt(textfiled)};
        direction_list.add(_direction_list);
    }

    static void undo_direction_list() {
        if (direction_list.size() == 0) {
            return;
        }
        direction_list.remove(direction_list.size() - 1);
    }

    static void save_direction_list(BufferedWriter out) throws IOException {
        int i = 0;
        while (i < direction_list.size()) {
            Integer[] d = direction_list.get(i);
            int direction = d[0];
            int count = d[1];
            if (direction == 0) {
                out.write(" F " + count);
            } else if (direction == 1) {
                out.write(" B " + count);
            }
            ++i;
        }
        if (direction_list.size() == 0) {
            out.write("noList");
        }
        out.newLine();
    }

    static void paint(Graphics g) {
        g.setColor(Color.black);
        int i = 0;
        while (i < number_of_holes) {
            g.drawString(Card.get_label(i), (int)DesignCanvas.start_v.x - 20, (int)DesignCanvas.start_v.y + pixel_size_width * i + pixel_size_height / 2);
            ++i;
        }
        i = 0;
        while (i < cards.size()) {
            Card card = cards.get(i);
            card.paint_designCanvas(g, i);
            ++i;
        }
    }

    static Yarn pick_yarn(Point p) {
        int i = 0;
        while (i < cards.size()) {
            boolean inside;
            Yarn yarn;
            Card card = cards.get(i);
            int j = 0;
            while (j < card.yarns.size()) {
                yarn = card.yarns.get(j);
                if (yarn.polygon != null && (inside = yarn.polygon.contains(p))) {
                    return yarn;
                }
                ++j;
            }
            if (!Main.boolean_mode) {
                j = 0;
                while (j < card.invisible_yarns.size()) {
                    yarn = card.invisible_yarns.get(j);
                    if (yarn.polygon != null && (inside = yarn.polygon.contains(p))) {
                        return yarn;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    static Arrow pick_arrow(Point p) {
        int i = 0;
        while (i < cards.size()) {
            Card card = cards.get(i);
            if (card.snap_arrow(p)) {
                return card.arrow;
            }
            ++i;
        }
        return null;
    }

    public static Arrow snap_arrow(Point p) {
        int i = 0;
        while (i < cards.size()) {
            Card card = cards.get(i);
            boolean snap_arrow = card.snap_arrow(p);
            if (snap_arrow) {
                return card.arrow;
            }
            ++i;
        }
        return null;
    }

    public static void pressed(Point p) {
        DesignCanvas.dragging(p);
    }

    public static void set_color(Color color) {
        ColorPalette.current_color = color;
        if (Main.boolean_mode) {
            if (color.getRed() > 128) {
                BFDesignCanvas.back = true;
            } else if (color.getRed() <= 128) {
                BFDesignCanvas.back = false;
            }
            System.out.println("Background_foreground.back " + BFDesignCanvas.back);
        }
    }

    static void dragging(Point p) {
        picked_yarn = DesignCanvas.pick_yarn(p);
        if (picked_yarn != null) {
            picked_yarn.change_color();
        }
    }

    public static void card_up() {
        cards.add(new Card());
        Main.textilePanel.construct_textile();
    }

    public static void card_down() {
        cards.remove(cards.size() - 1);
        Main.textilePanel.construct_textile();
    }

    public static void update_for_paint() {
        int i = 0;
        while (i < cards.size()) {
            Card card = cards.get(i);
            card.index = i++;
            card.update_boundaryBox();
        }
        Main.textilePanel.construct_textile();
        Main.mainPanel.repaint();
    }
}

