/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Arrow;
import board.ColorPalette;
import board.DesignCanvas;
import board.Main;
import board.MainPanel;
import board.Parallelogram;
import board.Vector2D;
import board.Yarn;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Card {
    int index;
    public List<Yarn> yarns = new ArrayList<Yarn>();
    List<Yarn> invisible_yarns = new ArrayList<Yarn>();
    public int direction = 1;
    Arrow arrow;
    static final int A = 0;
    static final int B = 1;
    static final int C = 2;
    static final int D = 3;
    static final int E = 4;
    static final int F = 5;
    static final int G = 6;
    static final int H = 7;
    static final int I = 8;
    static final int J = 9;
    Rectangle bbox;
    Color backGroundColor = Color.white;
    Color foreGroundColor = Color.gray;
    Color brown = new Color(204, 140, 81);
    Color brown2 = new Color(102, 53, 10);
    static final int RATIO = 3;
    static final int _SIDE = 70;
    static final int _HOLE_RADIUS = 4;
    static final int _SIDE_TO_HOLE = 15;
    static final int SIDE = 210;
    static final int HOLE_RADIUS = 12;
    static final int SIDE_TO_HOLE = 45;
    static final int DISTANCE_STRING = 2;
    static Vector2D[] hole_center_vertices = new Vector2D[DesignCanvas.number_of_holes];
    static double hole_center_vertices_radius = 82.0;
    static double outer_radius = 115.0;
    Vector2D arrow_center;
    static Polygon up_polygon;
    static Polygon down_polygon;
    static Polygon right_short_trapezoid_polygon;
    static Polygon left_short_trapezoid_polygon;
    public static double gradient;

    Card() {
        this.index = DesignCanvas.cards.size();
        this.yarns = new ArrayList<Yarn>();
        int i = 0;
        while (i < DesignCanvas.number_of_holes) {
            Yarn yarn = new Yarn(this, i, ColorPalette.DEFAULT_COLOR);
            this.yarns.add(yarn);
            ++i;
        }
        this.set_invisible_yarns();
        this.set_arrow();
        this.update_boundaryBox();
    }

    Card(boolean boolean_mode) {
        this.index = DesignCanvas.cards.size();
        this.yarns = new ArrayList<Yarn>();
        int i = 0;
        while (i < DesignCanvas.number_of_holes) {
            Color col = ColorPalette.DEFAULT_COLOR;
            if (boolean_mode && (i == 0 || i == 1)) {
                col = ColorPalette.colors[0];
            }
            Yarn yarn = new Yarn(this, i, col);
            yarn.orientation = 1;
            yarn.back = true;
            this.yarns.add(yarn);
            ++i;
        }
        this.set_arrow();
        this.set_boundaryBox();
    }

    Card(BufferedReader in) throws IOException {
        System.out.println("card");
        String line = in.readLine();
        StringTokenizer st = new StringTokenizer(line);
        String s = st.nextToken();
        this.direction = new Integer(s);
        this.index = DesignCanvas.cards.size();
        this.yarns = new ArrayList<Yarn>();
        while (true) {
            line = in.readLine();
            System.out.println("line " + line);
            if (line == null || line.equals("end card")) break;
            if (!line.equals("yarn")) continue;
            line = in.readLine();
            st = new StringTokenizer(line);
            int label = new Integer(st.nextToken());
            int color = new Integer(st.nextToken());
            Yarn yarn = new Yarn(this, label, ColorPalette.setColor(color));
            this.yarns.add(yarn);
        }
        this.set_invisible_yarns();
        this.set_arrow();
        this.set_boundaryBox();
    }

    Card(BufferedReader in, boolean bf) throws IOException {
        System.out.println("card");
        String line = in.readLine();
        StringTokenizer st = new StringTokenizer(line);
        String s = st.nextToken();
        System.out.println("st.next " + s);
        this.direction = new Integer(s);
        this.index = DesignCanvas.cards.size();
        this.yarns = new ArrayList<Yarn>();
        while (true) {
            line = in.readLine();
            System.out.println("line " + line);
            if (line == null || line.equals("end card")) break;
            st = new StringTokenizer(line);
            int count = 0;
            while (st.hasMoreElements()) {
                Yarn yarn;
                String next_token = st.nextToken();
                int label = new Integer(next_token);
                if (label == 0) {
                    yarn = new Yarn(this, count++, Color.white);
                    yarn.back = true;
                } else {
                    yarn = new Yarn(this, count++, Color.gray);
                    yarn.back = false;
                }
                this.yarns.add(yarn);
            }
            System.out.println("count " + count);
        }
        this.set_invisible_yarns();
        this.set_arrow();
        this.set_boundaryBox();
    }

    void set_boundaryBox() {
        this.bbox = new Rectangle(50 * this.index, 50 + 30 * this.index, 210, 210);
    }

    void update_boundaryBox() {
        Yarn yarn;
        this.set_boundaryBox();
        int i = 0;
        while (i < this.yarns.size()) {
            yarn = this.yarns.get(i);
            yarn.set_bbox();
            ++i;
        }
        i = 0;
        while (i < this.invisible_yarns.size()) {
            yarn = this.invisible_yarns.get(i);
            yarn.set_bbox_for_invisible(yarn.count_for_invisible);
            ++i;
        }
        this.update_arrow();
    }

    void set_invisible_yarns() {
        Yarn invisible_yarn;
        Yarn yarn;
        int i;
        this.invisible_yarns = new ArrayList<Yarn>();
        int j = 0;
        while (j < 2) {
            i = 0;
            while (i < this.yarns.size()) {
                yarn = this.yarns.get(i);
                invisible_yarn = new Yarn(yarn, j - 2);
                this.invisible_yarns.add(invisible_yarn);
                ++i;
            }
            ++j;
        }
        j = 0;
        while (j < 2) {
            i = 0;
            while (i < this.yarns.size()) {
                yarn = this.yarns.get(i);
                invisible_yarn = new Yarn(yarn, j + 1);
                this.invisible_yarns.add(invisible_yarn);
                ++i;
            }
            ++j;
        }
    }

    static void set_hole_center_vertices() {
        hole_center_vertices = new Vector2D[DesignCanvas.number_of_holes];
        double angle = 360 / DesignCanvas.number_of_holes;
        Vector2D vec = new Vector2D(-1.0, -1.0);
        vec.normalize();
        int i = 0;
        while (i < DesignCanvas.number_of_holes) {
            Card.hole_center_vertices[i] = vec;
            vec = Vector2D.rotate(vec, angle);
            ++i;
        }
    }

    void paint_m(Graphics g) {
        g.setFont(DesignCanvas.font);
        g.setColor(this.brown);
        int cx = this.bbox.x + this.bbox.width / 2;
        int cy = this.bbox.y + this.bbox.height / 2;
        int[] x = new int[DesignCanvas.number_of_holes];
        int[] y = new int[DesignCanvas.number_of_holes];
        int i = 0;
        while (i < DesignCanvas.number_of_holes) {
            Vector2D v = Vector2D.multiply(hole_center_vertices[i], outer_radius);
            x[i] = (int)v.x + cx;
            y[i] = (int)v.y + cy;
            ++i;
        }
        g.fillPolygon(x, y, DesignCanvas.number_of_holes);
        g.setColor(Color.black);
        g.drawPolygon(x, y, DesignCanvas.number_of_holes);
        i = 0;
        while (i < DesignCanvas.number_of_holes) {
            Arrow arrow;
            Yarn yarn = this.yarns.get(i);
            g.setColor(yarn.color);
            Vector2D v = Vector2D.multiply(hole_center_vertices[i], hole_center_vertices_radius);
            int x0 = (int)((double)cx + v.x);
            int y0 = (int)((double)cy + v.y);
            g.fillOval(x0, y0, 24, 24);
            if (this.direction == 1) {
                arrow = new Arrow(new Vector2D(x0, y0 - 20), new Vector2D(x0, y0));
                arrow.paint(g, false);
            } else if (this.direction == 0) {
                arrow = new Arrow(new Vector2D(x0, y0), new Vector2D(x0, y0 - 20));
                arrow.paint(g, false);
            }
            g.setColor(this.brown2);
            g.drawString(Card.get_label(i), (int)(Card.hole_center_vertices[i].x * hole_center_vertices_radius * 0.7 + (double)cx), (int)(Card.hole_center_vertices[i].y * hole_center_vertices_radius * 0.7 + (double)cy));
            ++i;
        }
    }

    void paint(Graphics g) {
        g.setFont(DesignCanvas.font);
        g.setColor(this.brown);
        g.fillRoundRect(this.bbox.x, this.bbox.y, 210, 210, 30, 30);
        g.setColor(Color.black);
        g.drawRoundRect(this.bbox.x, this.bbox.y, 210, 210, 30, 30);
        g.setColor(this.brown2);
        g.drawString("A", this.bbox.x + 45 - 12 - 2, this.bbox.y + 45 - 12 - 2);
        g.setColor(Color.black);
        g.fillOval(this.bbox.x + 45 - 12, this.bbox.y + 45 - 12, 24, 24);
        g.setColor(this.brown2);
        g.drawString("B", this.bbox.x + 210 - 45 - 12 - 2, this.bbox.y + 45 - 12 - 2);
        g.setColor(Color.black);
        g.fillOval(this.bbox.x + 210 - 45 - 12, this.bbox.y + 45 - 12, 24, 24);
        g.setColor(this.brown2);
        g.drawString("C", this.bbox.x + 210 - 45 - 12 - 2, this.bbox.y + 210 - 45 - 12 - 2);
        g.setColor(Color.black);
        g.fillOval(this.bbox.x + 210 - 45 - 12, this.bbox.y + 210 - 45 - 12, 24, 24);
        g.setColor(this.brown2);
        g.drawString("D", this.bbox.x + 45 - 12 - 2, this.bbox.y + 210 - 45 - 12 - 2);
        g.setColor(Color.black);
        g.fillOval(this.bbox.x + 45 - 12, this.bbox.y + 210 - 45 - 12, 24, 24);
        g.setColor(this.brown2);
        g.drawString("" + this.index, this.bbox.x + 105, this.bbox.y + 105);
    }

    void paint_through_yarn_up2(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(5.0f));
        int cx = this.bbox.x + this.bbox.width / 2;
        int cy = this.bbox.y + this.bbox.height / 2;
        int i = 0;
        while (i < DesignCanvas.number_of_holes) {
            Yarn yarn = this.yarns.get(i);
            g2.setColor(yarn.color);
            Vector2D v = Vector2D.multiply(hole_center_vertices[i], hole_center_vertices_radius);
            int _x = (int)((double)cx + v.x);
            int _y = (int)((double)cy + v.y);
            int x = _x;
            int y0 = this.bbox.y - 10;
            int y1 = _y;
            g2.drawLine(x, y0, x, y1);
            int y2 = (int)((double)(this.bbox.y + 45) + 6.0);
            int y3 = this.bbox.y + 210 + 20;
            g2.drawLine(x, y2, x, y3);
            ++i;
        }
        g2.setStroke(new BasicStroke(1.0f));
    }

    void paint_through_yarn_up(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(5.0f));
        Yarn yarn = this.yarns.get(0);
        g2.setColor(yarn.color);
        int x = (int)((double)(this.bbox.x + 45) - 6.0);
        int y0 = this.bbox.y + -10;
        int y1 = this.bbox.y;
        g2.drawLine(x, y0, x, y1);
        int y2 = (int)((double)(this.bbox.y + 45) + 6.0);
        int y3 = this.bbox.y + 210 + 20;
        g2.drawLine(x, y2, x, y3);
        yarn = this.yarns.get(1);
        g2.setColor(yarn.color);
        x = (int)((double)(this.bbox.x + 210 - 45) - 6.0);
        g2.drawLine(x, y0, x, y1);
        g2.drawLine(x, y2, x, y3);
        x = (int)((double)(this.bbox.x + 210 - 45) + 6.0);
        yarn = this.yarns.get(2);
        g2.setColor(yarn.color);
        g2.drawLine(x, y0, x, y1);
        y2 = (int)((double)(this.bbox.y + 210 - 45) - 6.0);
        g2.drawLine(x, y2, x, y3);
        x = (int)((double)(this.bbox.x + 45) + 6.0);
        yarn = this.yarns.get(3);
        g2.setColor(yarn.color);
        g2.drawLine(x, y0, x, y1);
        g2.drawLine(x, y2, x, y3);
        g2.setStroke(new BasicStroke(1.0f));
    }

    private static Color get_shadow_color(Yarn yarn) {
        int color_id = ColorPalette.get_color_index(yarn.color);
        if (color_id == 14) {
            return Color.black;
        }
        return Color.white;
    }

    void paint_through_yarn_down(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(5.0f));
        Yarn yarn = this.yarns.get(0);
        int x = (int)((double)(this.bbox.x + 45) - 6.0);
        int y0 = this.bbox.y + -10;
        int y1 = (int)((double)(this.bbox.y + 45) + 6.0);
        int y2 = this.bbox.y + 210;
        int y3 = this.bbox.y + 210 + 20;
        g2.setColor(Card.get_shadow_color(yarn));
        g2.drawLine(x + 1, y0, x + 1, y1);
        g2.drawLine(x + 1, y2, x + 1, y3);
        g2.setColor(yarn.color);
        g2.drawLine(x, y0, x, y1);
        g2.drawLine(x, y2, x, y3);
        g2.setStroke(new BasicStroke(5.0f));
        yarn = this.yarns.get(1);
        x = (int)((double)(this.bbox.x + 210 - 45) - 6.0);
        g2.setColor(Card.get_shadow_color(yarn));
        g2.drawLine(x + 1, y0, x + 1, y1);
        g2.drawLine(x + 1, y2, x + 1, y3);
        g2.setColor(yarn.color);
        g2.drawLine(x, y0, x, y1);
        g2.drawLine(x, y2, x, y3);
        x = (int)((double)(this.bbox.x + 210 - 45) + 6.0);
        yarn = this.yarns.get(2);
        y1 = (int)((double)(this.bbox.y + 210 - 45) + 6.0);
        g2.setColor(Card.get_shadow_color(yarn));
        g2.drawLine(x + 1, y0, x + 1, y1);
        g2.drawLine(x + 1, y2, x + 1, y3);
        g2.setColor(yarn.color);
        g2.drawLine(x, y0, x, y1);
        g2.drawLine(x, y2, x, y3);
        x = (int)((double)(this.bbox.x + 45) + 6.0);
        yarn = this.yarns.get(3);
        g2.setColor(Card.get_shadow_color(yarn));
        g2.drawLine(x + 1, y0, x + 1, y1);
        g2.drawLine(x + 1, y2, x + 1, y3);
        g2.setColor(yarn.color);
        g2.drawLine(x, y0, x, y1);
        g2.drawLine(x, y2, x, y3);
        g2.setStroke(new BasicStroke(1.0f));
    }

    void paint_designCanvas(Graphics g, int order) {
        Yarn yarn;
        g.setColor(Color.black);
        g.drawString("" + this.index, (int)DesignCanvas.start_v.x + DesignCanvas.pixel_size_width * order + DesignCanvas.pixel_size_height / 2, (int)DesignCanvas.start_v.y - 20);
        int i = 0;
        while (i < this.yarns.size()) {
            yarn = this.yarns.get(i);
            if (Main.boolean_mode) {
                yarn.paint_designCanvas_for_BF(g);
            } else {
                yarn.paint_designCanvas(g);
            }
            ++i;
        }
        if (!Main.boolean_mode) {
            i = 0;
            while (i < this.invisible_yarns.size()) {
                yarn = this.invisible_yarns.get(i);
                yarn.paint_designCanvas(g);
                ++i;
            }
        }
        Object polygon = null;
        this.paint_arrow(g);
    }

    void paint_arrow(Graphics g) {
        if (MainPanel.picked_arrow == this.arrow) {
            this.arrow.paint(g, true);
        } else {
            this.arrow.paint(g, false);
        }
    }

    void change_direction() {
        this.direction = (this.direction + 1) % 2;
        this.set_arrow();
    }

    boolean snap_arrow(Point p) {
        if (this.arrow_center == null) {
            return false;
        }
        double d = Vector2D.distance(this.arrow_center, p);
        return d < 10.0;
    }

    boolean contains(Point p) {
        return this.picked_yarn(p) != null;
    }

    Yarn picked_yarn(Point p) {
        int i = 0;
        while (i < this.yarns.size()) {
            Yarn yarn = this.yarns.get(i);
            if (yarn.polygon == null) {
                return null;
            }
            boolean inside = yarn.polygon.contains(p);
            if (inside) {
                return yarn;
            }
            ++i;
        }
        return null;
    }

    public Yarn getYarn(int label) {
        return this.yarns.get(label);
    }

    static void set_polygons() {
        Card.set_gradient();
        up_polygon = Card.create_up_polygon();
        down_polygon = Card.create_down_polygon();
        right_short_trapezoid_polygon = Card.create_right_short_trapezoid();
        left_short_trapezoid_polygon = Card.create_left_short_trapezoid();
    }

    static void set_gradient() {
        gradient = Main.boolean_mode ? 0.5 : 1.0;
    }

    void set_arrow() {
        this.arrow_center = new Vector2D(DesignCanvas.start_v.x + (double)(DesignCanvas.pixel_size_width * this.index) + (double)(DesignCanvas.pixel_size_width / 2), DesignCanvas.start_v.y + (double)(DesignCanvas.pixel_size_height * 5));
        this.arrow = this.direction == 0 ? new Arrow(this, Vector2D.add(DesignCanvas.up_arrow.start, this.arrow_center), Vector2D.add(DesignCanvas.up_arrow.end, this.arrow_center)) : new Arrow(this, Vector2D.add(DesignCanvas.down_arrow.start, this.arrow_center), Vector2D.add(DesignCanvas.down_arrow.end, this.arrow_center));
    }

    void update_arrow() {
        Vector2D prev = new Vector2D(this.arrow_center.x, this.arrow_center.y);
        this.arrow_center = new Vector2D(DesignCanvas.start_v.x + (double)(DesignCanvas.pixel_size_width * this.index) + (double)(DesignCanvas.pixel_size_width / 2), DesignCanvas.start_v.y + (double)(DesignCanvas.pixel_size_height * 5));
        this.arrow.move(this.arrow_center.x - prev.x, this.arrow_center.y - prev.y);
    }

    static Polygon create_up_polygon() {
        Vector2D vec0 = new Vector2D(DesignCanvas.pixel_size_width, (double)(-1 * DesignCanvas.pixel_size_height) * gradient);
        Vector2D vec1 = new Vector2D(0.0, DesignCanvas.pixel_size_height);
        return Parallelogram.create_polygon(vec0, vec1);
    }

    static Polygon create_down_polygon() {
        Vector2D vec0 = new Vector2D(DesignCanvas.pixel_size_width, (double)DesignCanvas.pixel_size_height * gradient);
        Vector2D vec1 = new Vector2D(0.0, DesignCanvas.pixel_size_height);
        return Parallelogram.create_polygon(vec0, vec1);
    }

    static Polygon create_left_short_trapezoid() {
        Vector2D vec0 = new Vector2D(DesignCanvas.pixel_size_width, (double)(-1 * DesignCanvas.pixel_size_height) * gradient);
        Vector2D vec1 = new Vector2D(0.0, DesignCanvas.pixel_size_height);
        return Parallelogram.create_trapezoid_left_short(vec0, vec1);
    }

    static Polygon create_right_short_trapezoid() {
        Vector2D vec0 = new Vector2D(DesignCanvas.pixel_size_width, (double)DesignCanvas.pixel_size_height * gradient);
        Vector2D vec1 = new Vector2D(0.0, DesignCanvas.pixel_size_height);
        return Parallelogram.create_trapezoid_right_short(vec0, vec1);
    }

    public static String get_label(int i) {
        switch (i) {
            case 0: {
                return "A";
            }
            case 1: {
                return "B";
            }
            case 2: {
                return "C";
            }
            case 3: {
                return "D";
            }
            case 4: {
                return "E";
            }
            case 5: {
                return "F";
            }
            case 6: {
                return "G";
            }
            case 7: {
                return "H";
            }
            case 8: {
                return "I";
            }
            case 9: {
                return "J";
            }
        }
        return "";
    }

    public void remove() {
        DesignCanvas.cards.remove(this);
        DesignCanvas.update_for_paint();
    }

    public void insert_left() {
        Card new_card = new Card();
        DesignCanvas.cards.add(this.index, new_card);
        DesignCanvas.update_for_paint();
    }

    public void insert_right() {
        Card new_card = new Card();
        DesignCanvas.cards.add(this.index + 1, new_card);
        DesignCanvas.update_for_paint();
    }

    public void save(BufferedWriter out) throws IOException {
        out.write("card");
        out.newLine();
        out.write("" + this.direction);
        out.newLine();
        int i = 0;
        while (i < this.yarns.size()) {
            Yarn yarn = this.yarns.get(i);
            yarn.save(out);
            out.newLine();
            ++i;
        }
        out.write("end card");
        out.newLine();
    }

    public void save_BF(BufferedWriter out) throws IOException {
        out.write("card");
        out.newLine();
        out.write("" + this.direction);
        out.newLine();
        int i = 0;
        while (i < DesignCanvas.number_of_holes) {
            Yarn yarn = this.yarns.get(i);
            if (yarn.back) {
                out.write("0 ");
            } else {
                out.write("1 ");
            }
            ++i;
        }
        out.newLine();
        out.write("end card");
        out.newLine();
    }

    public Card copy() {
        Card copy = new Card();
        copy.index = this.index;
        copy.direction = this.direction;
        int i = 0;
        while (i < this.yarns.size()) {
            Yarn yarn = this.yarns.get(i);
            Yarn copy_yarn = copy.yarns.get(i);
            copy_yarn.setColor(yarn.color);
            copy_yarn.back = yarn.back;
            ++i;
        }
        return copy;
    }

    public void update_all_yarn() {
        int i = 0;
        while (i < this.yarns.size()) {
            Yarn yarn = this.yarns.get(i);
            if (!Main.boolean_mode) {
                yarn.update_invisible_yarns_color();
            }
            ++i;
        }
    }

    public void move(int dx, int dy) {
        this.bbox.translate(dx, dy);
    }
}

