/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.BFDesignCanvas;
import board.Card;
import board.ColorPalette;
import board.DesignCanvas;
import board.Main;
import board.Parallelogram;
import board.Vector2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Yarn {
    public Color color = Color.white;
    Rectangle bbox;
    public Card card;
    int label;
    public boolean visible = true;
    Yarn parent_yarn = null;
    List<Yarn> invisible_yarns = new ArrayList<Yarn>();
    int count_for_invisible;
    public int orientation;
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int LEFT_SHORT = 2;
    public static final int RIGHT_SHORT = 3;
    public boolean back;
    static final int OVAL_RADIAN = 7;
    Polygon polygon;

    Yarn(Card _card) {
        this.card = _card;
        this.set_bbox();
    }

    Yarn(Card _card, int _label, Color _color) {
        this.card = _card;
        this.label = _label;
        this.color = _color;
        this.parent_yarn = null;
        this.visible = true;
        this.invisible_yarns = new ArrayList<Yarn>();
        this.set_bbox();
    }

    Yarn(Yarn parent, int _count) {
        this.card = parent.card;
        this.label = parent.label;
        this.color = parent.color;
        this.visible = false;
        this.parent_yarn = parent;
        parent.invisible_yarns.add(this);
        this.count_for_invisible = _count;
        this.set_bbox_for_invisible(this.count_for_invisible);
    }

    Yarn(StringTokenizer st) {
        if (!st.hasMoreTokens()) {
            System.out.println("no tokens");
        }
        this.label = new Integer(st.nextToken());
        int color_id = new Integer(st.nextToken());
        this.color = ColorPalette.colors[color_id];
    }

    void highlight(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(5.0f));
        g2.drawPolygon(this.polygon);
        g2.setStroke(new BasicStroke(1.0f));
    }

    void set_bbox() {
        this.bbox = new Rectangle((int)DesignCanvas.start_v.x + DesignCanvas.pixel_size_width * this.card.index, (int)DesignCanvas.start_v.y + DesignCanvas.pixel_size_height * this.label, DesignCanvas.pixel_size_width, DesignCanvas.pixel_size_height);
    }

    void set_bbox_for_invisible(int count) {
        this.bbox = new Rectangle((int)DesignCanvas.start_v.x + DesignCanvas.pixel_size_width * this.card.index, (int)DesignCanvas.start_v.y + DesignCanvas.pixel_size_height * (this.label + DesignCanvas.number_of_holes * count), DesignCanvas.pixel_size_width, DesignCanvas.pixel_size_height);
    }

    void paint_circle_on_the_card(Graphics g, Vector2D v) {
        g.setColor(this.color);
        g.fillOval((int)v.x - 7, (int)v.y - 7, 14, 14);
    }

    void paint_designCanvas(Graphics g) {
        if (this.visible) {
            g.setColor(this.color);
        } else {
            Color col = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 64);
            g.setColor(col);
        }
        if (this.card.direction == 0) {
            this.polygon = Parallelogram.move(Card.up_polygon, this.bbox.x, this.bbox.y + DesignCanvas.pixel_size_height);
        } else if (this.card.direction == 1) {
            this.polygon = Parallelogram.move(Card.down_polygon, this.bbox.x, this.bbox.y);
        }
        if (this.polygon != null) {
            g.fillPolygon(this.polygon);
            if (this.visible) {
                g.setColor(Color.black);
            } else {
                g.setColor(Color.gray);
            }
            g.drawPolygon(this.polygon);
        }
        if (DesignCanvas.picked_yarn == this) {
            this.highlight(g);
        }
    }

    void paint_designCanvas_for_BF(Graphics g) {
        if (this.back) {
            g.setColor(this.card.backGroundColor);
        } else {
            g.setColor(this.card.foreGroundColor);
        }
        BFDesignCanvas.set_orientation_and_bbox_BF(this);
        switch (this.orientation) {
            case 0: {
                this.polygon = Parallelogram.move(Card.up_polygon, this.bbox.x, this.bbox.y);
                break;
            }
            case 1: {
                this.polygon = Parallelogram.move(Card.down_polygon, this.bbox.x, this.bbox.y);
                break;
            }
            case 2: {
                this.polygon = Parallelogram.move(Card.left_short_trapezoid_polygon, this.bbox.x, this.bbox.y);
                break;
            }
            case 3: {
                this.polygon = Parallelogram.move(Card.right_short_trapezoid_polygon, this.bbox.x, this.bbox.y);
            }
        }
        if (this.polygon != null) {
            g.fillPolygon(this.polygon);
            if (this.visible) {
                g.setColor(Color.black);
            } else {
                g.setColor(Color.gray);
            }
            g.drawPolygon(this.polygon);
        }
        if (DesignCanvas.picked_yarn == this) {
            this.highlight(g);
        }
    }

    void setColor(Color col) {
        this.color = col;
        this.update_invisible_yarns_color();
    }

    void setInvisible() {
        this.visible = false;
    }

    void update_invisible_yarns_color() {
        int i = 0;
        while (i < this.invisible_yarns.size()) {
            Yarn yarn = this.invisible_yarns.get(i);
            yarn.color = this.color;
            ++i;
        }
    }

    void change_color() {
        if (Main.boolean_mode) {
            this.back = !this.back;
        }
        this.color = ColorPalette.current_color;
        if (this.visible) {
            this.update_invisible_yarns_color();
        } else {
            this.parent_yarn.change_color();
        }
    }

    public void save(BufferedWriter out) throws IOException {
        out.write("yarn");
        out.newLine();
        out.write(this.label + " " + ColorPalette.get_color_index(this.color));
    }

    void set_bbox(int i) {
        this.bbox = new Rectangle((int)DesignCanvas.start_v.x + DesignCanvas.pixel_size_width * this.card.index, (int)DesignCanvas.start_v.y + DesignCanvas.pixel_size_height * i, DesignCanvas.pixel_size_width, DesignCanvas.pixel_size_height);
    }

    public Yarn get_prev_yarn() {
        int index = this.card.yarns.indexOf(this);
        if (index == 0) {
            return null;
        }
        return this.card.yarns.get(index - 1);
    }
}

