/*
 * Decompiled with CFR 0.152.
 */
package board;

import java.awt.Point;
import java.awt.geom.Point2D;

public class Vector2D {
    public boolean fixed = false;
    public int index;
    public double x;
    public double y;
    public int color_id;
    public boolean visited = false;

    public Vector2D(Point2D p) {
        this.x = p.getX();
        this.y = p.getY();
    }

    public Vector2D(Point start, Point end) {
        this.x = end.x - start.x;
        this.y = end.y - start.y;
    }

    public Vector2D(Vector2D start, Vector2D end) {
        this.x = end.x - start.x;
        this.y = end.y - start.y;
    }

    public Vector2D(double start_x, double start_y, double end_x, double end_y) {
        this.x = end_x - start_x;
        this.y = end_y - start_y;
    }

    public Vector2D(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Vector2D() {
    }

    public Vector2D(double _x, double _y) {
        this.x = _x;
        this.y = _y;
    }

    public Vector2D(Vector2D v) {
        this.x = v.x;
        this.y = v.y;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public Vector2D duplicate() {
        return new Vector2D(this.x, this.y);
    }

    public static Vector2D normalize(Vector2D v) {
        double l = v.length();
        return new Vector2D(v.x / l, v.y / l);
    }

    public void normalize() {
        double l = this.length();
        this.x /= l;
        this.y /= l;
    }

    public void negate() {
        this.x *= -1.0;
        this.y *= -1.0;
    }

    public static Vector2D negate(Vector2D v) {
        return new Vector2D(-v.x, -v.y);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public static Vector2D add(Vector2D u, Vector2D v) {
        return new Vector2D(u.x + v.x, u.y + v.y);
    }

    public static Vector2D add(Vector2D u, Vector2D v, Vector2D w) {
        return new Vector2D(u.x + v.x + w.x, u.y + v.y + w.y);
    }

    public void add(Vector2D v) {
        this.x += v.x;
        this.y += v.y;
    }

    public void add(Point p) {
        this.x += (double)p.x;
        this.y += (double)p.y;
    }

    public static Vector2D subtract(Point u, Vector2D v) {
        return new Vector2D((double)u.x - v.x, (double)u.y - v.y);
    }

    public static Vector2D subtract(Vector2D u, Vector2D v) {
        return new Vector2D(u.x - v.x, u.y - v.y);
    }

    public void subtract(Vector2D v) {
        this.x -= v.x;
        this.y -= v.y;
    }

    public static Vector2D multiply(Vector2D v, double m) {
        return new Vector2D(v.x * m, v.y * m);
    }

    public void multiply(double m) {
        this.x *= m;
        this.y *= m;
    }

    public static double dot_product(Vector2D u, Vector2D v) {
        return u.x * v.x + u.y * v.y;
    }

    public static double cos(Vector2D u, Vector2D v) {
        double length = u.length() * v.length();
        if (length > 0.0) {
            return Vector2D.dot_product(u, v) / length;
        }
        return 0.0;
    }

    public static double cross_product(Vector2D u, Vector2D v) {
        return u.x * v.y - u.y * v.x;
    }

    public static double sin(Vector2D u, Vector2D v) {
        double length = u.length() * v.length();
        if (length > 0.0) {
            return Vector2D.cross_product(u, v) / length;
        }
        return 0.0;
    }

    public static double get_angle_PI(Vector2D u, Vector2D v) {
        double cosine = Vector2D.cos(u, v);
        if (cosine <= -1.0) {
            return Math.PI;
        }
        if (cosine >= 1.0) {
            return 0.0;
        }
        return Math.acos(cosine);
    }

    public static double get_angle_180(Vector2D u, Vector2D v) {
        double cosine = Vector2D.cos(u, v);
        if (cosine <= -1.0) {
            return 180.0;
        }
        if (cosine >= 1.0) {
            return 0.0;
        }
        return Math.acos(cosine) * 180.0 / Math.PI;
    }

    public static double get_angle_360(Vector2D u, Vector2D v) {
        if (u.x == v.x && u.y == v.y) {
            return 0.0;
        }
        double cos = Vector2D.cos(u, v);
        double sin = Vector2D.sin(u, v);
        if (cos == 0.0) {
            if (sin > 0.0) {
                return 90.0;
            }
            return 270.0;
        }
        if (sin == 0.0) {
            if (cos > 0.0) {
                return 0.0;
            }
            return 180.0;
        }
        double angle = 180.0 * Math.atan(sin / cos) / Math.PI;
        if (cos < 0.0) {
            angle += 180.0;
        }
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    public double get_angle180(Vector2D v) {
        double cos = Vector2D.cos(this, v);
        double sin = Vector2D.sin(this, v);
        if (cos == 0.0) {
            if (sin > 0.0) {
                return 90.0;
            }
            return -90.0;
        }
        if (sin == 0.0) {
            if (cos > 0.0) {
                return 0.0;
            }
            return 180.0;
        }
        double angle = 180.0 * Math.atan(sin / cos) / Math.PI;
        if (cos < 0.0) {
            angle = angle > 0.0 ? (angle -= 180.0) : (angle += 180.0);
        }
        return angle;
    }

    public static Vector2D rotate90(Vector2D vec) {
        return new Vector2D(-vec.y, vec.x);
    }

    public static Vector2D rotate270(Vector2D vec) {
        return new Vector2D(vec.y, -vec.x);
    }

    public static Vector2D rotate(Vector2D v, double degree) {
        if (degree == 90.0) {
            return new Vector2D(-v.y, v.x);
        }
        if (degree == 180.0) {
            return new Vector2D(-v.x, -v.y);
        }
        if (degree == 270.0) {
            return new Vector2D(v.y, -v.x);
        }
        double radian = degree * Math.PI / 180.0;
        double cos = Math.cos(radian);
        double sin = Math.sin(radian);
        return new Vector2D(v.x * cos - v.y * sin, v.x * sin + v.y * cos);
    }

    public static Vector2D flip(Vector2D vec, Vector2D axis) {
        Vector2D x_vec = Vector2D.normalize(axis);
        Vector2D y_vec = Vector2D.rotate90(x_vec);
        double x = Vector2D.dot_product(vec, x_vec);
        double y = Vector2D.dot_product(vec, y_vec);
        y = -y;
        return Vector2D.add(Vector2D.multiply(x_vec, x), Vector2D.multiply(y_vec, y));
    }

    public static Vector2D interporate(Vector2D start, Vector2D end, double t) {
        return new Vector2D(start.x * (1.0 - t) + end.x * t, start.y * (1.0 - t) + end.y * t);
    }

    public static double distance(int x1, int y1, int x2, int y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static double distance(Point start, Point end) {
        return Vector2D.distance(start.x, start.y, end.x, end.y);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static Vector2D interporate(Point start, Point end, double t) {
        return new Vector2D((double)start.x * (1.0 - t) + (double)end.x * t, (double)start.y * (1.0 - t) + (double)end.y * t);
    }

    public Point point() {
        return new Point((int)this.x, (int)this.y);
    }

    public static Point translatePoint(Point p, Vector2D vec) {
        return new Point((int)((double)p.x + vec.x), (int)((double)p.y + vec.y));
    }

    public Vector2D(double[] p) {
        this.x = p[0];
        this.y = p[1];
    }

    public Point Point() {
        return new Point((int)this.x, (int)this.y);
    }

    public Vector2D copy() {
        Vector2D v = new Vector2D(this.x, this.y);
        return v;
    }

    public boolean same_position(Vector2D v) {
        return this.x == v.x && this.y == v.y;
    }

    public static boolean same_position(Vector2D a, Vector2D b) {
        return a.x == b.x && a.y == b.y;
    }

    public static boolean touch(Vector2D v0, Vector2D v1) {
        return Vector2D.distance(v0, v1) < 1.0E-5;
    }

    public static Vector2D mid_point(Point a, Point b) {
        return new Vector2D((a.x + b.x) / 2, (a.y + b.y) / 2);
    }

    public static Vector2D mid_point(Vector2D a, Vector2D b) {
        return new Vector2D((a.x + b.x) / 2.0, (a.y + b.y) / 2.0);
    }

    public Vector2D translate(Vector2D v) {
        return new Vector2D(this.x + v.x, this.y + v.y);
    }

    public static Vector2D translate(Vector2D v, Vector2D vec) {
        return new Vector2D(v.x + vec.x, v.y + vec.y);
    }

    public void warp(Vector2D v) {
        this.x = v.x;
        this.y = v.y;
    }

    public void move_relative(Vector2D vec) {
        this.x += vec.x;
        this.y += vec.y;
    }

    public void move(double dx, double dy) {
        this.x += dx;
        this.y += dy;
    }

    public double distance(Point p) {
        return Math.sqrt(((double)p.x - this.x) * ((double)p.x - this.x) + ((double)p.y - this.y) * ((double)p.y - this.y));
    }

    public double distance(Vector2D node) {
        return Math.sqrt((node.x - this.x) * (node.x - this.x) + (node.y - this.y) * (node.y - this.y));
    }

    public static double distance(Vector2D n1, Vector2D n2) {
        return Math.sqrt((n1.x - n2.x) * (n1.x - n2.x) + (n1.y - n2.y) * (n1.y - n2.y));
    }

    public static double distance(Vector2D n1, Point n2) {
        return Math.sqrt((n1.x - (double)n2.x) * (n1.x - (double)n2.x) + (n1.y - (double)n2.y) * (n1.y - (double)n2.y));
    }

    public static Vector2D interpolate(Vector2D start, Vector2D end, double t) {
        return new Vector2D(start.x * (1.0 - t) + end.x * t, start.y * (1.0 - t) + end.y * t);
    }
}

