/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Card;
import board.DesignCanvas;
import board.Main;
import java.util.ArrayList;
import java.util.List;

public class Undo {
    static final int TIMES = 20;
    static List<List> history = new ArrayList<List>();

    static void init() {
        history = new ArrayList<List>();
    }

    static void push() {
        if (Main.boolean_mode) {
            Undo.pushBF();
        } else {
            Undo.push_designCanvas();
        }
    }

    static void pop() {
        if (Main.boolean_mode) {
            Undo.popBF();
        } else {
            Undo.pop_designCanvas();
        }
    }

    static void push_designCanvas() {
        ArrayList<Card> undo_cards = new ArrayList<Card>();
        int i = 0;
        while (i < DesignCanvas.cards.size()) {
            Card card = DesignCanvas.cards.get(i);
            undo_cards.add(card.copy());
            ++i;
        }
        history.add(undo_cards);
        if (history.size() == 20) {
            history.remove(0);
        }
    }

    static void pop_designCanvas() {
        if (history.size() == 0 || history == null) {
            System.err.println("Can not be recovered any more.... Sorry!");
            return;
        }
        List undo_cards = history.get(history.size() - 1);
        DesignCanvas.cards = new ArrayList<Card>();
        int i = 0;
        while (i < undo_cards.size()) {
            Card card = (Card)undo_cards.get(i);
            card.set_arrow();
            card.update_all_yarn();
            DesignCanvas.cards.add(card);
            ++i;
        }
        history.remove(undo_cards);
        DesignCanvas.update_for_paint();
        Main.mainPanel.repaint_all();
    }

    static void pushBF() {
        ArrayList<Card> undo_cards = new ArrayList<Card>();
        int i = 0;
        while (i < DesignCanvas.cards.size()) {
            Card card = DesignCanvas.cards.get(i);
            undo_cards.add(card.copy());
            ++i;
        }
        history.add(undo_cards);
        if (history.size() == 20) {
            history.remove(0);
        }
    }

    static void popBF() {
        if (history.size() == 0 || history == null) {
            System.err.println("Can not be recovered any more.... Sorry!");
            return;
        }
        List undo_cards = history.get(history.size() - 1);
        DesignCanvas.cards = new ArrayList<Card>();
        int i = 0;
        while (i < undo_cards.size()) {
            Card card = (Card)undo_cards.get(i);
            card.update_all_yarn();
            DesignCanvas.cards.add(card);
            ++i;
        }
        history.remove(undo_cards);
        Main.mainPanel.repaint_all();
    }
}

