/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.BFDesignCanvas;
import board.ColorPalette;
import board.Cursors;
import board.DesignCanvas;
import board.Main;
import board.MainPanel;
import board.Undo;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ToolPanel
extends Panel
implements MouseListener {
    public static int current_brush;
    public static int prev_brush;
    private MainPanel panel;
    static int N;
    static final int INIT_MARGIN = 0;
    static final int TOOLS_PER_WIDTH = 50;
    static final int TOOLS_HIGHT = 25;
    Image buffered_image;
    static final int IMAGE_SIZE = 24;
    Cursor cursor = Cursors.defaultCursor;
    private boolean[] button_pressed = new boolean[6];
    public static String[] tools;
    public static final int DRAW = 0;
    public static final int FILL = 1;
    public static final int MODE = 2;
    private static final int UNDO = 3;
    private static final int CLEAR = 4;
    private static final int ROTATE = 5;
    private int startX;
    public static String[] sounds;
    boolean clear = false;
    Image tools_image_1;
    Image tools_image_2;
    Image colors_image;

    static {
        N = 6;
        tools = new String[]{"draw", "fill", "mode", "undo", "clear", "rotate"};
        sounds = new String[]{"lock.wav", "click.wav", "cyu.wav", "bloop.wav", "piro.wav", "laser.wav"};
    }

    public Dimension getPreferredSize() {
        return new Dimension(1, 75);
    }

    ToolPanel(MainPanel _panel) {
        this.panel = _panel;
        this.tools_image_1 = this.loadImage("images\\tools_1.gif");
        if (Main.boolean_mode) {
            this.tools_image_2 = this.loadImage("images\\tools_3.gif");
            N = 6;
        } else {
            this.tools_image_2 = this.loadImage("images\\tools_2.gif");
            N = 5;
        }
        String filename = ColorPalette.get_image_panel_url();
        this.colors_image = this.loadImage(filename);
        this.addMouseListener(this);
        this.button_pressed[0] = true;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.buffered_image == null) {
            this.buffered_image = this.createImage(this.getWidth(), this.getHeight());
        }
        Graphics bg = this.buffered_image.getGraphics();
        this.paint_main(bg);
        bg.dispose();
        g.drawImage(this.buffered_image, 0, 0, null);
        int R = 16;
        super.paint(g);
    }

    public void paint_main(Graphics g) {
        g.setColor(Color.pink);
        int i = 0;
        while (i < N) {
            if (this.button_pressed[i]) {
                g.fill3DRect(0 + i * 50, 0, 50, 50, false);
            } else {
                g.fill3DRect(0 + i * 50, 0, 50, 50, true);
            }
            ++i;
        }
        if (MainPanel.mode == 0) {
            g.drawImage(this.tools_image_2, 0, 0, this);
        }
        if (MainPanel.mode == 1) {
            g.drawImage(this.tools_image_1, 0, 0, this);
        }
        if (MainPanel.mode == 0) {
            g.drawImage(this.colors_image, 50 * N + 0, 0, this);
            this.paint_picked_color(g);
        }
        int R = 16;
    }

    void paint_picked_color(Graphics g) {
        g.setColor(ColorPalette.current_color);
        g.fillOval(50 * N + 2 + 2, 6, 40, 40);
        if (ToolPanel.nearWhite(ColorPalette.current_color)) {
            g.setColor(Color.black);
            g.drawOval(50 * N + 2 + 2, 6, 40, 40);
        }
    }

    static boolean nearWhite(Color color) {
        return color.getBlue() > 250 && color.getRed() > 250 && color.getGreen() > 250;
    }

    public void mouseClicked(MouseEvent event) {
        event.getClickCount();
    }

    public void mouseEntered(MouseEvent event) {
        this.cursor = Main.f.getCursor();
        Main.f.setCursor(Cursors.defaultCursor);
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        this.startX = event.getX();
        if (this.startX > 50 * N + 0) {
            DesignCanvas.colorPalette.mousePressed(event);
            this.repaint();
            return;
        }
        int n = (this.startX - 0) / 50;
        this.change_button_pressed(n);
        this.menu(n);
        this.repaint();
        Main.mainPanel.repaint_all();
    }

    public void change_button_pressed(int index) {
        int i = 0;
        while (i < N) {
            this.button_pressed[i] = false;
            ++i;
        }
        this.button_pressed[index] = true;
        this.repaint();
    }

    public void menu(int index) {
        System.out.println("menu");
        switch (index) {
            case 4: {
                Main.f.setCursor(Cursors.defaultCursor);
                this.panel.clear();
                this.clear = true;
                break;
            }
            case 0: {
                this.panel.operation_status = 1;
                this.cursor = Cursors.brushCursor;
                break;
            }
            case 1: {
                this.panel.operation_status = 15;
                this.cursor = Cursors.bucketCursor;
                break;
            }
            case 2: {
                MainPanel.change_mode();
                break;
            }
            case 3: {
                Undo.pop();
                break;
            }
            case 5: {
                System.out.println("ROTATE");
                BFDesignCanvas.rotate();
            }
        }
        Main.mainPanel.repaint_all();
    }

    public void mouseReleased(MouseEvent event) {
    }

    protected Image loadImage(String pathname) {
        Image image = this.getToolkit().getImage(pathname);
        if (image != null) {
            MediaTracker mt = new MediaTracker(this);
            try {
                mt.addImage(image, 0);
                mt.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return image;
    }
}

