/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Vector2D;
import board._Line2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrokeAnalyzer {
    public static double unit_length = 10.0;
    public static double corner_threshold = 2.5;

    public static void initialize_index(List<Vector2D> vertices) {
        int i = 0;
        while (i < vertices.size()) {
            Vector2D v = vertices.get(i);
            v.index = i++;
        }
    }

    public static List<Vector2D> resample(List<Vector2D> vertices) {
        Vector2D v0 = vertices.get(0);
        Vector2D v1 = vertices.get(vertices.size() - 1);
        ArrayList<Vector2D> resampled = new ArrayList<Vector2D>();
        resampled.add(v0);
        double l = StrokeAnalyzer.getLength(vertices);
        int n = (int)(l / unit_length + 0.5);
        if (n <= 1) {
            resampled.add(v1);
            return resampled;
        }
        double unit = l / (double)n;
        double total = 0.0;
        double prev_total = 0.0;
        Vector2D prev = v0;
        double next_spot = unit;
        int index = 1;
        int count = 0;
        while (true) {
            Vector2D next = vertices.get(index);
            total += prev.distance(next);
            while (total >= next_spot) {
                Vector2D new_vertex = StrokeAnalyzer.interporate(prev, next, (next_spot - prev_total) / (total - prev_total));
                resampled.add(new_vertex);
                next_spot += unit;
                if (++count == n - 1) break;
            }
            if (count == n - 1) break;
            prev = next;
            prev_total = total;
            ++index;
        }
        resampled.add(v1);
        return resampled;
    }

    public static List<Vector2D> resample(List<Vector2D> vertices, double _unit_length) {
        Vector2D v0 = vertices.get(0);
        Vector2D v1 = vertices.get(vertices.size() - 1);
        ArrayList<Vector2D> resampled = new ArrayList<Vector2D>();
        resampled.add(v0);
        double l = StrokeAnalyzer.getLength(vertices);
        double unit = _unit_length;
        int n = (int)(l / unit) + 1;
        if (n <= 1) {
            resampled.add(v1);
            return resampled;
        }
        double total = 0.0;
        double prev_total = 0.0;
        Vector2D prev = v0;
        double next_spot = unit;
        int index = 1;
        int count = 0;
        while (true) {
            Vector2D next = vertices.get(index);
            total += prev.distance(next);
            while (total >= next_spot) {
                Vector2D new_vertex = StrokeAnalyzer.interporate(prev, next, (next_spot - prev_total) / (total - prev_total));
                resampled.add(new_vertex);
                next_spot += unit;
                if (++count == n - 1) break;
            }
            if (count == n - 1) break;
            prev = next;
            prev_total = total;
            ++index;
        }
        resampled.add(v1);
        return resampled;
    }

    public static List<Vector2D> resample(List<Vector2D> vertices, int n) {
        Vector2D v0 = vertices.get(0);
        Vector2D v1 = vertices.get(vertices.size() - 1);
        ArrayList<Vector2D> resampled = new ArrayList<Vector2D>();
        resampled.add(v0);
        double l = StrokeAnalyzer.getLength(vertices);
        if (n <= 1) {
            resampled.add(v1);
            return resampled;
        }
        double unit = l / (double)n;
        double total = 0.0;
        double prev_total = 0.0;
        Vector2D prev = v0;
        double next_spot = unit;
        int index = 1;
        int count = 0;
        while (true) {
            Vector2D next = vertices.get(index);
            total += prev.distance(next);
            while (total >= next_spot) {
                Vector2D new_vertex = StrokeAnalyzer.interporate(prev, next, (next_spot - prev_total) / (total - prev_total));
                resampled.add(new_vertex);
                next_spot += unit;
                if (++count == n - 1) break;
            }
            if (count == n - 1) break;
            prev = next;
            prev_total = total;
            ++index;
        }
        resampled.add(v1);
        return resampled;
    }

    public static Vector2D interporate(Vector2D start, Vector2D end, double t) {
        return new Vector2D(start.x * (1.0 - t) + end.x * t, start.y * (1.0 - t) + end.y * t);
    }

    public static double getLength(List<Vector2D> vertices) {
        double l = 0.0;
        int i = 0;
        while (i < vertices.size() - 1) {
            Vector2D v0 = vertices.get(i);
            Vector2D v1 = vertices.get(i + 1);
            l += v0.distance(v1);
            ++i;
        }
        return l;
    }

    public static List getResampledVertices(List vertices, double _unit_length) {
        unit_length = _unit_length;
        return StrokeAnalyzer.getResampledVertices(vertices);
    }

    public static List getResampledVertices(List vertices) {
        StrokeAnalyzer.initialize_index(vertices);
        List corners = new ArrayList();
        int i = 0;
        while (i < corners.size()) {
            ((Vector2D)corners.get((int)i)).fixed = true;
            ++i;
        }
        if (corners.size() <= 1) {
            corners = StrokeAnalyzer.getExtremes(vertices);
        }
        List resampled = new ArrayList();
        int v0_index = ((Vector2D)corners.get((int)(corners.size() - 1))).index;
        int i2 = 0;
        while (i2 < corners.size()) {
            int v1_index = ((Vector2D)corners.get((int)i2)).index;
            List sub_vertices = StrokeAnalyzer.get_sub_vertices(vertices, v0_index, v1_index);
            List<Vector2D> resampled_sub = StrokeAnalyzer.resample(sub_vertices);
            resampled_sub.remove(0);
            resampled = StrokeAnalyzer.connect_vector(resampled, resampled_sub);
            v0_index = v1_index;
            ++i2;
        }
        return resampled;
    }

    public static List getResampledVertices_noLoop(List vertices) {
        StrokeAnalyzer.initialize_index(vertices);
        List corners = StrokeAnalyzer.getCorners_noLoop(vertices);
        List resampled = new ArrayList();
        int v0_index = ((Vector2D)corners.get((int)0)).index;
        int i = 1;
        while (i < corners.size()) {
            int v1_index = ((Vector2D)corners.get((int)i)).index;
            List sub_vertices = StrokeAnalyzer.get_sub_vertices(vertices, v0_index, v1_index);
            List<Vector2D> resampled_sub = StrokeAnalyzer.resample(sub_vertices);
            if (i != 1) {
                resampled_sub.remove(0);
            }
            resampled = StrokeAnalyzer.connect_vector(resampled, resampled_sub);
            v0_index = v1_index;
            ++i;
        }
        return resampled;
    }

    public static List connect_vector(List main, List sub) {
        int i = 0;
        while (i < sub.size()) {
            main.add(sub.get(i));
            ++i;
        }
        return main;
    }

    public static List get_sub_vertices(List vertices, int index_v0, int index_v1) {
        ArrayList vertices_v0_to_v1 = new ArrayList();
        int i = index_v0;
        while (i != index_v1) {
            vertices_v0_to_v1.add(vertices.get(i));
            if (++i != vertices.size()) continue;
            i = 0;
        }
        vertices_v0_to_v1.add(vertices.get(index_v1));
        return vertices_v0_to_v1;
    }

    public static List getExtremes(List vertices) {
        Vector2D center = StrokeAnalyzer.get_center(vertices);
        Vector2D v0 = null;
        int index_v0 = 0;
        double max = -1.0;
        int i = 0;
        while (i < vertices.size()) {
            Vector2D v = (Vector2D)vertices.get(i);
            double d = Vector2D.distance(center, v);
            if (d > max) {
                v0 = v;
                max = d;
                index_v0 = i;
            }
            ++i;
        }
        Vector2D v1 = null;
        max = -1.0;
        int index_v1 = 0;
        int i2 = 0;
        while (i2 < vertices.size()) {
            Vector2D v = (Vector2D)vertices.get(i2);
            double d = Vector2D.distance(v0, v);
            if (d > max) {
                v1 = v;
                max = d;
                index_v1 = i2;
            }
            ++i2;
        }
        ArrayList<Vector2D> extremes = new ArrayList<Vector2D>();
        extremes.add(v0);
        extremes.add(v1);
        return extremes;
    }

    public static List getCorners(List vertices) {
        List extremes = StrokeAnalyzer.getExtremes(vertices);
        Vector2D v0 = (Vector2D)extremes.get(0);
        int index_v0 = v0.index;
        Vector2D v1 = (Vector2D)extremes.get(1);
        int index_v1 = v1.index;
        ArrayList vertices_v0_to_v1 = new ArrayList();
        int i = index_v0;
        while (i != index_v1) {
            vertices_v0_to_v1.add(vertices.get(i));
            if (++i != vertices.size()) continue;
            i = 0;
        }
        ArrayList vertices_v1_to_v0 = new ArrayList();
        int i2 = index_v1;
        while (i2 != index_v0) {
            vertices_v1_to_v0.add(vertices.get(i2));
            if (++i2 != vertices.size()) continue;
            i2 = 0;
        }
        List corners_v0_to_v1 = StrokeAnalyzer.get_corners_sub(vertices_v0_to_v1);
        List corners_v1_to_v0 = StrokeAnalyzer.get_corners_sub(vertices_v1_to_v0);
        ArrayList<Vector2D> corners = new ArrayList<Vector2D>();
        corners.add(v0);
        int i3 = 0;
        while (i3 < corners_v0_to_v1.size()) {
            corners.add((Vector2D)corners_v0_to_v1.get(i3));
            ++i3;
        }
        corners.add(v1);
        i3 = 0;
        while (i3 < corners_v1_to_v0.size()) {
            corners.add((Vector2D)corners_v1_to_v0.get(i3));
            ++i3;
        }
        return corners;
    }

    public static List getCorners_noLoop(List vertices) {
        List middle_corners = StrokeAnalyzer.get_corners_sub(vertices);
        List corners = new ArrayList();
        corners.add(vertices.get(0));
        corners = StrokeAnalyzer.connect_vector(corners, middle_corners);
        corners.add(vertices.get(vertices.size() - 1));
        return corners;
    }

    public static List get_corners_sub(List vertices) {
        Vector2D v1;
        if (vertices.size() == 0) {
            return new ArrayList();
        }
        Vector2D v0 = (Vector2D)vertices.get(0);
        if (v0.same_position(v1 = (Vector2D)vertices.get(vertices.size() - 1))) {
            return new ArrayList();
        }
        _Line2D line = new _Line2D(v0, v1);
        Vector2D cv = null;
        double max = corner_threshold;
        int index_cv = -1;
        int i = 0;
        while (i < vertices.size()) {
            Vector2D v = (Vector2D)vertices.get(i);
            double d = Math.abs(line.distance(v));
            if (d > max) {
                cv = v;
                max = d;
                index_cv = i;
            }
            ++i;
        }
        if (cv == null) {
            return new ArrayList();
        }
        ArrayList vertices0 = new ArrayList();
        int i2 = 0;
        while (i2 <= index_cv) {
            vertices0.add(vertices.get(i2));
            ++i2;
        }
        List corners0 = StrokeAnalyzer.get_corners_sub(vertices0);
        ArrayList vertices1 = new ArrayList();
        int i3 = index_cv;
        while (i3 < vertices.size()) {
            vertices1.add(vertices.get(i3));
            ++i3;
        }
        List corners1 = StrokeAnalyzer.get_corners_sub(vertices1);
        ArrayList corners = new ArrayList();
        int i4 = 0;
        while (i4 < corners0.size()) {
            corners.add(corners0.get(i4));
            ++i4;
        }
        corners.add(cv);
        i4 = 0;
        while (i4 < corners1.size()) {
            corners.add(corners1.get(i4));
            ++i4;
        }
        return corners;
    }

    public static Vector2D get_center(List vertices) {
        Vector2D center = new Vector2D();
        int i = 0;
        while (i < vertices.size()) {
            center.add((Vector2D)vertices.get(i));
            ++i;
        }
        center.multiply(1.0 / (double)vertices.size());
        return center;
    }
}

