/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Arrow;
import board.BFDesignCanvas;
import board.Buttons;
import board.ButtonsInterface;
import board.Cursors;
import board.DesignCanvas;
import board.File;
import board.Fill;
import board.Finish;
import board.HowToMakeCanvas;
import board.Main;
import board.Mapping;
import board.MyPopupMenu;
import board.Undo;
import board.Workshop;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JTextField;

public class MainPanel
extends Panel
implements ButtonsInterface {
    static Scrollbar yoko;
    JScrollBar scrollBar;
    JLabel label;
    static JTextField textfiled;
    List<List> history = new ArrayList<List>();
    Image buffered_image = null;
    public boolean repaint_all = true;
    Point start;
    Point end;
    static Image bg_image;
    boolean shift = false;
    static final int EDIT_MODE = 0;
    static final int CARDS_MODE = 1;
    static int mode;
    public int operation_status = 1;
    public static final int NONE = 0;
    public static final int DRAWING = 1;
    public static final int FILL = 15;
    public static boolean during_pulling;
    static Arrow picked_arrow;

    static {
        mode = 0;
        during_pulling = false;
        picked_arrow = null;
    }

    MainPanel() {
        MouseDispatcher mouseDispatcher = new MouseDispatcher();
        this.addMouseListener(mouseDispatcher);
        this.addMouseMotionListener(mouseDispatcher);
        this.addKeyListener(mouseDispatcher);
    }

    public void init() {
        DesignCanvas.init_colorPalette();
        if (Main.boolean_mode) {
            BFDesignCanvas.init();
        } else {
            DesignCanvas.init();
        }
        Undo.init();
    }

    public void initializeButtons(Buttons buttons) {
        if (Main.isEnglish) {
            this.initializeButtons_en(buttons);
        } else {
            this.initializeButtons_ja(buttons);
        }
    }

    public void initializeButtons_en(Buttons buttons) {
        buttons.addButton("load");
        buttons.addButton("save");
        buttons.add(new JLabel("-------------------------------"));
        if (!Main.boolean_mode) {
            ButtonGroup cbg = new ButtonGroup();
            MyRadioButton cbox = new MyRadioButton("Forward", cbg, true);
            buttons.add(cbox);
            cbox = new MyRadioButton("Backward", cbg, false);
            buttons.add(cbox);
            textfiled = new JTextField("4");
            buttons.add(textfiled);
            buttons.addButton("OK");
            buttons.addButton("UNDO");
            buttons.add(new JLabel("-------------------------------"));
        }
        JLabel label = new JLabel("The number of Card");
        buttons.add(label);
        buttons.addButton("INC");
        buttons.addButton("DEC");
        buttons.add(new JLabel("-------------------------------"));
        if (Main.boolean_mode) {
            label = new JLabel("card length");
            buttons.add(label);
            buttons.addButton("up");
            buttons.addButton("down");
        }
        buttons.add(new JLabel(""));
        buttons.add(new JLabel(""));
        buttons.addButton("FINISH");
        buttons.setCursor(Cursor.getDefaultCursor());
    }

    public void initializeButtons_ja(Buttons buttons) {
        buttons.addButton("\u3072\u3089\u304f");
        buttons.addButton("\u307b\u305e\u3093");
        buttons.add(new JLabel("-------------------------------"));
        if (!Main.boolean_mode) {
            ButtonGroup cbg = new ButtonGroup();
            MyRadioButton cbox = new MyRadioButton("\u307e\u3048", cbg, true);
            buttons.add(cbox);
            cbox = new MyRadioButton("\u3046\u3057\u308d", cbg, false);
            buttons.add(cbox);
            textfiled = new JTextField("4");
            buttons.add(textfiled);
            buttons.addButton("\u3051\u3063\u3066\u3044");
            buttons.addButton("\u3082\u3069\u3059");
            buttons.add(new JLabel("-------------------------------"));
        }
        JLabel label = new JLabel("\u30ab\u30fc\u30c9\u306e\u307e\u3044\u3059\u3046");
        buttons.add(label);
        buttons.addButton("\u3075\u3084\u3059");
        buttons.addButton("\u3078\u3089\u3059");
        buttons.add(new JLabel("-------------------------------"));
        if (Main.boolean_mode) {
            label = new JLabel("\u3072\u3082\u306e\u306a\u304c\u3055");
            buttons.add(label);
            buttons.addButton("\u306a\u304c\u304f");
            buttons.addButton("\u307f\u3058\u304b\u304f");
        }
        buttons.add(new JLabel(""));
        buttons.add(new JLabel(""));
        buttons.addButton("\u304a\u308f\u308a");
        buttons.setCursor(Cursor.getDefaultCursor());
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void repaint_all() {
        this.repaint_all = true;
        this.repaint();
        Main.textilePanel.repaint();
    }

    public void paint(Graphics g) {
        if (this.buffered_image == null) {
            this.buffered_image = this.createImage(this.getSize().width, this.getSize().height);
        }
        Graphics bg = this.buffered_image.getGraphics();
        bg.setColor(Color.white);
        bg.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (bg_image != null) {
            bg.drawImage(bg_image, 0, 0, null);
        }
        this.paint_main(bg);
        bg.dispose();
        g.drawImage(this.buffered_image, 0, 0, this);
        this.repaint_all = false;
    }

    private void paint_main(Graphics g) {
        if (mode == 0) {
            if (Main.boolean_mode) {
                BFDesignCanvas.paint(g);
            } else {
                DesignCanvas.paint(g);
                DesignCanvas.paint_direction(g);
            }
        } else if (mode == 1) {
            HowToMakeCanvas.paint_cards(g);
        }
        if (Workshop.workshop) {
            Finish.paint(g);
        }
    }

    public void paint_stroke(Graphics g, List stroke) {
        int i = 0;
        while (i < stroke.size() - 1) {
            Point p = (Point)stroke.get(i);
            Point q = (Point)stroke.get(i + 1);
            g.drawLine(p.x, p.y, q.x, q.y);
            ++i;
        }
    }

    public void load_image(String filename) {
        if (this.buffered_image == null) {
            this.buffered_image = this.createImage(this.getSize().width, this.getSize().height);
        }
        Graphics bg = this.buffered_image.getGraphics();
        bg_image = File.load_image(filename);
        bg.drawImage(bg_image, 0, 0, null);
        this.repaint_all();
    }

    public void load_image() {
        bg_image = File.load_image();
        Graphics bg = this.buffered_image.getGraphics();
        bg.drawImage(bg_image, 0, 0, null);
        this.repaint_all();
    }

    public void clear_image() {
        System.out.println("clear image");
        bg_image = null;
        Graphics bg = this.buffered_image.getGraphics();
        bg.setColor(Color.white);
        bg.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.repaint_all();
    }

    public void clear() {
        if (Main.boolean_mode) {
            BFDesignCanvas.clear();
        } else {
            DesignCanvas.clear();
        }
        Main.textilePanel.construct_textile();
        this.repaint_all();
    }

    static void change_mode() {
        if ((mode = (mode + 1) % 2) == 1) {
            System.out.println("cards");
            HowToMakeCanvas.init();
        } else if (mode == 0) {
            bg_image = null;
        }
        MainPanel.set_cursor();
    }

    static void change_colorful_or_boolean() {
        boolean bl = Main.boolean_mode = !Main.boolean_mode;
        if (Main.boolean_mode) {
            BFDesignCanvas.init();
        }
    }

    static void set_cursor() {
        if (mode == 1) {
            Main.f.setCursor(Cursors.handCursor);
        } else if (mode == 0) {
            if (picked_arrow != null) {
                Main.f.setCursor(Cursors.defaultCursor);
                return;
            }
            switch (Main.mainPanel.operation_status) {
                case 15: {
                    Main.f.setCursor(Cursors.bucketCursor);
                    break;
                }
                case 1: {
                    Main.f.setCursor(Cursors.brushCursor);
                }
            }
        }
    }

    public void load() {
        this.clear();
        if (Main.boolean_mode) {
            File.load_cards_BF();
        } else {
            File.load_cards();
        }
        DesignCanvas.set_paint_order_cards();
        Main.textilePanel.construct_textile();
        Main.textilePanel.repaint();
    }

    public void save() {
        if (Main.boolean_mode) {
            File.save_cards_BF(DesignCanvas.cards);
        } else {
            File.save_cards(DesignCanvas.cards);
        }
    }

    public void save_images() {
    }

    public void buttonPressed(String label) {
        if (label.equals("quit")) {
            System.exit(0);
        } else if (label.equals("clear")) {
            DesignCanvas.clear();
        } else if (label.equals("save") || label.equals("\u307b\u305e\u3093")) {
            Main.mainPanel.save();
        } else if (label.equals("load") || label.equals("\u3072\u3089\u304f")) {
            Main.mainPanel.load();
        } else if (label.equals("UNDO") || label.equals("\u3082\u3069\u3059")) {
            DesignCanvas.undo_direction_list();
            Main.mainPanel.repaint_all();
        } else if (label.equals("OK") || label.equals("\u3051\u3063\u3066\u3044")) {
            DesignCanvas.textfiled = textfiled.getText();
            DesignCanvas.set_direction_list();
            Main.mainPanel.repaint_all();
        } else if (label.equals("Forward") || label.equals("\u307e\u3048")) {
            DesignCanvas.direction = 0;
        } else if (label.equals("Backward") || label.equals("\u3046\u3057\u308d")) {
            DesignCanvas.direction = 1;
        } else if (label.equals("INC") || label.equals("\u3075\u3084\u3059")) {
            DesignCanvas.card_up();
            Main.mainPanel.repaint_all();
        } else if (label.equals("DEC") || label.equals("\u3078\u3089\u3059")) {
            DesignCanvas.card_down();
            Main.mainPanel.repaint_all();
        } else if (label.equals("up") || label.equals("\u306a\u304c\u304f")) {
            BFDesignCanvas.card_up();
        } else if (label.equals("down") || label.equals("\u307f\u3058\u304b\u304f")) {
            BFDesignCanvas.card_down();
        } else if (label.equals("FINISH") || label.equals("\u304a\u308f\u308a")) {
            Finish.run();
        }
        this.repaint();
    }

    public class MouseDispatcher
    extends MouseAdapter
    implements MouseMotionListener,
    KeyListener {
        boolean right_button;

        public void mouseMoved(MouseEvent e) {
            Point p = e.getPoint();
            if (!BFDesignCanvas.perpendicular) {
                p = Mapping.mapping(p);
            }
            DesignCanvas.picked_yarn = DesignCanvas.pick_yarn(p);
            picked_arrow = DesignCanvas.pick_arrow(p);
            MainPanel.set_cursor();
            if (DesignCanvas.picked_yarn == null && Main.boolean_mode) {
                BFDesignCanvas.mouseMoved(p);
            }
            MainPanel.this.repaint_all();
        }

        public void mousePressed(MouseEvent e) {
            Undo.push();
            Point p = e.getPoint();
            if (mode == 1) {
                HowToMakeCanvas.mousePressed(p);
                return;
            }
            if (Main.boolean_mode) {
                boolean bl = this.right_button = (e.getModifiers() & 4) != 0;
                if (this.right_button) {
                    if (DesignCanvas.picked_yarn != null) {
                        MyPopupMenu popup = new MyPopupMenu(Main.mainPanel);
                        MainPanel.this.add(popup);
                        popup.show(e.getComponent(), p.x, p.y);
                    }
                } else {
                    BFDesignCanvas.mousePressed(p);
                }
                return;
            }
            boolean bl = this.right_button = (e.getModifiers() & 4) != 0;
            if (this.right_button) {
                if (DesignCanvas.picked_yarn != null) {
                    MyPopupMenu popup = new MyPopupMenu(Main.mainPanel);
                    MainPanel.this.add(popup);
                    popup.show(e.getComponent(), p.x, p.y);
                }
                return;
            }
            if ((e.getModifiers() & 1) != 0) {
                MainPanel.this.shift = true;
            }
            if ((picked_arrow = DesignCanvas.pick_arrow(p)) != null) {
                MainPanel.picked_arrow.card.change_direction();
                MainPanel.this.repaint_all();
                return;
            }
            switch (MainPanel.this.operation_status) {
                case 15: {
                    Fill.fill(p);
                    break;
                }
                case 1: {
                    if (mode != 0) break;
                    DesignCanvas.pressed(p);
                }
            }
            MainPanel.this.repaint_all();
        }

        public void mouseDragged(MouseEvent e) {
            Point p = e.getPoint();
            if (this.right_button) {
                return;
            }
            if (mode == 1) {
                HowToMakeCanvas.mouseDragged(p);
                return;
            }
            if (Main.boolean_mode) {
                BFDesignCanvas.mouseDragged(p);
                return;
            }
            switch (MainPanel.this.operation_status) {
                case 1: {
                    if (mode != 0) break;
                    DesignCanvas.dragging(p);
                }
            }
            MainPanel.this.repaint_all();
        }

        public void mouseReleased(MouseEvent e) {
            Point p = e.getPoint();
            if (this.right_button) {
                return;
            }
            if (mode == 1) {
                HowToMakeCanvas.mouseReleased(p);
                return;
            }
            if (Main.boolean_mode) {
                BFDesignCanvas.mouseReleased(p);
                return;
            }
            switch (MainPanel.this.operation_status) {
                default: 
            }
            MainPanel.this.shift = false;
            MainPanel.this.repaint_all();
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getModifiers() == 2) {
                e.getKeyCode();
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    private class MyRadioButton
    extends JRadioButton {
        MyRadioButton(String label, ButtonGroup group, boolean flag) {
            super(label, flag);
            group.add(this);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    MainPanel.this.buttonPressed(MyRadioButton.this.getText());
                }
            });
        }
    }
}

