/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Card;
import board.DesignCanvas;
import board.Main;
import java.awt.FileDialog;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class File {
    static boolean save2dropbox = true;

    public static void save(Image img) {
        BufferedImage bimg = new BufferedImage(img.getWidth(null), img.getHeight(null), 5);
        Graphics2D g = bimg.createGraphics();
        g.drawImage(img, 0, 0, null);
        try {
            File.save(bimg);
        }
        catch (Exception e) {
            System.out.println("save error " + e);
        }
    }

    private static void save(BufferedImage img) throws IOException {
        FileDialog fileDialog = new FileDialog(Main.f, "Save Image", 1);
        fileDialog.setDirectory(".\\data\\");
        fileDialog.setFile("*.png");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String filename = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
            FileOutputStream out = new FileOutputStream(filename);
            try {
                ImageIO.write((RenderedImage)img, "png", out);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        fileDialog.dispose();
    }

    public static void save(Image img, String filename) {
        BufferedImage bimg = new BufferedImage(img.getWidth(null), img.getHeight(null), 5);
        Graphics2D g = bimg.createGraphics();
        g.drawImage(img, 0, 0, null);
        try {
            File.save(bimg, filename);
        }
        catch (Exception e) {
            System.out.println("save error " + e);
        }
    }

    private static void save(BufferedImage img, String filename) throws IOException {
        FileOutputStream out = new FileOutputStream(filename);
        try {
            ImageIO.write((RenderedImage)img, "png", out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Image load_image(String filename) {
        BufferedImage image = null;
        try {
            java.io.File f = new java.io.File(filename);
            image = ImageIO.read(f);
        }
        catch (Exception e) {
            System.out.println("load error " + e);
        }
        return image;
    }

    public static Image load_image() {
        FileDialog fileDialog = new FileDialog(Main.f, "Load Image", 0);
        fileDialog.setDirectory(".\\data\\");
        fileDialog.setFile("*.jpg");
        fileDialog.setVisible(true);
        BufferedImage image = null;
        if (fileDialog.getFile() != null) {
            String filename = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
            try {
                java.io.File f = new java.io.File(filename);
                image = ImageIO.read(f);
            }
            catch (Exception e) {
                System.out.println("load error " + e);
            }
        }
        fileDialog.dispose();
        return image;
    }

    public static void load_cards() {
        if (Main.boolean_mode) {
            File.load_cards_BF();
        } else {
            File.load_cards_designCanvas();
        }
    }

    public static void load_cards_designCanvas() {
        DesignCanvas.clear_for_load();
        System.out.println("load cards");
        FileDialog fileDialog = new FileDialog(Main.f, "Load Cards", 0);
        fileDialog.setDirectory(".\\data\\");
        fileDialog.setFile("*.dat");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String filename = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
            DesignCanvas.cards = new ArrayList<Card>();
            try {
                BufferedReader in = new BufferedReader(new FileReader(filename));
                String line = in.readLine();
                System.out.println("line " + line);
                StringTokenizer st = new StringTokenizer(line);
                DesignCanvas.direction_list = new ArrayList<Integer[]>();
                while (st.hasMoreTokens()) {
                    Integer[] _direction_list;
                    String s = st.nextToken();
                    if (s.matches("F")) {
                        s = st.nextToken();
                        _direction_list = new Integer[]{0, Integer.parseInt(s)};
                        DesignCanvas.direction_list.add(_direction_list);
                        continue;
                    }
                    if (s.matches("B")) {
                        s = st.nextToken();
                        _direction_list = new Integer[]{1, Integer.parseInt(s)};
                        DesignCanvas.direction_list.add(_direction_list);
                        continue;
                    }
                    s.matches("noList");
                }
                while (true) {
                    line = in.readLine();
                    System.out.println("line " + line);
                    if (line == null || !line.equals("card")) break;
                    Card card = new Card(in);
                    DesignCanvas.cards.add(card);
                    System.out.println("cards " + DesignCanvas.cards.size());
                }
                Main.textilePanel.construct_textile();
            }
            catch (Exception e) {
                System.out.println("load error " + e);
            }
        }
        fileDialog.dispose();
        Main.mainPanel.repaint();
    }

    public static void load_cards_BF() {
        DesignCanvas.clear_for_load();
        System.out.println("load cards");
        FileDialog fileDialog = new FileDialog(Main.f, "Load Cards", 0);
        fileDialog.setDirectory(".\\data\\");
        fileDialog.setFile("*.bf");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String filename = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
            DesignCanvas.cards = new ArrayList<Card>();
            try {
                BufferedReader in = new BufferedReader(new FileReader(filename));
                String line = in.readLine();
                StringTokenizer st = new StringTokenizer(line);
                DesignCanvas.direction_list = new ArrayList<Integer[]>();
                while (st.hasMoreTokens()) {
                    Integer[] _direction_list;
                    String s = st.nextToken();
                    if (s.matches("F")) {
                        s = st.nextToken();
                        _direction_list = new Integer[]{0, Integer.parseInt(s)};
                        DesignCanvas.direction_list.add(_direction_list);
                        continue;
                    }
                    if (!s.matches("B")) continue;
                    s = st.nextToken();
                    _direction_list = new Integer[]{1, Integer.parseInt(s)};
                    DesignCanvas.direction_list.add(_direction_list);
                }
                System.out.println("loadcards BF");
                while (true) {
                    line = in.readLine();
                    System.out.println("line " + line);
                    if (line == null || !line.equals("card")) break;
                    Card card = new Card(in, true);
                    DesignCanvas.cards.add(card);
                    System.out.println("cards " + DesignCanvas.cards.size());
                }
                Main.textilePanel.construct_textile();
            }
            catch (Exception e) {
                System.out.println("load error " + e);
            }
        }
        fileDialog.dispose();
        Main.mainPanel.repaint();
    }

    public static void save_cards(List<Card> cards) {
        FileDialog fileDialog = new FileDialog(Main.f, "Save Cards", 1);
        fileDialog.setDirectory(".\\data\\");
        String autofilename = File.autoFileName();
        fileDialog.setFile(autofilename + ".dat");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            try {
                String filename = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
                BufferedWriter out = new BufferedWriter(new FileWriter(filename));
                DesignCanvas.save_direction_list(out);
                int i = 0;
                while (i < cards.size()) {
                    cards.get(i).save(out);
                    ++i;
                }
                out.newLine();
                out.flush();
                out.close();
            }
            catch (IOException e) {
                System.out.print("IO Error " + e);
            }
        }
    }

    private static String get_file_name(String _filename, boolean BF) {
        String filename = "";
        String extension = "";
        extension = BF ? "bf" : "dat";
        filename = save2dropbox ? "C:\\Users\\yuki\\dropbox\\weavy_userdata\\" + _filename + "." + extension : ".\\data\\" + _filename + "." + extension;
        return filename;
    }

    public static void save_cards_noFileReName(String _filename, List<Card> cards) {
        try {
            String filename = File.get_file_name(_filename, false);
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            DesignCanvas.save_direction_list(out);
            int i = 0;
            while (i < cards.size()) {
                cards.get(i).save(out);
                ++i;
            }
            out.newLine();
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.print("IO Error " + e);
        }
    }

    public static void save_cards_BF(List<Card> cards) {
        FileDialog fileDialog = new FileDialog(Main.f, "Save Cards", 1);
        fileDialog.setDirectory(".\\data\\");
        String autofilename = File.autoFileName();
        fileDialog.setFile(autofilename + ".bf");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            try {
                String filename = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
                BufferedWriter out = new BufferedWriter(new FileWriter(filename));
                DesignCanvas.save_direction_list(out);
                int i = 0;
                while (i < cards.size()) {
                    cards.get(i).save_BF(out);
                    ++i;
                }
                out.newLine();
                out.flush();
                out.close();
            }
            catch (IOException e) {
                System.out.print("IO Error " + e);
            }
        }
    }

    public static void save_cards_BF_noFileReName(String _filename, List<Card> cards) {
        try {
            String filename = File.get_file_name(_filename, true);
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            DesignCanvas.save_direction_list(out);
            int i = 0;
            while (i < cards.size()) {
                cards.get(i).save_BF(out);
                ++i;
            }
            out.newLine();
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.print("IO Error " + e);
        }
    }

    public static String autoFileName() {
        String filename = "";
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int date = calendar.get(5);
        int dayOfWeek = calendar.get(7);
        int hourOfDay = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int ms = calendar.get(14);
        filename = String.valueOf(filename) + "File_" + month + "_" + date + "_" + hourOfDay + "_" + minute + "_" + second;
        return filename;
    }
}

