/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.DesignCanvas;
import board.ToolPanel;
import board.Workshop;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;

public class ColorPalette
extends Window
implements MouseListener {
    static String color_image_url = "images\\colors.gif";
    static String color_image_url_workshop = "images\\colors_workshop.png";
    static Color DEFAULT_COLOR;
    static final int DEFAULT_COLOR_INDEX = 14;
    static final int INIT_COLOR_INDEX = 21;
    int width;
    int height;
    int[] pixels;
    ColorModel colorModel;
    Image image;
    static Color[] colors;
    static Color current_color;

    ColorPalette(Frame frame) {
        super(frame);
        String filename = ColorPalette.get_image_panel_url();
        this.image = this.loadImage(filename);
        this.grabPixels();
        this.setLocation(1024 - this.width, 0);
        this.setSize(this.width, this.height);
        this.addMouseListener(this);
    }

    public void paint(Graphics g) {
        g.drawImage(this.image, 0, 0, null);
    }

    public void grabPixels() {
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        this.pixels = new int[this.width * this.height];
        PixelGrabber pg = new PixelGrabber(this.image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
        }
        this.colorModel = pg.getColorModel();
    }

    Color pick_color(int x, int y) {
        if ((x -= 50 * ToolPanel.N) <= 48) {
            return current_color;
        }
        return new Color(this.colorModel.getRed(this.pixels[x + y * this.width]), this.colorModel.getGreen(this.pixels[x + y * this.width]), this.colorModel.getBlue(this.pixels[x + y * this.width]));
    }

    public void mousePressed(MouseEvent e) {
        DesignCanvas.set_color(this.pick_color(e.getX(), e.getY()));
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public static String get_image_panel_url() {
        return Workshop.workshop ? color_image_url_workshop : color_image_url;
    }

    protected Image loadImage(String pathname) {
        Image image = this.getToolkit().getImage(pathname);
        if (image != null) {
            MediaTracker mt = new MediaTracker(this);
            try {
                mt.addImage(image, 0);
                mt.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return image;
    }

    static void set_colors_list() {
        Point[] color_points = new Point[28];
        colors = new Color[color_points.length];
        int count = 0;
        int j = 0;
        while (j < 2) {
            int y = 15 + 25 * j;
            int i = 0;
            while (i < 14) {
                int x = 60 + 25 * i;
                color_points[count++] = new Point(x, y);
                ++i;
            }
            ++j;
        }
        ColorModel colorModel = DesignCanvas.colorPalette.colorModel;
        int i = 0;
        while (i < color_points.length) {
            Point p = color_points[i];
            ColorPalette.colors[i] = new Color(colorModel.getRed(DesignCanvas.colorPalette.pixels[p.x + p.y * DesignCanvas.colorPalette.width]), colorModel.getGreen(DesignCanvas.colorPalette.pixels[p.x + p.y * DesignCanvas.colorPalette.width]), colorModel.getBlue(DesignCanvas.colorPalette.pixels[p.x + p.y * DesignCanvas.colorPalette.width]));
            ++i;
        }
        DEFAULT_COLOR = colors[14];
        current_color = colors[21];
    }

    public static Color setColor(int color) {
        if (color == -1) {
            return DEFAULT_COLOR;
        }
        return colors[color];
    }

    public static int get_color_index(Color col) {
        int i = 0;
        while (i < colors.length) {
            Color color = colors[i];
            if (ColorPalette.sameColor(color, col)) {
                return i;
            }
            ++i;
        }
        return 14;
    }

    private static boolean sameColor(Color col0, Color col1) {
        return col0.getBlue() == col1.getBlue() && col0.getRed() == col1.getRed() && col0.getGreen() == col1.getGreen();
    }
}

