/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.BFDesignCanvas;
import board.Card;
import board.DesignCanvas;
import board.File;
import board.Main;
import board.MainPanel;
import board.Yarn;
import java.awt.Color;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import textile.Row;
import textile.TextileFrame;
import textile.TextilePanel;

public class Capture {
    static String message_en = "The system saves your design. Thank you! ";
    static String message_ja = "\u307b\u305e\u3093\u3057\u307e\u3057\u305f";

    public static void run() {
        String filename = File.autoFileName();
        if (Main.boolean_mode) {
            Capture.capture_BF_noFileReName(filename);
            File.save_cards_BF_noFileReName(filename, DesignCanvas.cards);
        } else {
            Capture.capture_designCanvas_noFileReName(filename);
            File.save_cards_noFileReName(filename, DesignCanvas.cards);
        }
        Capture.showThankyouPanel(Main.mainPanel);
    }

    public static void capture_designCanvas() {
        System.out.println("capture");
        MainPanel designPanel = Main.mainPanel;
        Frame designFrame = Main.f;
        TextilePanel textilePanel = Main.textilePanel;
        TextileFrame textileFrame = Main.textileFrame;
        int image_width = designPanel.getWidth() + textilePanel.getWidth();
        int image_height = Math.max(designPanel.getHeight(), textilePanel.getHeight());
        BufferedImage bufferedImage = new BufferedImage(image_width, image_height, 1);
        System.out.println("size: " + bufferedImage.getWidth() + ", " + bufferedImage.getHeight());
        Graphics g = bufferedImage.getGraphics();
        ((Container)designPanel).paint(g);
        g.drawImage(TextilePanel.buffered_image, designPanel.getWidth(), 0, null);
        g.dispose();
        try {
            System.out.println("try");
            FileDialog fileDialog = new FileDialog(designFrame, "Save image", 1);
            fileDialog.setDirectory("C:\\Users\\yuki\\dropbox\\weavy");
            String fileName = File.autoFileName();
            fileDialog.setFile(String.valueOf(fileName) + ".png");
            fileDialog.setVisible(true);
            if (fileDialog.getFile() != null) {
                String filename = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
                java.io.File file = new java.io.File(filename);
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
                fileDialog.dispose();
            }
        }
        catch (IOException e) {
            System.out.println("" + e);
        }
    }

    public static void capture_designCanvas_noFileReName(String _filename) {
        MainPanel designPanel = Main.mainPanel;
        Frame designFrame = Main.f;
        TextilePanel textilePanel = Main.textilePanel;
        TextileFrame textileFrame = Main.textileFrame;
        int image_width = designPanel.getWidth() + textilePanel.getWidth();
        int image_height = Math.max(designPanel.getHeight(), textilePanel.getHeight());
        BufferedImage bufferedImage = new BufferedImage(image_width, image_height, 1);
        Graphics g = bufferedImage.getGraphics();
        ((Container)designPanel).paint(g);
        g.drawImage(TextilePanel.buffered_image, designPanel.getWidth(), 0, null);
        g.dispose();
        try {
            String filename = ".\\data\\" + _filename + ".png";
            System.out.println("filename " + filename);
            java.io.File file = new java.io.File(filename);
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException e) {
            System.out.println("" + e);
        }
    }

    public static void capture_BF() {
        System.out.println("capture");
        TextilePanel textilePanel = Main.textilePanel;
        TextileFrame textileFrame = Main.textileFrame;
        if (Main.boolean_mode && !BFDesignCanvas.perpendicular) {
            BFDesignCanvas.rotate();
        }
        int max_index = 0;
        int i = 0;
        while (i < DesignCanvas.cards.size()) {
            Card card = DesignCanvas.cards.get(i);
            int _max_index = Capture.get_max_index(card);
            if (max_index < _max_index) {
                max_index = _max_index;
            }
            ++i;
        }
        int image_width = Main.TEXTILE_PANEL_WIDTH;
        int image_height = 40 + Row.pixel_height * (max_index + 1);
        TextilePanel.start.y = 20.0;
        BufferedImage bufferedImage = new BufferedImage(image_width, image_height, 1);
        System.out.println("size: " + bufferedImage.getWidth() + ", " + bufferedImage.getHeight());
        Graphics g = bufferedImage.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, image_width, image_height);
        TextilePanel.paint_main((Graphics)g, (boolean)true);
        g.dispose();
        try {
            System.out.println("try");
            FileDialog fileDialog = new FileDialog((Frame)textileFrame, "Save image", 1);
            fileDialog.setDirectory("C:\\Users\\yuki\\dropbox\\weavy");
            String fileName = File.autoFileName();
            fileDialog.setFile(String.valueOf(fileName) + ".png");
            fileDialog.setVisible(true);
            if (fileDialog.getFile() != null) {
                String filename = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
                java.io.File file = new java.io.File(filename);
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
                fileDialog.dispose();
            }
        }
        catch (IOException e) {
            System.out.println("" + e);
        }
    }

    public static void capture_BF_noFileReName(String _filename) {
        System.out.println("capture");
        TextilePanel textilePanel = Main.textilePanel;
        TextileFrame textileFrame = Main.textileFrame;
        if (Main.boolean_mode && !BFDesignCanvas.perpendicular) {
            BFDesignCanvas.rotate();
        }
        int max_index = 0;
        int i = 0;
        while (i < DesignCanvas.cards.size()) {
            Card card = DesignCanvas.cards.get(i);
            int _max_index = Capture.get_max_index(card);
            if (max_index < _max_index) {
                max_index = _max_index;
            }
            ++i;
        }
        int image_width = Main.TEXTILE_PANEL_WIDTH;
        int image_height = 40 + Row.pixel_height * (max_index + 1);
        TextilePanel.start.y = 20.0;
        BufferedImage bufferedImage = new BufferedImage(image_width, image_height, 1);
        System.out.println("size: " + bufferedImage.getWidth() + ", " + bufferedImage.getHeight());
        Graphics g = bufferedImage.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, image_width, image_height);
        TextilePanel.paint_main((Graphics)g, (boolean)true);
        g.dispose();
        try {
            String filename = ".\\data\\" + _filename + ".png";
            System.out.println("filename " + filename);
            java.io.File file = new java.io.File(filename);
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException e) {
            System.out.println("" + e);
        }
    }

    static int get_max_index(Card card) {
        int max_index = 0;
        int i = 0;
        while (i < card.yarns.size()) {
            Yarn yarn = card.yarns.get(i);
            if (!yarn.back) {
                max_index = i;
            }
            ++i;
        }
        return max_index;
    }

    public static void showThankyouPanel(MainPanel panel) {
        String message = "";
        message = Main.isEnglish ? message_en : message_ja;
        UIManager.put("OptionPane.okButtonText", "OK");
        JOptionPane.showMessageDialog(panel, message);
    }
}

