/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Card;
import board.ColorBOX;
import board.ColorPalette;
import board.DesignCanvas;
import board.Fill;
import board.HowToMakeCanvas;
import board.Main;
import board.Mapping;
import board.Yarn;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import textile.Row;
import textile.TextileFrame;

public class BFDesignCanvas {
    static double scrollBar_val;
    static final int INIT_START_POSITION_Y = 40;
    static final int COLOR_BOX_POSITION_Y = 60;
    static final int VISIBLE_YARNS = 7;
    static boolean back;
    public static Font font;
    public static Image rotate_button_image;
    public static Point rotate_button_position;
    public static boolean perpendicular;
    static Point prev;
    static Rectangle panel_bbox;
    static int visible_yarn_number;
    static final int NUMBER_OF_PAINT_YARNS = 8;
    static final int COLOR_BOX_SIZE = 24;
    static ColorBOX picked_color_box;

    static {
        back = true;
        font = new Font("Helvetica", 0, 20);
        perpendicular = true;
        panel_bbox = new Rectangle(0, 50, Main.PANEL_WIDTH, Main.PANEL_HEIGHT - 200);
        visible_yarn_number = 100;
    }

    static void init() {
        DesignCanvas.number_of_holes = 100;
        DesignCanvas.start_v.y = 100.0;
        Row.pixel_width = 10;
        Row.pixel_height = 20;
        DesignCanvas.pixel_size_width = 25;
        DesignCanvas.set_create_arrow();
        Card.set_polygons();
        DesignCanvas.cards = new ArrayList<Card>();
        HowToMakeCanvas.paint_order_cards = new ArrayList<Card>();
        int i = 0;
        while (i < 10) {
            Card card = new Card(true);
            DesignCanvas.cards.add(card);
            HowToMakeCanvas.paint_order_cards.add(card);
            ++i;
        }
        BFDesignCanvas.construct_color_boxes();
        BFDesignCanvas.set_rotate_button_image();
        Main.mainPanel.scrollBar.setVisible(true);
        BFDesignCanvas.update_yarn_position();
    }

    static void rotate() {
        boolean bl = perpendicular = !perpendicular;
        if (perpendicular) {
            BFDesignCanvas.set_perpendicular();
        } else {
            BFDesignCanvas.set_horizontal();
        }
    }

    static void set_perpendicular() {
        Main.f.setSize(Main.PANEL_WIDTH, Main.PANEL_HEIGHT);
        Main.textileFrame.setSize(Main.TEXTILE_PANEL_WIDTH, Main.TEXTILE_PANEL_HEIGHT);
        Main.textileFrame.setLocation(Main.f.getX() + Main.f.getWidth(), Main.f.getY());
        Main.textilePanel.setSize(new Dimension(Main.textileFrame.getWidth(), Main.textileFrame.getHeight()));
        TextileFrame.panel.remove(TextileFrame.scrollBar);
        TextileFrame.panel.add("West", TextileFrame.scrollBar);
        TextileFrame.scrollBar.setOrientation(1);
        TextileFrame.panel.setVisible(false);
        TextileFrame.panel.setVisible(true);
        Main.textileFrame.setVisible(false);
        Main.textileFrame.setVisible(true);
        Main.toolPanel_sub.remove(Main.mainPanel.scrollBar);
        Main.f.add("West", Main.mainPanel.scrollBar);
        Main.mainPanel.scrollBar.setOrientation(1);
    }

    static void set_horizontal() {
        System.out.println("set_horizontal");
        TextileFrame.panel.remove(TextileFrame.scrollBar);
        TextileFrame.panel.add("South", TextileFrame.scrollBar);
        TextileFrame.scrollBar.setOrientation(0);
        Main.f.setSize(Main.PANEL_WIDTH, Main.PANEL_HEIGHT - 100);
        Main.textileFrame.setSize(Main.PANEL_WIDTH, Main.TEXTILE_PANEL_WIDTH);
        Main.textileFrame.setLocation(Main.f.getX(), Main.f.getY() + Main.f.getHeight());
        Main.textilePanel.setSize(new Dimension(Main.textileFrame.getWidth(), Main.textileFrame.getHeight()));
        Main.f.remove(Main.mainPanel.scrollBar);
        Main.toolPanel_sub.add("North", Main.mainPanel.scrollBar);
        Main.mainPanel.scrollBar.setOrientation(0);
        TextileFrame.panel.setVisible(false);
        TextileFrame.panel.setVisible(true);
        Main.textileFrame.setVisible(false);
        Main.textileFrame.setVisible(true);
    }

    static void set_rotate_button_image() {
    }

    static void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (!perpendicular) {
            g2.rotate(-1.5707963267948966, Mapping.center.x, Mapping.center.y);
        }
        BFDesignCanvas.paint_design_canvas(g2);
        BFDesignCanvas.paint_BF_colors(g);
    }

    static void paint_design_canvas(Graphics g) {
        g.setColor(Color.black);
        BFDesignCanvas.paint_yarns(g);
        BFDesignCanvas.paint_card_numbers(g);
    }

    static void card_up() {
        int i = 0;
        while (i < DesignCanvas.cards.size()) {
            Card card = DesignCanvas.cards.get(i);
            Yarn yarn = new Yarn(card, 0, Color.white);
            card.yarns.add(0, yarn);
            int j = 1;
            while (j < card.yarns.size()) {
                Yarn yarn0 = card.yarns.get(j);
                ++yarn0.label;
                yarn0.set_bbox();
                ++j;
            }
            ++i;
        }
        Main.mainPanel.repaint();
    }

    static void card_down() {
        int i = 0;
        while (i < DesignCanvas.cards.size()) {
            Card card = DesignCanvas.cards.get(i);
            Yarn yarn = new Yarn(card, card.yarns.size(), Color.white);
            card.yarns.add(yarn);
            ++i;
        }
        Main.mainPanel.repaint();
    }

    static void mousePressed(Point _p) {
        Point p = _p;
        if (!perpendicular) {
            p = Mapping.mapping(_p);
        }
        if (picked_color_box != null) {
            BFDesignCanvas.update_picked_color_box();
            return;
        }
        switch (Main.mainPanel.operation_status) {
            case 1: {
                DesignCanvas.picked_yarn = DesignCanvas.pick_yarn(p);
                if (DesignCanvas.picked_yarn == null) break;
                DesignCanvas.picked_yarn.back = !DesignCanvas.picked_yarn.back;
                break;
            }
            case 15: {
                Fill.fill(p);
            }
        }
    }

    static void mouseMoved(Point _p) {
        picked_color_box = BFDesignCanvas.pick_color_box(_p);
    }

    static void ScrollBar_ValueChanged(int value) {
        scrollBar_val = (double)value / 100.0;
        BFDesignCanvas.update_yarn_position();
        Main.mainPanel.repaint_all();
    }

    static void mouseDragged(Point p) {
        Main.mainPanel.repaint_all();
    }

    static void mouseReleased(Point p) {
    }

    static void paint_card_numbers(Graphics g) {
        int i = 0;
        while (i < DesignCanvas.cards.size()) {
            g.setColor(Color.black);
            g.setFont(font);
            g.drawString("" + i, (int)DesignCanvas.start_v.x + DesignCanvas.pixel_size_width * i + DesignCanvas.pixel_size_width / 2, 40);
            ++i;
        }
    }

    static void paint_yarns(Graphics g) {
        int i = 0;
        while (i < DesignCanvas.cards.size()) {
            Card card = DesignCanvas.cards.get(i);
            int j = 0;
            while (j < card.yarns.size()) {
                Yarn yarn = card.yarns.get(j);
                yarn.set_bbox();
                BFDesignCanvas.set_visible(yarn);
                yarn.paint_designCanvas_for_BF(g);
                ++j;
            }
            ++i;
        }
    }

    private static void set_visible(Yarn yarn) {
        yarn.visible = panel_bbox.contains(yarn.bbox);
    }

    static void update_yarn_position() {
        DesignCanvas.start_v.y = 160.0 - (double)(DesignCanvas.pixel_size_height * (DesignCanvas.number_of_holes - 7)) * scrollBar_val;
    }

    static void set_orientation_and_bbox_BF(Yarn yarn) {
        Yarn prev_yarn = yarn.get_prev_yarn();
        yarn.orientation = prev_yarn == null ? 0 : (prev_yarn.back == yarn.back ? (prev_yarn.orientation == 1 || prev_yarn.orientation == 2 ? 3 : 2) : (prev_yarn.orientation == 1 || prev_yarn.orientation == 2 ? 1 : 0));
        if (prev_yarn != null && prev_yarn.polygon != null) {
            yarn.bbox = new Rectangle(prev_yarn.polygon.xpoints[3], prev_yarn.polygon.ypoints[3], DesignCanvas.pixel_size_width, DesignCanvas.pixel_size_height);
        }
    }

    static void convert() {
        int i = 0;
        while (i < DesignCanvas.cards.size()) {
            Card card = DesignCanvas.cards.get(i);
            ++i;
        }
    }

    public static void clear() {
        System.out.println("clear");
        int i = 0;
        while (i < DesignCanvas.cards.size()) {
            Card card = DesignCanvas.cards.get(i);
            int j = 0;
            while (j < card.yarns.size()) {
                Yarn yarn = card.yarns.get(j);
                yarn.back = true;
                ++j;
            }
            card.backGroundColor = Color.white;
            card.foreGroundColor = Color.gray;
            ++i;
        }
    }

    private static void construct_color_boxes() {
        int i = 0;
        while (i < DesignCanvas.cards.size()) {
            Card card = DesignCanvas.cards.get(i);
            int x = (int)DesignCanvas.start_v.x + DesignCanvas.pixel_size_width * i;
            int y = 60;
            card.backColorBOX = new ColorBOX(new Rectangle(x, y, 24, 24), card.backGroundColor, card, 0);
            card.foreColorBOX = new ColorBOX(new Rectangle(x, y + 24, 24, 24), card.foreGroundColor, card, 1);
            ++i;
        }
    }

    private static void paint_BF_colors(Graphics g) {
        int i = 0;
        while (i < DesignCanvas.cards.size()) {
            Card card = DesignCanvas.cards.get(i);
            if (picked_color_box == card.backColorBOX) {
                card.backColorBOX.highlight(g);
            } else {
                card.backColorBOX.paint(g);
            }
            if (picked_color_box == card.foreColorBOX) {
                card.foreColorBOX.highlight(g);
            } else {
                card.foreColorBOX.paint(g);
            }
            ++i;
        }
    }

    static void paint_color_box(Graphics g, Color color, Rectangle bbox) {
        g.setColor(color);
        g.fillRect(bbox.x, bbox.y, bbox.width, bbox.height);
        g.setColor(Color.black);
        g.drawRect(bbox.x, bbox.y, bbox.width, bbox.height);
    }

    private static ColorBOX pick_color_box(Point p) {
        int i = 0;
        while (i < DesignCanvas.cards.size()) {
            Card card = DesignCanvas.cards.get(i);
            ColorBOX colorBOX = card.backColorBOX;
            if (colorBOX.bbox.contains(p)) {
                return colorBOX;
            }
            colorBOX = card.foreColorBOX;
            if (colorBOX.bbox.contains(p)) {
                return colorBOX;
            }
            ++i;
        }
        return null;
    }

    static void update_picked_color_box() {
        if (BFDesignCanvas.picked_color_box.type == 0) {
            BFDesignCanvas.picked_color_box.card.backGroundColor = ColorPalette.current_color;
        } else {
            BFDesignCanvas.picked_color_box.card.foreGroundColor = ColorPalette.current_color;
        }
        BFDesignCanvas.picked_color_box.card.update_color();
    }
}

