/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Card;
import board.Vector2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;

public class Arrow {
    Vector2D start;
    Vector2D end;
    Card card;
    public int HEAD_WIDTH = 10;
    public int HEAD_LENGTH = 10;

    Arrow(Card _card, Vector2D _start, Vector2D _end) {
        this.card = _card;
        this.start = _start;
        this.end = _end;
    }

    Arrow(Vector2D _start, Vector2D _end) {
        this.start = _start;
        this.end = _end;
    }

    public void paint(Graphics g, boolean highlight) {
        if (highlight) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.red);
            g2.setStroke(new BasicStroke(4.0f));
            this.paint_arrow_head(this.end, new Vector2D(this.end, this.start), g2);
            g2.drawLine((int)this.start.x, (int)this.start.y, (int)this.end.x, (int)this.end.y);
            g2.setStroke(new BasicStroke(1.0f));
        } else {
            g.setColor(Color.black);
            this.paint_arrow_head(this.end, new Vector2D(this.end, this.start), g);
            g.drawLine((int)this.start.x, (int)this.start.y, (int)this.end.x, (int)this.end.y);
        }
    }

    public Vector2D paint_arrow_head(Vector2D v, Vector2D vec, Graphics g) {
        vec.normalize();
        Vector2D cross = Vector2D.rotate90(vec);
        Vector2D base = Vector2D.translate(v, Vector2D.multiply(vec, this.HEAD_LENGTH));
        Vector2D v0 = Vector2D.translate(base, Vector2D.multiply(cross, this.HEAD_WIDTH / 2));
        Vector2D v1 = Vector2D.translate(base, Vector2D.multiply(cross, -this.HEAD_WIDTH / 2));
        Polygon polygon = new Polygon();
        polygon.addPoint((int)v.x, (int)v.y);
        polygon.addPoint((int)v0.x, (int)v0.y);
        polygon.addPoint((int)v1.x, (int)v1.y);
        g.fillPolygon(polygon);
        return base;
    }

    public void move(double dx, double dy) {
        this.start.move(dx, dy);
        this.end.move(dx, dy);
    }
}

