/*
 * Decompiled with CFR 0.152.
 */
package VisualNumerics.math;

import VisualNumerics.math.BLAS;
import VisualNumerics.math.DoubleMatrix;
import VisualNumerics.math.DoubleVector;
import VisualNumerics.math.MathException;

public class DoubleCholesky {
    private double[][] fac;
    private double cond;
    private double[][] acopy;
    private int n;
    private static final double SMALLEST = 2.2250738585072E-308;
    private static final double LARGEST = 1.7976931348623E308;
    private static final double EPSILON_LARGE = 2.2204460492503E-16;
    private static final int NB = 129;

    public DoubleCholesky(double[][] dArray) throws IllegalArgumentException, MathException {
        double d;
        int n;
        int n2;
        int n3;
        int n4;
        double[][] dArray2 = new double[8][129];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        DoubleMatrix.CheckMatrix(dArray, nArray, nArray2);
        this.n = nArray[0];
        int n5 = nArray2[0];
        int n6 = this.n;
        int n7 = n5;
        if (!DoubleMatrix.IsSymmetric(dArray)) {
            throw new MathException("Cholesky factorization requires a symmetric matrix.");
        }
        this.fac = DoubleMatrix.copy(dArray);
        this.acopy = new double[n6][n7];
        this.acopy = dArray;
        int n8 = 0;
        while (n8 < this.n - 1) {
            n4 = n8;
            while (n4 < this.n - 1) {
                this.fac[n4 + 1][n8] = this.fac[n8][n4 + 1];
                ++n4;
            }
            ++n8;
        }
        int n9 = 0;
        int n10 = this.n % 8;
        n4 = 1;
        while (n4 <= this.n - n10) {
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18 = (int)Math.min(129.0, (double)(this.n - n4));
            if (this.fac[n4 - 1][n4 - 1] <= 0.0) {
                n9 = n4;
                throw new MathException("Matrix is not positive definite.");
            }
            this.fac[n4 - 1][n4 - 1] = Math.sqrt(this.fac[n4 - 1][n4 - 1]);
            double d2 = 1.0 / this.fac[n4 - 1][n4 - 1];
            n3 = 1;
            while (n3 <= n18) {
                double[] dArray3 = this.fac[n4 - 1];
                int n19 = n4 + n3 - 1;
                dArray3[n19] = dArray3[n19] * d2;
                dArray2[0][n3 - 1] = -this.fac[n4 - 1][n4 + n3 - 1];
                ++n3;
            }
            n2 = n4 + n18 + 1;
            while (n2 <= this.n) {
                double[] dArray4 = this.fac[n4 - 1];
                int n20 = n2 - 1;
                dArray4[n20] = dArray4[n20] * d2;
                ++n2;
            }
            n = 1;
            while (n <= 7) {
                n17 = n;
                while (n17 <= this.n - n4) {
                    double[] dArray5 = this.fac[n4 + n - 1];
                    int n21 = n4 + n17 - 1;
                    dArray5[n21] = dArray5[n21] + this.fac[n4 - 1][n4 + n17 - 1] * dArray2[0][n - 1];
                    ++n17;
                }
                ++n;
            }
            if (this.fac[n4][n4] <= 0.0) {
                n9 = n4 + 1;
                throw new MathException("Matrix is not positive definite.");
            }
            this.fac[n4][n4] = Math.sqrt(this.fac[n4][n4]);
            double d3 = 1.0 / this.fac[n4][n4];
            n17 = 2;
            while (n17 <= n18) {
                double[] dArray6 = this.fac[n4];
                int n22 = n4 + n17 - 1;
                dArray6[n22] = dArray6[n22] * d3;
                dArray2[1][n17 - 1] = -this.fac[n4][n4 + n17 - 1];
                ++n17;
            }
            int n23 = n4 + n18 + 1;
            while (n23 <= this.n) {
                double[] dArray7 = this.fac[n4];
                int n24 = n23 - 1;
                dArray7[n24] = dArray7[n24] * d3;
                ++n23;
            }
            int n25 = 2;
            while (n25 <= 7) {
                n16 = n25;
                while (n16 <= this.n - n4) {
                    double[] dArray8 = this.fac[n4 + n25 - 1];
                    int n26 = n4 + n16 - 1;
                    dArray8[n26] = dArray8[n26] + this.fac[n4][n4 + n16 - 1] * dArray2[1][n25 - 1];
                    ++n16;
                }
                ++n25;
            }
            if (this.fac[n4 + 1][n4 + 1] <= 0.0) {
                n9 = n4 + 2;
                throw new MathException("Matrix is not positive definite.");
            }
            this.fac[n4 + 1][n4 + 1] = Math.sqrt(this.fac[n4 + 1][n4 + 1]);
            double d4 = 1.0 / this.fac[n4 + 1][n4 + 1];
            n16 = 3;
            while (n16 <= n18) {
                double[] dArray9 = this.fac[n4 + 1];
                int n27 = n4 + n16 - 1;
                dArray9[n27] = dArray9[n27] * d4;
                dArray2[2][n16 - 1] = -this.fac[n4 + 1][n4 + n16 - 1];
                ++n16;
            }
            int n28 = n4 + n18 + 1;
            while (n28 <= this.n) {
                double[] dArray10 = this.fac[n4 + 1];
                int n29 = n28 - 1;
                dArray10[n29] = dArray10[n29] * d4;
                ++n28;
            }
            int n30 = 3;
            while (n30 <= 7) {
                n15 = n30;
                while (n15 <= this.n - n4) {
                    double[] dArray11 = this.fac[n4 + n30 - 1];
                    int n31 = n4 + n15 - 1;
                    dArray11[n31] = dArray11[n31] + this.fac[n4 + 1][n4 + n15 - 1] * dArray2[2][n30 - 1];
                    ++n15;
                }
                ++n30;
            }
            if (this.fac[n4 + 2][n4 + 2] <= 0.0) {
                n9 = n4 + 3;
                throw new MathException("Matrix is not positive definite.");
            }
            this.fac[n4 + 2][n4 + 2] = Math.sqrt(this.fac[n4 + 2][n4 + 2]);
            double d5 = 1.0 / this.fac[n4 + 2][n4 + 2];
            n15 = 4;
            while (n15 <= n18) {
                double[] dArray12 = this.fac[n4 + 2];
                int n32 = n4 + n15 - 1;
                dArray12[n32] = dArray12[n32] * d5;
                dArray2[3][n15 - 1] = -this.fac[n4 + 2][n4 + n15 - 1];
                ++n15;
            }
            int n33 = n4 + n18 + 1;
            while (n33 <= this.n) {
                double[] dArray13 = this.fac[n4 + 2];
                int n34 = n33 - 1;
                dArray13[n34] = dArray13[n34] * d5;
                ++n33;
            }
            int n35 = 4;
            while (n35 <= 7) {
                n14 = n35;
                while (n14 <= this.n - n4) {
                    double[] dArray14 = this.fac[n4 + n35 - 1];
                    int n36 = n4 + n14 - 1;
                    dArray14[n36] = dArray14[n36] + this.fac[n4 + 2][n4 + n14 - 1] * dArray2[3][n35 - 1];
                    ++n14;
                }
                ++n35;
            }
            if (this.fac[n4 + 3][n4 + 3] <= 0.0) {
                n9 = n4 + 4;
                throw new MathException("Matrix is not positive definite.");
            }
            this.fac[n4 + 3][n4 + 3] = Math.sqrt(this.fac[n4 + 3][n4 + 3]);
            double d6 = 1.0 / this.fac[n4 + 3][n4 + 3];
            n14 = 5;
            while (n14 <= n18) {
                double[] dArray15 = this.fac[n4 + 3];
                int n37 = n4 + n14 - 1;
                dArray15[n37] = dArray15[n37] * d6;
                dArray2[4][n14 - 1] = -this.fac[n4 + 3][n4 + n14 - 1];
                ++n14;
            }
            int n38 = n4 + n18 + 1;
            while (n38 <= this.n) {
                double[] dArray16 = this.fac[n4 + 3];
                int n39 = n38 - 1;
                dArray16[n39] = dArray16[n39] * d6;
                ++n38;
            }
            int n40 = 5;
            while (n40 <= 7) {
                n13 = n40;
                while (n13 <= this.n - n4) {
                    double[] dArray17 = this.fac[n4 + n40 - 1];
                    int n41 = n4 + n13 - 1;
                    dArray17[n41] = dArray17[n41] + this.fac[n4 + 3][n4 + n13 - 1] * dArray2[4][n40 - 1];
                    ++n13;
                }
                ++n40;
            }
            if (this.fac[n4 + 4][n4 + 4] <= 0.0) {
                n9 = n4 + 5;
                throw new MathException("Matrix is not positive definite.");
            }
            this.fac[n4 + 4][n4 + 4] = Math.sqrt(this.fac[n4 + 4][n4 + 4]);
            double d7 = 1.0 / this.fac[n4 + 4][n4 + 4];
            n13 = 6;
            while (n13 <= n18) {
                double[] dArray18 = this.fac[n4 + 4];
                int n42 = n4 + n13 - 1;
                dArray18[n42] = dArray18[n42] * d7;
                dArray2[5][n13 - 1] = -this.fac[n4 + 4][n4 + n13 - 1];
                ++n13;
            }
            int n43 = n4 + n18 + 1;
            while (n43 <= this.n) {
                double[] dArray19 = this.fac[n4 + 4];
                int n44 = n43 - 1;
                dArray19[n44] = dArray19[n44] * d7;
                ++n43;
            }
            int n45 = 6;
            while (n45 <= 7) {
                n12 = n45;
                while (n12 <= this.n - n4) {
                    double[] dArray20 = this.fac[n4 + n45 - 1];
                    int n46 = n4 + n12 - 1;
                    dArray20[n46] = dArray20[n46] + this.fac[n4 + 4][n4 + n12 - 1] * dArray2[5][n45 - 1];
                    ++n12;
                }
                ++n45;
            }
            if (this.fac[n4 + 5][n4 + 5] <= 0.0) {
                n9 = n4 + 6;
                throw new MathException("Matrix is not positive definite.");
            }
            this.fac[n4 + 5][n4 + 5] = Math.sqrt(this.fac[n4 + 5][n4 + 5]);
            double d8 = 1.0 / this.fac[n4 + 5][n4 + 5];
            n12 = 7;
            while (n12 <= n18) {
                double[] dArray21 = this.fac[n4 + 5];
                int n47 = n4 + n12 - 1;
                dArray21[n47] = dArray21[n47] * d8;
                dArray2[6][n12 - 1] = -this.fac[n4 + 5][n4 + n12 - 1];
                ++n12;
            }
            int n48 = n4 + n18 + 1;
            while (n48 <= this.n) {
                double[] dArray22 = this.fac[n4 + 5];
                int n49 = n48 - 1;
                dArray22[n49] = dArray22[n49] * d8;
                ++n48;
            }
            int n50 = 7;
            while (n50 <= this.n - n4) {
                double[] dArray23 = this.fac[n4 + 6];
                int n51 = n4 + n50 - 1;
                dArray23[n51] = dArray23[n51] + this.fac[n4 + 5][n4 + n50 - 1] * dArray2[6][6];
                ++n50;
            }
            if (this.fac[n4 + 6][n4 + 6] <= 0.0) {
                n9 = n4 + 7;
                throw new MathException("Matrix is not positive definite.");
            }
            this.fac[n4 + 6][n4 + 6] = Math.sqrt(this.fac[n4 + 6][n4 + 6]);
            double d9 = 1.0 / this.fac[n4 + 6][n4 + 6];
            int n52 = 8;
            while (n52 <= n18) {
                double[] dArray24 = this.fac[n4 + 6];
                int n53 = n4 + n52 - 1;
                dArray24[n53] = dArray24[n53] * d9;
                dArray2[7][n52 - 1] = -this.fac[n4 + 6][n4 + n52 - 1];
                ++n52;
            }
            int n54 = n4 + n18 + 1;
            while (n54 <= this.n) {
                double[] dArray25 = this.fac[n4 + 6];
                int n55 = n54 - 1;
                dArray25[n55] = dArray25[n55] * d9;
                ++n54;
            }
            int n56 = 8;
            while (n56 <= n18) {
                n11 = n56;
                while (n11 <= this.n - n4) {
                    double[] dArray26 = this.fac[n4 + n56 - 1];
                    int n57 = n4 + n11 - 1;
                    dArray26[n57] = dArray26[n57] + (this.fac[n4 - 1][n4 + n11 - 1] * dArray2[0][n56 - 1] + this.fac[n4][n4 + n11 - 1] * dArray2[1][n56 - 1] + this.fac[n4 + 1][n4 + n11 - 1] * dArray2[2][n56 - 1] + this.fac[n4 + 2][n4 + n11 - 1] * dArray2[3][n56 - 1] + this.fac[n4 + 3][n4 + n11 - 1] * dArray2[4][n56 - 1] + this.fac[n4 + 4][n4 + n11 - 1] * dArray2[5][n56 - 1] + this.fac[n4 + 5][n4 + n11 - 1] * dArray2[6][n56 - 1] + this.fac[n4 + 6][n4 + n11 - 1] * dArray2[7][n56 - 1]);
                    ++n11;
                }
                ++n56;
            }
            n11 = n4 + 129 + 1;
            while (n11 <= this.n) {
                int n58;
                int n59 = n11 - 1;
                n18 = (int)Math.min((double)(this.n - n59), 129.0);
                int n60 = 0;
                while (n60 <= 7) {
                    n58 = 1;
                    while (n58 <= n18) {
                        dArray2[n60][n58 - 1] = -this.fac[n4 + n60 - 1][n59 + n58 - 1];
                        ++n58;
                    }
                    ++n60;
                }
                n58 = 1;
                while (n58 <= n18) {
                    int n61 = n58;
                    while (n61 <= this.n - n59) {
                        double[] dArray27 = this.fac[n59 + n58 - 1];
                        int n62 = n59 + n61 - 1;
                        dArray27[n62] = dArray27[n62] + (this.fac[n4 - 1][n59 + n61 - 1] * dArray2[0][n58 - 1] + this.fac[n4][n59 + n61 - 1] * dArray2[1][n58 - 1] + this.fac[n4 + 1][n59 + n61 - 1] * dArray2[2][n58 - 1] + this.fac[n4 + 2][n59 + n61 - 1] * dArray2[3][n58 - 1] + this.fac[n4 + 3][n59 + n61 - 1] * dArray2[4][n58 - 1] + this.fac[n4 + 4][n59 + n61 - 1] * dArray2[5][n58 - 1] + this.fac[n4 + 5][n59 + n61 - 1] * dArray2[6][n58 - 1] + this.fac[n4 + 6][n59 + n61 - 1] * dArray2[7][n58 - 1]);
                        ++n61;
                    }
                    ++n58;
                }
                n11 += 129;
            }
            n4 += 8;
        }
        n3 = this.n - n10 + 1;
        if (n10 == 7) {
            if (this.fac[n3 - 1][n3 - 1] <= 0.0) {
                n9 = n3;
                throw new MathException("Matrix is not positive definite.");
            }
            this.fac[n3 - 1][n3 - 1] = Math.sqrt(this.fac[n3 - 1][n3 - 1]);
            d = 1.0 / this.fac[n3 - 1][n3 - 1];
            double[] dArray28 = this.fac[n3 - 1];
            int n63 = n3;
            dArray28[n63] = dArray28[n63] * d;
            double[] dArray29 = this.fac[n3 - 1];
            int n64 = n3 + 1;
            dArray29[n64] = dArray29[n64] * d;
            double[] dArray30 = this.fac[n3 - 1];
            int n65 = n3 + 2;
            dArray30[n65] = dArray30[n65] * d;
            double[] dArray31 = this.fac[n3 - 1];
            int n66 = n3 + 3;
            dArray31[n66] = dArray31[n66] * d;
            double[] dArray32 = this.fac[n3 - 1];
            int n67 = n3 + 4;
            dArray32[n67] = dArray32[n67] * d;
            double[] dArray33 = this.fac[n3 - 1];
            int n68 = n3 + 5;
            dArray33[n68] = dArray33[n68] * d;
            double[] dArray34 = this.fac[n3];
            int n69 = n3;
            dArray34[n69] = dArray34[n69] - this.fac[n3 - 1][n3] * this.fac[n3 - 1][n3];
            double[] dArray35 = this.fac[n3];
            int n70 = n3 + 1;
            dArray35[n70] = dArray35[n70] + -this.fac[n3 - 1][n3 + 1] * this.fac[n3 - 1][n3];
            double[] dArray36 = this.fac[n3];
            int n71 = n3 + 2;
            dArray36[n71] = dArray36[n71] + -this.fac[n3 - 1][n3 + 2] * this.fac[n3 - 1][n3];
            double[] dArray37 = this.fac[n3];
            int n72 = n3 + 3;
            dArray37[n72] = dArray37[n72] + -this.fac[n3 - 1][n3 + 3] * this.fac[n3 - 1][n3];
            double[] dArray38 = this.fac[n3];
            int n73 = n3 + 4;
            dArray38[n73] = dArray38[n73] + -this.fac[n3 - 1][n3 + 4] * this.fac[n3 - 1][n3];
            double[] dArray39 = this.fac[n3];
            int n74 = n3 + 5;
            dArray39[n74] = dArray39[n74] + -this.fac[n3 - 1][n3 + 5] * this.fac[n3 - 1][n3];
            double[] dArray40 = this.fac[n3 + 1];
            int n75 = n3 + 1;
            dArray40[n75] = dArray40[n75] - this.fac[n3 - 1][n3 + 1] * this.fac[n3 - 1][n3 + 1];
            double[] dArray41 = this.fac[n3 + 1];
            int n76 = n3 + 2;
            dArray41[n76] = dArray41[n76] + -this.fac[n3 - 1][n3 + 2] * this.fac[n3 - 1][n3 + 1];
            double[] dArray42 = this.fac[n3 + 1];
            int n77 = n3 + 3;
            dArray42[n77] = dArray42[n77] + -this.fac[n3 - 1][n3 + 3] * this.fac[n3 - 1][n3 + 1];
            double[] dArray43 = this.fac[n3 + 1];
            int n78 = n3 + 4;
            dArray43[n78] = dArray43[n78] + -this.fac[n3 - 1][n3 + 4] * this.fac[n3 - 1][n3 + 1];
            double[] dArray44 = this.fac[n3 + 1];
            int n79 = n3 + 5;
            dArray44[n79] = dArray44[n79] + -this.fac[n3 - 1][n3 + 5] * this.fac[n3 - 1][n3 + 1];
            double[] dArray45 = this.fac[n3 + 2];
            int n80 = n3 + 2;
            dArray45[n80] = dArray45[n80] - this.fac[n3 - 1][n3 + 2] * this.fac[n3 - 1][n3 + 2];
            double[] dArray46 = this.fac[n3 + 2];
            int n81 = n3 + 3;
            dArray46[n81] = dArray46[n81] + -this.fac[n3 - 1][n3 + 3] * this.fac[n3 - 1][n3 + 2];
            double[] dArray47 = this.fac[n3 + 2];
            int n82 = n3 + 4;
            dArray47[n82] = dArray47[n82] + -this.fac[n3 - 1][n3 + 4] * this.fac[n3 - 1][n3 + 2];
            double[] dArray48 = this.fac[n3 + 2];
            int n83 = n3 + 5;
            dArray48[n83] = dArray48[n83] + -this.fac[n3 - 1][n3 + 5] * this.fac[n3 - 1][n3 + 2];
            double[] dArray49 = this.fac[n3 + 3];
            int n84 = n3 + 3;
            dArray49[n84] = dArray49[n84] - this.fac[n3 - 1][n3 + 3] * this.fac[n3 - 1][n3 + 3];
            double[] dArray50 = this.fac[n3 + 3];
            int n85 = n3 + 4;
            dArray50[n85] = dArray50[n85] + -this.fac[n3 - 1][n3 + 4] * this.fac[n3 - 1][n3 + 3];
            double[] dArray51 = this.fac[n3 + 3];
            int n86 = n3 + 5;
            dArray51[n86] = dArray51[n86] + -this.fac[n3 - 1][n3 + 5] * this.fac[n3 - 1][n3 + 3];
            double[] dArray52 = this.fac[n3 + 4];
            int n87 = n3 + 4;
            dArray52[n87] = dArray52[n87] - this.fac[n3 - 1][n3 + 4] * this.fac[n3 - 1][n3 + 4];
            double[] dArray53 = this.fac[n3 + 4];
            int n88 = n3 + 5;
            dArray53[n88] = dArray53[n88] + -this.fac[n3 - 1][n3 + 5] * this.fac[n3 - 1][n3 + 4];
            double[] dArray54 = this.fac[n3 + 5];
            int n89 = n3 + 5;
            dArray54[n89] = dArray54[n89] - this.fac[n3 - 1][n3 + 5] * this.fac[n3 - 1][n3 + 5];
            ++n3;
            --n10;
        }
        if (n10 == 6) {
            if (this.fac[n3 - 1][n3 - 1] <= 0.0) {
                n9 = n3;
                throw new MathException("Matrix is not positive definite.");
            }
            this.fac[n3 - 1][n3 - 1] = Math.sqrt(this.fac[n3 - 1][n3 - 1]);
            d = 1.0 / this.fac[n3 - 1][n3 - 1];
            double[] dArray55 = this.fac[n3 - 1];
            int n90 = n3;
            dArray55[n90] = dArray55[n90] * d;
            double[] dArray56 = this.fac[n3 - 1];
            int n91 = n3 + 1;
            dArray56[n91] = dArray56[n91] * d;
            double[] dArray57 = this.fac[n3 - 1];
            int n92 = n3 + 2;
            dArray57[n92] = dArray57[n92] * d;
            double[] dArray58 = this.fac[n3 - 1];
            int n93 = n3 + 3;
            dArray58[n93] = dArray58[n93] * d;
            double[] dArray59 = this.fac[n3 - 1];
            int n94 = n3 + 4;
            dArray59[n94] = dArray59[n94] * d;
            double[] dArray60 = this.fac[n3];
            int n95 = n3;
            dArray60[n95] = dArray60[n95] - this.fac[n3 - 1][n3] * this.fac[n3 - 1][n3];
            double[] dArray61 = this.fac[n3];
            int n96 = n3 + 1;
            dArray61[n96] = dArray61[n96] + -this.fac[n3 - 1][n3 + 1] * this.fac[n3 - 1][n3];
            double[] dArray62 = this.fac[n3];
            int n97 = n3 + 2;
            dArray62[n97] = dArray62[n97] + -this.fac[n3 - 1][n3 + 2] * this.fac[n3 - 1][n3];
            double[] dArray63 = this.fac[n3];
            int n98 = n3 + 3;
            dArray63[n98] = dArray63[n98] + -this.fac[n3 - 1][n3 + 3] * this.fac[n3 - 1][n3];
            double[] dArray64 = this.fac[n3];
            int n99 = n3 + 4;
            dArray64[n99] = dArray64[n99] + -this.fac[n3 - 1][n3 + 4] * this.fac[n3 - 1][n3];
            double[] dArray65 = this.fac[n3 + 1];
            int n100 = n3 + 1;
            dArray65[n100] = dArray65[n100] - this.fac[n3 - 1][n3 + 1] * this.fac[n3 - 1][n3 + 1];
            double[] dArray66 = this.fac[n3 + 1];
            int n101 = n3 + 2;
            dArray66[n101] = dArray66[n101] + -this.fac[n3 - 1][n3 + 2] * this.fac[n3 - 1][n3 + 1];
            double[] dArray67 = this.fac[n3 + 1];
            int n102 = n3 + 3;
            dArray67[n102] = dArray67[n102] + -this.fac[n3 - 1][n3 + 3] * this.fac[n3 - 1][n3 + 1];
            double[] dArray68 = this.fac[n3 + 1];
            int n103 = n3 + 4;
            dArray68[n103] = dArray68[n103] + -this.fac[n3 - 1][n3 + 4] * this.fac[n3 - 1][n3 + 1];
            double[] dArray69 = this.fac[n3 + 2];
            int n104 = n3 + 2;
            dArray69[n104] = dArray69[n104] - this.fac[n3 - 1][n3 + 2] * this.fac[n3 - 1][n3 + 2];
            double[] dArray70 = this.fac[n3 + 2];
            int n105 = n3 + 3;
            dArray70[n105] = dArray70[n105] + -this.fac[n3 - 1][n3 + 3] * this.fac[n3 - 1][n3 + 2];
            double[] dArray71 = this.fac[n3 + 2];
            int n106 = n3 + 4;
            dArray71[n106] = dArray71[n106] + -this.fac[n3 - 1][n3 + 4] * this.fac[n3 - 1][n3 + 2];
            double[] dArray72 = this.fac[n3 + 3];
            int n107 = n3 + 3;
            dArray72[n107] = dArray72[n107] - this.fac[n3 - 1][n3 + 3] * this.fac[n3 - 1][n3 + 3];
            double[] dArray73 = this.fac[n3 + 3];
            int n108 = n3 + 4;
            dArray73[n108] = dArray73[n108] + -this.fac[n3 - 1][n3 + 4] * this.fac[n3 - 1][n3 + 3];
            double[] dArray74 = this.fac[n3 + 4];
            int n109 = n3 + 4;
            dArray74[n109] = dArray74[n109] - this.fac[n3 - 1][n3 + 4] * this.fac[n3 - 1][n3 + 4];
            ++n3;
            --n10;
        }
        if (n10 == 5) {
            if (this.fac[n3 - 1][n3 - 1] <= 0.0) {
                n9 = n3;
                throw new MathException("Matrix is not positive definite.");
            }
            this.fac[n3 - 1][n3 - 1] = Math.sqrt(this.fac[n3 - 1][n3 - 1]);
            d = 1.0 / this.fac[n3 - 1][n3 - 1];
            double[] dArray75 = this.fac[n3 - 1];
            int n110 = n3;
            dArray75[n110] = dArray75[n110] * d;
            double[] dArray76 = this.fac[n3 - 1];
            int n111 = n3 + 1;
            dArray76[n111] = dArray76[n111] * d;
            double[] dArray77 = this.fac[n3 - 1];
            int n112 = n3 + 2;
            dArray77[n112] = dArray77[n112] * d;
            double[] dArray78 = this.fac[n3 - 1];
            int n113 = n3 + 3;
            dArray78[n113] = dArray78[n113] * d;
            double[] dArray79 = this.fac[n3];
            int n114 = n3;
            dArray79[n114] = dArray79[n114] - this.fac[n3 - 1][n3] * this.fac[n3 - 1][n3];
            double[] dArray80 = this.fac[n3];
            int n115 = n3 + 1;
            dArray80[n115] = dArray80[n115] + -this.fac[n3 - 1][n3 + 1] * this.fac[n3 - 1][n3];
            double[] dArray81 = this.fac[n3];
            int n116 = n3 + 2;
            dArray81[n116] = dArray81[n116] + -this.fac[n3 - 1][n3 + 2] * this.fac[n3 - 1][n3];
            double[] dArray82 = this.fac[n3];
            int n117 = n3 + 3;
            dArray82[n117] = dArray82[n117] + -this.fac[n3 - 1][n3 + 3] * this.fac[n3 - 1][n3];
            double[] dArray83 = this.fac[n3 + 1];
            int n118 = n3 + 1;
            dArray83[n118] = dArray83[n118] - this.fac[n3 - 1][n3 + 1] * this.fac[n3 - 1][n3 + 1];
            double[] dArray84 = this.fac[n3 + 1];
            int n119 = n3 + 2;
            dArray84[n119] = dArray84[n119] + -this.fac[n3 - 1][n3 + 2] * this.fac[n3 - 1][n3 + 1];
            double[] dArray85 = this.fac[n3 + 1];
            int n120 = n3 + 3;
            dArray85[n120] = dArray85[n120] + -this.fac[n3 - 1][n3 + 3] * this.fac[n3 - 1][n3 + 1];
            double[] dArray86 = this.fac[n3 + 2];
            int n121 = n3 + 2;
            dArray86[n121] = dArray86[n121] - this.fac[n3 - 1][n3 + 2] * this.fac[n3 - 1][n3 + 2];
            double[] dArray87 = this.fac[n3 + 2];
            int n122 = n3 + 3;
            dArray87[n122] = dArray87[n122] + -this.fac[n3 - 1][n3 + 3] * this.fac[n3 - 1][n3 + 2];
            double[] dArray88 = this.fac[n3 + 3];
            int n123 = n3 + 3;
            dArray88[n123] = dArray88[n123] - this.fac[n3 - 1][n3 + 3] * this.fac[n3 - 1][n3 + 3];
            ++n3;
            --n10;
        }
        if (n10 == 4) {
            if (this.fac[n3 - 1][n3 - 1] <= 0.0) {
                n9 = n3;
                throw new MathException("Matrix is not positive definite.");
            }
            this.fac[n3 - 1][n3 - 1] = Math.sqrt(this.fac[n3 - 1][n3 - 1]);
            d = 1.0 / this.fac[n3 - 1][n3 - 1];
            double[] dArray89 = this.fac[n3 - 1];
            int n124 = n3;
            dArray89[n124] = dArray89[n124] * d;
            double[] dArray90 = this.fac[n3 - 1];
            int n125 = n3 + 1;
            dArray90[n125] = dArray90[n125] * d;
            double[] dArray91 = this.fac[n3 - 1];
            int n126 = n3 + 2;
            dArray91[n126] = dArray91[n126] * d;
            double[] dArray92 = this.fac[n3];
            int n127 = n3;
            dArray92[n127] = dArray92[n127] - this.fac[n3 - 1][n3] * this.fac[n3 - 1][n3];
            double[] dArray93 = this.fac[n3];
            int n128 = n3 + 1;
            dArray93[n128] = dArray93[n128] + -this.fac[n3 - 1][n3 + 1] * this.fac[n3 - 1][n3];
            double[] dArray94 = this.fac[n3];
            int n129 = n3 + 2;
            dArray94[n129] = dArray94[n129] + -this.fac[n3 - 1][n3 + 2] * this.fac[n3 - 1][n3];
            double[] dArray95 = this.fac[n3 + 1];
            int n130 = n3 + 1;
            dArray95[n130] = dArray95[n130] - this.fac[n3 - 1][n3 + 1] * this.fac[n3 - 1][n3 + 1];
            double[] dArray96 = this.fac[n3 + 1];
            int n131 = n3 + 2;
            dArray96[n131] = dArray96[n131] + -this.fac[n3 - 1][n3 + 2] * this.fac[n3 - 1][n3 + 1];
            double[] dArray97 = this.fac[n3 + 2];
            int n132 = n3 + 2;
            dArray97[n132] = dArray97[n132] - this.fac[n3 - 1][n3 + 2] * this.fac[n3 - 1][n3 + 2];
            ++n3;
            --n10;
        }
        if (n10 == 3) {
            if (this.fac[n3 - 1][n3 - 1] <= 0.0) {
                n9 = n3;
                throw new MathException("Matrix is not positive definite.");
            }
            this.fac[n3 - 1][n3 - 1] = Math.sqrt(this.fac[n3 - 1][n3 - 1]);
            d = 1.0 / this.fac[n3 - 1][n3 - 1];
            double[] dArray98 = this.fac[n3 - 1];
            int n133 = n3;
            dArray98[n133] = dArray98[n133] * d;
            double[] dArray99 = this.fac[n3 - 1];
            int n134 = n3 + 1;
            dArray99[n134] = dArray99[n134] * d;
            double[] dArray100 = this.fac[n3];
            int n135 = n3;
            dArray100[n135] = dArray100[n135] - this.fac[n3 - 1][n3] * this.fac[n3 - 1][n3];
            double[] dArray101 = this.fac[n3];
            int n136 = n3 + 1;
            dArray101[n136] = dArray101[n136] + -this.fac[n3 - 1][n3 + 1] * this.fac[n3 - 1][n3];
            double[] dArray102 = this.fac[n3 + 1];
            int n137 = n3 + 1;
            dArray102[n137] = dArray102[n137] - this.fac[n3 - 1][n3 + 1] * this.fac[n3 - 1][n3 + 1];
            ++n3;
            --n10;
        }
        if (n10 == 2) {
            if (this.fac[n3 - 1][n3 - 1] <= 0.0) {
                n9 = n3;
                throw new MathException("Matrix is not positive definite.");
            }
            this.fac[n3 - 1][n3 - 1] = Math.sqrt(this.fac[n3 - 1][n3 - 1]);
            d = 1.0 / this.fac[n3 - 1][n3 - 1];
            double[] dArray103 = this.fac[n3 - 1];
            int n138 = n3;
            dArray103[n138] = dArray103[n138] * d;
            double[] dArray104 = this.fac[n3];
            int n139 = n3;
            dArray104[n139] = dArray104[n139] - this.fac[n3 - 1][n3] * this.fac[n3 - 1][n3];
            ++n3;
            --n10;
        }
        if (n10 == 1) {
            if (this.fac[n3 - 1][n3 - 1] <= 0.0) {
                n9 = n3;
                throw new MathException("Matrix is not positive definite.");
            }
            this.fac[n3 - 1][n3 - 1] = Math.sqrt(this.fac[n3 - 1][n3 - 1]);
        }
        n2 = 0;
        while (n2 < this.n - 1) {
            n = n2;
            while (n < this.n - 1) {
                this.fac[n + 1][n2] = this.fac[n2][n + 1];
                ++n;
            }
            ++n2;
        }
    }

    public double[][] R() {
        return this.fac;
    }

    public double condition() throws MathException {
        int n;
        double d;
        int n2;
        double d2;
        this.cond = 1.0;
        double d3 = BLAS.dnr1rr(this.n, this.n, this.acopy);
        double d4 = 1.0;
        double[] dArray = new double[this.n];
        int n3 = 0;
        while (n3 < this.n) {
            int n4;
            if (dArray[n3] != 0.0) {
                d4 = Math.abs(d4);
                if (-dArray[n3] < 0.0) {
                    d4 = -d4;
                }
            }
            if (Math.abs(d4 - dArray[n3]) > this.fac[n3][n3]) {
                d2 = this.fac[n3][n3] / Math.abs(d4 - dArray[n3]);
                BLAS.dscal(this.n, d2, dArray, 0, 1);
                d4 *= d2;
            }
            double d5 = d4 - dArray[n3];
            double d6 = -d4 - dArray[n3];
            d2 = Math.abs(d5);
            double d7 = Math.abs(d6);
            if (Math.abs(this.fac[n3][n3]) > 2.2250738585072E-308) {
                d5 /= this.fac[n3][n3];
                d6 /= this.fac[n3][n3];
            }
            if ((n4 = n3 + 1) < this.n) {
                int n5 = n3 + 1;
                while (n5 < this.n) {
                    d7 += Math.abs(dArray[n5] + d6 * this.fac[n3][n5]);
                    ++n5;
                }
                n2 = 1;
                while (n2 < this.n - n3) {
                    int n6 = n2 + n3;
                    dArray[n6] = dArray[n6] + d5 * this.fac[n3][n2 + n3];
                    ++n2;
                }
                int n7 = 1;
                while (n7 < this.n - n3) {
                    d2 += Math.abs(dArray[n7 + n3]);
                    ++n7;
                }
                if (d2 < d7) {
                    d = d6 - d5;
                    d5 = d6;
                    n = 1;
                    while (n < this.n - n3) {
                        int n8 = n + n3;
                        dArray[n8] = dArray[n8] + d * this.fac[n3][n + n3];
                        ++n;
                    }
                }
            }
            dArray[n3] = d5;
            ++n3;
        }
        d2 = 1.0 / BLAS.dasum(this.n, dArray, 0, 1);
        BLAS.dscal(this.n, d2, dArray, 0, 1);
        n3 = this.n - 1;
        while (n3 >= 0) {
            if (Math.abs(dArray[n3]) > this.fac[n3][n3]) {
                d2 = this.fac[n3][n3] / Math.abs(dArray[n3]);
                BLAS.dscal(this.n, d2, dArray, 0, 1);
            }
            if (Math.abs(this.fac[n3][n3]) > 2.2250738585072E-308) {
                int n9 = n3;
                dArray[n9] = dArray[n9] / this.fac[n3][n3];
            }
            d = -dArray[n3];
            n2 = 0;
            while (n2 < n3) {
                int n10 = n2;
                dArray[n10] = dArray[n10] - this.fac[n2][n3] * dArray[n3];
                ++n2;
            }
            --n3;
        }
        d2 = 1.0 / BLAS.dasum(this.n, dArray, 0, 1);
        BLAS.dscal(this.n, d2, dArray, 0, 1);
        double d8 = 1.0;
        n3 = 0;
        while (n3 < this.n) {
            double d9 = 0.0;
            n = 0;
            while (n < n3) {
                d9 += this.fac[n][n3] * dArray[n];
                ++n;
            }
            int n11 = n3;
            dArray[n11] = dArray[n11] - d9;
            if (Math.abs(dArray[n3]) > this.fac[n3][n3]) {
                d2 = this.fac[n3][n3] / Math.abs(dArray[n3]);
                BLAS.dscal(this.n, d2, dArray, 0, 1);
                d8 *= d2;
            }
            if (Math.abs(this.fac[n3][n3]) > 2.2250738585072E-308) {
                int n12 = n3;
                dArray[n12] = dArray[n12] / this.fac[n3][n3];
            }
            ++n3;
        }
        d2 = 1.0 / BLAS.dasum(this.n, dArray, 0, 1);
        BLAS.dscal(this.n, d2, dArray, 0, 1);
        d8 *= d2;
        n3 = this.n - 1;
        while (n3 >= 0) {
            if (Math.abs(dArray[n3]) > this.fac[n3][n3]) {
                d2 = this.fac[n3][n3] / Math.abs(dArray[n3]);
                BLAS.dscal(this.n, d2, dArray, 0, 1);
                d8 *= d2;
            }
            if (Math.abs(this.fac[n3][n3]) > 2.2250738585072E-308) {
                int n13 = n3;
                dArray[n13] = dArray[n13] / this.fac[n3][n3];
            }
            d = -dArray[n3];
            int n14 = 0;
            while (n14 < n3) {
                int n15 = n14;
                dArray[n15] = dArray[n15] - this.fac[n14][n3] * dArray[n3];
                ++n14;
            }
            --n3;
        }
        d2 = 1.0 / BLAS.dasum(this.n, dArray, 0, 1);
        BLAS.dscal(this.n, d2, dArray, 0, 1);
        d8 *= d2;
        if (d3 != 0.0) {
            this.cond = d8 / d3;
        }
        if (this.cond <= 2.2204460492503E-16) {
            throw new MathException("The matrix is algorithmically singular.");
        }
        return this.cond;
    }

    public double determinant() {
        double d = 1.0;
        int n = 0;
        while (n < this.n) {
            d *= this.fac[n][n];
            ++n;
        }
        return d * d;
    }

    public double[][] inverse() throws MathException {
        int n;
        int n2;
        int n3;
        double d;
        int n4;
        double[][] dArray = DoubleMatrix.copy(this.fac);
        int n5 = 0;
        while (n5 < this.n) {
            n4 = 0;
            while (n4 < n5) {
                dArray[n5][n4] = 0.0;
                ++n4;
            }
            ++n5;
        }
        n4 = 0;
        while (n4 < this.n) {
            int n6 = n4;
            if (Math.abs(dArray[n4][n4]) <= 2.2250738585072E-308) {
                throw new MathException("The matrix to be inverted is singular.");
            }
            dArray[n4][n4] = 1.0 / dArray[n4][n4];
            d = -dArray[n4][n4];
            n3 = 0;
            while (n3 < n4) {
                double[] dArray2 = dArray[n3];
                int n7 = n4;
                dArray2[n7] = dArray2[n7] * d;
                ++n3;
            }
            if (n4 < this.n - 1) {
                n2 = 0;
                while (n2 < this.n - n4 - 1) {
                    n = 0;
                    while (n < n4) {
                        double[] dArray3 = dArray[n];
                        int n8 = n4 + 1 + n2;
                        dArray3[n8] = dArray3[n8] + dArray[n][n4] * dArray[n4][n4 + 1 + n2];
                        ++n;
                    }
                    ++n2;
                }
                n = 0;
                while (n < this.n - n4 - 1) {
                    double[] dArray4 = dArray[n4];
                    int n9 = n4 + 1 + n;
                    dArray4[n9] = dArray4[n9] * dArray[n4][n4];
                    ++n;
                }
            }
            ++n4;
        }
        n3 = 0;
        while (n3 < this.n) {
            n2 = 0;
            while (n2 < n3) {
                n = 0;
                while (n < n2 + 1) {
                    double[] dArray5 = dArray[n];
                    int n10 = n2;
                    dArray5[n10] = dArray5[n10] + dArray[n][n3] * dArray[n2][n3];
                    ++n;
                }
                ++n2;
            }
            d = dArray[n3][n3];
            n = 0;
            while (n < n3 + 1) {
                double[] dArray6 = dArray[n];
                int n11 = n3;
                dArray6[n11] = dArray6[n11] * d;
                ++n;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < this.n) {
            n = n2;
            while (n < this.n - 1) {
                dArray[n + 1][n2] = dArray[n2][n + 1];
                ++n;
            }
            ++n2;
        }
        return dArray;
    }

    public double[] solve(double[] dArray) throws MathException {
        int n;
        double d;
        int n2 = 0;
        while (n2 < this.n) {
            if (this.fac[n2][n2] == 0.0) {
                throw new MathException("The input triangular matrix is singular.");
            }
            ++n2;
        }
        double[] dArray2 = DoubleVector.copy(dArray);
        int n3 = 0;
        while (n3 < this.n) {
            d = 0.0;
            n = 0;
            while (n < n3) {
                d += this.fac[n3][n] * dArray2[n];
                ++n;
            }
            int n4 = n3;
            dArray2[n4] = dArray2[n4] - d;
            int n5 = n3;
            dArray2[n5] = dArray2[n5] / this.fac[n3][n3];
            ++n3;
        }
        n = this.n - 1;
        while (n >= 0) {
            d = 0.0;
            if (n < this.n - 1) {
                int n6 = n + 1;
                while (n6 < this.n) {
                    d += this.fac[n][n6] * dArray2[n6];
                    ++n6;
                }
            }
            int n7 = n;
            dArray2[n7] = dArray2[n7] - d;
            int n8 = n;
            dArray2[n8] = dArray2[n8] / this.fac[n][n];
            --n;
        }
        return dArray2;
    }
}

