/*
 * Decompiled with CFR 0.152.
 */
package VisualNumerics.math;

import VisualNumerics.math.Complex;

public final class ComplexVector {
    public static Complex[] add(double d, Complex[] complexArray) {
        Complex[] complexArray2 = new Complex[complexArray.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray2[n] = Complex.add(d, complexArray[n]);
            ++n;
        }
        return complexArray2;
    }

    public static Complex[] add(Complex complex, Complex[] complexArray) {
        Complex[] complexArray2 = new Complex[complexArray.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray2[n] = Complex.add(complex, complexArray[n]);
            ++n;
        }
        return complexArray2;
    }

    public static Complex[] add(double[] dArray, Complex[] complexArray) {
        Complex[] complexArray2 = new Complex[complexArray.length];
        if (dArray.length == complexArray.length) {
            int n = 0;
            while (n < complexArray.length) {
                complexArray2[n] = Complex.add(dArray[n], complexArray[n]);
                ++n;
            }
        } else {
            throw new IllegalArgumentException("Vectors must have the same length.");
        }
        return complexArray2;
    }

    public static Complex[] add(Complex[] complexArray, Complex[] complexArray2) {
        Complex[] complexArray3 = new Complex[complexArray2.length];
        if (complexArray.length == complexArray2.length) {
            int n = 0;
            while (n < complexArray2.length) {
                complexArray3[n] = Complex.add(complexArray[n], complexArray2[n]);
                ++n;
            }
        } else {
            throw new IllegalArgumentException("Vectors must have the same length.");
        }
        return complexArray3;
    }

    public static Complex[] conjugate(Complex[] complexArray) {
        int n = complexArray.length;
        Complex[] complexArray2 = new Complex[n];
        int n2 = 0;
        while (n2 < n) {
            complexArray2[n2] = Complex.conjugate(complexArray[n2]);
            ++n2;
        }
        return complexArray2;
    }

    public static double[] imag(Complex[] complexArray) {
        int n = complexArray.length;
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = complexArray[n2].im;
            ++n2;
        }
        return dArray;
    }

    public static double infinityNorm(Complex[] complexArray) {
        double d = Complex.abs(complexArray[0]);
        int n = 1;
        while (n < complexArray.length) {
            double d2 = Complex.abs(complexArray[n]);
            d = Math.max(d, d2);
            ++n;
        }
        return d;
    }

    public static Complex innerProduct(Complex[] complexArray, Complex[] complexArray2) {
        Complex complex = new Complex();
        int n = 0;
        while (n < complexArray.length) {
            complex = Complex.add(complex, Complex.multiply(complexArray[n], complexArray2[n]));
            ++n;
        }
        return complex;
    }

    public static Complex[] multiply(double d, Complex[] complexArray) {
        Complex[] complexArray2 = new Complex[complexArray.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray2[n] = Complex.multiply(d, complexArray[n]);
            ++n;
        }
        return complexArray2;
    }

    public static Complex[] multiply(Complex complex, Complex[] complexArray) {
        Complex[] complexArray2 = new Complex[complexArray.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray2[n] = Complex.multiply(complex, complexArray[n]);
            ++n;
        }
        return complexArray2;
    }

    public static Complex[] multiply(double[] dArray, Complex[] complexArray) {
        Complex[] complexArray2 = new Complex[complexArray.length];
        if (dArray.length == complexArray.length) {
            int n = 0;
            while (n < complexArray.length) {
                complexArray2[n] = Complex.multiply(dArray[n], complexArray[n]);
                ++n;
            }
        } else {
            throw new IllegalArgumentException("Vectors must have the same length.");
        }
        return complexArray2;
    }

    public static Complex[] multiply(Complex[] complexArray, Complex[] complexArray2) {
        Complex[] complexArray3 = new Complex[complexArray2.length];
        if (complexArray.length == complexArray2.length) {
            int n = 0;
            while (n < complexArray2.length) {
                complexArray3[n] = Complex.multiply(complexArray[n], complexArray2[n]);
                ++n;
            }
        } else {
            throw new IllegalArgumentException("Vectors must have the same length.");
        }
        return complexArray3;
    }

    static void multiplyEq(Complex[] complexArray, Complex complex) {
        int n = 0;
        while (n < complexArray.length) {
            complexArray[n].multiply(complex);
            ++n;
        }
    }

    public static double oneNorm(Complex[] complexArray) {
        double d = 0.0;
        int n = 0;
        while (n < complexArray.length) {
            d += Complex.abs(complexArray[n]);
            ++n;
        }
        return d;
    }

    public static Complex product(Complex[] complexArray) {
        Complex complex = new Complex(1.0);
        int n = 0;
        while (n < complexArray.length) {
            complex = Complex.multiply(complex, complexArray[n]);
            ++n;
        }
        return complex;
    }

    public static double[] real(Complex[] complexArray) {
        int n = complexArray.length;
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = complexArray[n2].re;
            ++n2;
        }
        return dArray;
    }

    public static Complex[] subtract(double[] dArray, Complex[] complexArray) {
        Complex[] complexArray2 = new Complex[complexArray.length];
        if (dArray.length == complexArray.length) {
            int n = 0;
            while (n < complexArray.length) {
                complexArray2[n] = Complex.subtract(dArray[n], complexArray[n]);
                ++n;
            }
        } else {
            throw new IllegalArgumentException("Vectors must have the same length.");
        }
        return complexArray2;
    }

    public static Complex[] subtract(Complex[] complexArray, double d) {
        Complex[] complexArray2 = new Complex[complexArray.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray2[n] = Complex.subtract(complexArray[n], d);
            ++n;
        }
        return complexArray2;
    }

    public static Complex[] subtract(Complex[] complexArray, Complex complex) {
        Complex[] complexArray2 = new Complex[complexArray.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray2[n] = Complex.subtract(complexArray[n], complex);
            ++n;
        }
        return complexArray2;
    }

    public static Complex[] subtract(Complex[] complexArray, double[] dArray) {
        Complex[] complexArray2 = new Complex[complexArray.length];
        if (dArray.length == complexArray.length) {
            int n = 0;
            while (n < complexArray.length) {
                complexArray2[n] = Complex.subtract(complexArray[n], dArray[n]);
                ++n;
            }
        } else {
            throw new IllegalArgumentException("Vectors must have the same length.");
        }
        return complexArray2;
    }

    public static Complex[] subtract(Complex[] complexArray, Complex[] complexArray2) {
        Complex[] complexArray3 = new Complex[complexArray2.length];
        if (complexArray.length == complexArray2.length) {
            int n = 0;
            while (n < complexArray2.length) {
                complexArray3[n] = Complex.subtract(complexArray[n], complexArray2[n]);
                ++n;
            }
        } else {
            throw new IllegalArgumentException("Vectors must have the same length.");
        }
        return complexArray3;
    }

    public static Complex sum(Complex[] complexArray) {
        Complex complex = new Complex();
        int n = 0;
        while (n < complexArray.length) {
            complex = Complex.add(complex, complexArray[n]);
            ++n;
        }
        return complex;
    }

    public static double twoNorm(Complex[] complexArray) {
        double d;
        double d2 = 0.0;
        double d3 = 1.0;
        double[] dArray = new double[]{1.0010415475916E-146, 4.4989137945432E161, 2.2227587494851E-162, 1.9979190722022E146, 5.0104209000224E-293, 1.9958403095347E292};
        double d4 = d2;
        double d5 = 0.0;
        int n = 0;
        while (n < complexArray.length) {
            d4 += Complex.abs(complexArray[n]);
            ++n;
        }
        if (d4 < (double)complexArray.length * dArray[0]) {
            d4 = dArray[1];
            d = dArray[2];
        } else if (d4 > dArray[3]) {
            d4 = dArray[4];
            d = dArray[5];
        } else {
            int n2 = 0;
            while (n2 < complexArray.length) {
                d5 += complexArray[n2].re * complexArray[n2].re + complexArray[n2].im * complexArray[n2].im;
                ++n2;
            }
            return Math.sqrt(d5);
        }
        int n3 = 0;
        while (n3 < complexArray.length) {
            d5 += d4 * complexArray[n3].re * (d4 * complexArray[n3].re) + d4 * complexArray[n3].im * (d4 * complexArray[n3].im);
            ++n3;
        }
        return Math.sqrt(d5) * d;
    }
}

