/*
 * Decompiled with CFR 0.152.
 */
package VisualNumerics.math;

import VisualNumerics.math.Complex;
import VisualNumerics.math.ComplexLU;
import VisualNumerics.math.ComplexQR;
import VisualNumerics.math.ComplexVector;
import VisualNumerics.math.MathException;

public class ComplexMatrix {
    static void CheckMatrix(Complex[][] complexArray, int[] nArray, int[] nArray2) throws IllegalArgumentException {
        nArray[0] = complexArray.length;
        nArray2[0] = complexArray[0].length;
        int n = 1;
        while (n < nArray[0]) {
            if (complexArray[n].length != nArray2[0]) {
                throw new IllegalArgumentException("The lengths of the rows of the input matrix are not consistent.");
            }
            ++n;
        }
    }

    public static Complex[] QRsolve(Complex[][] complexArray, Complex[] complexArray2) throws IllegalArgumentException, MathException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ComplexMatrix.CheckMatrix(complexArray, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        int n3 = complexArray2.length;
        if (n != n3) {
            throw new IllegalArgumentException("The number of rows in the input matrix A is not equal to the number of elements in the input vector B.");
        }
        try {
            ComplexQR complexQR = new ComplexQR(complexArray);
            return complexQR.solve(complexArray2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (MathException mathException) {
            throw mathException;
        }
    }

    public static Complex[][] add(Complex[][] complexArray, Complex[][] complexArray2) throws IllegalArgumentException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ComplexMatrix.CheckMatrix(complexArray, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        ComplexMatrix.CheckMatrix(complexArray2, nArray, nArray2);
        int n3 = nArray[0];
        int n4 = nArray2[0];
        if (n != n3 || n2 != n4) {
            throw new IllegalArgumentException("Matrices A and B must have similar dimensions.");
        }
        Complex[][] complexArray3 = new Complex[n3][n4];
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n4) {
                complexArray3[n5][n6] = Complex.add(complexArray[n5][n6], complexArray2[n5][n6]);
                ++n6;
            }
            ++n5;
        }
        return complexArray3;
    }

    public static Complex[][] adjoint(Complex[][] complexArray) throws IllegalArgumentException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ComplexMatrix.CheckMatrix(complexArray, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        Complex[][] complexArray2 = new Complex[n2][n];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                complexArray2[n3][n4] = new Complex(Complex.conjugate(complexArray[n4][n3]));
                ++n4;
            }
            ++n3;
        }
        return complexArray2;
    }

    public static Complex determinant(Complex[][] complexArray) throws IllegalArgumentException, MathException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ComplexMatrix.CheckMatrix(complexArray, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        ComplexLU complexLU = new ComplexLU(complexArray);
        return complexLU.determinant();
    }

    public static double frobeniusNorm(Complex[][] complexArray) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        Complex[] complexArray2 = new Complex[n];
        int n3 = 0;
        while (n3 < n) {
            complexArray2[n3] = complexArray[n3][0];
            ++n3;
        }
        double d = ComplexVector.twoNorm(complexArray2);
        int n4 = 1;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                complexArray2[n5] = complexArray[n5][n4];
                ++n5;
            }
            double d2 = ComplexVector.twoNorm(complexArray2);
            d = ComplexMatrix.hypt(d, d2);
            ++n4;
        }
        return d;
    }

    private static double hypt(double d, double d2) {
        double d3 = Math.max(Math.abs(d), Math.abs(d2));
        if (d3 == 0.0) {
            return d3;
        }
        double d4 = Math.min(Math.abs(d), Math.abs(d2)) / d3;
        d4 = Math.pow(d4, 2.0);
        double d5 = 4.0 + d4;
        while (d5 != 4.0) {
            double d6 = d4 / d5;
            double d7 = 1.0 + 2.0 * d6;
            d3 *= d7;
            d4 = d6 / d7 * (d6 / d7) * d4;
            d5 = 4.0 + d4;
        }
        return d3;
    }

    public static double infinityNorm(Complex[][] complexArray) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        double d = 0.0;
        int n3 = 0;
        while (n3 < n) {
            double d2 = 0.0;
            int n4 = 0;
            while (n4 < n2) {
                d2 += Complex.abs(complexArray[n3][n4]);
                ++n4;
            }
            if (d2 > d) {
                d = d2;
            }
            ++n3;
        }
        return d;
    }

    public static Complex[][] inverse(Complex[][] complexArray) throws IllegalArgumentException, MathException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ComplexMatrix.CheckMatrix(complexArray, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        ComplexLU complexLU = new ComplexLU(complexArray);
        return complexLU.inverse();
    }

    public static Complex[] multiply(Complex[] complexArray, Complex[][] complexArray2) throws IllegalArgumentException {
        int n = complexArray.length;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ComplexMatrix.CheckMatrix(complexArray2, nArray, nArray2);
        int n2 = nArray[0];
        int n3 = nArray2[0];
        if (n != n2) {
            throw new IllegalArgumentException("The number of elements in the input vector is not equal to the number of rows in the input matrix.");
        }
        Complex[] complexArray3 = new Complex[n3];
        int n4 = 0;
        while (n4 < n3) {
            complexArray3[n4] = new Complex();
            int n5 = 0;
            while (n5 < n) {
                Complex complex = Complex.multiply(complexArray[n5], complexArray2[n5][n4]);
                complexArray3[n4] = Complex.add(complexArray3[n4], complex);
                ++n5;
            }
            ++n4;
        }
        return complexArray3;
    }

    public static Complex[] multiply(Complex[][] complexArray, Complex[] complexArray2) throws IllegalArgumentException {
        int n = complexArray2.length;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ComplexMatrix.CheckMatrix(complexArray, nArray, nArray2);
        int n2 = nArray[0];
        int n3 = nArray2[0];
        if (n3 != n) {
            throw new IllegalArgumentException("The number of columns in the input matrix is not equal to the number of elements in the input vector.");
        }
        Complex[] complexArray3 = new Complex[n2];
        int n4 = 0;
        while (n4 < n2) {
            complexArray3[n4] = new Complex();
            int n5 = 0;
            while (n5 < n) {
                Complex complex = Complex.multiply(complexArray[n4][n5], complexArray2[n5]);
                complexArray3[n4] = Complex.add(complexArray3[n4], complex);
                ++n5;
            }
            ++n4;
        }
        return complexArray3;
    }

    public static Complex[][] multiply(Complex[][] complexArray, Complex[][] complexArray2) throws IllegalArgumentException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ComplexMatrix.CheckMatrix(complexArray, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        ComplexMatrix.CheckMatrix(complexArray2, nArray, nArray2);
        int n3 = nArray[0];
        int n4 = nArray2[0];
        if (n2 != n3) {
            throw new IllegalArgumentException("The number of columns in the input matrix A is not equal to the number of rows in the input matrix B.");
        }
        Complex[][] complexArray3 = new Complex[n][n4];
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < n4) {
                complexArray3[n5][n6] = new Complex();
                int n7 = 0;
                while (n7 < n3) {
                    Complex complex = Complex.multiply(complexArray[n5][n7], complexArray2[n7][n6]);
                    complexArray3[n5][n6] = Complex.add(complexArray3[n5][n6], complex);
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
        return complexArray3;
    }

    public static double oneNorm(Complex[][] complexArray) {
        int n = complexArray.length;
        int n2 = complexArray[0].length;
        double d = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            double d2 = 0.0;
            int n4 = 0;
            while (n4 < n) {
                d2 += Complex.abs(complexArray[n4][n3]);
                ++n4;
            }
            if (d2 > d) {
                d = d2;
            }
            ++n3;
        }
        return d;
    }

    public static Complex[] solve(Complex[][] complexArray, Complex[] complexArray2) throws IllegalArgumentException, MathException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ComplexMatrix.CheckMatrix(complexArray, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        int n3 = complexArray2.length;
        if (n != n3) {
            throw new IllegalArgumentException("The number of rows in the input matrix A is not equal to the number of elements in the input vector B.");
        }
        try {
            ComplexLU complexLU = new ComplexLU(complexArray);
            return complexLU.solve(complexArray2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (MathException mathException) {
            throw mathException;
        }
    }

    public static Complex[][] subtract(Complex[][] complexArray, Complex[][] complexArray2) throws IllegalArgumentException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ComplexMatrix.CheckMatrix(complexArray, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        ComplexMatrix.CheckMatrix(complexArray2, nArray, nArray2);
        int n3 = nArray[0];
        int n4 = nArray2[0];
        if (n != n3 || n2 != n4) {
            throw new IllegalArgumentException("Matrices A and B must have similar dimensions.");
        }
        Complex[][] complexArray3 = new Complex[n3][n4];
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n4) {
                complexArray3[n5][n6] = Complex.subtract(complexArray[n5][n6], complexArray2[n5][n6]);
                ++n6;
            }
            ++n5;
        }
        return complexArray3;
    }

    public static Complex trace(Complex[][] complexArray) throws MathException {
        Complex complex = new Complex(0.0);
        if (complexArray.length != complexArray[0].length) {
            throw new MathException("Matrix is not square.");
        }
        int n = 0;
        while (n < complexArray.length) {
            complex.add(complexArray[n][n]);
            ++n;
        }
        return complex;
    }

    public static Complex[][] transpose(Complex[][] complexArray) throws IllegalArgumentException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ComplexMatrix.CheckMatrix(complexArray, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        Complex[][] complexArray2 = new Complex[n2][n];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                complexArray2[n3][n4] = new Complex(complexArray[n4][n3]);
                ++n4;
            }
            ++n3;
        }
        return complexArray2;
    }

    static Complex[][] zero(int n, int n2) {
        Complex[][] complexArray = new Complex[n][n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                complexArray[n3][n4] = new Complex(0.0, 0.0);
                ++n4;
            }
            ++n3;
        }
        return complexArray;
    }
}

