/*
 * Decompiled with CFR 0.152.
 */
package VisualNumerics.math;

import VisualNumerics.math.Sfun;

public class Complex {
    public static final Complex INFINITY = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    public double re;
    public double im;
    public static String suffix = "i";
    private static final double EPSILON_LARGE = 2.2204460492503E-16;
    private static final double XMAX = 4.503599627370523E15;
    private static final double YLARGE = 8.127810475;
    private static final double YBIG = 4.139162736;
    private static final double YMIN = 1.5;
    private static final int NTERMS = 8;
    private static final double RMIN = 2.58095E-8;

    public Complex() {
        this.re = 0.0;
        this.im = 0.0;
    }

    public Complex(double d) {
        this.re = d;
        this.im = 0.0;
    }

    public Complex(double d, double d2) {
        this.re = d;
        this.im = d2;
    }

    public Complex(Complex complex) {
        this.re = complex.re;
        this.im = complex.im;
    }

    public static double abs(Complex complex) {
        double d;
        double d2 = Math.abs(complex.re);
        if (d2 + (d = Math.abs(complex.im)) == 0.0) {
            return 0.0;
        }
        if (d2 > d) {
            return d2 * Math.sqrt(1.0 + (d /= d2) * d);
        }
        return d * Math.sqrt((d2 /= d) * d2 + 1.0);
    }

    public static Complex acos(Complex complex) {
        return Complex.subtract(1.5707963267948966, Complex.asin(complex));
    }

    public Complex add(double d) {
        this.re += d;
        return this;
    }

    public static Complex add(double d, Complex complex) {
        return new Complex(d + complex.re, complex.im);
    }

    public Complex add(Complex complex) {
        this.re += complex.re;
        this.im += complex.im;
        return this;
    }

    public static Complex add(Complex complex, double d) {
        return new Complex(complex.re + d, complex.im);
    }

    public static Complex add(Complex complex, Complex complex2) {
        return new Complex(complex.re + complex2.re, complex.im + complex2.im);
    }

    public static double argument(Complex complex) {
        return Math.atan2(complex.im, complex.re);
    }

    public static Complex asin(Complex complex) {
        Complex complex2 = new Complex();
        Complex complex3 = complex;
        double d = Complex.abs(complex3);
        if (d <= 0.1) {
            if (d < 2.58095E-8) {
                return complex3;
            }
            Complex complex4 = Complex.multiply(complex3, complex3);
            int n = 1;
            while (n <= 8) {
                double d2 = 2 * (8 - n) + 1;
                complex2 = Complex.multiply(Complex.multiply(complex2, complex4), d2 / (d2 + 1.0));
                complex2.re += 1.0 / d2;
                ++n;
            }
            complex2.multiply(complex3);
        } else {
            if (complex3.re < 0.0) {
                complex3 = Complex.negate(complex);
            }
            Complex complex5 = new Complex(0.0, 1.0);
            Complex complex6 = Complex.sqrt(Complex.add(complex3, 1.0));
            if (complex6.im < 0.0) {
                complex6 = Complex.negate(complex6);
            }
            Complex complex7 = Complex.sqrt(Complex.subtract(complex3, 1.0));
            Complex complex8 = Complex.log(Complex.add(complex3, Complex.multiply(complex6, complex7)));
            complex8.multiply(complex5);
            complex2 = Complex.subtract(1.5707963267948966, complex8);
            if (complex2.re > 1.5707963267948966) {
                complex2 = Complex.subtract(Math.PI, complex2);
            } else if (complex2.re <= -1.5707963267948966) {
                complex2 = Complex.subtract(-Math.PI, complex2);
            }
            if (complex.re < 0.0) {
                complex2 = Complex.negate(complex2);
            }
        }
        return complex2;
    }

    public static Complex conjugate(Complex complex) {
        return new Complex(complex.re, -complex.im);
    }

    public static Complex cos(Complex complex) {
        return new Complex(Math.cos(complex.re) * Sfun.cosh(complex.im), -Math.sin(complex.re) * Sfun.sinh(complex.im));
    }

    public Complex divide(double d) {
        this.re /= d;
        this.im /= d;
        return this;
    }

    public Complex divide(Complex complex) {
        Complex complex2 = Complex.divide(this, complex);
        this.re = complex2.re;
        this.im = complex2.im;
        return this;
    }

    public static Complex divide(Complex complex, double d) {
        return new Complex(complex.re / d, complex.im / d);
    }

    public static Complex divide(Complex complex, Complex complex2) {
        Complex complex3;
        if (Math.abs(complex2.re) > Math.abs(complex2.im)) {
            double d = complex2.im / complex2.re;
            double d2 = complex2.re + complex2.im * d;
            complex3 = new Complex((complex.re + complex.im * d) / d2, (complex.im - complex.re * d) / d2);
        } else {
            double d = complex2.re / complex2.im;
            double d3 = complex2.im + complex2.re * d;
            complex3 = new Complex((complex.im + complex.re * d) / d3, (complex.im * d - complex.re) / d3);
        }
        return complex3;
    }

    public boolean equals(Complex complex) {
        return this.re == complex.re && this.im == complex.im;
    }

    public boolean equals(Object object) {
        Double d = new Double(this.re);
        Double d2 = new Double(this.im);
        if (object == null || !(object instanceof Number)) {
            return false;
        }
        Double d3 = new Double(((Number)object).doubleValue());
        Double d4 = new Double(0.0);
        return d.equals(d3) && d2.equals(d4);
    }

    public static Complex exp(Complex complex) {
        double d;
        double d2 = d = complex.re == 0.0 ? 1.0 : Math.exp(complex.re);
        if (Double.isInfinite(d)) {
            return INFINITY;
        }
        if (complex.im == 0.0) {
            return new Complex(d, complex.im);
        }
        return new Complex(d * Math.cos(complex.im), d * Math.sin(complex.im));
    }

    public static boolean isInfinite(Complex complex) {
        return Double.isInfinite(complex.re) || Double.isInfinite(complex.im);
    }

    public static boolean isNaN(Complex complex) {
        return Double.isNaN(complex.re) || Double.isNaN(complex.im);
    }

    private static Complex l_c_proc_cs(Complex complex) {
        double d = 2.0;
        double d2 = 7.45058E-9;
        double d3 = complex.im / complex.re;
        if (Math.abs(d3) <= d2) {
            return new Complex(1.0, 0.5 * d3);
        }
        double d4 = 1.0 / d3;
        double d5 = d4 >= 0.0 ? Math.sqrt(1.0 + d4 * d4) : -Math.sqrt(1.0 + d4 * d4);
        double d6 = 1.0 / (d4 + d5);
        double d7 = 1.0 / Math.sqrt(1.0 + d6 * d6);
        return new Complex(d7, d7 * d6);
    }

    public static Complex log(Complex complex) {
        return new Complex(Math.log(Complex.abs(complex)), Complex.argument(complex));
    }

    public Complex multiply(double d) {
        this.re *= d;
        this.im *= d;
        return this;
    }

    public static Complex multiply(double d, Complex complex) {
        return new Complex(d * complex.re, d * complex.im);
    }

    public Complex multiply(Complex complex) {
        double d = this.re * complex.re - this.im * complex.im;
        this.im = this.re * complex.im + this.im * complex.re;
        this.re = d;
        return this;
    }

    public static Complex multiply(Complex complex, double d) {
        return new Complex(complex.re * d, complex.im * d);
    }

    public static Complex multiply(Complex complex, Complex complex2) {
        return new Complex(complex.re * complex2.re - complex.im * complex2.im, complex.re * complex2.im + complex.im * complex2.re);
    }

    public static Complex negate(Complex complex) {
        return new Complex(-complex.re, -complex.im);
    }

    public static Complex pow(Complex complex, double d) {
        double d2 = Complex.argument(complex);
        double d3 = Complex.abs(complex);
        if (d3 == 0.0) {
            return complex;
        }
        double d4 = Math.pow(d3, d);
        return new Complex(d4 * Math.cos(d * d2), d4 * Math.sin(d * d2));
    }

    public static Complex pow(Complex complex, Complex complex2) {
        Complex complex3 = new Complex();
        double d = Complex.abs(complex);
        if (d == 0.0) {
            return complex3;
        }
        double d2 = Complex.argument(complex);
        complex3.im = complex2.im * Math.log(d) + complex2.re * d2;
        if (Complex.isInfinite(complex3 = Complex.exp(complex3))) {
            return complex3;
        }
        double d3 = Math.abs(Math.pow(d, complex2.re) * Math.exp(-complex2.im * d2));
        return Complex.multiply(d3, complex3);
    }

    public static Complex sin(Complex complex) {
        return new Complex(Math.sin(complex.re) * Sfun.cosh(complex.im), Math.cos(complex.re) * Sfun.sinh(complex.im));
    }

    public static Complex sqrt(Complex complex) {
        double d = Complex.abs(complex);
        if (d == 0.0) {
            return complex;
        }
        if (Math.abs(complex.re) < Math.abs(complex.im)) {
            if (complex.im >= 0.0) {
                Complex complex2 = new Complex(complex.im, -complex.re);
                d = 0.5 * d;
                Complex complex3 = new Complex(Complex.l_c_proc_cs(complex2));
                d = Math.sqrt(d);
                complex.re = d * (complex3.re - complex3.im);
                complex.im = d * (complex3.re + complex3.im);
            } else {
                Complex complex4 = new Complex(-complex.im, complex.re);
                d = 0.5 * d;
                Complex complex5 = Complex.l_c_proc_cs(complex4);
                d = Math.sqrt(d);
                complex.re = d * (complex5.re + complex5.im);
                complex.im = d * (complex5.im - complex5.re);
            }
        } else if (complex.re < 0.0) {
            complex.re = -complex.re;
            complex.im = -complex.im;
            Complex complex6 = new Complex(Complex.l_c_proc_cs(complex));
            d = Math.sqrt(d);
            if (complex.im > 0.0) {
                complex.re = d * complex6.im;
                complex.im = -d * complex6.re;
            } else {
                complex.re = -d * complex6.im;
                complex.im = d * complex6.re;
            }
        } else {
            Complex complex7 = Complex.l_c_proc_cs(complex);
            d = Math.sqrt(d);
            complex.re = d * complex7.re;
            complex.im = d * complex7.im;
        }
        return new Complex(complex);
    }

    public Complex subtract(double d) {
        this.re -= d;
        return this;
    }

    public static Complex subtract(double d, Complex complex) {
        return new Complex(d - complex.re, -complex.im);
    }

    public Complex subtract(Complex complex) {
        this.re -= complex.re;
        this.im -= complex.im;
        return this;
    }

    public static Complex subtract(Complex complex, double d) {
        return new Complex(complex.re - d, complex.im);
    }

    public static Complex subtract(Complex complex, Complex complex2) {
        return new Complex(complex.re - complex2.re, complex.im - complex2.im);
    }

    public static Complex tan(Complex complex) {
        if (Math.abs(complex.im) > 8.127810475) {
            double d = complex.im < 0.0 ? -1.0 : 1.0;
            return new Complex(0.0, d);
        }
        double d = 2.0 * complex.re;
        double d2 = 2.0 * complex.im;
        if (Math.abs(d) > 4.503599627370523E15) {
            if (Math.abs(complex.im) < 1.5) {
                throw new ArithmeticException();
            }
            if (Math.abs(complex.im) < 4.139162736) {
                return new Complex(0.0, Sfun.tanh(d2));
            }
        }
        double d3 = Math.sin(d);
        double d4 = Math.cos(d) + Sfun.cosh(d2);
        if (d4 <= complex.re * d * 2.2204460492503E-16 * 2.2204460492503E-16) {
            throw new ArithmeticException();
        }
        return new Complex(d3 / d4, Sfun.sinh(d2) / d4);
    }

    public String toString() {
        if (this.im == 0.0) {
            return String.valueOf(this.re);
        }
        if (this.re == 0.0) {
            return String.valueOf(String.valueOf(this.im)) + suffix;
        }
        String string = this.im < 0.0 ? "" : "+";
        return String.valueOf(String.valueOf(this.re)) + string + String.valueOf(this.im) + suffix;
    }

    static double zabs1(Complex complex) {
        return Math.abs(complex.re) + Math.abs(complex.im);
    }
}

