/*
 * Decompiled with CFR 0.152.
 */
package textile;

import board.BFDesignCanvas;
import board.Card;
import board.ColorPalette;
import board.DesignCanvas;
import board.File;
import board.Main;
import board.MainPanel;
import board.Parallelogram;
import board.Util;
import board.Vector2D;
import board.Yarn;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import textile.Row;
import textile.TextileFrame;

public class TextilePanel
extends Panel {
    public static final int VISIBLE_YARNS = 100;
    public static final int INIT_START_POSITION_Y = 20;
    public static Vector2D start = new Vector2D(40.0, 20.0);
    MainPanel mainPanel;
    static List<Row> rows;
    static String filename;
    static boolean texture;
    private static final TextilePanel INSTANCE;
    static Image[] yarn_images;
    public static Image buffered_image;
    static Image bg_image;
    Polygon polygon;
    Image bg = new ImageIcon("./images/wall.jpg").getImage();

    static {
        filename = "./images/wall.jpg";
        texture = false;
        INSTANCE = new TextilePanel();
        yarn_images = new Image[7];
        buffered_image = null;
    }

    public static TextilePanel getInstance() {
        return INSTANCE;
    }

    void setMainPanel(MainPanel mainPanel) {
        this.mainPanel = mainPanel;
    }

    public void init() {
        this.construct_textile();
        Row.create_polygon();
        if (Main.boolean_mode) {
            TextileFrame.scrollBar.setVisible(true);
        } else {
            TextileFrame.scrollBar.setVisible(false);
            TextileFrame.label.setText("");
        }
    }

    public static void load_image() {
        Image image = File.load_image((String)filename);
        int new_width = Main.textileFrame.getWidth();
        int new_height = Main.textileFrame.getHeight();
        Image new_image = Main.textilePanel.createImage(new_width, new_height);
        new_image.getGraphics().drawImage(image.getScaledInstance(image.getWidth(null), image.getHeight(null), 16), 0, 0, new_width, new_height, null);
        bg_image = new_image;
    }

    public void construct_textile() {
        rows = new ArrayList<Row>();
        int j = 0;
        while (j < DesignCanvas.number_of_holes) {
            Row row = new Row();
            int i = 0;
            while (i < DesignCanvas.cards.size()) {
                Card card = (Card)DesignCanvas.cards.get(i);
                Yarn yarn = card.getYarn(j);
                row.yarns.add(yarn);
                ++i;
            }
            rows.add(row);
            ++j;
        }
    }

    public static void load_yarn_images() {
        TextilePanel.yarn_images[ColorPalette.get_color_index((Color)Color.pink)] = File.load_image((String)"images/pink10.gif");
    }

    public void paint_image(Graphics g, int x, int y) {
        g.drawImage(yarn_images[1], x, y, null);
    }

    static void paint_borderLine(Graphics g) {
        g.setColor(Color.black);
        g.drawLine((int)TextilePanel.start.x, (int)TextilePanel.start.y, (int)TextilePanel.start.x, (int)TextilePanel.start.y + 500);
        g.drawLine((int)(TextilePanel.start.x + (double)(Row.pixel_width * DesignCanvas.cards.size())), (int)TextilePanel.start.y, (int)(TextilePanel.start.x + (double)(Row.pixel_width * DesignCanvas.cards.size())), (int)TextilePanel.start.y + 500);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (buffered_image == null) {
            buffered_image = this.createImage(this.getSize().width, this.getSize().height);
        }
        Graphics bg = buffered_image.getGraphics();
        bg.setColor(Color.white);
        bg.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.paintComponent(bg);
        if (bg_image != null) {
            bg.drawImage(bg_image, 0, 0, null);
        }
        TextilePanel.paint_main(bg, false);
        bg.dispose();
        g.drawImage(buffered_image, 0, 0, this);
    }

    static void paint_DesignCanvas_main(Graphics g) {
        int counter = 0;
        int row_index = 0;
        if (DesignCanvas.direction_list.size() == 0) {
            TextilePanel.paint_no_direction_list(g);
        }
        int prev_direction = -1;
        int m = 0;
        while (m < 50) {
            int j = 0;
            while (j < DesignCanvas.direction_list.size()) {
                Integer[] d = (Integer[])DesignCanvas.direction_list.get(j);
                int direction = d[0];
                int count = d[1];
                if (prev_direction != -1) {
                    if (direction == 0 && direction != prev_direction) {
                        ++counter;
                    } else if (direction == 1 && direction != prev_direction) {
                        --counter;
                    }
                }
                int k = 0;
                while (k < count) {
                    Row row = rows.get(Util.mod((int)counter, (int)DesignCanvas.number_of_holes));
                    if (texture) {
                        row.paint_yarn_texture(g, row_index++, direction);
                    } else {
                        row.paint(g, row_index++, direction);
                    }
                    if (direction == 0) {
                        if (k == count - 1) {
                            row.paint_span(g, row_index);
                        }
                        ++counter;
                    } else if (direction == 1) {
                        if (k == count - 1) {
                            row.paint_span(g, row_index);
                        }
                        --counter;
                    }
                    ++k;
                }
                prev_direction = direction;
                ++j;
            }
            ++m;
        }
    }

    public static void paint_main(Graphics g, boolean capture) {
        Graphics2D g2 = (Graphics2D)g;
        if (!BFDesignCanvas.perpendicular) {
            g2.rotate(-1.5707963267948966, Main.TEXTILE_PANEL_WIDTH / 2, Main.TEXTILE_PANEL_WIDTH / 4);
        }
        if (Main.boolean_mode) {
            TextilePanel.paint_borderLine(g2);
            TextilePanel.paint_BF_main(g2, capture);
        } else {
            TextilePanel.paint_DesignCanvas_main(g2);
            TextilePanel.paint_borderLine(g2);
        }
    }

    static void paint_BF_main(Graphics g, boolean capture) {
        int i = 0;
        while (i < DesignCanvas.cards.size()) {
            Card card = (Card)DesignCanvas.cards.get(i);
            int bbox_x = (int)TextilePanel.start.x + Row.pixel_width * i;
            int bbox_y = (int)TextilePanel.start.y;
            int j = 0;
            while (j < card.yarns.size()) {
                Yarn yarn = (Yarn)card.yarns.get(j);
                Polygon polygon = null;
                switch (yarn.orientation) {
                    case 0: {
                        polygon = Parallelogram.move((Polygon)Row.up_polygon, (int)bbox_x, (int)bbox_y);
                        bbox_y += Row.pixel_height;
                        break;
                    }
                    case 1: {
                        polygon = Parallelogram.move((Polygon)Row.down_polygon, (int)bbox_x, (int)bbox_y);
                        bbox_y += Row.pixel_height;
                        break;
                    }
                    case 2: {
                        polygon = Parallelogram.move((Polygon)Row.left_short_trapezoid, (int)bbox_x, (int)bbox_y);
                        bbox_y = (int)((double)bbox_y + (double)Row.pixel_height * 0.5);
                        break;
                    }
                    case 3: {
                        polygon = Parallelogram.move((Polygon)Row.right_short_trapezoid, (int)bbox_x, (int)bbox_y);
                        bbox_y = (int)((double)bbox_y + (double)Row.pixel_height * 1.5);
                    }
                }
                if (polygon != null) {
                    if (yarn.back) {
                        g.setColor(yarn.card.backGroundColor);
                    } else {
                        g.setColor(yarn.card.foreGroundColor);
                    }
                    g.fillPolygon(polygon);
                    if (yarn.visible && !capture) {
                        g.setColor(Color.red);
                    } else {
                        g.setColor(Color.black);
                    }
                    g.drawPolygon(polygon);
                }
                ++j;
            }
            ++i;
        }
    }

    static void paint_no_direction_list(Graphics g) {
        int row_index = 0;
        if (rows.size() == 0) {
            return;
        }
        int m = 0;
        while (m < 50) {
            int i = 0;
            while (i < DesignCanvas.number_of_holes) {
                Row row = rows.get(i);
                if (texture) {
                    row.paint_yarn_texture(g, row_index++, 0);
                } else {
                    row.paint(g, row_index++, 0);
                }
                ++i;
            }
            ++m;
        }
    }

    public void change_texture_or_not() {
        texture = !texture;
    }

    public void update_slider_val(int _value) {
        double value = (double)_value / 100.0;
        TextilePanel.start.y = 20.0 - (double)(Row.pixel_height * 100 - (this.getHeight() - 100)) * value;
        Main.textilePanel.repaint();
    }

    public void paintComponent(Graphics g) {
        g.drawImage(this.bg, 0, 0, this.getWidth(), this.getHeight(), this);
    }
}

