/*
 * Decompiled with CFR 0.152.
 */
package textile;

import board.Card;
import board.Main;
import board.Parallelogram;
import board.Vector2D;
import board.Yarn;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.List;
import textile.TextilePanel;

public class Row {
    public static int pixel_width = 10;
    public static int pixel_height = 10;
    static double scale = 0.9;
    List<Yarn> yarns = new ArrayList<Yarn>();
    static Polygon up_polygon;
    static Polygon down_polygon;
    static Polygon left_short_trapezoid;
    static Polygon right_short_trapezoid;

    Row() {
    }

    static void create_polygon() {
        up_polygon = Row.create_up_polygon();
        down_polygon = Row.create_down_polygon();
        left_short_trapezoid = Row.create_left_short_trapezoid();
        right_short_trapezoid = Row.create_right_short_trapezoid();
    }

    static Polygon create_up_polygon() {
        Vector2D vec0 = new Vector2D((double)pixel_width, (double)(-1 * pixel_height) * Card.gradient);
        Vector2D vec1 = new Vector2D(0.0, (double)pixel_height);
        return Parallelogram.create_polygon((Vector2D)vec0, (Vector2D)vec1);
    }

    static Polygon create_down_polygon() {
        Vector2D vec0 = new Vector2D((double)pixel_width, (double)pixel_height * Card.gradient);
        Vector2D vec1 = new Vector2D(0.0, (double)pixel_height);
        return Parallelogram.create_polygon((Vector2D)vec0, (Vector2D)vec1);
    }

    static Polygon create_left_short_trapezoid() {
        Vector2D vec0 = new Vector2D((double)pixel_width, (double)(-1 * pixel_height) * Card.gradient);
        Vector2D vec1 = new Vector2D(0.0, (double)pixel_height);
        return Parallelogram.create_trapezoid_left_short((Vector2D)vec0, (Vector2D)vec1);
    }

    static Polygon create_right_short_trapezoid() {
        Vector2D vec0 = new Vector2D((double)pixel_width, (double)pixel_height * Card.gradient);
        Vector2D vec1 = new Vector2D(0.0, (double)pixel_height);
        return Parallelogram.create_trapezoid_right_short((Vector2D)vec0, (Vector2D)vec1);
    }

    static Polygon move(Polygon _polygon, int dx, int dy) {
        int[] x = new int[_polygon.npoints];
        int[] y = new int[_polygon.npoints];
        int n = _polygon.npoints;
        int i = 0;
        while (i < _polygon.npoints) {
            x[i] = (int)((double)_polygon.xpoints[i] * scale + (double)dx);
            y[i] = (int)((double)_polygon.ypoints[i] * scale + (double)dy);
            ++i;
        }
        return new Polygon(x, y, n);
    }

    void paint_yarn_texture(Graphics g, int index, int direction) {
        if (Main.mainPanel == null) {
            return;
        }
        int i = 0;
        while (i < this.yarns.size()) {
            Yarn yarn = this.yarns.get(i);
            if (yarn.color == Color.white || (yarn.card.direction == 0 ? direction != 0 : yarn.card.direction != 1 || direction != 0)) {
                // empty if block
            }
            ++i;
        }
    }

    void paint(Graphics g, int index, int direction) {
        if (Main.mainPanel == null) {
            return;
        }
        int i = 0;
        while (i < this.yarns.size()) {
            Yarn yarn = this.yarns.get(i);
            g.setColor(yarn.color);
            Polygon polygon = null;
            if (yarn.card.direction == 0) {
                if (direction == 0) {
                    polygon = Row.move(up_polygon, (int)TextilePanel.start.x + pixel_width * i, (int)TextilePanel.start.y + pixel_height * index + pixel_height);
                } else if (direction == 1) {
                    polygon = Row.move(down_polygon, (int)TextilePanel.start.x + pixel_width * i, (int)TextilePanel.start.y + pixel_height * index);
                }
            } else if (yarn.card.direction == 1) {
                if (direction == 0) {
                    polygon = Row.move(down_polygon, (int)TextilePanel.start.x + pixel_width * i, (int)TextilePanel.start.y + pixel_height * index);
                } else if (direction == 1) {
                    polygon = Row.move(up_polygon, (int)TextilePanel.start.x + pixel_width * i, (int)TextilePanel.start.y + pixel_height * index + pixel_height);
                }
            }
            if (polygon != null) {
                g.fillPolygon(polygon);
            }
            ++i;
        }
    }

    void paint_span(Graphics g, int index) {
        int i = 0;
        while (i < this.yarns.size()) {
            Yarn yarn = this.yarns.get(i);
            g.setColor(yarn.color);
            g.fillRect((int)(TextilePanel.start.x + (double)(pixel_width * i)), (int)(TextilePanel.start.y + (double)(pixel_height * index)), pixel_width, pixel_height);
            ++i;
        }
    }
}

