package umfpack;

import java.util.*;

public class Umfpack {
    public native void factorize(int n, int[] Ap, int[] Ai, double[] Ax);
    public native void solve(double[] b, double[] x);
    public native void release();
		
    static {
        System.loadLibrary("umfpack");
    }
    
    
    
    
    public void factorize(double[][] A){
    	int n = A.length;
    	
    	int[] Ap = new int[n+1];
    	Vector _Ai = new Vector();
    	Vector _Ax = new Vector();
    	
  		for(int j=0; j<n; j++){
  			Ap[j] = _Ai.size();
  	    	for(int i=0; i<n; i++)
    		{
				if (A[i][j] != 0) {
					_Ai.addElement(new Integer( i ));
					_Ax.addElement(new Double( A[i][j] ));
				}
			}
    	}
  		Ap[n] = _Ai.size();
    	
    	
    	int[] Ai = new int[_Ai.size()];
    	for(int i=0; i<_Ai.size(); i++)
    		Ai[i] = ((Integer)_Ai.elementAt(i)).intValue();
    		
    	double[] Ax = new double[_Ax.size()];
    	for(int i=0; i<_Ax.size(); i++)
    		Ax[i] = ((Double)_Ax.elementAt(i)).doubleValue();
    		
 
    	factorize(n, Ap, Ai, Ax);
    }
    
    public static void main(String[] args) {
 
		Umfpack umfpack = new Umfpack();

		
		int		 n = 5 ;
		int[]    Ap = {0, 2, 5, 9, 10, 12} ;
		int[]    Ai = { 0, 1, 0, 2, 4, 1, 2, 3, 4, 2, 1, 4} ;
		double[] Ax = {2., 3., 3., -1., 4., 4., -3., 1., 2., 2., 6., 1.} ;
		double[] b = {8., 45., -3., 3., 19.} ;
		double[] x = new double[5];
		
		//umfpack.factorize(n, Ap, Ai, Ax);
		
		double[][] A = {
		{2, 3, 0, 0, 0},
		{3, 0, 4, 0, 6},
		{0, -1, -3, 2, 0},
		{0, 0, 1, 0, 0},
		{0, 4, 2, 0, 1}};
		
		umfpack.factorize(A);
		
		umfpack.solve(b, x);
		umfpack.release();
		
		System.out.println("umfpacktest");
		for(int i=0; i<5; i++)
			System.out.println(" "+x[i]);
	}
}
