package triangle;

import java.util.*;

public class Triangle {
	
	// native methods
    static public native int[] triangulate_polygon(double[] boundary_xy);
    static public native int[] triangulate_polygon_with_inner_vertices(double[] boundary_xy, double[] inner_xy);
		
    static {
        System.loadLibrary("triangle");
    }


	// public methods
    //static public native int[] triangulate_closed_polygon_with_inner_vertices(ArrayList boundary_vertices, ArrayList inner_vertices);
	
	// input  {{x,y}, {x,y},...}  
	// output {{index, index, index}, {index, index, index}, ... }
	static public ArrayList triangulate_polygon(ArrayList boundary_vertices){
		int n = boundary_vertices.size();
		double[] xys = new double[n*2];
		for(int i=0; i<n; i++){
			double[] xy = (double[]) boundary_vertices.get(i);
			xys[i*2+0] = xy[0];
			xys[i*2+1] = xy[1];
		}
		
		int[] triangles = triangulate_polygon(xys);
		
		ArrayList faces = new ArrayList();
		for(int i=0; i<triangles.length/3; i++){
			int[] face = {triangles[i*3], triangles[i*3+1], triangles[i*3+2]} ;
			faces.add(face);
		}
		return faces;
	}

	/*
	// input  {{x,y}, {x,y},...}  
	// output {{index, index, index}, {index, index, index}, ... }
	static public ArrayList triangulate_polygon_with_inner_vertices(ArrayList boundary_vertices, ArrayList inner_vertices){
		double[] boundary_xys = new double[boundary_vertices.size()*2];
		for(int i=0; i<boundary_vertices.size(); i++){
			double[] xy = (double[]) boundary_vertices.get(i);
			boundary_xys[i*2+0] = xy[0];
			boundary_xys[i*2+1] = xy[1];
		}
		double[] inner_xys = new double[inner_vertices.size()*2];
		for(int i=0; i<inner_vertices.size(); i++){
			double[] xy = (double[]) inner_vertices.get(i);
			inner_xys[i*2+0] = xy[0];
			inner_xys[i*2+1] = xy[1];
		}
		
		int[] triangles = triangulate_polygon_with_inner_vertices(boundary_xys, inner_xys);
		
		ArrayList faces = new ArrayList();
		for(int i=0; i<triangles.length/3; i++){
			int[] face = {triangles[i*3], triangles[i*3+1], triangles[i*3+2]} ;
			faces.add(face);
		}
		return faces;
	}
	*/
	// input  
	//	vertices	ArrayList of double[] ({x,y}, {x,y},...)
	// output ArrayList[2] { vertices, faces }
	//	vertices	ArrayList of double[] ( {x, y, z},  ...)  (discard inner_vertices outside of boundary_vertices)
	//  faces		ArrayList of int[]	  ( {vertex_index, vertex_index, vertex_index}, ...)
	
	static public ArrayList[] triangulate_polygon_with_inner_vertices(ArrayList boundary_vertices, ArrayList inner_vertices){
		double[] boundary_xys = new double[boundary_vertices.size()*2];
		for(int i=0; i<boundary_vertices.size(); i++){
			double[] xy = (double[]) boundary_vertices.get(i);
			boundary_xys[i*2+0] = xy[0];
			boundary_xys[i*2+1] = xy[1];
		}
		double[] inner_xys = new double[inner_vertices.size()*2];
		for(int i=0; i<inner_vertices.size(); i++){
			double[] xy = (double[]) inner_vertices.get(i);
			inner_xys[i*2+0] = xy[0];
			inner_xys[i*2+1] = xy[1];
		}
		
		
		// int[] boundary_xys =  { x0,y0, x1,y1, ...}
		// int[] inner_xys =  { x0,y0, x1,y1, ...}
		// int[] triangles = {index0, index1, index2,   index0, index1, index2,   ...} 
		int[] triangles = triangle.Triangle.triangulate_polygon_with_inner_vertices(boundary_xys, inner_xys);
	
		
		boolean[] vertex_used = new boolean[boundary_vertices.size()+inner_vertices.size()];
		for(int i=0; i<triangles.length; i++){
			int index = triangles[i];
			if (vertex_used[index] == false){
				vertex_used[index] = true;
			}
		}
		
		
		int[] index_map = new int[boundary_vertices.size()+inner_vertices.size()];
		int index = 0;
		ArrayList vertices = new ArrayList();
		for(int i=0; i<boundary_vertices.size()+inner_vertices.size(); i++){
			if (vertex_used[i]){
				double[] xy = null;
				if (i < boundary_vertices.size())
					xy = (double[]) boundary_vertices.get(i);
				else
					xy = (double[]) inner_vertices.get(i - boundary_vertices.size());
				vertices.add(xy);
				
				index_map[i] = index++;
				
			}
		}

		
		
		ArrayList faces = new ArrayList();
		for(int i=0; i<triangles.length/3; i++){
			int[] face = {index_map[triangles[i*3]], index_map[triangles[i*3+1]], index_map[triangles[i*3+2]]} ;
			faces.add(face);
		}
		
		ArrayList[] result = {vertices, faces};
		
		return result;
	}
	
	
	

	public static void main( String[] args ) {
		double[] xys = { 0,0,  1,0,  1,1, 0,1};
		
		int[] triangles = triangulate_polygon(xys);
		
		for(int i=0; i<triangles.length; i++)
			System.out.println(""+triangles[i]);
		

	}
}
