/*
 * Decompiled with CFR 0.152.
 */
package rigid;

import rigid.Edge;
import rigid.Face;
import rigid.Mesh;
import teddy.Edge2D;
import teddy.Vertex2D;

public class WeightPaint {
    static double NEW_WEIGHT = 10000.0;
    Mesh mesh;
    Vertex2D prev_v;
    boolean nothing_happend;

    public WeightPaint(Mesh mesh) {
        this.mesh = mesh;
    }

    public void start_painting(Vertex2D v) {
        this.prev_v = v;
        this.nothing_happend = true;
        int i = 0;
        while (i < this.mesh.faces.size()) {
            Face face = (Face)this.mesh.faces.get(i);
            if (face.contains(v)) {
                face.weight = NEW_WEIGHT;
                this.nothing_happend = false;
                break;
            }
            ++i;
        }
    }

    public void painting(Vertex2D v) {
        Edge2D paint_edge = new Edge2D(this.prev_v, v);
        this.prev_v = v;
        int i = 0;
        while (i < this.mesh.edges.size()) {
            Edge edge = (Edge)this.mesh.edges.get(i);
            if (paint_edge.cross(new Edge2D((Vertex2D)edge.start, (Vertex2D)edge.end))) {
                if (edge.left_face != null) {
                    edge.left_face.weight = NEW_WEIGHT;
                }
                if (edge.right_face != null) {
                    edge.right_face.weight = NEW_WEIGHT;
                }
                this.nothing_happend = false;
            }
            ++i;
        }
    }

    public void finish_painting() {
        if (this.nothing_happend) {
            int i = 0;
            while (i < this.mesh.faces.size()) {
                Face face = (Face)this.mesh.faces.get(i);
                face.weight = 1.0;
                ++i;
            }
        }
    }
}

