/*
 * Decompiled with CFR 0.152.
 */
package rigid;

import java.util.ArrayList;
import java.util.List;
import rigid.Edge;
import rigid.Face;
import teddy.Vector2;
import teddy.Vertex2D;

public class Vertex
extends Vertex2D {
    public List edges = new ArrayList();
    public int index;
    boolean fixed = false;
    public float[] textureCoords = new float[2];

    public Vertex() {
    }

    public Vertex(double x, double y) {
        super(x, y);
    }

    public Vertex(Vertex2D v) {
        super(v.x, v.y);
    }

    public Vertex(Vertex v) {
        super(v.x, v.y);
    }

    public String toString() {
        return "(" + (int)this.x + ", " + (int)this.y + ")";
    }

    public Vertex get_duplicated() {
        Vertex new_vertex = new Vertex(this);
        new_vertex.index = this.index;
        new_vertex.fixed = this.fixed;
        new_vertex.textureCoords = this.textureCoords;
        new_vertex.edges = this.edges;
        return new_vertex;
    }

    public ArrayList get_surrounding_edges() {
        ArrayList<Edge> surrounding_edges = new ArrayList<Edge>();
        ArrayList faces = this.get_faces();
        int i = 0;
        while (i < faces.size()) {
            Face face = (Face)faces.get(i);
            surrounding_edges.add(face.get_opposite_edge(this));
            ++i;
        }
        return surrounding_edges;
    }

    public List get_surrounding_vertices() {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        int i = 0;
        while (i < this.edges.size()) {
            Edge edge = (Edge)this.edges.get(i);
            vertices.add(edge.get_opposite_vertex(this));
            ++i;
        }
        return vertices;
    }

    public void remove_edge(Edge edge) {
        this.edges.remove(edge);
    }

    public Edge get_common_edge(Vertex v) {
        int i = 0;
        while (i < this.edges.size()) {
            Edge edge = (Edge)this.edges.get(i);
            if (edge.contains(v)) {
                return edge;
            }
            ++i;
        }
        return null;
    }

    public ArrayList get_faces() {
        ArrayList<Face> faces = new ArrayList<Face>();
        int i = 0;
        while (i < this.edges.size()) {
            Edge edge = (Edge)this.edges.get(i);
            if (edge.left_face != null && !faces.contains(edge.left_face)) {
                faces.add(edge.left_face);
            }
            if (edge.right_face != null && !faces.contains(edge.right_face)) {
                faces.add(edge.right_face);
            }
            ++i;
        }
        return faces;
    }

    public void move_relative(Vector2 vec) {
        this.x += vec.x;
        this.y += vec.y;
    }
}

