/*
 * Decompiled with CFR 0.152.
 */
package rigid;

import java.util.Vector;
import rigid.Entry;

public class SparseMatrix {
    int n;
    Vector[] columns;

    SparseMatrix(int n) {
        this.n = n;
        this.columns = new Vector[n];
        int i = 0;
        while (i < n) {
            this.columns[i] = new Vector();
            ++i;
        }
    }

    public void add(int _row, int _column, double value) {
        if (value == 0.0) {
            return;
        }
        Vector column = this.columns[_column];
        int i = 0;
        while (i < column.size()) {
            Entry entry = (Entry)column.elementAt(i);
            if (_row < entry.row) {
                column.insertElementAt(new Entry(_row, value), i);
                break;
            }
            if (_row == entry.row) {
                entry.value += value;
                break;
            }
            ++i;
        }
        column.addElement(new Entry(_row, value));
    }

    Object[] get_umfpack_matrix() {
        int n_of_entries = 0;
        int i = 0;
        while (i < this.n) {
            n_of_entries += this.columns[i].size();
            ++i;
        }
        int[] Ap = new int[this.n + 1];
        int[] Ai = new int[n_of_entries];
        double[] Ax = new double[n_of_entries];
        int index = 0;
        int i2 = 0;
        while (i2 < this.n) {
            Ap[i2] = index;
            Vector column = this.columns[i2];
            int j = 0;
            while (j < column.size()) {
                Entry entry = (Entry)column.elementAt(j);
                Ai[index] = entry.row;
                Ax[index] = entry.value;
                ++index;
                ++j;
            }
            ++i2;
        }
        Ap[this.n] = index;
        Object[] result = new Object[]{Ap, Ai, Ax};
        return result;
    }
}

