/*
 * Decompiled with CFR 0.152.
 */
package rigid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rigid.Edge;
import rigid.Face;
import rigid.Mesh;
import rigid.Vertex;
import teddy.Util;
import teddy.Vector2;

public class Skin {
    static Mesh h;

    public static void refine(Mesh mesh) {
        int i = 0;
        while (i < 3) {
            Skin.refine_mesh_connectivity(mesh);
            ++i;
        }
        i = 0;
        while (i < 5) {
            Skin.drift(mesh);
            ++i;
        }
        Skin.refine_mesh_connectivity(mesh);
        i = 0;
        while (i < 5) {
            Skin.drift(mesh);
            ++i;
        }
    }

    public static void grind(Mesh mesh) {
        h = mesh;
        ArrayList<Edge> edges = new ArrayList<Edge>();
        int i = 0;
        while (i < mesh.edges.size()) {
            if (mesh.edges(i).length() > Skin.h.unit_length * 1.5) {
                edges.add(mesh.edges(i));
            }
            ++i;
        }
        i = 0;
        while (i < edges.size()) {
            Edge edge = (Edge)edges.get(i);
            if (!edge.disposed && Skin.split_valence_test(edge)) {
                Skin.split_edge(edge, edges);
            }
            ++i;
        }
        h.set_parameters();
    }

    public static void drift(Mesh h) {
        int i = 0;
        while (i < h.vertices.size()) {
            Vertex v = (Vertex)((Object)h.vertices.get(i));
            if (!v.fixed) {
                Skin.drift(h, v);
            }
            ++i;
        }
        h.set_parameters();
    }

    public static void drift(Mesh h, Vertex v) {
        Vector2 dv = Skin.get_vector_to_isosurface(v);
        Vector2 cv = Skin.get_vector_to_centroid(v);
        if (Double.isNaN(dv.x)) {
            System.out.println("dv = Nan");
        }
        if (Double.isNaN(cv.x)) {
            System.out.println("cv = Nan");
        }
        Vector2 vec = Vector2.add((Vector2)dv, (Vector2)cv);
        if (!Double.isNaN(vec.x)) {
            v.add(vec);
        }
    }

    static Vector2 get_vector_to_centroid(Vertex v) {
        Vertex center = new Vertex();
        ArrayList edges = v.get_surrounding_edges();
        double length = 0.0;
        int i = 0;
        while (i < edges.size()) {
            Edge edge = (Edge)edges.get(i);
            double l = edge.length();
            center.add(Vector2.multiply((Vector2)edge.mid_vertex(), (double)l));
            length += l;
            ++i;
        }
        center.multiply(1.0 / length);
        Vector2 vector = new Vector2((Vector2)v, (Vector2)center);
        double weight = 0.3;
        return Vector2.multiply((Vector2)vector, (double)weight);
    }

    static Vector2 get_vector_to_isosurface(Vertex v) {
        return new Vector2();
    }

    public static int refine_mesh_connectivity(Mesh _h) {
        h = _h;
        ArrayList<Edge> edges = new ArrayList<Edge>();
        int i = 0;
        while (i < Skin.h.edges.size()) {
            if (h.edges(i) != null) {
                edges.add(h.edges(i));
            }
            ++i;
        }
        int count = 0;
        ArrayList _edges = new ArrayList();
        int max_count = edges.size() * 4;
        int i2 = 0;
        while (i2 < edges.size()) {
            Edge edge = (Edge)edges.get(i2);
            if (!edge.disposed) {
                if (Skin.swap_valence_test(edge)) {
                    Skin.swap_edge(edge, edges);
                    ++count;
                } else if (Skin.split_valence_test(edge)) {
                    Skin.split_edge(edge, edges);
                    ++count;
                } else if (Skin.collapse_valence_test(edge)) {
                    Skin.collapse_edge(edge, edges);
                    ++count;
                }
            }
            if (count >= max_count) break;
            ++i2;
        }
        return count;
    }

    public static boolean split_valence_test(Edge edge) {
        if (edge.left_face == null || edge.right_face == null) {
            return false;
        }
        double target_length = Skin.h.unit_length;
        if (edge.length() < target_length * 1.25) {
            return false;
        }
        if (edge.length() > target_length * 1.5) {
            return true;
        }
        int v0_edges = 0;
        int v1_edges = 0;
        if (edge.left_face != null) {
            v0_edges = edge.left_face.get_opposite_vertex((Edge)edge).edges.size();
        }
        if (edge.right_face != null) {
            v1_edges = edge.right_face.get_opposite_vertex((Edge)edge).edges.size();
        }
        return v0_edges < 6 && v1_edges < 6;
    }

    public static boolean collapse_valence_test(Edge edge) {
        Vertex p;
        if (edge.start.fixed || edge.end.fixed) {
            return false;
        }
        double target_length = Skin.h.unit_length;
        if (edge.length() > target_length * 0.75) {
            return false;
        }
        Vertex v0 = null;
        Vertex v1 = null;
        if (edge.left_face != null) {
            v0 = edge.left_face.get_opposite_vertex(edge);
        }
        if (edge.right_face != null) {
            v1 = edge.right_face.get_opposite_vertex(edge);
        }
        ArrayList<Vertex> around_start = new ArrayList<Vertex>();
        Iterator e = edge.start.get_surrounding_vertices().iterator();
        while (e.hasNext()) {
            Vertex p2 = (Vertex)((Object)e.next());
            if (p2 == v0 || p2 == v1 || p2 == edge.end) continue;
            around_start.add(p2);
        }
        ArrayList<Vertex> around_end = new ArrayList<Vertex>();
        Iterator e2 = edge.end.get_surrounding_vertices().iterator();
        while (e2.hasNext()) {
            p = (Vertex)((Object)e2.next());
            if (p == v0 || p == v1 || p == edge.start) continue;
            around_end.add(p);
        }
        int i = 0;
        while (i < around_start.size()) {
            p = (Vertex)((Object)around_start.get(i));
            int j = 0;
            while (j < around_end.size()) {
                Vertex q = (Vertex)((Object)around_end.get(j));
                if (p == q || p.get_common_edge(q) != null) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        if (edge.length() < target_length * 0.5) {
            return true;
        }
        int v0_edges = 0;
        int v1_edges = 0;
        if (v0 != null) {
            v0_edges = v0.edges.size();
        }
        if (v1 != null) {
            v1_edges = v1.edges.size();
        }
        int before = Math.abs(v0_edges - 6) + Math.abs(v1_edges - 6) + Math.abs(edge.start.edges.size() - 6) + Math.abs(edge.end.edges.size() - 6);
        int after = Math.abs(v0_edges - 7) + Math.abs(v1_edges - 7) + Math.abs(edge.start.edges.size() + edge.end.edges.size() - 4 - 6);
        return after < before;
    }

    private static boolean swap_valence_test(Edge edge) {
        Vertex v1;
        if (edge.left_face == null || edge.right_face == null) {
            return false;
        }
        Vertex v0 = edge.left_face.get_opposite_vertex(edge);
        if (v0.get_common_edge(v1 = edge.right_face.get_opposite_vertex(edge)) != null) {
            return false;
        }
        if (Skin.get_angle(v0, edge.start, edge.end) >= 1.5707963267948966 || Skin.get_angle(v0, edge.end, edge.start) >= 1.5707963267948966 || Skin.get_angle(v1, edge.start, edge.end) >= 1.5707963267948966 || Skin.get_angle(v1, edge.end, edge.start) >= 1.5707963267948966) {
            return false;
        }
        double current_min_angle = Skin.min(Skin.get_angle(v0, edge.start, edge.end), Skin.get_angle(v0, edge.end, edge.start), Skin.get_angle(v1, edge.start, edge.end), Skin.get_angle(v1, edge.end, edge.start));
        double target_min_angle = Skin.min(Skin.get_angle(v0, v1, edge.end), Skin.get_angle(v0, v1, edge.start), Skin.get_angle(v1, v0, edge.end), Skin.get_angle(v1, v0, edge.start));
        if (target_min_angle > current_min_angle * 1.25) {
            return true;
        }
        if (target_min_angle < current_min_angle * 0.8) {
            return false;
        }
        int before = Math.abs(v0.edges.size() - 6) + Math.abs(v1.edges.size() - 6) + Math.abs(edge.start.edges.size() - 6) + Math.abs(edge.end.edges.size() - 6);
        int after = Math.abs(v0.edges.size() - 5) + Math.abs(v1.edges.size() - 5) + Math.abs(edge.start.edges.size() - 7) + Math.abs(edge.end.edges.size() - 7);
        return after < before;
    }

    private static double min(double a, double b, double c, double d) {
        return Math.min(Math.min(a, b), Math.min(c, d));
    }

    private static double get_angle(Vertex v0, Vertex v1, Vertex v2) {
        Vector2 vec0 = new Vector2((Vector2)v1, (Vector2)v0);
        Vector2 vec1 = new Vector2((Vector2)v1, (Vector2)v2);
        return Vector2.get_angle_PI((Vector2)vec0, (Vector2)vec1);
    }

    private static void split_edge(Edge edge, List dirty_edges) {
        Vertex mid_vertex = edge.mid_vertex();
        Edge edge0 = new Edge(edge.start, mid_vertex);
        Edge edge1 = new Edge(mid_vertex, edge.end);
        h.add(mid_vertex);
        h.add(edge0);
        h.add(edge1);
        dirty_edges.add(edge0);
        dirty_edges.add(edge1);
        if (edge.left_face != null) {
            Skin.split_edge_sub(edge.left_face, edge, edge0, edge1, mid_vertex, dirty_edges);
        }
        if (edge.right_face != null) {
            Skin.split_edge_sub(edge.right_face, edge, edge1, edge0, mid_vertex, dirty_edges);
        }
    }

    private static void split_edge_sub(Face old_face, Edge edge, Edge edge0, Edge edge1, Vertex mid_vertex, List dirty_edges) {
        int n = old_face.get_edge_index(edge);
        Edge mid_edge = new Edge(old_face.get_vertex(n + 2), mid_vertex);
        Face new_face0 = new Face(old_face.edges(n + 1), mid_edge, edge1);
        Face new_face1 = new Face(old_face.edges(n + 2), edge0, mid_edge);
        h.add(mid_edge);
        h.add(new_face0);
        h.add(new_face1);
        h.remove(old_face);
        dirty_edges.add(mid_edge);
    }

    private static void collapse_edge(Edge short_edge, List dirty_edges) {
        if (short_edge.start.fixed) {
            Skin.remove_a_short_edge(short_edge, short_edge.end, short_edge.start, dirty_edges);
        } else if (short_edge.end.fixed) {
            Skin.remove_a_short_edge(short_edge, short_edge.start, short_edge.end, dirty_edges);
        } else {
            Skin.collapse_edge_center(short_edge, dirty_edges);
        }
    }

    private static void collapse_edge_center(Edge short_edge, List dirty_edges) {
        Face face;
        Vertex the_other_vertex;
        Edge edge;
        Face left_face = short_edge.left_face;
        Face right_face = short_edge.right_face;
        List start_faces = Util.duplicate((List)short_edge.start.get_faces());
        List end_faces = Util.duplicate((List)short_edge.end.get_faces());
        Vertex new_vertex = short_edge.mid_vertex();
        new_vertex.fixed = short_edge.start.fixed;
        h.add(new_vertex);
        ArrayList edge_replace_list = new ArrayList();
        Iterator e = short_edge.start.edges.iterator();
        while (e.hasNext()) {
            edge = (Edge)e.next();
            if (edge == short_edge) continue;
            the_other_vertex = edge.get_opposite_vertex(short_edge.start);
            Skin.register_replacement(edge_replace_list, edge, new_vertex, the_other_vertex, dirty_edges);
        }
        e = short_edge.end.edges.iterator();
        while (e.hasNext()) {
            edge = (Edge)e.next();
            if (edge == short_edge) continue;
            the_other_vertex = edge.get_opposite_vertex(short_edge.end);
            Skin.register_replacement(edge_replace_list, edge, new_vertex, the_other_vertex, dirty_edges);
        }
        e = start_faces.iterator();
        while (e.hasNext()) {
            face = (Face)e.next();
            if (face == left_face || face == right_face) continue;
            h.add(Skin.replaced_face(face, edge_replace_list));
            h.remove(face);
        }
        e = end_faces.iterator();
        while (e.hasNext()) {
            face = (Face)e.next();
            if (face == left_face || face == right_face) continue;
            h.add(Skin.replaced_face(face, edge_replace_list));
            h.remove(face);
        }
        if (left_face != null) {
            h.remove(left_face);
        }
        if (right_face != null) {
            h.remove(right_face);
        }
    }

    private static void swap_edge(Edge edge, List dirty_edges) {
        Vertex v0 = edge.left_face.get_opposite_vertex(edge);
        Vertex v1 = edge.right_face.get_opposite_vertex(edge);
        Edge start_v0 = edge.left_face.get_opposite_edge(edge.end);
        Edge end_v0 = edge.left_face.get_opposite_edge(edge.start);
        Edge start_v1 = edge.right_face.get_opposite_edge(edge.end);
        Edge end_v1 = edge.right_face.get_opposite_edge(edge.start);
        Face left_face = edge.left_face;
        Face right_face = edge.right_face;
        Edge new_edge = new Edge(v0, v1);
        Face new_face0 = new Face(start_v1, new_edge, start_v0);
        Face new_face1 = new Face(end_v0, new_edge, end_v1);
        h.add(new_edge);
        h.add(new_face0);
        h.add(new_face1);
        h.remove(left_face);
        h.remove(right_face);
        dirty_edges.add(new_edge);
    }

    public static void remove_a_short_edge(Edge short_edge, Vertex deleted_vertex, Vertex base_vertex, List dirty_edges) {
        Face left_face = short_edge.left_face;
        Face right_face = short_edge.right_face;
        List deleted_faces = Util.duplicate((List)deleted_vertex.get_faces());
        Vertex new_vertex = base_vertex;
        ArrayList edge_replace_list = new ArrayList();
        Skin.init_replacement(edge_replace_list, base_vertex);
        Iterator e = deleted_vertex.edges.iterator();
        while (e.hasNext()) {
            Edge edge = (Edge)e.next();
            if (edge == short_edge) continue;
            Vertex the_other_vertex = edge.get_opposite_vertex(deleted_vertex);
            Skin.register_replacement(edge_replace_list, edge, new_vertex, the_other_vertex, dirty_edges);
        }
        e = deleted_faces.iterator();
        while (e.hasNext()) {
            Face face = (Face)e.next();
            if (face == left_face || face == right_face) continue;
            h.add(Skin.replaced_face(face, edge_replace_list));
            h.remove(face);
        }
        h.remove(left_face);
        h.remove(right_face);
    }

    private static Face replaced_face_special(Face face, List edge_replace_list, Edge short_edge) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        int i = 0;
        while (i < face.edges.length) {
            Edge edge = face.edges[i];
            if (edge != short_edge) {
                edges.add(Skin.get_corresponding_edge(edge, edge_replace_list));
            }
            ++i;
        }
        return new Face(edges);
    }

    private static Face replaced_face(Face face, List edge_replace_list) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        int i = 0;
        while (i < face.edges.length) {
            Edge edge = face.edges(i);
            edges.add(Skin.get_corresponding_edge(edge, edge_replace_list));
            ++i;
        }
        return new Face(edges);
    }

    private static Edge get_corresponding_edge(Edge edge, List edge_replace_list) {
        Iterator e = edge_replace_list.iterator();
        while (e.hasNext()) {
            Object[] objects = (Object[])e.next();
            Edge registered_edge = (Edge)objects[0];
            if (edge != registered_edge) continue;
            return (Edge)objects[1];
        }
        return edge;
    }

    private static void init_replacement(List edge_replace_list, Vertex base_vertex) {
        Iterator e = base_vertex.edges.iterator();
        while (e.hasNext()) {
            Edge edge = (Edge)e.next();
            Object[] new_objects = new Object[]{edge, edge};
            edge_replace_list.add(new_objects);
        }
    }

    private static void register_replacement(List edge_replace_list, Edge edge, Vertex start, Vertex end, List dirty_edges) {
        Iterator e = edge_replace_list.iterator();
        while (e.hasNext()) {
            Object[] objects = (Object[])e.next();
            Edge new_edge = (Edge)objects[1];
            if (!new_edge.contains(start) || !new_edge.contains(end)) continue;
            Object[] new_objects = new Object[]{edge, new_edge};
            edge_replace_list.add(new_objects);
            return;
        }
        Edge new_edge = new Edge(start, end);
        h.add(new_edge);
        Object[] objects = new Object[]{edge, new_edge};
        edge_replace_list.add(objects);
        dirty_edges.add(new_edge);
    }
}

