/*
 * Decompiled with CFR 0.152.
 */
package rigid;

import VisualNumerics.math.DoubleLU;
import VisualNumerics.math.DoubleMatrix;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import rigid.Mesh;
import rigid.SparseMatrix;
import rigid.Vertex;
import teddy.Face2D;
import teddy.Util;
import teddy.Vector2;
import teddy.Vertex2D;
import umfpack.Umfpack;

public class RigidTransform {
    Mesh mesh;
    double[][] E;
    int n_vertices;
    boolean COMPARE = false;
    transient Umfpack umfpack = null;
    int matrix_id = -1;
    double[][] invG_C;
    List input_vertices;
    List output_vertices;
    double[][] inversed_matrix;
    DoubleLU doubleLU;

    public RigidTransform(Mesh mesh) {
        this.mesh = mesh;
    }

    public RigidTransform get_duplicated(Mesh new_mesh) {
        RigidTransform rt = new RigidTransform(new_mesh);
        rt.E = (double[][])this.E.clone();
        rt.n_vertices = this.n_vertices;
        return rt;
    }

    public void initialize_E_laplacian() {
        this.mesh.set_indices();
        this.n_vertices = this.mesh.vertices.size();
        this.E = new double[this.n_vertices * 2][this.n_vertices * 2];
        int i = 0;
        while (i < this.mesh.faces.size()) {
            Face2D face = (Face2D)this.mesh.faces.get(i);
            Vertex2D v0 = face.get_vertex(0);
            Vertex2D v1 = face.get_vertex(1);
            Vertex2D v2 = face.get_vertex(2);
            this.set_face_constraints(v0, v1, v2);
            ++i;
        }
    }

    void set_face_constraints(Vertex2D v0, Vertex2D v1, Vertex2D v2) {
        int[] b = new int[6];
        int i = 0;
        while (i < 2) {
            b[0 + i] = v0.index * 2 + i;
            b[2 + i] = v1.index * 2 + i;
            b[4 + i] = v2.index * 2 + i;
            ++i;
        }
        double[][][] T = this.compute_T(v0, v1, v2);
        double[][] A = new double[][]{{-1.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, -1.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, -1.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, -1.0, 0.0, 1.0}, {1.0, 0.0, 0.0, 0.0, -1.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, -1.0}};
        Vector2 vec01 = new Vector2((Vector2)v0, (Vector2)v1);
        Vector2 vec12 = new Vector2((Vector2)v1, (Vector2)v2);
        Vector2 vec20 = new Vector2((Vector2)v2, (Vector2)v0);
        int i2 = 0;
        while (i2 < 6) {
            double[] dArray = A[0];
            int n = i2;
            dArray[n] = dArray[n] + -(T[0][0][i2] * vec01.x + T[0][1][i2] * vec01.y);
            double[] dArray2 = A[1];
            int n2 = i2;
            dArray2[n2] = dArray2[n2] + -(T[1][0][i2] * vec01.x + T[1][1][i2] * vec01.y);
            double[] dArray3 = A[2];
            int n3 = i2;
            dArray3[n3] = dArray3[n3] + -(T[0][0][i2] * vec12.x + T[0][1][i2] * vec12.y);
            double[] dArray4 = A[3];
            int n4 = i2;
            dArray4[n4] = dArray4[n4] + -(T[1][0][i2] * vec12.x + T[1][1][i2] * vec12.y);
            double[] dArray5 = A[4];
            int n5 = i2;
            dArray5[n5] = dArray5[n5] + -(T[0][0][i2] * vec20.x + T[0][1][i2] * vec20.y);
            double[] dArray6 = A[5];
            int n6 = i2;
            dArray6[n6] = dArray6[n6] + -(T[1][0][i2] * vec20.x + T[1][1][i2] * vec20.y);
            ++i2;
        }
        i2 = 0;
        while (i2 < 6) {
            int j = 0;
            while (j < 6) {
                int k = 0;
                while (k < 6) {
                    double[] dArray = this.E[b[i2]];
                    int n = b[j];
                    dArray[n] = dArray[n] + A[k][i2] * A[k][j];
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
    }

    double[][][] compute_T(Vertex2D v0, Vertex2D v1, Vertex2D v2) {
        int nn = 6;
        Vertex2D[] vvs = new Vertex2D[]{v0, v1, v2};
        double[][] A = new double[nn][4];
        int i = 0;
        while (i < vvs.length) {
            Vertex2D u = vvs[i];
            A[i * 2 + 0][0] = u.x;
            A[i * 2 + 0][1] = u.y;
            A[i * 2 + 0][2] = 1.0;
            A[i * 2 + 0][3] = 0.0;
            A[i * 2 + 1][0] = u.y;
            A[i * 2 + 1][1] = -u.x;
            A[i * 2 + 1][2] = 0.0;
            A[i * 2 + 1][3] = 1.0;
            ++i;
        }
        double[][] AT = this.transpose(A);
        double[][] ATA_AT = this.multiply(this.inverse(this.multiply(AT, A)), AT);
        double[] a = ATA_AT[0];
        double[] w = ATA_AT[1];
        double[][][] T = new double[2][2][nn];
        int i2 = 0;
        while (i2 < nn) {
            T[0][0][i2] = a[i2];
            T[0][1][i2] = w[i2];
            T[1][0][i2] = -w[i2];
            T[1][1][i2] = a[i2];
            ++i2;
        }
        return T;
    }

    double[][] multiply(double[][] A, double[][] B) {
        return DoubleMatrix.multiply((double[][])A, (double[][])B);
    }

    double[][] transpose(double[][] A) {
        return DoubleMatrix.transpose((double[][])A);
    }

    double[] multiply(double[][] A, double[] B) {
        return DoubleMatrix.multiply((double[][])A, (double[])B);
    }

    public void _initialize_E() {
        this.mesh.set_indices();
        int n = this.mesh.vertices.size();
        double[][] _E = new double[this.mesh.faces.size() * 6][this.mesh.vertices.size() * 2];
        int i = 0;
        while (i < this.mesh.faces.size()) {
            Face2D face = (Face2D)this.mesh.faces.get(i);
            Vertex2D v0 = face.get_vertex(0);
            Vertex2D v1 = face.get_vertex(1);
            Vertex2D v2 = face.get_vertex(2);
            int v0x = v0.index * 2;
            int v0y = v0.index * 2 + 1;
            int v1x = v1.index * 2;
            int v1y = v1.index * 2 + 1;
            int v2x = v2.index * 2;
            int v2y = v2.index * 2 + 1;
            double[][] A02 = new double[2][2];
            double[][] A12 = new double[2][2];
            double[][] A10 = new double[2][2];
            double[][] A20 = new double[2][2];
            double[][] A21 = new double[2][2];
            double[][] A01 = new double[2][2];
            RigidTransform.set_relative_coords(v0, v1, v2, A02, A12);
            RigidTransform.set_relative_coords(v1, v2, v0, A10, A20);
            RigidTransform.set_relative_coords(v2, v0, v1, A21, A01);
            this.set_triangle_constraint_sub(_E, i * 6, face.weight, v0x, v0y, v1x, v1y, v2x, v2y, A01, A10, A12, A21, A20, A02);
            this.set_triangle_constraint_sub(_E, i * 6 + 2, face.weight, v1x, v1y, v2x, v2y, v0x, v0y, A12, A21, A20, A02, A01, A10);
            this.set_triangle_constraint_sub(_E, i * 6 + 4, face.weight, v2x, v2y, v0x, v0y, v1x, v1y, A20, A02, A01, A10, A12, A21);
            ++i;
        }
        this.E = this.multiply(this.transpose(_E), _E);
    }

    void set_triangle_constraint_sub(double[][] _E, int row, double weight, int v0x, int v0y, int v1x, int v1y, int v2x, int v2y, double[][] A01, double[][] A10, double[][] A12, double[][] A21, double[][] A20, double[][] A02) {
        _E[row + 0][v2x] = 1.0 * weight;
        _E[row + 0][v2y] = 0.0;
        _E[row + 0][v0x] = -A02[0][0] * weight;
        _E[row + 0][v0y] = -A02[1][0] * weight;
        _E[row + 0][v1x] = -A12[0][0] * weight;
        _E[row + 0][v1y] = -A12[1][0] * weight;
        _E[row + 1][v2x] = 0.0;
        _E[row + 1][v2y] = 1.0 * weight;
        _E[row + 1][v0x] = -A02[0][1] * weight;
        _E[row + 1][v0y] = -A02[1][1] * weight;
        _E[row + 1][v1x] = -A12[0][1] * weight;
        _E[row + 1][v1y] = -A12[1][1] * weight;
    }

    public void initialize_E() {
        this.mesh.set_indices();
        int n = this.mesh.vertices.size();
        this.E = new double[n * 2][n * 2];
        int i = 0;
        while (i < this.mesh.faces.size()) {
            Face2D face = (Face2D)this.mesh.faces.get(i);
            Vertex2D v0 = face.get_vertex(0);
            Vertex2D v1 = face.get_vertex(1);
            Vertex2D v2 = face.get_vertex(2);
            int v0x = v0.index * 2;
            int v0y = v0.index * 2 + 1;
            int v1x = v1.index * 2;
            int v1y = v1.index * 2 + 1;
            int v2x = v2.index * 2;
            int v2y = v2.index * 2 + 1;
            double[][] A02 = new double[2][2];
            double[][] A12 = new double[2][2];
            double[][] A10 = new double[2][2];
            double[][] A20 = new double[2][2];
            double[][] A21 = new double[2][2];
            double[][] A01 = new double[2][2];
            RigidTransform.set_relative_coords(v0, v1, v2, A02, A12);
            RigidTransform.set_relative_coords(v1, v2, v0, A10, A20);
            RigidTransform.set_relative_coords(v2, v0, v1, A21, A01);
            this.set_triangle_constraint_sub(v0x, v0y, v1x, v1y, v2x, v2y, A01, A10, A12, A21, A20, A02, face.weight);
            this.set_triangle_constraint_sub(v1x, v1y, v2x, v2y, v0x, v0y, A12, A21, A20, A02, A01, A10, face.weight);
            this.set_triangle_constraint_sub(v2x, v2y, v0x, v0y, v1x, v1y, A20, A02, A01, A10, A12, A21, face.weight);
            ++i;
        }
    }

    void set_triangle_constraint_sub(int v0x, int v0y, int v1x, int v1y, int v2x, int v2y, double[][] A01, double[][] A10, double[][] A12, double[][] A21, double[][] A20, double[][] A02, double weight) {
        double[] dArray = this.E[v2x];
        int n = v0x;
        dArray[n] = dArray[n] + (-A02[0][0] + A21[0][0] * A01[0][0] + A21[0][1] * A01[0][1] - A20[0][0]);
        double[] dArray2 = this.E[v2x];
        int n2 = v0y;
        dArray2[n2] = dArray2[n2] + (-A02[1][0] + A21[0][0] * A01[1][0] + A21[0][1] * A01[1][1] - A20[0][1]);
        double[] dArray3 = this.E[v2x];
        int n3 = v1x;
        dArray3[n3] = dArray3[n3] + (-A12[0][0] - A21[0][0] + A20[0][0] * A10[0][0] + A20[0][1] * A10[0][1]);
        double[] dArray4 = this.E[v2x];
        int n4 = v1y;
        dArray4[n4] = dArray4[n4] + (-A12[1][0] - A21[0][1] + A20[0][0] * A10[1][0] + A20[0][1] * A10[1][1]);
        double[] dArray5 = this.E[v2x];
        int n5 = v2x;
        dArray5[n5] = dArray5[n5] + (1.0 + A21[0][0] * A21[0][0] + A21[0][1] * A21[0][1] + A20[0][0] * A20[0][0] + A20[0][1] * A20[0][1]);
        double[] dArray6 = this.E[v2x];
        int n6 = v2y;
        dArray6[n6] = dArray6[n6] + (0.0 + A21[0][0] * A21[1][0] + A21[0][1] * A21[1][1] + A20[0][0] * A20[1][0] + A20[0][1] * A20[1][1]);
        double[] dArray7 = this.E[v2y];
        int n7 = v0x;
        dArray7[n7] = dArray7[n7] + (-A02[0][1] + A21[1][0] * A01[0][0] + A21[1][1] * A01[0][1] - A20[1][0]) * weight;
        double[] dArray8 = this.E[v2y];
        int n8 = v0y;
        dArray8[n8] = dArray8[n8] + (-A02[1][1] + A21[1][0] * A01[1][0] + A21[1][1] * A01[1][1] - A20[1][1]) * weight;
        double[] dArray9 = this.E[v2y];
        int n9 = v1x;
        dArray9[n9] = dArray9[n9] + (-A12[0][1] - A21[1][0] + A20[1][0] * A10[0][0] + A20[1][1] * A10[0][1]) * weight;
        double[] dArray10 = this.E[v2y];
        int n10 = v1y;
        dArray10[n10] = dArray10[n10] + (-A12[1][1] - A21[1][1] + A20[1][0] * A10[1][0] + A20[1][1] * A10[1][1]) * weight;
        double[] dArray11 = this.E[v2y];
        int n11 = v2x;
        dArray11[n11] = dArray11[n11] + (0.0 + A21[1][0] * A21[0][0] + A21[1][1] * A21[0][1] + A20[1][0] * A20[0][0] + A20[1][1] * A20[0][1]) * weight;
        double[] dArray12 = this.E[v2y];
        int n12 = v2y;
        dArray12[n12] = dArray12[n12] + (1.0 + A21[1][0] * A21[1][0] + A21[1][1] * A21[1][1] + A20[1][0] * A20[1][0] + A20[1][1] * A20[1][1]) * weight;
    }

    static void set_relative_coords(Vertex2D v0, Vertex2D v1, Vertex2D v2, double[][] A02, double[][] A12) {
        Vector2 v01 = new Vector2((Vector2)v0, (Vector2)v1);
        Vector2 v02 = new Vector2((Vector2)v0, (Vector2)v2);
        Vector2 v01t = new Vector2(v01.y, -v01.x);
        double det = v01.x * v01.x + v01.y * v01.y;
        double[] w = new double[]{(v01.x * v02.x + v01.y * v02.y) / det, (v01.y * v02.x - v01.x * v02.y) / det};
        A02[0][0] = 1.0 - w[0];
        A02[1][0] = -w[1];
        A02[0][1] = w[1];
        A02[1][1] = 1.0 - w[0];
        A12[0][0] = w[0];
        A12[1][0] = w[1];
        A12[0][1] = -w[1];
        A12[1][1] = w[0];
    }

    public void compile(List _input_vertices) {
        this.input_vertices = _input_vertices;
        this.output_vertices = Util.subtract((List)this.mesh.vertices, (List)this.input_vertices);
        int n_output = this.output_vertices.size();
        int n_input = this.input_vertices.size();
        SparseMatrix matrix = new SparseMatrix(n_output * 2);
        int i = 0;
        while (i < n_output) {
            Vertex2D u = (Vertex2D)this.output_vertices.get(i);
            int j = 0;
            while (j < n_output) {
                Vertex2D v = (Vertex2D)this.output_vertices.get(j);
                if (this.E[u.index * 2][v.index * 2] != 0.0) {
                    matrix.add(i * 2, j * 2, this.E[u.index * 2][v.index * 2]);
                    matrix.add(i * 2 + 1, j * 2, this.E[u.index * 2 + 1][v.index * 2]);
                    matrix.add(i * 2, j * 2 + 1, this.E[u.index * 2][v.index * 2 + 1]);
                    matrix.add(i * 2 + 1, j * 2 + 1, this.E[u.index * 2 + 1][v.index * 2 + 1]);
                }
                ++j;
            }
            ++i;
        }
        Object[] A = matrix.get_umfpack_matrix();
        int[] Ap = (int[])A[0];
        int[] Ai = (int[])A[1];
        double[] Ax = (double[])A[2];
        this.umfpack_factorize(n_output * 2, Ap, Ai, Ax);
        double[][] C = new double[this.output_vertices.size() * 2][this.input_vertices.size() * 2];
        int i2 = 0;
        while (i2 < n_output) {
            Vertex2D u = (Vertex2D)this.output_vertices.get(i2);
            int j = 0;
            while (j < n_input) {
                Vertex2D v = (Vertex2D)this.input_vertices.get(j);
                if (this.E[u.index * 2][v.index * 2] != 0.0) {
                    double[] dArray = C[i2 * 2];
                    int n = j * 2;
                    dArray[n] = dArray[n] - this.E[u.index * 2][v.index * 2];
                    double[] dArray2 = C[i2 * 2];
                    int n2 = j * 2 + 1;
                    dArray2[n2] = dArray2[n2] - this.E[u.index * 2][v.index * 2 + 1];
                    double[] dArray3 = C[i2 * 2 + 1];
                    int n3 = j * 2;
                    dArray3[n3] = dArray3[n3] - this.E[u.index * 2 + 1][v.index * 2];
                    double[] dArray4 = C[i2 * 2 + 1];
                    int n4 = j * 2 + 1;
                    dArray4[n4] = dArray4[n4] - this.E[u.index * 2 + 1][v.index * 2 + 1];
                }
                ++j;
            }
            ++i2;
        }
        double[][] invG_C_transpose = new double[this.input_vertices.size() * 2][this.output_vertices.size() * 2];
        double[] q = new double[this.input_vertices.size() * 2];
        int i3 = 0;
        while (i3 < this.input_vertices.size() * 2) {
            q[i3] = 1.0;
            double[] B = this.multiply(C, q);
            invG_C_transpose[i3] = this.umfpack_solve(B);
            q[i3] = 0.0;
            ++i3;
        }
        this.invG_C = this.transpose(invG_C_transpose);
    }

    public void _compile(List _input_vertices) {
        this.input_vertices = _input_vertices;
        this.output_vertices = Util.subtract((List)this.mesh.vertices, (List)this.input_vertices);
        int n_output = this.output_vertices.size();
        SparseMatrix matrix = new SparseMatrix(n_output * 2);
        int i = 0;
        while (i < n_output) {
            Vertex u = (Vertex)((Object)this.output_vertices.get(i));
            int j = 0;
            while (j < n_output) {
                Vertex2D v = (Vertex2D)this.output_vertices.get(j);
                if (this.E[u.index * 2][v.index * 2] != 0.0) {
                    matrix.add(i * 2, j * 2, this.E[u.index * 2][v.index * 2]);
                    matrix.add(i * 2 + 1, j * 2, this.E[u.index * 2 + 1][v.index * 2]);
                    matrix.add(i * 2, j * 2 + 1, this.E[u.index * 2][v.index * 2 + 1]);
                    matrix.add(i * 2 + 1, j * 2 + 1, this.E[u.index * 2 + 1][v.index * 2 + 1]);
                }
                ++j;
            }
            ++i;
        }
        Object[] A = matrix.get_umfpack_matrix();
        int[] Ap = (int[])A[0];
        int[] Ai = (int[])A[1];
        double[] Ax = (double[])A[2];
        this.umfpack_factorize(n_output * 2, Ap, Ai, Ax);
    }

    public void __compile(List _input_vertices) {
        this.input_vertices = _input_vertices;
        this.output_vertices = Util.subtract((List)this.mesh.vertices, (List)this.input_vertices);
        int n_output = this.output_vertices.size();
        double[][] m = new double[n_output * 2][n_output * 2];
        int i = 0;
        while (i < n_output) {
            Vertex2D u = (Vertex2D)this.output_vertices.get(i);
            int j = 0;
            while (j < n_output) {
                Vertex2D v = (Vertex2D)this.output_vertices.get(j);
                m[i * 2][j * 2] = this.E[u.index * 2][v.index * 2];
                m[i * 2 + 1][j * 2] = this.E[u.index * 2 + 1][v.index * 2];
                m[i * 2][j * 2 + 1] = this.E[u.index * 2][v.index * 2 + 1];
                m[i * 2 + 1][j * 2 + 1] = this.E[u.index * 2 + 1][v.index * 2 + 1];
                ++j;
            }
            ++i;
        }
        if (this.COMPARE) {
            long time = System.currentTimeMillis();
            this.doubleLU = this.construct_doubleLU(m);
            System.out.println("doubleLU " + (System.currentTimeMillis() - time));
            time = System.currentTimeMillis();
            this.umfpack_factorize(m);
            System.out.println("umfpack " + (System.currentTimeMillis() - time));
        }
        this.umfpack_factorize(m);
    }

    void umfpack_factorize(double[][] A) {
        if (this.umfpack == null) {
            this.umfpack = new Umfpack();
        } else {
            this.umfpack.release();
        }
        this.umfpack.factorize(A);
    }

    void umfpack_factorize(int n, int[] Ap, int[] Ai, double[] Ax) {
        if (this.umfpack == null) {
            this.umfpack = new Umfpack();
        } else {
            this.umfpack.release();
        }
        this.umfpack.factorize(n, Ap, Ai, Ax);
    }

    double[] umfpack_solve(double[] B) {
        double[] x = new double[B.length];
        this.umfpack.solve(B, x);
        return x;
    }

    public void umfpack_release() {
        if (this.matrix_id != -1 && this.umfpack != null) {
            this.umfpack.release();
        }
    }

    public void update() {
        int n_input = this.input_vertices.size();
        int n_output = this.output_vertices.size();
        double[] q = new double[n_input * 2];
        int i = 0;
        while (i < n_input) {
            Vertex2D v = (Vertex2D)this.input_vertices.get(i);
            q[i * 2] = v.x;
            q[i * 2 + 1] = v.y;
            ++i;
        }
        double[] output = this.multiply(this.invG_C, q);
        int i2 = 0;
        while (i2 < n_output) {
            Vertex2D v = (Vertex2D)this.output_vertices.get(i2);
            v.x = output[i2 * 2];
            v.y = output[i2 * 2 + 1];
            ++i2;
        }
    }

    public void _update() {
        int n_input = this.input_vertices.size();
        int n_output = this.output_vertices.size();
        double[] b = new double[n_output * 2];
        int i = 0;
        while (i < n_output) {
            Vertex2D u = (Vertex2D)this.output_vertices.get(i);
            int j = 0;
            while (j < n_input) {
                Vertex2D v = (Vertex2D)this.input_vertices.get(j);
                int n = i * 2;
                b[n] = b[n] - (this.E[u.index * 2][v.index * 2] * v.x + this.E[u.index * 2][v.index * 2 + 1] * v.y);
                int n2 = i * 2 + 1;
                b[n2] = b[n2] - (this.E[u.index * 2 + 1][v.index * 2] * v.x + this.E[u.index * 2 + 1][v.index * 2 + 1] * v.y);
                ++j;
            }
            ++i;
        }
        double[] output = null;
        if (this.COMPARE) {
            long time = System.currentTimeMillis();
            int i2 = 0;
            while (i2 < 100) {
                output = this.doubleLU.solve(b);
                ++i2;
            }
            System.out.println("update DoubleLU " + (System.currentTimeMillis() - time));
            time = System.currentTimeMillis();
            i2 = 0;
            while (i2 < 100) {
                output = this.umfpack_solve(b);
                ++i2;
            }
            System.out.println("update umfpack  " + (System.currentTimeMillis() - time));
        }
        output = this.umfpack_solve(b);
        int i3 = 0;
        while (i3 < n_output) {
            Vertex v = (Vertex)((Object)this.output_vertices.get(i3));
            v.x = output[i3 * 2];
            v.y = output[i3 * 2 + 1];
            ++i3;
        }
    }

    public double[] solve_linear_system(double[][] A, double[] b) {
        double[] x = null;
        try {
            x = DoubleMatrix.solve((double[][])A, (double[])b);
        }
        catch (Exception e) {
            System.out.println("Solve failed! " + e);
        }
        return x;
    }

    public double[][] inverse(double[][] A) {
        double[][] _A = null;
        try {
            _A = DoubleMatrix.inverse((double[][])A);
        }
        catch (Exception e) {
            System.out.println("Solve failed! " + e);
        }
        return _A;
    }

    public DoubleLU construct_doubleLU(double[][] A) {
        DoubleLU doubleLU = null;
        try {
            doubleLU = new DoubleLU(A);
        }
        catch (Exception e) {
            System.out.println("Solve failed! " + e);
        }
        return doubleLU;
    }

    static void store(double[][] m, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            int i = 0;
            while (i < m.length) {
                int j = 0;
                while (j < m[i].length) {
                    out.write(" " + m[i][j]);
                    ++j;
                }
                out.newLine();
                ++i;
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.print("IO Error " + e);
        }
    }
}

