/*
 * Decompiled with CFR 0.152.
 */
package rigid;

import java.util.ArrayList;
import java.util.List;
import rigid.Edge;
import rigid.Face;
import rigid.Mesh;
import rigid.Vertex;
import teddy.Vector2;
import teddy.Vertex2D;

public class Relaxation {
    Mesh mesh;
    double[] angle1;
    double[] angle2;
    Vector2[][] coords;
    Vertex[][] face_vertex;
    double[] original_edge_length;
    Vector2[][] ws;

    public Relaxation(Mesh mesh) {
        this.mesh = mesh;
        this.init_placements();
    }

    public void relax(List vertices) {
        Vector2[] target = this.get_target_positions();
        int i = 0;
        while (i < vertices.size()) {
            Vertex v = (Vertex)((Object)vertices.get(i));
            v.warp(target[v.index]);
            ++i;
        }
    }

    public Vector2[] get_target_positions() {
        Vector2[] target = new Vector2[this.mesh.vertices.size()];
        int i = 0;
        while (i < this.mesh.vertices.size()) {
            target[i] = new Vector2();
            ++i;
        }
        int[] weight = new int[this.mesh.vertices.size()];
        int i2 = 0;
        while (i2 < this.mesh.faces.size()) {
            Face face = (Face)this.mesh.faces.get(i2);
            Vertex v0 = this.face_vertex[i2][0];
            Vertex v1 = this.face_vertex[i2][1];
            Vertex v2 = this.face_vertex[i2][2];
            Vector2 center = Vector2.multiply((Vector2)Vector2.add((Vector2)v0, (Vector2)v1, (Vector2)v2), (double)0.3333333333333333);
            Vector2 vec0 = new Vector2(center, (Vector2)v0);
            Vector2 vec1 = new Vector2(center, (Vector2)v1);
            vec1 = Vector2.rotate((Vector2)vec1, (double)this.angle1[i2]);
            Vector2 vec2 = new Vector2(center, (Vector2)v2);
            vec2 = Vector2.rotate((Vector2)vec2, (double)this.angle2[i2]);
            Vector2 vec_x = Vector2.add((Vector2)vec0, (Vector2)vec1, (Vector2)vec2);
            vec_x = Vector2.normalize((Vector2)vec_x);
            Vector2 vec_y = Vector2.rotate90((Vector2)vec_x);
            Vector2 v0_target = Vector2.add((Vector2)center, (Vector2)Vector2.multiply((Vector2)vec_x, (double)this.coords[i2][0].x), (Vector2)Vector2.multiply((Vector2)vec_y, (double)this.coords[i2][0].y));
            Vector2 v1_target = Vector2.add((Vector2)center, (Vector2)Vector2.multiply((Vector2)vec_x, (double)this.coords[i2][1].x), (Vector2)Vector2.multiply((Vector2)vec_y, (double)this.coords[i2][1].y));
            Vector2 v2_target = Vector2.add((Vector2)center, (Vector2)Vector2.multiply((Vector2)vec_x, (double)this.coords[i2][2].x), (Vector2)Vector2.multiply((Vector2)vec_y, (double)this.coords[i2][2].y));
            target[v0.index].add(v0_target);
            target[v1.index].add(v1_target);
            target[v2.index].add(v2_target);
            int n = v0.index;
            weight[n] = weight[n] + 1;
            int n2 = v1.index;
            weight[n2] = weight[n2] + 1;
            int n3 = v2.index;
            weight[n3] = weight[n3] + 1;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.mesh.vertices.size()) {
            target[i2] = Vector2.multiply((Vector2)target[i2], (double)(1.0 / (double)weight[i2]));
            ++i2;
        }
        return target;
    }

    public void init_placements() {
        this.angle1 = new double[this.mesh.faces.size()];
        this.angle2 = new double[this.mesh.faces.size()];
        this.coords = new Vector2[this.mesh.faces.size()][3];
        this.face_vertex = new Vertex[this.mesh.faces.size()][3];
        int i = 0;
        while (i < this.mesh.faces.size()) {
            Face face = (Face)this.mesh.faces.get(i);
            Vertex2D center = face.get_center();
            Vertex v0 = face.get_vertex(0);
            Vertex v1 = face.get_vertex(1);
            Vertex v2 = face.get_vertex(2);
            this.face_vertex[i][0] = v0;
            this.face_vertex[i][1] = v1;
            this.face_vertex[i][2] = v2;
            Vector2 vec0 = new Vector2((Vector2)center, (Vector2)v0);
            Vector2 vec1 = new Vector2((Vector2)center, (Vector2)v1);
            this.angle1[i] = Vector2.get_angle_360((Vector2)vec1, (Vector2)vec0);
            Vector2 vec2 = new Vector2((Vector2)center, (Vector2)v2);
            this.angle2[i] = Vector2.get_angle_360((Vector2)vec2, (Vector2)vec0);
            Vector2 vec_x = new Vector2(vec0);
            vec_x = Vector2.normalize((Vector2)vec_x);
            Vector2 vec_y = Vector2.rotate90((Vector2)vec_x);
            this.coords[i][0] = new Vector2(Vector2.dot_product((Vector2)vec_x, (Vector2)vec0), Vector2.dot_product((Vector2)vec_y, (Vector2)vec0));
            this.coords[i][1] = new Vector2(Vector2.dot_product((Vector2)vec_x, (Vector2)vec1), Vector2.dot_product((Vector2)vec_y, (Vector2)vec1));
            this.coords[i][2] = new Vector2(Vector2.dot_product((Vector2)vec_x, (Vector2)vec2), Vector2.dot_product((Vector2)vec_y, (Vector2)vec2));
            ++i;
        }
    }

    public Vector2 _get_target_position(Vertex v) {
        Vector2 sum = new Vector2();
        int i = 0;
        while (i < v.edges.size()) {
            Edge edge = (Edge)v.edges.get(i);
            Vertex u = edge.get_opposite_vertex(v);
            Vector2 vec = new Vector2((Vector2)v, (Vector2)u);
            vec = Vector2.normalize((Vector2)vec);
            double excess = edge.length() - this.get_original_length(edge);
            vec = Vector2.multiply((Vector2)vec, (double)excess);
            sum = Vector2.add((Vector2)sum, (Vector2)vec);
            ++i;
        }
        sum = Vector2.multiply((Vector2)sum, (double)0.2);
        return Vector2.add((Vector2)v, (Vector2)sum);
    }

    public Vector2 __get_target_position(Vertex v) {
        ArrayList faces = v.get_faces();
        Vector2 sum = new Vector2();
        double total_w = 0.0;
        int i = 0;
        while (i < faces.size()) {
            Face face = (Face)faces.get(i);
            Edge edge = face.get_opposite_edge(v);
            Vector2 vec_x = new Vector2((Vector2)edge.start, (Vector2)edge.end);
            Vector2 vec_y = Vector2.rotate90((Vector2)vec_x);
            double ratio = edge.length() / this.get_original_length(edge);
            Vector2 w = new Vector2(this.get_w(face, v));
            w.y /= ratio;
            Vector2 target = Vector2.add((Vector2)edge.start, (Vector2)Vector2.multiply((Vector2)vec_x, (double)w.x), (Vector2)Vector2.multiply((Vector2)vec_y, (double)w.y));
            Vector2 vec = new Vector2((Vector2)v, target);
            sum = Vector2.add((Vector2)sum, (Vector2)vec);
            ++i;
        }
        sum = Vector2.multiply((Vector2)sum, (double)0.2);
        return Vector2.add((Vector2)v, (Vector2)sum);
    }

    public void init() {
        this.ws = new Vector2[this.mesh.faces.size()][3];
        this.original_edge_length = new double[this.mesh.edges.size()];
        int i = 0;
        while (i < this.mesh.edges.size()) {
            Edge edge = (Edge)this.mesh.edges.get(i);
            this.original_edge_length[i] = edge.length();
            ++i;
        }
        i = 0;
        while (i < this.mesh.faces.size()) {
            Face face = (Face)this.mesh.faces.get(i);
            int j = 0;
            while (j < 3) {
                Vertex v = face.get_vertex(j);
                Edge edge = face.get_opposite_edge(v);
                Vector2 vec = new Vector2((Vector2)edge.start, (Vector2)v);
                Vector2 vec_x = new Vector2((Vector2)edge.start, (Vector2)edge.end);
                Vector2 vec_y = Vector2.rotate90((Vector2)vec_x);
                double length = vec_x.length();
                double wx = Vector2.dot_product((Vector2)vec_x, (Vector2)vec) / (length * length);
                double wy = Vector2.dot_product((Vector2)vec_y, (Vector2)vec) / (length * length);
                this.ws[i][j] = new Vector2(wx, wy);
                ++j;
            }
            ++i;
        }
    }

    double get_original_length(Edge edge) {
        return this.original_edge_length[edge.index];
    }

    Vector2 get_w(Face face, Vertex v) {
        int i = face.get_vertex_index(v);
        return this.ws[face.index][i];
    }
}

