/*
 * Decompiled with CFR 0.152.
 */
package rigid;

import java.util.ArrayList;
import rigid.Delaunay;
import rigid.Edge;
import rigid.Face;
import rigid.Skin;
import rigid.Vertex;
import teddy.Edge2D;
import teddy.Face2D;
import teddy.Polyhedron2D;
import teddy.Vertex2D;

public class Mesh {
    public ArrayList vertices = new ArrayList();
    public ArrayList edges = new ArrayList();
    public ArrayList faces = new ArrayList();
    public double unit_length;
    public ArrayList original_stroke;

    Mesh() {
    }

    public Mesh(ArrayList stroke, double unit_length) {
        this.unit_length = unit_length;
        this.construct_mesh(stroke);
    }

    public Mesh(ArrayList stroke, ArrayList triangles, double unit_length) {
        this.unit_length = unit_length;
        this.construct_mesh(stroke, triangles);
    }

    public static Mesh construct_mesh_from_polyhedron2D(Polyhedron2D p) {
        Mesh mesh = new Mesh();
        mesh.vertices = new ArrayList();
        int i = 0;
        while (i < p.vertices.size()) {
            Vertex2D v = p.vertices(i);
            mesh.vertices.add(v);
            ++i;
        }
        mesh.edges = new ArrayList();
        i = 0;
        while (i < p.edges.size()) {
            Edge2D edge = p.edges(i);
            mesh.edges.add(edge);
            ++i;
        }
        mesh.faces = new ArrayList();
        i = 0;
        while (i < p.faces.size()) {
            Face2D face = p.faces(i);
            mesh.faces.add(face);
            ++i;
        }
        return mesh;
    }

    public static ArrayList create_mesh(ArrayList stroke, double unit_length) {
        Mesh mesh = new Mesh(stroke, unit_length);
        ArrayList<double[]> verts = new ArrayList<double[]>();
        ArrayList<int[]> edges = new ArrayList<int[]>();
        ArrayList<int[]> faces = new ArrayList<int[]>();
        int i = 0;
        while (i < mesh.vertices.size()) {
            Vertex v = mesh.vertices(i);
            double[] _v = new double[]{v.x, v.y};
            verts.add(_v);
            ++i;
        }
        i = 0;
        while (i < mesh.edges.size()) {
            Edge edge = mesh.edges(i);
            int[] _edge = new int[]{edge.start.index, edge.end.index};
            edges.add(_edge);
            ++i;
        }
        i = 0;
        while (i < mesh.faces.size()) {
            Face face = mesh.faces(i);
            int[] _face = new int[]{face.get_vertex((int)0).index, face.get_vertex((int)2).index, face.get_vertex((int)1).index};
            faces.add(_face);
            ++i;
        }
        ArrayList<ArrayList<Object[]>> result = new ArrayList<ArrayList<Object[]>>();
        result.add(verts);
        result.add(edges);
        result.add(faces);
        return result;
    }

    public Mesh get_duplicated() {
        Face face;
        Edge edge;
        Vertex v;
        Mesh new_mesh = new Mesh();
        this.set_indices();
        int i = 0;
        while (i < this.vertices.size()) {
            v = this.vertices(i);
            new_mesh.vertices.add(v.get_duplicated());
            ++i;
        }
        i = 0;
        while (i < this.edges.size()) {
            edge = this.edges(i);
            new_mesh.edges.add(edge.get_duplicated());
            ++i;
        }
        i = 0;
        while (i < this.faces.size()) {
            face = this.faces(i);
            new_mesh.faces.add(face.get_duplicated());
            ++i;
        }
        i = 0;
        while (i < this.vertices.size()) {
            v = this.vertices(i);
            Vertex new_v = new_mesh.vertices(i);
            new_v.edges = new ArrayList();
            int j = 0;
            while (j < v.edges.size()) {
                Edge edge2 = (Edge)v.edges.get(j);
                new_v.edges.add(new_mesh.edges.get(edge2.index));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.edges.size()) {
            edge = this.edges(i);
            Edge new_edge = new_mesh.edges(i);
            new_edge.start = new_mesh.vertices(edge.start.index);
            new_edge.end = new_mesh.vertices(edge.end.index);
            if (edge.left_face != null) {
                new_edge.left_face = new_mesh.faces(edge.left_face.index);
            }
            if (edge.right_face != null) {
                new_edge.right_face = new_mesh.faces(edge.right_face.index);
            }
            ++i;
        }
        i = 0;
        while (i < this.faces.size()) {
            face = this.faces(i);
            Face new_face = new_mesh.faces(i);
            new_face.edges[0] = new_mesh.edges(face.edges[0].index);
            new_face.edges[1] = new_mesh.edges(face.edges[1].index);
            new_face.edges[2] = new_mesh.edges(face.edges[2].index);
            ++i;
        }
        return new_mesh;
    }

    public void construct_mesh(ArrayList stroke) {
        this.original_stroke = stroke;
        ArrayList[] result = Delaunay.triangulate(stroke);
        ArrayList _edges = result[0];
        ArrayList _faces = result[1];
        int i = 0;
        while (i < stroke.size()) {
            Vertex2D v = (Vertex2D)stroke.get(i);
            Vertex vertex = new Vertex(v.x, v.y);
            vertex.fixed = true;
            this.vertices.add(vertex);
            ++i;
        }
        i = 0;
        while (i < _edges.size()) {
            int[] _edge = (int[])_edges.get(i);
            this.edges.add(new Edge((Vertex)((Object)this.vertices.get(_edge[0])), (Vertex)((Object)this.vertices.get(_edge[1]))));
            ++i;
        }
        i = 0;
        while (i < _faces.size()) {
            int[] _face = (int[])_faces.get(i);
            this.faces.add(new Face((Edge)this.edges.get(_face[0]), (Edge)this.edges.get(_face[1]), (Edge)this.edges.get(_face[2])));
            ++i;
        }
        Skin.refine(this);
    }

    public void construct_mesh(ArrayList stroke, ArrayList triangles) {
        this.original_stroke = stroke;
        int i = 0;
        while (i < stroke.size()) {
            Vertex2D v = (Vertex2D)stroke.get(i);
            Vertex vertex = new Vertex(v.x, v.y);
            vertex.fixed = true;
            this.vertices.add(vertex);
            ++i;
        }
        i = 0;
        while (i < triangles.size()) {
            int[] triangle = (int[])triangles.get(i);
            Vertex v0 = (Vertex)((Object)this.vertices.get(triangle[0]));
            Vertex v1 = (Vertex)((Object)this.vertices.get(triangle[1]));
            Vertex v2 = (Vertex)((Object)this.vertices.get(triangle[2]));
            this.faces.add(new Face(this.get_edge(v0, v1), this.get_edge(v1, v2), this.get_edge(v2, v0)));
            ++i;
        }
        Skin.grind(this);
    }

    Edge get_edge(Vertex v0, Vertex v1) {
        Edge edge = v0.get_common_edge(v1);
        if (edge == null) {
            edge = new Edge(v0, v1);
            this.edges.add(edge);
        }
        return edge;
    }

    public Vertex2D pick_vertex(Vertex2D p) {
        Vertex2D closest = null;
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < this.vertices.size()) {
            Vertex2D v = (Vertex2D)this.vertices.get(i);
            double d = Vertex2D.distance((Vertex2D)v, (Vertex2D)p);
            if (d < min) {
                min = d;
                closest = v;
            }
            ++i;
        }
        return closest;
    }

    public Vertex vertices(int i) {
        return (Vertex)((Object)this.vertices.get(i));
    }

    public Edge edges(int i) {
        return (Edge)this.edges.get(i);
    }

    public Face faces(int i) {
        return (Face)this.faces.get(i);
    }

    public void add(Vertex vertex) {
        this.vertices.add(vertex);
        vertex.index = this.vertices.size();
    }

    public void add(Edge edge) {
        this.edges.add(edge);
        edge.index = this.edges.size();
    }

    public void add(Face face) {
        this.faces.add(face);
        face.index = this.faces.size();
    }

    public void remove(Vertex vertex) {
        this.vertices.remove((Object)vertex);
    }

    public void remove(Edge edge) {
        this.edges.remove(edge);
        edge.disposed = true;
        edge.start.remove_edge(edge);
        if (edge.start.edges.size() == 0) {
            this.remove(edge.start);
        }
        edge.end.remove_edge(edge);
        if (edge.end.edges.size() == 0) {
            this.remove(edge.end);
        }
    }

    public void remove(Face face) {
        this.faces.remove(face);
        face.disposed = true;
        int i = 0;
        while (i < face.edges.length) {
            Edge edge = face.edges[i];
            edge.remove_face(face);
            if (edge.left_face == null && edge.right_face == null) {
                this.remove(edge);
            }
            ++i;
        }
    }

    public void set_parameters() {
        this.set_indices();
    }

    public void set_indices() {
        int i = 0;
        while (i < this.vertices.size()) {
            ((Vertex2D)this.vertices.get((int)i)).index = i;
            ++i;
        }
        i = 0;
        while (i < this.edges.size()) {
            ((Edge2D)this.edges.get((int)i)).index = i;
            ++i;
        }
        i = 0;
        while (i < this.faces.size()) {
            ((Face2D)this.faces.get((int)i)).index = i;
            ++i;
        }
    }

    public void check_edges() {
        int i = 0;
        while (i < this.edges.size()) {
            Edge edge = (Edge)this.edges.get(i);
            if (edge.left_face == null || edge.right_face == null) {
                System.out.println("edge does not have two polygons");
            }
            ++i;
        }
    }

    public void insert_vertex(Vertex2D v) {
        int i = 0;
        while (i < this.faces.size()) {
            Face face = (Face)this.faces.get(i);
            if (face.contains(v)) {
                this.insert_vertex(face);
                return;
            }
            ++i;
        }
    }

    public void insert_vertex(Face face) {
        Vertex center = new Vertex(face.get_center());
        this.vertices.add(center);
        Edge edge0 = face.edges[0];
        Edge edge1 = face.edges[1];
        Edge edge2 = face.edges[2];
        Vertex v01 = edge0.get_common_vertex(edge1);
        Vertex v12 = edge1.get_common_vertex(edge2);
        Vertex v20 = edge2.get_common_vertex(edge0);
        Edge edge01 = new Edge(center, v01);
        Edge edge12 = new Edge(center, v12);
        Edge edge20 = new Edge(center, v20);
        this.edges.add(edge01);
        this.edges.add(edge12);
        this.edges.add(edge20);
        Face face0 = new Face(edge20, edge0, edge01);
        Face face1 = new Face(edge01, edge1, edge12);
        Face face2 = new Face(edge12, edge2, edge20);
        this.faces.remove(face);
        this.faces.add(face0);
        this.faces.add(face1);
        this.faces.add(face2);
        this.set_parameters();
    }

    public void swap_edge(Vertex2D v) {
        double min = Double.MAX_VALUE;
        Edge closest = null;
        int i = 0;
        while (i < this.edges.size()) {
            Edge edge = (Edge)this.edges.get(i);
            double d = new Edge2D((Vertex2D)edge.start, (Vertex2D)edge.end).distance(v);
            if (d < min) {
                min = d;
                closest = edge;
            }
            ++i;
        }
        this.swap_edge(closest);
    }

    public void swap_or_split(Vertex2D v) {
        double d;
        double min = Double.MAX_VALUE;
        Object closest = null;
        int i = 0;
        while (i < this.edges.size()) {
            Edge edge = (Edge)this.edges.get(i);
            d = new Edge2D((Vertex2D)edge.start, (Vertex2D)edge.end).distance(v);
            if (d < min) {
                min = d;
                closest = edge;
            }
            ++i;
        }
        i = 0;
        while (i < this.faces.size()) {
            Face face = (Face)this.faces.get(i);
            d = Vertex.distance((Vertex2D)face.get_center(), (Vertex2D)v);
            if (d < min) {
                min = d;
                closest = face;
            }
            ++i;
        }
        if (closest instanceof Edge) {
            this.swap_edge((Edge)closest);
        } else {
            this.insert_vertex((Face)closest);
        }
    }

    public void swap_edge(Edge edge) {
        this.faces.remove(edge.left_face);
        this.faces.remove(edge.right_face);
        this.edges.remove(edge);
        Vertex left_v = edge.left_face.get_opposite_vertex(edge);
        Vertex right_v = edge.right_face.get_opposite_vertex(edge);
        Edge new_edge = new Edge(left_v, right_v);
        this.edges.add(new_edge);
        Face start_face = new Face(new_edge, left_v.get_common_edge(edge.start), right_v.get_common_edge(edge.start));
        Face end_face = new Face(new_edge, right_v.get_common_edge(edge.end), left_v.get_common_edge(edge.end));
        this.faces.add(start_face);
        this.faces.add(end_face);
        this.set_parameters();
    }

    public void set_weight(Vertex2D v) {
        int i = 0;
        while (i < this.faces.size()) {
            Face face = (Face)this.faces.get(i);
            if (face.contains(v)) {
                face.weight = 10000.0;
                System.out.println("set weight " + face.index);
            }
            ++i;
        }
    }
}

