/*
 * Decompiled with CFR 0.152.
 */
package rigid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import rigid.Face;
import teddy.Rectangle2D;
import teddy.Util;

public class FaceBuckets
implements Serializable {
    double x0;
    double y0;
    double x1;
    double y1;
    double dx;
    double dy;
    int n = 100;
    ArrayList[][] buckets = new ArrayList[this.n][this.n];

    public ArrayList get_faces_in_buckets(Rectangle2D bbox) {
        int u0 = (int)((bbox.x - this.x0) / this.dx);
        int v0 = (int)((bbox.y - this.y0) / this.dy);
        int u1 = (int)((bbox.x + bbox.width - this.x0) / this.dx);
        int v1 = (int)((bbox.y + bbox.height - this.y0) / this.dy);
        u0 = Math.max(0, u0);
        v0 = Math.max(0, v0);
        u1 = Math.min(this.n - 1, u1);
        v1 = Math.min(this.n - 1, v1);
        ArrayList vector = new ArrayList();
        int u = u0;
        while (u <= u1) {
            int v = v0;
            while (v <= v1) {
                if (this.buckets[u][v] != null) {
                    Util.appendVectorWithoutDuplication(vector, (List)this.buckets[u][v]);
                }
                ++v;
            }
            ++u;
        }
        return vector;
    }

    public void add_face_in_buckets(Face face) {
        Rectangle2D bbox = face.get_bbox();
        int u0 = (int)((bbox.x - this.x0) / this.dx);
        int v0 = (int)((bbox.y - this.y0) / this.dy);
        int u1 = (int)((bbox.x + bbox.width - this.x0) / this.dx);
        int v1 = (int)((bbox.y + bbox.height - this.y0) / this.dy);
        u0 = Math.max(0, u0);
        v0 = Math.max(0, v0);
        u1 = Math.min(this.n - 1, u1);
        v1 = Math.min(this.n - 1, v1);
        int u = u0;
        while (u <= u1) {
            int v = v0;
            while (v <= v1) {
                if (this.buckets[u][v] == null) {
                    this.buckets[u][v] = new ArrayList();
                }
                this.buckets[u][v].add(face);
                ++v;
            }
            ++u;
        }
    }

    static FaceBuckets create_buckets(ArrayList faces) {
        return new FaceBuckets(faces);
    }

    private FaceBuckets(ArrayList faces) {
        this.compute_bbox(faces);
        int i = 0;
        while (i < faces.size()) {
            this.add_face_in_buckets((Face)faces.get(i));
            ++i;
        }
    }

    public void compute_bbox(ArrayList faces) {
        this.x0 = Double.MAX_VALUE;
        this.y0 = Double.MAX_VALUE;
        this.x1 = Double.MIN_VALUE;
        this.x1 = Double.MIN_VALUE;
        int i = 0;
        while (i < faces.size()) {
            Rectangle2D bbox = ((Face)faces.get(i)).get_bbox();
            this.x0 = Math.min(this.x0, bbox.x);
            this.y0 = Math.min(this.y0, bbox.y);
            this.x1 = Math.max(this.x1, bbox.x + bbox.width);
            this.y1 = Math.max(this.y1, bbox.y + bbox.height);
            ++i;
        }
        this.x1 += 1.0;
        this.y1 += 1.0;
        this.dx = (this.x1 - this.x0) / (double)this.n;
        this.dy = (this.y1 - this.y0) / (double)this.n;
    }
}

