/*
 * Decompiled with CFR 0.152.
 */
package rigid;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import rigid.Edge;
import rigid.Vertex;
import teddy.Rectangle2D;
import teddy.Util;
import teddy.Vector2;
import teddy.Vertex2D;

public class Face {
    public int index;
    public Edge[] edges;
    boolean disposed;
    boolean is_front_facing;
    public double depth;
    public double weight = 1.0;
    Rectangle2D bbox;
    Point bucket_p0;
    Point bucket_p1;

    Face() {
    }

    Face(Edge edge0, Edge edge1, Edge edge2) {
        this.edges = new Edge[3];
        this.add_edge(0, edge0, edge1);
        this.add_edge(1, edge1, edge2);
        this.add_edge(2, edge2, edge0);
    }

    Face(List _edges) {
        this.edges = new Edge[_edges.size()];
        int i = 0;
        while (i < _edges.size()) {
            this.add_edge(i, (Edge)_edges.get(i), (Edge)_edges.get(Util.mod((int)(i + 1), (int)_edges.size())));
            ++i;
        }
    }

    public Face get_duplicated() {
        Face new_face = new Face();
        new_face.edges = (Edge[])this.edges.clone();
        new_face.index = this.index;
        new_face.disposed = this.disposed;
        new_face.is_front_facing = this.is_front_facing;
        new_face.depth = this.depth;
        new_face.weight = this.weight;
        return new_face;
    }

    public String toString() {
        return " {" + (Object)((Object)this.get_vertex(0)) + " " + (Object)((Object)this.get_vertex(1)) + " " + (Object)((Object)this.get_vertex(2)) + "}";
    }

    private void add_edge(int i, Edge e, Edge next_edge) {
        this.edges[i] = e;
        if (next_edge.contains(e.end)) {
            e.left_face = this;
        } else {
            e.right_face = this;
        }
    }

    public Vertex get_vertex(int i) {
        i = Util.mod((int)i, (int)this.edges.length);
        return this.edges(i - 1).get_common_vertex(this.edges(i));
    }

    public Edge edges(int i) {
        return this.edges[Util.mod((int)i, (int)this.edges.length)];
    }

    public Edge get_opposite_edge(Vertex v) {
        int i = 0;
        while (i < 3) {
            if (!this.edges[i].contains(v)) {
                return this.edges[i];
            }
            ++i;
        }
        return null;
    }

    public Vertex get_opposite_vertex(Edge edge) {
        int i = 0;
        while (i < 3) {
            Vertex v = this.get_vertex(i);
            if (!edge.contains(v)) {
                return v;
            }
            ++i;
        }
        return null;
    }

    public int get_edge_index(Edge e) {
        int i = 0;
        while (i < this.edges.length) {
            if (this.edges[i] == e) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int get_vertex_index(Vertex v) {
        List vertices = this.get_vertices();
        int i = 0;
        while (i < vertices.size()) {
            if (vertices.get(i) == v) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public List get_vertices() {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        int i = 0;
        while (i < 3) {
            vertices.add(this.edges(i - 1).get_common_vertex(this.edges(i)));
            ++i;
        }
        return vertices;
    }

    public Vertex2D get_center() {
        Vector2 center = new Vector2(0.0, 0.0);
        center.add((Vector2)this.get_vertex(0));
        center.add((Vector2)this.get_vertex(1));
        center.add((Vector2)this.get_vertex(2));
        return new Vertex2D(center.x / 3.0, center.y / 3.0);
    }

    public boolean is_front_facing() {
        Vertex v0 = this.get_vertex(0);
        Vertex v1 = this.get_vertex(1);
        Vertex v2 = this.get_vertex(2);
        return Face.on_the_left(v0, v1, v2);
    }

    public boolean contains(Vertex2D p) {
        Vertex v2;
        Vertex v1;
        Vertex v0 = this.get_vertex(0);
        if (Face.on_the_left(v0, v1 = this.get_vertex(1), v2 = this.get_vertex(2))) {
            return Face.on_the_left(v0, v1, p) && Face.on_the_left(v1, v2, p) && Face.on_the_left(v2, v0, p);
        }
        return Face.on_the_right(v0, v1, p) && Face.on_the_right(v1, v2, p) && Face.on_the_right(v2, v0, p);
    }

    public static boolean on_the_left(Vertex2D v0, Vertex2D v1, Vertex2D p) {
        Vector2 vec0 = new Vector2((Vector2)v0, (Vector2)v1);
        Vector2 vec1 = new Vector2((Vector2)v0, (Vector2)p);
        return Vector2.cross_product((Vector2)vec0, (Vector2)vec1) <= 0.0;
    }

    public static boolean on_the_right(Vertex2D v0, Vertex2D v1, Vertex2D p) {
        return !Face.on_the_left(v0, v1, p);
    }

    public static boolean intersects(Face face0, Face face1) {
        if (face0.is_front_facing() ? Face.all_on_the_right(face0, face1) : Face.all_on_the_left(face0, face1)) {
            return false;
        }
        return !(face1.is_front_facing() ? Face.all_on_the_right(face1, face0) : Face.all_on_the_left(face1, face0));
    }

    public static boolean all_on_the_right(Face face0, Face face1) {
        Vertex v0 = face0.get_vertex(0);
        Vertex v1 = face0.get_vertex(1);
        Vertex v2 = face0.get_vertex(2);
        return Face.all_on_the_right(v0, v1, face1) || Face.all_on_the_right(v1, v2, face1) || Face.all_on_the_right(v2, v0, face1);
    }

    public static boolean all_on_the_right(Vertex2D v0, Vertex2D v1, Face face) {
        return Face.on_the_right(v0, v1, face.get_vertex(0)) && Face.on_the_right(v0, v1, face.get_vertex(1)) && Face.on_the_right(v0, v1, face.get_vertex(2));
    }

    public static boolean all_on_the_left(Face face0, Face face1) {
        Vertex v0 = face0.get_vertex(0);
        Vertex v1 = face0.get_vertex(1);
        Vertex v2 = face0.get_vertex(2);
        return Face.all_on_the_left(v0, v1, face1) || Face.all_on_the_left(v1, v2, face1) || Face.all_on_the_left(v2, v0, face1);
    }

    public static boolean all_on_the_left(Vertex2D v0, Vertex2D v1, Face face) {
        return Face.on_the_left(v0, v1, face.get_vertex(0)) && Face.on_the_left(v0, v1, face.get_vertex(1)) && Face.on_the_left(v0, v1, face.get_vertex(2));
    }

    public boolean is_connected_to(Face face) {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                if (this.edges[i].is_connected_to(face.edges[j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void set_bbox() {
        double x0 = Double.MAX_VALUE;
        double y0 = Double.MAX_VALUE;
        double x1 = -1.7976931348623157E308;
        double y1 = -1.7976931348623157E308;
        int i = 0;
        while (i < 3) {
            Vertex v = this.get_vertex(i);
            if (x0 > v.x) {
                x0 = v.x;
            }
            if (y0 > v.y) {
                y0 = v.y;
            }
            if (x1 < v.x) {
                x1 = v.x;
            }
            if (y1 < v.y) {
                y1 = v.y;
            }
            ++i;
        }
        this.bbox = new Rectangle2D(x0, y0, x1 - x0, y1 - y0);
    }

    public Rectangle2D get_bbox() {
        if (this.bbox == null) {
            this.set_bbox();
        }
        return this.bbox;
    }
}

