/*
 * Decompiled with CFR 0.152.
 */
package rigid;

import rigid.Face;
import rigid.Vertex;
import teddy.Vector2;
import teddy.Vertex2D;

public class Edge {
    public int index;
    public Vertex start;
    public Vertex end;
    public Face left_face;
    public Face right_face;
    boolean disposed;
    double warped_length;

    Edge(Vertex start, Vertex end) {
        this.start = start;
        this.end = end;
        start.edges.add(this);
        end.edges.add(this);
    }

    public Edge get_duplicated() {
        Edge new_edge = new Edge(this.start, this.end);
        new_edge.index = this.index;
        new_edge.left_face = this.left_face;
        new_edge.right_face = this.right_face;
        new_edge.disposed = this.disposed;
        new_edge.warped_length = this.warped_length;
        return new_edge;
    }

    public double length() {
        return Vertex.distance((Vertex2D)this.start, (Vertex2D)this.end);
    }

    public Vertex mid_vertex() {
        return new Vertex(Vertex2D.mid_vertex((Vertex2D)this.start, (Vertex2D)this.end));
    }

    public boolean contains(Vertex v) {
        return v == this.start || v == this.end;
    }

    public Face get_opposite_face(Face face) {
        if (face == this.left_face) {
            return this.right_face;
        }
        if (face == this.right_face) {
            return this.left_face;
        }
        return null;
    }

    public Face get_remaining_face() {
        if (this.left_face == null && this.right_face != null) {
            return this.right_face;
        }
        if (this.left_face != null && this.right_face == null) {
            return this.left_face;
        }
        System.out.println("Error in Edge.get_remaining_face()");
        return null;
    }

    public Vertex get_common_vertex(Edge edge) {
        if (this.start == edge.start || this.start == edge.end) {
            return this.start;
        }
        if (this.end == edge.start || this.end == edge.end) {
            return this.end;
        }
        return null;
    }

    public Vertex get_opposite_vertex(Vertex v) {
        if (this.start == v) {
            return this.end;
        }
        if (this.end == v) {
            return this.start;
        }
        return null;
    }

    public void remove_face(Face p) {
        if (this.left_face == p) {
            this.left_face = null;
        } else if (this.right_face == p) {
            this.right_face = null;
        }
    }

    public Face get_common_face(Edge edge) {
        if (this.left_face != null && (this.left_face == edge.left_face || this.left_face == edge.right_face)) {
            return this.left_face;
        }
        if (this.right_face != null && (this.right_face == edge.left_face || this.right_face == edge.right_face)) {
            return this.right_face;
        }
        return null;
    }

    public boolean on_boundary() {
        return this.left_face == null || this.right_face == null;
    }

    public boolean is_connected_to(Edge edge) {
        return this.start == edge.start || this.start == edge.end || this.end == edge.start || this.end == edge.end;
    }

    public static boolean intersects(Edge edge0, Edge edge1) {
        return edge0.check_side(edge1.start) * edge0.check_side(edge1.end) <= 0.0 && edge1.check_side(edge0.start) * edge1.check_side(edge0.end) <= 0.0;
    }

    double check_side(Vertex p) {
        Vector2 vec0 = new Vector2((Vector2)this.start, (Vector2)this.end);
        Vector2 vec1 = new Vector2((Vector2)this.start, (Vector2)p);
        return Vector2.cross_product((Vector2)vec0, (Vector2)vec1);
    }
}

