/*
 * Decompiled with CFR 0.152.
 */
package rigid;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import rigid.Edge;
import rigid.Face;
import rigid.MergeFindSet;
import rigid.Mesh;
import rigid.Vertex;

public class DepthAdjust {
    public static boolean ENABLED = true;
    public static double AREA_BASE_DEPTH = 0.0;
    public static double STROKE_BASE_DEPTH = 0.02;
    Mesh mesh;
    Vector silhouette_edges;
    public Face back_facing_face;

    public DepthAdjust(Mesh mesh) {
        this.mesh = mesh;
        Edge base_edge = null;
        int i = 0;
        while (i < mesh.edges.size()) {
            Edge edge = (Edge)mesh.edges.get(i);
            if (edge.left_face == null || edge.right_face == null) {
                base_edge = edge;
                break;
            }
            ++i;
        }
        this.silhouette_edges = new Vector();
        Edge edge = base_edge;
        Vertex vertex = edge.right_face == null ? edge.end : edge.start;
        do {
            this.silhouette_edges.add(edge);
            edge = this.find_next_edge(vertex, edge);
            vertex = edge.get_opposite_vertex(vertex);
        } while (edge != base_edge);
    }

    Edge find_next_edge(Vertex v, Edge prev_edge) {
        int i = 0;
        while (i < v.edges.size()) {
            Edge edge = (Edge)v.edges.get(i);
            if (edge != prev_edge && (edge.left_face == null || edge.right_face == null)) {
                return edge;
            }
            ++i;
        }
        return null;
    }

    public void detect_overlapping_regions() {
        boolean found_zero;
        if (!ENABLED) {
            int i = 0;
            while (i < this.mesh.vertices.size()) {
                Vertex v = (Vertex)((Object)this.mesh.vertices.get(i));
                v.depth = 0.0;
                ++i;
            }
            return;
        }
        int count = 0;
        this.back_facing_face = null;
        int i = 0;
        while (i < this.mesh.faces.size()) {
            Face face = (Face)this.mesh.faces.get(i);
            face.index = i;
            face.depth = 0.0;
            face.is_front_facing = face.is_front_facing();
            if (!face.is_front_facing) {
                ++count;
                this.back_facing_face = face;
            }
            ++i;
        }
        Vector<Edge[]> intersections = new Vector<Edge[]>();
        int i2 = 0;
        while (i2 < this.silhouette_edges.size() - 2) {
            Edge edge = (Edge)this.silhouette_edges.get(i2);
            int j = i2 + 2;
            while (j < this.silhouette_edges.size()) {
                Edge edge2;
                if ((i2 != 0 || j != this.silhouette_edges.size() - 1) && Edge.intersects(edge, edge2 = (Edge)this.silhouette_edges.get(j))) {
                    Edge[] pair = new Edge[]{edge, edge2};
                    intersections.add(pair);
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.mesh.vertices.size()) {
            Vertex v = (Vertex)((Object)this.mesh.vertices.get(i2));
            v.depth = 0.0;
            ++i2;
        }
        if (intersections.size() == 0) {
            return;
        }
        Vector region_pairs = new Vector();
        int i3 = 0;
        while (i3 < intersections.size()) {
            Edge[] pair = (Edge[])intersections.get(i3);
            Edge edge0 = pair[0];
            Edge edge1 = pair[1];
            Face face0 = edge0.left_face != null ? edge0.left_face : edge0.right_face;
            Face face1 = edge1.left_face != null ? edge1.left_face : edge1.right_face;
            this.propagate(region_pairs, face0, face1);
            ++i3;
        }
        if (region_pairs.size() == 0) {
            return;
        }
        MergeFindSet.init();
        i3 = 0;
        while (i3 < region_pairs.size()) {
            Region[] region_pair = (Region[])region_pairs.get(i3);
            MergeFindSet.add_set(region_pair[0].faces);
            MergeFindSet.add_set(region_pair[1].faces);
            ++i3;
        }
        int[] ds = new int[]{-1, 1, -2, 2, -3, 3, -4, 4, -5, 5, -6};
        MergeFindSet.re_order_sets_according_to_prev_sets();
        int i4 = 0;
        while (i4 < MergeFindSet.sets.size()) {
            MergeFindSet set = (MergeFindSet)MergeFindSet.sets.get(i4);
            int j = 0;
            while (j < set.size()) {
                Face face = (Face)set.get(j);
                int d = i4 < ds.length ? ds[i4] : -6;
                face.depth = 0.1 * (double)d;
                int k = 0;
                while (k < 3) {
                    face.get_vertex((int)k).depth = face.depth;
                    ++k;
                }
                ++j;
            }
            ++i4;
        }
        double[] depths = new double[this.mesh.vertices.size()];
        int i5 = 0;
        while (i5 < this.mesh.vertices.size()) {
            depths[i5] = ((Vertex)((Object)this.mesh.vertices.get((int)i5))).depth;
            ++i5;
        }
        do {
            double[] new_depths = (double[])depths.clone();
            found_zero = false;
            int i6 = 0;
            while (i6 < this.mesh.vertices.size()) {
                Vertex v = (Vertex)((Object)this.mesh.vertices.get(i6));
                if (depths[v.index] == 0.0) {
                    found_zero = true;
                } else {
                    List vs = v.get_surrounding_vertices();
                    int j = 0;
                    while (j < vs.size()) {
                        Vertex u = (Vertex)((Object)vs.get(j));
                        if (depths[u.index] == 0.0) {
                            new_depths[u.index] = depths[v.index];
                        }
                        ++j;
                    }
                }
                ++i6;
            }
            depths = new_depths;
        } while (found_zero);
        i = 0;
        while (i < this.mesh.vertices.size()) {
            ((Vertex)((Object)this.mesh.vertices.get((int)i))).depth = depths[i];
            ++i;
        }
    }

    public void propagate(Vector region_pairs, Face face0, Face face1) {
        int count1;
        int count0;
        Face neighbor;
        int i = 0;
        while (i < region_pairs.size()) {
            Region[] region_pair = (Region[])region_pairs.get(i);
            if (region_pair[0].contains(face0) && region_pair[1].contains(face1)) {
                return;
            }
            if (region_pair[0].contains(face1) && region_pair[1].contains(face0)) {
                return;
            }
            ++i;
        }
        Region region0 = new Region();
        Region region1 = new Region();
        Neighbors neighbors0 = new Neighbors(100);
        Neighbors neighbors1 = new Neighbors(100);
        region0.add(face0);
        region1.add(face1);
        int i2 = 0;
        while (i2 < face0.edges.length) {
            neighbor = face0.edges(i2).get_opposite_face(face0);
            if (neighbor != null && face0.is_front_facing == neighbor.is_front_facing) {
                neighbors0.add(new Neighbor(neighbor, face1));
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < face1.edges.length) {
            neighbor = face1.edges(i2).get_opposite_face(face1);
            if (neighbor != null && face1.is_front_facing == neighbor.is_front_facing) {
                neighbors1.add(new Neighbor(neighbor, face0));
            }
            ++i2;
        }
        do {
            count0 = region0.size();
            count1 = region1.size();
            neighbors1 = this.propagate_sub(region0, region1, neighbors1);
            neighbors0 = this.propagate_sub(region1, region0, neighbors0);
        } while (count0 != region0.size() || count1 != region1.size());
        Region[] region_pair = new Region[]{region0, region1};
        region_pairs.add(region_pair);
    }

    public Neighbors propagate_sub(Region base_region, Region region, Neighbors neighbors) {
        boolean[] deleted_neighbor = new boolean[this.mesh.faces.size()];
        int i = 0;
        while (i < neighbors.size()) {
            Neighbor neighbor = (Neighbor)neighbors.get(i);
            if (region.contains(neighbor.face) || base_region.contains(neighbor.face)) {
                deleted_neighbor[i] = true;
            } else {
                Face base_face = this.intersects(neighbor, base_region);
                if (base_face != null) {
                    Face face = neighbor.face;
                    region.add(face);
                    deleted_neighbor[i] = true;
                    int j = 0;
                    while (j < face.edges.length) {
                        Face next_face = face.edges(j).get_opposite_face(face);
                        if (!(next_face == null || face.is_front_facing != next_face.is_front_facing || region.contains(next_face) || base_region.contains(next_face) || neighbors.contains(next_face))) {
                            Neighbor next_neighbor = new Neighbor(next_face, base_face);
                            neighbors.add(next_neighbor);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        Neighbors revised_neighbors = new Neighbors(neighbors.size() * 2);
        int i2 = 0;
        while (i2 < neighbors.size()) {
            if (!deleted_neighbor[i2]) {
                revised_neighbors.add(neighbors.get(i2));
            }
            ++i2;
        }
        return revised_neighbors;
    }

    public Face intersects(Neighbor neighbor, Region region) {
        Face face = neighbor.face;
        int i = 0;
        while (i < region.size()) {
            Face region_face = (Face)region.get(i);
            if (!face.is_connected_to(region_face) && Face.intersects(face, region_face)) {
                return region_face;
            }
            ++i;
        }
        return null;
    }

    class Region {
        Vector faces;
        boolean[] contains;
        int id;

        Region() {
            this.contains = new boolean[DepthAdjust.this.mesh.faces.size()];
            this.id = (int)(1000.0 * Math.random());
            this.faces = new Vector();
        }

        void add(Face face) {
            this.faces.add(face);
            this.contains[face.index] = true;
        }

        boolean contains(Face face) {
            return this.contains[face.index];
        }

        int size() {
            return this.faces.size();
        }

        Object get(int i) {
            return this.faces.get(i);
        }

        public String toString() {
            return "" + this.id;
        }

        public void print() {
            int i = 0;
            while (i < this.faces.size()) {
                System.out.print(" " + ((Face)this.faces.get((int)i)).index);
                ++i;
            }
            System.out.println();
        }
    }

    class Neighbor {
        Face face;
        Face base_face;

        Neighbor(Face _face, Face _base_face) {
            this.face = _face;
            this.base_face = _base_face;
        }
    }

    class Neighbors
    extends ArrayList {
        void add(Face face) {
            super.add(face);
        }

        boolean contains(Face face) {
            return super.contains(face);
        }

        Neighbors(int n) {
            super(n);
        }
    }
}

