/*
 * Decompiled with CFR 0.152.
 */
package rigid;

public class ConjugateGradient {
    public static double[] solve_least_square(double[][] A, double[] b, double[] x) {
        b = ConjugateGradient.multiply(ConjugateGradient.transpose(A), b);
        A = ConjugateGradient.multiply(ConjugateGradient.transpose(A), A);
        return ConjugateGradient.solve(A, b, x);
    }

    public static double[] solve(double[][] A, double[] b, double[] x) {
        double delta_new;
        double[] r;
        double[] d = r = ConjugateGradient.subtract(b, ConjugateGradient.multiply(A, x));
        double delta_0 = delta_new = ConjugateGradient.dot_product(r, r);
        int i = 0;
        while (i < 10) {
            if (delta_new < 1.0E-5) break;
            double[] q = ConjugateGradient.multiply(A, d);
            double alpha = delta_new / ConjugateGradient.dot_product(d, q);
            x = ConjugateGradient.add(x, ConjugateGradient.multiply(d, alpha));
            r = ConjugateGradient.subtract(b, ConjugateGradient.multiply(A, x));
            double delta_old = delta_new;
            delta_new = ConjugateGradient.dot_product(r, r);
            double beta = delta_new / delta_old;
            d = ConjugateGradient.add(r, ConjugateGradient.multiply(d, beta));
            ++i;
        }
        return x;
    }

    public static double[] multiply(double[][] a, double[] b) {
        double[] c = new double[a.length];
        int i = 0;
        while (i < a.length) {
            c[i] = ConjugateGradient.dot_product(a[i], b);
            ++i;
        }
        return c;
    }

    public static double[] add(double[] a, double[] b) {
        double[] c = new double[a.length];
        int i = 0;
        while (i < a.length) {
            c[i] = a[i] + b[i];
            ++i;
        }
        return c;
    }

    public static double[] subtract(double[] a, double[] b) {
        double[] c = new double[a.length];
        int i = 0;
        while (i < a.length) {
            c[i] = a[i] - b[i];
            ++i;
        }
        return c;
    }

    public static double[] multiply(double[] a, double b) {
        double[] c = new double[a.length];
        int i = 0;
        while (i < a.length) {
            c[i] = a[i] * b;
            ++i;
        }
        return c;
    }

    public static double dot_product(double[] a, double[] b) {
        double c = 0.0;
        int i = 0;
        while (i < a.length) {
            c += a[i] * b[i];
            ++i;
        }
        return c;
    }

    public static double[][] transpose(double[][] A) {
        int m = A.length;
        int n = A[0].length;
        double[][] B = new double[n][m];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                B[j][i] = A[i][j];
                ++j;
            }
            ++i;
        }
        return B;
    }

    public static double[][] multiply(double[][] A, double[][] B) {
        B = ConjugateGradient.transpose(B);
        double[][] C = new double[A.length][B.length];
        int i = 0;
        while (i < A.length) {
            int j = 0;
            while (j < B.length) {
                C[i][j] = ConjugateGradient.dot_product(A[i], B[j]);
                ++j;
            }
            ++i;
        }
        return C;
    }
}

