/*
 * Decompiled with CFR 0.152.
 */
package rigid;

import VisualNumerics.math.DoubleMatrix;
import VisualNumerics.math.DoubleSVD;
import VisualNumerics.math.DoubleVector;
import java.util.ArrayList;
import java.util.List;
import rigid.Face;
import rigid.Mesh;
import rigid.RigidTransform;
import rigid.SparseMatrix;
import rigid.Vertex;
import teddy.Face2D;
import teddy.Util;
import teddy.Vector2;
import teddy.Vertex2D;
import umfpack.Umfpack;

public class AdjustScale {
    Mesh mesh;
    double[][] inverse_mx;
    List input_vertices;
    List output_vertices;
    boolean ACCELERATION = false;
    double[][] invG_C;
    double[][] invG;
    transient Umfpack umfpack = null;
    int matrix_id;
    double[] bx;
    double[] by;
    double[][] Mx;
    double[] Bx;
    double[] By;
    double[][][] M_inverse;
    double[][][] A02s;
    double[][][] A12s;
    double[] original_length01;
    public List fitted_triangles;
    Vertex[][] original_v;
    Vector2[] original_vec01s;
    Vector2[] original_vec02s;
    double[][][] inverseds;
    double[][][] angle1;
    double[][][] angle2;
    Vector2[][] coords;

    public AdjustScale(Mesh mesh) {
        this.mesh = mesh;
        this.prepare_rotate_and_fit_triangle_new();
        this.compute_base_matrix();
    }

    public AdjustScale get_duplicated(Mesh new_mesh) {
        AdjustScale new_as = new AdjustScale(new_mesh);
        new_as.Mx = (double[][])this.Mx.clone();
        return new_as;
    }

    public void compile(List _input_vertices) {
        this.input_vertices = _input_vertices;
        this.output_vertices = Util.subtract((List)this.mesh.vertices, (List)this.input_vertices);
        int n_input = this.input_vertices.size();
        int n_output = this.output_vertices.size();
        SparseMatrix matrix = new SparseMatrix(n_output);
        int i = 0;
        while (i < n_output) {
            Vertex2D u = (Vertex2D)this.output_vertices.get(i);
            int j = 0;
            while (j < n_output) {
                Vertex2D v = (Vertex2D)this.output_vertices.get(j);
                matrix.add(i, j, this.Mx[u.index][v.index]);
                ++j;
            }
            ++i;
        }
        Object[] A = matrix.get_umfpack_matrix();
        int[] Ap = (int[])A[0];
        int[] Ai = (int[])A[1];
        double[] Ax = (double[])A[2];
        this.umfpack_factorize(n_output, Ap, Ai, Ax);
        if (!this.ACCELERATION) {
            return;
        }
        double[][] C = new double[this.output_vertices.size()][this.input_vertices.size()];
        int i2 = 0;
        while (i2 < n_output) {
            Vertex2D u = (Vertex2D)this.output_vertices.get(i2);
            int j = 0;
            while (j < n_input) {
                Vertex2D v = (Vertex2D)this.input_vertices.get(j);
                double[] dArray = C[i2];
                int n = j++;
                dArray[n] = dArray[n] - this.Mx[u.index][v.index];
            }
            ++i2;
        }
        double[][] invG_C_transpose = new double[this.input_vertices.size()][this.output_vertices.size()];
        double[] q = new double[this.input_vertices.size()];
        int i3 = 0;
        while (i3 < this.input_vertices.size()) {
            q[i3] = 1.0;
            double[] B = this.multiply(C, q);
            invG_C_transpose[i3] = this.umfpack_solve(B);
            q[i3] = 0.0;
            ++i3;
        }
        this.invG_C = this.transpose(invG_C_transpose);
        double[][] invG_transpose = new double[this.output_vertices.size()][this.output_vertices.size()];
        q = new double[this.output_vertices.size()];
        int i4 = 0;
        while (i4 < this.output_vertices.size()) {
            q[i4] = 1.0;
            invG_transpose[i4] = this.umfpack_solve(q);
            q[i4] = 0.0;
            ++i4;
        }
        this.invG = this.transpose(invG_transpose);
    }

    void umfpack_factorize(double[][] A) {
        if (this.umfpack == null) {
            this.umfpack = new Umfpack();
        } else {
            this.umfpack.release();
        }
        this.umfpack.factorize(A);
    }

    void umfpack_factorize(int n, int[] Ap, int[] Ai, double[] Ax) {
        if (this.umfpack == null) {
            this.umfpack = new Umfpack();
        } else {
            this.umfpack.release();
        }
        this.umfpack.factorize(n, Ap, Ai, Ax);
    }

    double[] umfpack_solve(double[] B) {
        double[] x = new double[B.length];
        this.umfpack.solve(B, x);
        return x;
    }

    public void update() {
        double[] vy;
        double[] vx;
        Vertex2D v;
        this.fitted_triangles = new ArrayList();
        this.compute_B();
        int n_input = this.input_vertices.size();
        int n_output = this.output_vertices.size();
        double[] bx = new double[n_output];
        double[] by = new double[n_output];
        if (!this.ACCELERATION) {
            int i = 0;
            while (i < n_output) {
                Vertex2D u = (Vertex2D)this.output_vertices.get(i);
                bx[i] = this.Bx[u.index];
                by[i] = this.By[u.index];
                int j = 0;
                while (j < n_input) {
                    v = (Vertex2D)this.input_vertices.get(j);
                    int n = i;
                    bx[n] = bx[n] + -this.Mx[u.index][v.index] * v.x;
                    int n2 = i;
                    by[n2] = by[n2] + -this.Mx[u.index][v.index] * v.y;
                    ++j;
                }
                ++i;
            }
            vx = this.umfpack_solve(bx);
            vy = this.umfpack_solve(by);
        } else {
            double[] qx = new double[n_input];
            double[] qy = new double[n_input];
            int i = 0;
            while (i < n_input) {
                v = (Vertex2D)this.input_vertices.get(i);
                qx[i] = v.x;
                qy[i] = v.y;
                ++i;
            }
            i = 0;
            while (i < n_output) {
                Vertex2D u = (Vertex2D)this.output_vertices.get(i);
                bx[i] = this.Bx[u.index];
                by[i] = this.By[u.index];
                ++i;
            }
            vx = this.add(this.multiply(this.invG_C, qx), this.multiply(this.invG, bx));
            vy = this.add(this.multiply(this.invG_C, qy), this.multiply(this.invG, by));
        }
        int i = 0;
        while (i < n_output) {
            Vertex2D v2 = (Vertex2D)this.output_vertices.get(i);
            v2.x = vx[i];
            v2.y = vy[i];
            ++i;
        }
    }

    void check(double[][] mx, double[][] my, double[] bx, double[] by, List output_vertices) {
        double[] vx = new double[output_vertices.size()];
        double[] vy = new double[output_vertices.size()];
        int i = 0;
        while (i < output_vertices.size()) {
            Vertex2D v = (Vertex2D)output_vertices.get(i);
            vx[i] = v.x;
            vy[i] = v.y;
            ++i;
        }
        double[] ux = DoubleMatrix.multiply((double[][])mx, (double[])vx);
        double[] uy = DoubleMatrix.multiply((double[][])my, (double[])vy);
        int i2 = 0;
        while (i2 < output_vertices.size()) {
            System.out.println(ux[i2] + " " + bx[i2] + "      " + uy[i2] + " " + by[i2]);
            ++i2;
        }
    }

    public void compute_base_matrix() {
        int n = this.mesh.vertices.size();
        this.Mx = new double[n][n];
        int i = 0;
        while (i < this.mesh.faces.size()) {
            Face2D face = (Face2D)this.mesh.faces.get(i);
            Vertex2D v0 = face.get_vertex(0);
            Vertex2D v1 = face.get_vertex(1);
            Vertex2D v2 = face.get_vertex(2);
            this.set_base_matrix_sub(v0, v1, v2, face.weight);
            this.set_base_matrix_sub(v1, v2, v0, face.weight);
            this.set_base_matrix_sub(v2, v0, v1, face.weight);
            ++i;
        }
    }

    void set_base_matrix_sub(Vertex2D v0, Vertex2D v1, Vertex2D v2, double weight) {
        double[] dArray = this.Mx[v0.index];
        int n = v0.index;
        dArray[n] = dArray[n] + weight;
        double[] dArray2 = this.Mx[v0.index];
        int n2 = v1.index;
        dArray2[n2] = dArray2[n2] + -weight;
        double[] dArray3 = this.Mx[v0.index];
        int n3 = v0.index;
        dArray3[n3] = dArray3[n3] + weight;
        double[] dArray4 = this.Mx[v0.index];
        int n4 = v2.index;
        dArray4[n4] = dArray4[n4] + -weight;
    }

    public void compute_B() {
        int n = this.mesh.vertices.size();
        this.Bx = new double[n];
        this.By = new double[n];
        int i = 0;
        while (i < this.mesh.faces.size()) {
            Face2D face = (Face2D)this.mesh.faces.get(i);
            Vector2[] d = this.rotate_and_fit_triangle_new(face);
            Vector2 d01 = d[0];
            Vector2 d12 = d[1];
            Vector2 d20 = d[2];
            Vertex2D v0 = face.get_vertex(0);
            Vertex2D v1 = face.get_vertex(1);
            Vertex2D v2 = face.get_vertex(2);
            this.set_b_sub(v0, v1, v2, d01, d12, d20, face.weight);
            this.set_b_sub(v1, v2, v0, d12, d20, d01, face.weight);
            this.set_b_sub(v2, v0, v1, d20, d01, d12, face.weight);
            ++i;
        }
    }

    void set_b_sub(Vertex2D v0, Vertex2D v1, Vertex2D v2, Vector2 d01, Vector2 d12, Vector2 d20, double weight) {
        int n = v0.index;
        this.Bx[n] = this.Bx[n] + (-d01.x + d20.x) * weight;
        int n2 = v0.index;
        this.By[n2] = this.By[n2] + (-d01.y + d20.y) * weight;
    }

    void prepare_rotate_and_fit_triangle_new() {
        this.M_inverse = new double[this.mesh.faces.size()][][];
        this.A02s = new double[this.mesh.faces.size()][][];
        this.A12s = new double[this.mesh.faces.size()][][];
        this.original_length01 = new double[this.mesh.faces.size()];
        int i = 0;
        while (i < this.mesh.faces.size()) {
            this.prepare_rotate_and_fit_triangle_new((Face2D)this.mesh.faces.get(i));
            ++i;
        }
    }

    void prepare_rotate_and_fit_triangle_new(Face2D face) {
        int i = face.index;
        Vertex2D v0 = face.get_vertex(0);
        Vertex2D v1 = face.get_vertex(1);
        Vertex2D v2 = face.get_vertex(2);
        double[][] A02 = new double[2][2];
        double[][] A12 = new double[2][2];
        RigidTransform.set_relative_coords(v0, v1, v2, A02, A12);
        A02 = DoubleMatrix.transpose((double[][])A02);
        A12 = DoubleMatrix.transpose((double[][])A12);
        double[][] M = new double[][]{{1.0 + A02[0][0] * A02[0][0] + A02[1][0] * A02[1][0], A02[0][0] * A02[0][1] + A02[1][0] * A02[1][1], A02[0][0] * A12[0][0] + A02[1][0] * A12[1][0], A02[0][0] * A12[0][1] + A02[1][0] * A12[1][1]}, {A02[0][1] * A02[0][0] + A02[1][1] * A02[1][0], 1.0 + A02[0][1] * A02[0][1] + A02[1][1] * A02[1][1], A02[0][1] * A12[0][0] + A02[1][1] * A12[1][0], A02[0][1] * A12[0][1] + A02[1][1] * A12[1][1]}, {A12[0][0] * A02[0][0] + A12[1][0] * A02[1][0], A12[0][0] * A02[0][1] + A12[1][0] * A02[1][1], 1.0 + A12[0][0] * A12[0][0] + A12[1][0] * A12[1][0], A12[0][0] * A12[0][1] + A12[1][0] * A12[1][1]}, {A12[0][1] * A02[0][0] + A12[1][1] * A02[1][0], A12[0][1] * A02[0][1] + A12[1][1] * A02[1][1], A12[0][1] * A12[0][0] + A12[1][1] * A12[1][0], 1.0 + A12[0][1] * A12[0][1] + A12[1][1] * A12[1][1]}};
        this.M_inverse[i] = this.inverse(M);
        this.A02s[i] = A02;
        this.A12s[i] = A12;
        this.original_length01[i] = new Vector2((Vector2)v0, (Vector2)v1).length();
    }

    Vector2[] rotate_and_fit_triangle_new(Face2D face) {
        int i = face.index;
        Vertex2D v0 = face.get_vertex(0);
        Vertex2D v1 = face.get_vertex(1);
        Vertex2D v2 = face.get_vertex(2);
        double[][] A02 = this.A02s[i];
        double[][] A12 = this.A12s[i];
        double[] b = new double[]{v0.x + A02[0][0] * v2.x + A02[1][0] * v2.y, v0.y + A02[0][1] * v2.x + A02[1][1] * v2.y, v1.x + A12[0][0] * v2.x + A12[1][0] * v2.y, v1.y + A12[0][1] * v2.x + A12[1][1] * v2.y};
        double[] x = DoubleMatrix.multiply((double[][])this.M_inverse[i], (double[])b);
        Vector2 u0 = new Vector2(x[0], x[1]);
        Vector2 u1 = new Vector2(x[2], x[3]);
        Vector2 u2 = new Vector2(A02[0][0] * u0.x + A02[0][1] * u0.y + A12[0][0] * u1.x + A12[0][1] * u1.y, A02[1][0] * u0.x + A02[1][1] * u0.y + A12[1][0] * u1.x + A12[1][1] * u1.y);
        Vector2 d01 = new Vector2(u0, u1);
        Vector2 d12 = new Vector2(u1, u2);
        Vector2 d20 = new Vector2(u2, u0);
        double ratio = this.original_length01[face.index] / d01.length();
        d01 = Vector2.multiply((Vector2)d01, (double)ratio);
        d12 = Vector2.multiply((Vector2)d12, (double)ratio);
        d20 = Vector2.multiply((Vector2)d20, (double)ratio);
        this.add_fitted_triangle(face, d01, d12, d20);
        Vector2[] result = new Vector2[]{d01, d12, d20};
        return result;
    }

    void add_fitted_triangle(Face2D face, Vector2 d01, Vector2 d12, Vector2 d20) {
        Vertex2D center = new Vertex2D((Vector2)face.get_center());
        Vector2 c = Vector2.multiply((Vector2)Vector2.add((Vector2)d01, (Vector2)Vector2.add((Vector2)d01, (Vector2)d12)), (double)0.3333333333333333);
        Vertex2D v0 = Vertex2D.translate((Vertex2D)center, (Vector2)Vector2.negate((Vector2)c));
        Vertex2D v1 = Vertex2D.translate((Vertex2D)v0, (Vector2)d01);
        Vertex2D v2 = Vertex2D.translate((Vertex2D)v1, (Vector2)d12);
        Vertex2D[] v = new Vertex2D[]{v0, v1, v2};
        this.fitted_triangles.add(v);
    }

    public void prepare_rotate_and_fit_triangle() {
        this.original_vec01s = new Vector2[this.mesh.faces.size()];
        this.original_vec02s = new Vector2[this.mesh.faces.size()];
        this.inverseds = new double[this.mesh.faces.size()][2][2];
        int i = 0;
        while (i < this.mesh.faces.size()) {
            this.prepare_rotate_and_fit_triangle((Face2D)this.mesh.faces.get(i));
            ++i;
        }
    }

    public void prepare_rotate_and_fit_triangle(Face2D face) {
        Vector2 original_vec01 = new Vector2((Vector2)face.get_vertex(0), (Vector2)face.get_vertex(1));
        Vector2 original_vec02 = new Vector2((Vector2)face.get_vertex(0), (Vector2)face.get_vertex(2));
        double[][] original_vec01_vec02 = new double[][]{{original_vec01.x, original_vec02.x}, {original_vec01.y, original_vec02.y}};
        this.original_vec01s[face.index] = original_vec01;
        this.original_vec02s[face.index] = original_vec02;
        this.inverseds[face.index] = this.inverse(original_vec01_vec02);
    }

    public Vector2[] rotate_and_fit_triangle(Face2D face) {
        Vector2 original_vec01 = this.original_vec01s[face.index];
        Vector2 original_vec02 = this.original_vec02s[face.index];
        double[][] inversed = this.inverseds[face.index];
        Vertex2D current_v0 = face.get_vertex(0);
        Vertex2D current_v1 = face.get_vertex(1);
        Vertex2D current_v2 = face.get_vertex(2);
        Vector2 current_vec01 = new Vector2((Vector2)current_v0, (Vector2)current_v1);
        Vector2 current_vec02 = new Vector2((Vector2)current_v0, (Vector2)current_v2);
        double[][] current_vec01_vec02 = new double[][]{{current_vec01.x, current_vec02.x}, {current_vec01.y, current_vec02.y}};
        double[][] A = DoubleMatrix.multiply((double[][])current_vec01_vec02, (double[][])inversed);
        DoubleSVD svd = new DoubleSVD(A);
        double[][] U = svd.U();
        double[][] V = svd.V();
        double[][] VT = DoubleMatrix.transpose((double[][])V);
        double[][] R = DoubleMatrix.multiply((double[][])U, (double[][])VT);
        Vector2 d01 = this.multiply(R, original_vec01);
        Vector2 d02 = this.multiply(R, original_vec02);
        Vector2 d12 = Vector2.add((Vector2)Vector2.multiply((Vector2)d01, (double)-1.0), (Vector2)d02);
        Vector2 d20 = Vector2.multiply((Vector2)d02, (double)-1.0);
        Vector2[] result = new Vector2[]{d01, d12, d20};
        return result;
    }

    double[][] inverse(double[][] A) {
        try {
            return DoubleMatrix.inverse((double[][])A);
        }
        catch (Exception e) {
            System.out.println("" + e);
            return null;
        }
    }

    void print_matrix(double[][] R) {
        System.out.println(R[0][0] + " " + R[0][1]);
        System.out.println(R[1][0] + " " + R[1][1]);
        System.out.println();
    }

    Vector2 multiply(double[][] R, Vector2 original_v) {
        return new Vector2(R[0][0] * original_v.x + R[0][1] * original_v.y, R[1][0] * original_v.x + R[1][1] * original_v.y);
    }

    Vector2[] rotate_and_fit_triangle_old(Face2D face) {
        int i = face.index;
        Vertex2D v0 = face.get_vertex(0);
        Vertex2D v1 = face.get_vertex(1);
        Vertex2D v2 = face.get_vertex(2);
        Vector2 center = Vector2.multiply((Vector2)Vector2.add((Vector2)v0, (Vector2)v1, (Vector2)v2), (double)0.3333333333333333);
        Vector2 vec0 = new Vector2(center, (Vector2)v0);
        Vector2 vec1 = new Vector2(center, (Vector2)v1);
        vec1 = this.multiply(this.angle1[i], vec1);
        Vector2 vec2 = new Vector2(center, (Vector2)v2);
        vec2 = this.multiply(this.angle2[i], vec2);
        Vector2 vec_x = Vector2.add((Vector2)vec0, (Vector2)vec1, (Vector2)vec2);
        vec_x = Vector2.normalize((Vector2)vec_x);
        Vector2 vec_y = Vector2.rotate90((Vector2)vec_x);
        Vector2 v0_target = Vector2.add((Vector2)center, (Vector2)Vector2.multiply((Vector2)vec_x, (double)this.coords[i][0].x), (Vector2)Vector2.multiply((Vector2)vec_y, (double)this.coords[i][0].y));
        Vector2 v1_target = Vector2.add((Vector2)center, (Vector2)Vector2.multiply((Vector2)vec_x, (double)this.coords[i][1].x), (Vector2)Vector2.multiply((Vector2)vec_y, (double)this.coords[i][1].y));
        Vector2 v2_target = Vector2.add((Vector2)center, (Vector2)Vector2.multiply((Vector2)vec_x, (double)this.coords[i][2].x), (Vector2)Vector2.multiply((Vector2)vec_y, (double)this.coords[i][2].y));
        Vector2 d01 = new Vector2(v0_target, v1_target);
        Vector2 d12 = new Vector2(v1_target, v2_target);
        Vector2 d20 = new Vector2(v2_target, v0_target);
        Vector2[] result = new Vector2[]{d01, d12, d20};
        return result;
    }

    public void prepare_rotate_and_fit_triangle_old() {
        this.angle1 = new double[this.mesh.faces.size()][2][2];
        this.angle2 = new double[this.mesh.faces.size()][2][2];
        this.coords = new Vector2[this.mesh.faces.size()][3];
        this.original_v = new Vertex[this.mesh.faces.size()][3];
        int i = 0;
        while (i < this.mesh.faces.size()) {
            Face face = (Face)this.mesh.faces.get(i);
            Vertex2D center = face.get_center();
            Vertex v0 = face.get_vertex(0);
            Vertex v1 = face.get_vertex(1);
            Vertex v2 = face.get_vertex(2);
            this.original_v[i][0] = new Vertex(v0);
            this.original_v[i][1] = new Vertex(v1);
            this.original_v[i][2] = new Vertex(v2);
            Vector2 vec0 = new Vector2((Vector2)center, (Vector2)v0);
            Vector2 vec1 = new Vector2((Vector2)center, (Vector2)v1);
            this.angle1[i] = this.get_rotation_matrix(vec1, vec0);
            Vector2 vec2 = new Vector2((Vector2)center, (Vector2)v2);
            this.angle2[i] = this.get_rotation_matrix(vec2, vec0);
            Vector2 vec_x = new Vector2(vec0);
            vec_x = Vector2.normalize((Vector2)vec_x);
            Vector2 vec_y = Vector2.rotate90((Vector2)vec_x);
            this.coords[i][0] = new Vector2(Vector2.dot_product((Vector2)vec_x, (Vector2)vec0), Vector2.dot_product((Vector2)vec_y, (Vector2)vec0));
            this.coords[i][1] = new Vector2(Vector2.dot_product((Vector2)vec_x, (Vector2)vec1), Vector2.dot_product((Vector2)vec_y, (Vector2)vec1));
            this.coords[i][2] = new Vector2(Vector2.dot_product((Vector2)vec_x, (Vector2)vec2), Vector2.dot_product((Vector2)vec_y, (Vector2)vec2));
            ++i;
        }
    }

    double[][] get_rotation_matrix(Vector2 base, Vector2 target) {
        double l = base.length() * target.length();
        double cos = Vector2.dot_product((Vector2)base, (Vector2)target) / l;
        double sin = Vector2.cross_product((Vector2)base, (Vector2)target) / l;
        double[][] R = new double[][]{{cos, -sin}, {sin, cos}};
        return R;
    }

    double[][] multiply(double[][] A, double[][] B) {
        return DoubleMatrix.multiply((double[][])A, (double[][])B);
    }

    double[][] transpose(double[][] A) {
        return DoubleMatrix.transpose((double[][])A);
    }

    double[] multiply(double[][] A, double[] B) {
        return DoubleMatrix.multiply((double[][])A, (double[])B);
    }

    double[] add(double[] a, double[] b) {
        return DoubleVector.add((double[])a, (double[])b);
    }
}

