/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.math;

import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector4d;

public class Vector4
extends Vector4d {
    public Vector4() {
    }

    public Vector4(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4(double[] v) {
        this(v[0], v[1], v[2], v[3]);
    }

    public Vector4(Tuple3d v, double w) {
        this(v.x, v.y, v.z, w);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Vector4) {
            Vector4 v = (Vector4)((Object)o);
            return this.x == v.x && this.y == v.y && this.z == v.z && this.w == v.w;
        }
        return false;
    }

    public double[] getArray() {
        double[] a = new double[]{this.x, this.y, this.z, this.w};
        return a;
    }

    public void setArray(double[] a) {
        this.x = a[0];
        this.y = a[1];
        this.z = a[2];
        this.w = a[3];
    }

    public void set(Vector4 other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
        this.w = other.w;
    }

    public boolean equals(Vector4 v) {
        return this.x == v.x && this.y == v.y && this.z == v.z && this.w == v.w;
    }

    public double getItem(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IllegalArgumentException();
    }

    public void setItem(int i, double v) {
        switch (i) {
            case 0: {
                this.x = v;
                return;
            }
            case 1: {
                this.y = v;
                return;
            }
            case 2: {
                this.z = v;
                return;
            }
            case 3: {
                this.w = v;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Vector4 negate(Vector4 v) {
        return new Vector4(-v.x, -v.y, -v.z, -v.w);
    }

    public static double dotProduct(Vector4 a, Vector4 b) {
        return a.x * b.x + a.y * b.y + a.z * b.z + a.w * b.w;
    }

    public static Vector4 multiply(Vector4d a, Matrix4d b) {
        Vector4 ab = new Vector4();
        ab.x = a.x * b.m00 + a.y * b.m10 + a.z * b.m20 + a.w * b.m30;
        ab.y = a.x * b.m01 + a.y * b.m11 + a.z * b.m21 + a.w * b.m31;
        ab.z = a.x * b.m02 + a.y * b.m12 + a.z * b.m22 + a.w * b.m32;
        ab.w = a.x * b.m03 + a.y * b.m13 + a.z * b.m23 + a.w * b.m33;
        return ab;
    }

    public static Vector4 multiply(Matrix4d a, Vector4d b) {
        Vector4 ab = new Vector4();
        ab.x = b.x * a.m00 + b.y * a.m01 + b.z * a.m02 + b.w * a.m03;
        ab.y = b.x * a.m10 + b.y * a.m11 + b.z * a.m12 + b.w * a.m13;
        ab.z = b.x * a.m20 + b.y * a.m21 + b.z * a.m22 + b.w * a.m23;
        ab.w = b.x * a.m30 + b.y * a.m31 + b.z * a.m32 + b.w * a.m33;
        return ab;
    }

    public void transform(Matrix4d m) {
        this.set(Vector4.multiply(this, m));
    }

    public String toString() {
        return "edu.cmu.cs.stage3.math.Vector4[x=" + this.x + ",y=" + this.y + ",z=" + this.z + ",w=" + this.w + "]";
    }

    public static Vector4 valueOf(String s) {
        String[] markers = new String[]{"edu.cmu.cs.stage3.math.Vector4[x=", ",y=", ",z=", ",w=", "]"};
        double[] values = new double[markers.length - 1];
        int i = 0;
        while (i < values.length) {
            int begin = s.indexOf(markers[i]) + markers[i].length();
            int end = s.indexOf(markers[i + 1]);
            values[i] = Double.valueOf(s.substring(begin, end));
            ++i;
        }
        return new Vector4(values);
    }
}

