/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.math;

import edu.cmu.cs.stage3.math.Interpolable;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;

public class Vector3
extends Vector3d
implements Interpolable {
    public static final Vector3 ZERO = new Vector3(0.0, 0.0, 0.0);
    public static final Vector3 X_AXIS = new Vector3(1.0, 0.0, 0.0);
    public static final Vector3 X_AXIS_NEGATIVE = new Vector3(-1.0, 0.0, 0.0);
    public static final Vector3 Y_AXIS = new Vector3(0.0, 1.0, 0.0);
    public static final Vector3 Y_AXIS_NEGATIVE = new Vector3(0.0, -1.0, 0.0);
    public static final Vector3 Z_AXIS = new Vector3(0.0, 0.0, 1.0);
    public static final Vector3 Z_AXIS_NEGATIVE = new Vector3(0.0, 0.0, -1.0);

    public Vector3() {
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(double[] v) {
        this(v[0], v[1], v[2]);
    }

    public Vector3(Tuple3d t) {
        this(t.x, t.y, t.z);
    }

    public Vector3(Tuple4d t) {
        this(t.x / t.w, t.y / t.w, t.z / t.w);
    }

    public double getItem(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException();
    }

    public void setItem(int i, double v) {
        switch (i) {
            case 0: {
                this.x = v;
                return;
            }
            case 1: {
                this.y = v;
                return;
            }
            case 2: {
                this.z = v;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public double[] getArray() {
        double[] a = new double[]{this.x, this.y, this.z};
        return a;
    }

    public void setArray(double[] a) {
        this.x = a[0];
        this.y = a[1];
        this.z = a[2];
    }

    public void add(Vector3 v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public static Vector3 add(Vector3d a, Vector3d b) {
        return new Vector3(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    public void subtract(Vector3 v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
    }

    public static Vector3 subtract(Vector3d a, Vector3d b) {
        return new Vector3(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    public static Vector3 negate(Vector3d v) {
        return new Vector3(-v.x, -v.y, -v.z);
    }

    public void multiply(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
    }

    public void multiply(Vector3d scalar) {
        this.x *= scalar.x;
        this.y *= scalar.y;
        this.z *= scalar.z;
    }

    public static Vector3 multiply(Vector3d v, double scalar) {
        return new Vector3(v.x * scalar, v.y * scalar, v.z * scalar);
    }

    public static Vector3 multiply(Vector3d v, Vector3 scalar) {
        return new Vector3(v.x * scalar.x, v.y * scalar.y, v.z * scalar.z);
    }

    public void divide(double divisor) {
        this.multiply(1.0 / divisor);
    }

    public void divide(Vector3d divisor) {
        this.x /= divisor.x;
        this.y /= divisor.y;
        this.z /= divisor.z;
    }

    public static Vector3 divide(Vector3d v, double divisor) {
        return Vector3.multiply(v, 1.0 / divisor);
    }

    public static Vector3 divide(Vector3d numerator, Vector3d divisor) {
        return new Vector3(numerator.x / divisor.x, numerator.y / divisor.y, numerator.z / divisor.z);
    }

    public void invert() {
        this.x = 1.0 / this.x;
        this.y = 1.0 / this.y;
        this.z = 1.0 / this.z;
    }

    public static Vector3 invert(Vector3d v) {
        return new Vector3(1.0 / v.x, 1.0 / v.y, 1.0 / v.z);
    }

    public static Vector3 normalizeV(Vector3d v) {
        Vector3 nv = new Vector3(v.x, v.y, v.z);
        nv.normalize();
        return nv;
    }

    public static double getLengthSquared(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    public static double getLength(double x, double y, double z) {
        double lengthSquared = Vector3.getLengthSquared(x, y, z);
        if (lengthSquared == 1.0) {
            return 1.0;
        }
        return Math.sqrt(lengthSquared);
    }

    public double getLengthSquared() {
        return Vector3.getLengthSquared(this.x, this.y, this.z);
    }

    public double getLength() {
        return Vector3.getLength(this.x, this.y, this.z);
    }

    public static double dotProduct(Vector3d a, Vector3d b) {
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    public static Vector3 crossProduct(Vector3d a, Vector3d b) {
        return new Vector3(a.y * b.z - a.z * b.y, a.z * b.x - a.x * b.z, a.x * b.y - a.y * b.x);
    }

    public static Vector3 interpolate(Vector3d a, Vector3d b, double portion) {
        return new Vector3(a.x + (b.x - a.x) * portion, a.y + (b.y - a.y) * portion, a.z + (b.z - a.z) * portion);
    }

    public Interpolable interpolate(Interpolable b, double portion) {
        return Vector3.interpolate(this, (Vector3)b, portion);
    }

    public Vector3 projectOnto(Vector3d b) {
        return Vector3.multiply(b, Vector3.dotProduct(b, this) / Vector3.dotProduct(b, b));
    }

    public static Vector3 projectOnto(Vector3d a, Vector3d b) {
        return Vector3.multiply(b, Vector3.dotProduct(b, a) / Vector3.dotProduct(b, b));
    }

    public static Vector3 multiply(Matrix3d a, Vector3d b) {
        double x = a.m00 * b.x + a.m01 * b.y + a.m02 * b.z;
        double y = a.m10 * b.x + a.m11 * b.y + a.m12 * b.z;
        double z = a.m20 * b.x + a.m21 * b.y + a.m22 * b.z;
        return new Vector3(x, y, z);
    }

    public static Vector3 multiply(Vector3d a, Matrix4d b) {
        Vector3 ab = new Vector3();
        ab.x = a.x * b.m00 + a.y * b.m10 + a.z * b.m20;
        ab.y = a.x * b.m01 + a.y * b.m11 + a.z * b.m21;
        ab.z = a.x * b.m02 + a.y * b.m12 + a.z * b.m22;
        return ab;
    }

    public static Vector3 combine(Vector3d a, Vector3d b, double asc1, double bsc1) {
        Vector3 ab = new Vector3();
        ab.x = asc1 * a.x + bsc1 * b.x;
        ab.y = asc1 * a.y + bsc1 * b.y;
        ab.z = asc1 * a.z + bsc1 * b.z;
        return ab;
    }

    public String toString() {
        return "edu.cmu.cs.stage3.math.Vector3[x=" + this.x + ",y=" + this.y + ",z=" + this.z + "]";
    }

    public static Vector3 valueOf(String s) {
        String[] markers = new String[]{"edu.cmu.cs.stage3.math.Vector3[x=", ",y=", ",z=", "]"};
        double[] values = new double[markers.length - 1];
        int i = 0;
        while (i < values.length) {
            int begin = s.indexOf(markers[i]) + markers[i].length();
            int end = s.indexOf(markers[i + 1]);
            values[i] = Double.valueOf(s.substring(begin, end));
            ++i;
        }
        return new Vector3(values);
    }
}

