/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.image.codec;

import edu.cmu.cs.stage3.io.image.codec.ImageEncodeParam;
import edu.cmu.cs.stage3.io.image.codec.ImageEncoderImpl;
import edu.cmu.cs.stage3.io.image.codec.JaiI18N;
import edu.cmu.cs.stage3.io.image.codec.TIFFEncodeParam;
import edu.cmu.cs.stage3.io.image.codec.TIFFField;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class TIFFImageEncoder
extends ImageEncoderImpl {
    long firstIFDOffset = 0L;
    boolean skipByte = false;
    private static final int TIFF_BILEVEL_WHITE_IS_ZERO = 0;
    private static final int TIFF_BILEVEL_BLACK_IS_ZERO = 1;
    private static final int TIFF_PALETTE = 2;
    private static final int TIFF_FULLCOLOR = 3;
    private static final int TIFF_GREYSCALE = 4;
    private static final int COMP_NONE = 1;
    private static final int[] sizeOfType;

    static {
        int[] nArray = new int[13];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 4;
        nArray[5] = 8;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 2;
        nArray[9] = 4;
        nArray[10] = 8;
        nArray[11] = 4;
        nArray[12] = 8;
        sizeOfType = nArray;
    }

    public TIFFImageEncoder(OutputStream output, ImageEncodeParam param) {
        super(output, param);
        if (this.param == null) {
            this.param = new TIFFEncodeParam();
        }
    }

    public void encode(RenderedImage im) throws IOException {
        int compression = 1;
        int minX = im.getMinX();
        int minY = im.getMinY();
        int width = im.getWidth();
        int height = im.getHeight();
        SampleModel sampleModel = im.getSampleModel();
        int numBands = sampleModel.getNumBands();
        int[] sampleSize = sampleModel.getSampleSize();
        int dataType = sampleModel.getDataType();
        if (dataType != 0 && dataType != 2 && dataType != 1) {
            throw new Error(JaiI18N.getString("TIFFImageEncoder0"));
        }
        boolean dataTypeIsShort = dataType == 2 || dataType == 1;
        ColorModel colorModel = im.getColorModel();
        if (colorModel != null && colorModel instanceof IndexColorModel && dataTypeIsShort) {
            throw new Error(JaiI18N.getString("TIFFImageEncoder2"));
        }
        IndexColorModel icm = null;
        int sizeOfColormap = 0;
        int[] colormap = null;
        int numFields = 12;
        if (dataTypeIsShort) {
            numFields += 3;
        }
        int photometricInterpretation = 2;
        int imageType = 3;
        if (colorModel instanceof IndexColorModel) {
            icm = (IndexColorModel)colorModel;
            int mapSize = icm.getMapSize();
            if (sampleSize[0] == 1) {
                if (mapSize != 2) {
                    throw new IllegalArgumentException(JaiI18N.getString("TIFFImageEncoder1"));
                }
                byte[] r = new byte[mapSize];
                icm.getReds(r);
                byte[] g = new byte[mapSize];
                icm.getGreens(g);
                byte[] b = new byte[mapSize];
                icm.getBlues(b);
                imageType = (r[0] & 0xFF) == 0 && (r[1] & 0xFF) == 255 && (g[0] & 0xFF) == 0 && (g[1] & 0xFF) == 255 && (b[0] & 0xFF) == 0 && (b[1] & 0xFF) == 255 ? 1 : ((r[0] & 0xFF) == 255 && (r[1] & 0xFF) == 0 && (g[0] & 0xFF) == 255 && (g[1] & 0xFF) == 0 && (b[0] & 0xFF) == 255 && (b[1] & 0xFF) == 0 ? 0 : 2);
            } else {
                imageType = 2;
            }
        } else {
            imageType = (colorModel == null || colorModel.getColorSpace().getType() == 6) && numBands == 1 ? 4 : 3;
        }
        switch (imageType) {
            case 0: {
                photometricInterpretation = 0;
                break;
            }
            case 1: {
                photometricInterpretation = 1;
                break;
            }
            case 4: {
                photometricInterpretation = 1;
                break;
            }
            case 2: {
                photometricInterpretation = 3;
                icm = (IndexColorModel)colorModel;
                sizeOfColormap = icm.getMapSize();
                byte[] r = new byte[sizeOfColormap];
                icm.getReds(r);
                byte[] g = new byte[sizeOfColormap];
                icm.getGreens(g);
                byte[] b = new byte[sizeOfColormap];
                icm.getBlues(b);
                int redIndex = 0;
                int greenIndex = sizeOfColormap;
                int blueIndex = 2 * sizeOfColormap;
                colormap = new int[sizeOfColormap * 3];
                int i = 0;
                while (i < sizeOfColormap) {
                    colormap[redIndex++] = r[i] << 8 & 0xFFFF;
                    colormap[greenIndex++] = g[i] << 8 & 0xFFFF;
                    colormap[blueIndex++] = b[i] << 8 & 0xFFFF;
                    ++i;
                }
                sizeOfColormap *= 3;
                ++numFields;
                break;
            }
            case 3: {
                photometricInterpretation = 2;
            }
        }
        long rowsPerStrip = 8L;
        int strips = (int)Math.ceil((double)height / 8.0);
        long[] stripByteCounts = new long[strips];
        long bytesPerRow = (long)Math.ceil((double)sampleSize[0] / 8.0 * (double)width * (double)numBands);
        long bytesPerStrip = bytesPerRow * rowsPerStrip;
        int i = 0;
        while (i < strips) {
            stripByteCounts[i] = bytesPerStrip;
            ++i;
        }
        long lastStripRows = (long)height - rowsPerStrip * (long)(strips - 1);
        stripByteCounts[strips - 1] = lastStripRows * bytesPerRow;
        long totalBytesOfData = bytesPerStrip * (long)(strips - 1) + stripByteCounts[strips - 1];
        long[] stripOffsets = new long[strips];
        stripOffsets[0] = 8L;
        int i2 = 1;
        while (i2 < strips) {
            stripOffsets[i2] = stripOffsets[i2 - 1] + stripByteCounts[i2 - 1];
            ++i2;
        }
        TIFFField[] fields = new TIFFField[numFields];
        int fld = 0;
        fields[fld++] = new TIFFField(256, 4, 1, new long[]{width});
        fields[fld++] = new TIFFField(257, 4, 1, new long[]{height});
        fields[fld++] = new TIFFField(258, 3, numBands, sampleSize);
        fields[fld++] = new TIFFField(259, 3, 1, new int[]{compression});
        fields[fld++] = new TIFFField(262, 3, 1, new int[]{photometricInterpretation});
        fields[fld++] = new TIFFField(273, 4, strips, stripOffsets);
        fields[fld++] = new TIFFField(277, 3, 1, new int[]{numBands});
        fields[fld++] = new TIFFField(278, 4, 1, new long[]{rowsPerStrip});
        fields[fld++] = new TIFFField(279, 4, strips, stripByteCounts);
        fields[fld++] = new TIFFField(282, 5, 1, new long[][]{{72L, 1L}});
        fields[fld++] = new TIFFField(283, 5, 1, new long[][]{{72L, 1L}});
        fields[fld++] = new TIFFField(296, 3, 1, new int[]{2});
        if (colormap != null) {
            fields[fld++] = new TIFFField(320, 3, sizeOfColormap, colormap);
        }
        if (dataTypeIsShort) {
            int[] sampleFormat = new int[numBands];
            sampleFormat[0] = dataType == 1 ? 1 : 2;
            int b = 1;
            while (b < numBands) {
                sampleFormat[b] = sampleFormat[0];
                ++b;
            }
            fields[fld++] = new TIFFField(339, 3, numBands, sampleFormat);
            int[] minValue = new int[numBands];
            minValue[0] = dataType == 1 ? 0 : Short.MIN_VALUE;
            int b2 = 1;
            while (b2 < numBands) {
                minValue[b2] = minValue[0];
                ++b2;
            }
            fields[fld++] = new TIFFField(340, 3, numBands, minValue);
            int[] maxValue = new int[numBands];
            maxValue[0] = dataType == 1 ? 65535 : Short.MAX_VALUE;
            int b3 = 1;
            while (b3 < numBands) {
                maxValue[b3] = maxValue[0];
                ++b3;
            }
            fields[fld++] = new TIFFField(341, 3, numBands, maxValue);
        }
        this.firstIFDOffset = 8L + totalBytesOfData;
        if (this.firstIFDOffset % 2L != 0L) {
            this.skipByte = true;
            ++this.firstIFDOffset;
        }
        this.writeFileHeader(this.firstIFDOffset);
        int[] pixels = new int[8 * width * numBands];
        byte[] bpixels = null;
        if (dataType == 0) {
            bpixels = new byte[8 * width * numBands];
        } else if (dataTypeIsShort) {
            bpixels = new byte[16 * width * numBands];
        }
        int lastRow = minY + height;
        int row = minY;
        while (row < lastRow) {
            int rows = Math.min(8, lastRow - row);
            int size = rows * width * numBands;
            Raster src = im.getData(new Rectangle(minX, row, width, rows));
            src.getPixels(minX, row, width, rows, pixels);
            int pixel = 0;
            int k = 0;
            switch (sampleSize[0]) {
                case 1: {
                    int j;
                    int index = 0;
                    int i3 = 0;
                    while (i3 < rows) {
                        j = 0;
                        while (j < width / 8) {
                            pixel = pixels[index++] << 7 | pixels[index++] << 6 | pixels[index++] << 5 | pixels[index++] << 4 | pixels[index++] << 3 | pixels[index++] << 2 | pixels[index++] << 1 | pixels[index++];
                            bpixels[k++] = (byte)pixel;
                            ++j;
                        }
                        if (width % 8 > 0) {
                            pixel = 0;
                            j = 0;
                            while (j < width % 8) {
                                pixel |= pixels[index++] << 7 - j;
                                ++j;
                            }
                            bpixels[k++] = (byte)pixel;
                        }
                        ++i3;
                    }
                    this.output.write(bpixels, 0, rows * ((width + 7) / 8));
                    break;
                }
                case 4: {
                    int j;
                    int index = 0;
                    int i3 = 0;
                    while (i3 < rows) {
                        j = 0;
                        while (j < width / 2) {
                            pixel = pixels[index++] << 4 | pixels[index++];
                            bpixels[k++] = (byte)pixel;
                            ++j;
                        }
                        if (width % 2 == 1) {
                            pixel = pixels[index++] << 4;
                            bpixels[k++] = (byte)pixel;
                        }
                        ++i3;
                    }
                    this.output.write(bpixels, 0, rows * ((width + 1) / 2));
                    break;
                }
                case 8: {
                    int i3 = 0;
                    while (i3 < size) {
                        bpixels[i3] = (byte)pixels[i3];
                        ++i3;
                    }
                    this.output.write(bpixels, 0, size);
                    break;
                }
                case 16: {
                    int l = 0;
                    int i4 = 0;
                    while (i4 < size) {
                        short value = (short)pixels[i4];
                        bpixels[l++] = (byte)((value & 0xFF00) >> 8);
                        bpixels[l++] = (byte)(value & 0xFF);
                        ++i4;
                    }
                    this.output.write(bpixels, 0, size * 2);
                }
            }
            row += 8;
        }
        this.writeDirectory(fields, 0);
    }

    private void writeFileHeader(long firstIFDOffset) throws IOException {
        this.output.write(77);
        this.output.write(77);
        this.output.write(0);
        this.output.write(42);
        this.writeLong(firstIFDOffset);
    }

    private void writeDirectory(TIFFField[] fields, int nextIFDOffset) throws IOException {
        if (this.skipByte) {
            this.output.write(0);
        }
        int numEntries = fields.length;
        long offsetBeyondIFD = this.firstIFDOffset + (long)(12 * numEntries) + 4L + 2L;
        Vector<Integer> tooBig = new Vector<Integer>();
        this.writeUnsignedShort(numEntries);
        int i = 0;
        while (i < numEntries) {
            TIFFField field = fields[i];
            int tag = field.getTag();
            this.writeUnsignedShort(tag);
            int type = field.getType();
            this.writeUnsignedShort(type);
            int count = field.getCount();
            this.writeLong(count);
            if (count * sizeOfType[type] > 4) {
                this.writeLong(offsetBeyondIFD);
                offsetBeyondIFD += (long)(count * sizeOfType[type]);
                tooBig.add(new Integer(i));
            } else {
                this.writeValuesAsFourBytes(field);
            }
            ++i;
        }
        this.writeLong(nextIFDOffset);
        int i2 = 0;
        while (i2 < tooBig.size()) {
            int index = (Integer)tooBig.elementAt(i2);
            this.writeValues(fields[index]);
            ++i2;
        }
    }

    private void writeValuesAsFourBytes(TIFFField field) throws IOException {
        int dataType = field.getType();
        int count = field.getCount();
        switch (dataType) {
            case 1: {
                byte[] bytes = field.getAsBytes();
                int i = 0;
                while (i < count) {
                    this.output.write(bytes[i]);
                    ++i;
                }
                i = 0;
                while (i < 4 - count) {
                    this.output.write(0);
                    ++i;
                }
                break;
            }
            case 3: {
                int[] shorts = field.getAsInts();
                int i = 0;
                while (i < count) {
                    this.writeUnsignedShort(shorts[i]);
                    ++i;
                }
                i = 0;
                while (i < 2 - count) {
                    this.writeUnsignedShort(0);
                    ++i;
                }
                break;
            }
            case 4: {
                long[] longs = field.getAsLongs();
                int i = 0;
                while (i < count) {
                    this.writeLong(longs[i]);
                    ++i;
                }
                break;
            }
        }
    }

    private void writeValues(TIFFField field) throws IOException {
        int dataType = field.getType();
        int count = field.getCount();
        switch (dataType) {
            case 1: {
                byte[] bytes = field.getAsBytes();
                int i = 0;
                while (i < count) {
                    this.output.write(bytes[i]);
                    ++i;
                }
                break;
            }
            case 3: {
                int[] shorts = field.getAsInts();
                int i = 0;
                while (i < count) {
                    this.writeUnsignedShort(shorts[i]);
                    ++i;
                }
                break;
            }
            case 4: {
                long[] longs = field.getAsLongs();
                int i = 0;
                while (i < count) {
                    this.writeLong(longs[i]);
                    ++i;
                }
                break;
            }
            case 5: {
                long[][] rationals = field.getAsRationals();
                int i = 0;
                while (i < count) {
                    this.writeLong(rationals[i][0]);
                    this.writeLong(rationals[i][1]);
                    ++i;
                }
                break;
            }
        }
    }

    private void writeUnsignedShort(int s) throws IOException {
        this.output.write((s & 0xFF00) >>> 8);
        this.output.write(s & 0xFF);
    }

    private void writeLong(long l) throws IOException {
        this.output.write((int)((l & 0xFFFFFFFFFF000000L) >>> 24));
        this.output.write((int)((l & 0xFF0000L) >>> 16));
        this.output.write((int)((l & 0xFF00L) >>> 8));
        this.output.write((int)l & 0xFF);
    }
}

