/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.image.codec;

import edu.cmu.cs.stage3.io.image.codec.BMPEncodeParam;
import edu.cmu.cs.stage3.io.image.codec.ImageEncodeParam;
import edu.cmu.cs.stage3.io.image.codec.ImageEncoderImpl;
import edu.cmu.cs.stage3.io.image.codec.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;

public class BMPImageEncoder
extends ImageEncoderImpl {
    private OutputStream output;
    private int version;
    private boolean isCompressed;
    private boolean isTopDown;
    private int w;
    private int h;

    public BMPImageEncoder(OutputStream output, ImageEncodeParam param) {
        super(output, param);
        this.output = output;
        BMPEncodeParam bmpParam = param == null ? new BMPEncodeParam() : (BMPEncodeParam)param;
        this.version = bmpParam.getVersion();
        this.isCompressed = bmpParam.isCompressed();
        this.isTopDown = bmpParam.isTopDown();
    }

    public void encode(RenderedImage im) throws IOException {
        int minX = im.getMinX();
        int minY = im.getMinY();
        this.w = im.getWidth();
        this.h = im.getHeight();
        int bitsPerPixel = 24;
        boolean isPalette = false;
        int paletteEntries = 0;
        IndexColorModel icm = null;
        SampleModel sm = im.getSampleModel();
        int numBands = sm.getNumBands();
        ColorModel cm = im.getColorModel();
        if (numBands != 1 && numBands != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("BMPImageEncoder1"));
        }
        int[] sampleSize = sm.getSampleSize();
        if (sampleSize[0] > 8) {
            throw new RuntimeException(JaiI18N.getString("BMPImageEncoder2"));
        }
        int i = 1;
        while (i < sampleSize.length) {
            if (sampleSize[i] != sampleSize[0]) {
                throw new RuntimeException(JaiI18N.getString("BMPImageEncoder3"));
            }
            ++i;
        }
        int dataType = sm.getTransferType();
        if (dataType == 1 || dataType == 2 || dataType == 3 || dataType == 4 || dataType == 5) {
            throw new RuntimeException(JaiI18N.getString("BMPImageEncoder0"));
        }
        int destScanlineBytes = this.w * numBands;
        int compression = 0;
        byte[] r = null;
        byte[] g = null;
        byte[] b = null;
        byte[] a = null;
        if (cm instanceof IndexColorModel) {
            isPalette = true;
            icm = (IndexColorModel)cm;
            paletteEntries = icm.getMapSize();
            if (paletteEntries <= 2) {
                bitsPerPixel = 1;
                destScanlineBytes = (int)Math.ceil((double)this.w / 8.0);
            } else if (paletteEntries <= 16) {
                bitsPerPixel = 4;
                destScanlineBytes = (int)Math.ceil((double)this.w / 2.0);
            } else if (paletteEntries <= 256) {
                bitsPerPixel = 8;
            } else {
                bitsPerPixel = 24;
                isPalette = false;
                paletteEntries = 0;
                destScanlineBytes = this.w * 3;
            }
            if (isPalette) {
                r = new byte[paletteEntries];
                g = new byte[paletteEntries];
                b = new byte[paletteEntries];
                a = new byte[paletteEntries];
                icm.getAlphas(a);
                icm.getReds(r);
                icm.getGreens(g);
                icm.getBlues(b);
            }
        } else if (numBands == 1) {
            isPalette = true;
            paletteEntries = 256;
            bitsPerPixel = sampleSize[0];
            destScanlineBytes = (int)Math.ceil((double)(this.w * bitsPerPixel) / 8.0);
            r = new byte[256];
            g = new byte[256];
            b = new byte[256];
            a = new byte[256];
            int i2 = 0;
            while (i2 < 256) {
                r[i2] = (byte)i2;
                g[i2] = (byte)i2;
                b[i2] = (byte)i2;
                a[i2] = (byte)i2;
                ++i2;
            }
        }
        int fileSize = 0;
        int offset = 0;
        int headerSize = 0;
        int imageSize = 0;
        int xPelsPerMeter = 0;
        int yPelsPerMeter = 0;
        int colorsUsed = 0;
        int colorsImportant = paletteEntries;
        int padding = 0;
        int remainder = destScanlineBytes % 4;
        if (remainder != 0) {
            padding = 4 - remainder;
        }
        switch (this.version) {
            case 0: {
                offset = 26 + paletteEntries * 3;
                headerSize = 12;
                imageSize = (destScanlineBytes + padding) * this.h;
                fileSize = imageSize + offset;
                throw new RuntimeException(JaiI18N.getString("BMPImageEncoder5"));
            }
            case 1: {
                offset = 54 + paletteEntries * 4;
                imageSize = (destScanlineBytes + padding) * this.h;
                fileSize = imageSize + offset;
                headerSize = 40;
                break;
            }
            case 2: {
                headerSize = 108;
                throw new RuntimeException(JaiI18N.getString("BMPImageEncoder5"));
            }
        }
        this.writeFileHeader(fileSize, offset);
        this.writeInfoHeader(headerSize, bitsPerPixel);
        this.writeDWord(compression);
        this.writeDWord(imageSize);
        this.writeDWord(xPelsPerMeter);
        this.writeDWord(yPelsPerMeter);
        this.writeDWord(colorsUsed);
        this.writeDWord(colorsImportant);
        if (isPalette) {
            switch (this.version) {
                case 0: {
                    int i3 = 0;
                    while (i3 < paletteEntries) {
                        this.output.write(b[i3]);
                        this.output.write(g[i3]);
                        this.output.write(r[i3]);
                        ++i3;
                    }
                    break;
                }
                default: {
                    int i3 = 0;
                    while (i3 < paletteEntries) {
                        this.output.write(b[i3]);
                        this.output.write(g[i3]);
                        this.output.write(r[i3]);
                        this.output.write(a[i3]);
                        ++i3;
                    }
                    break block5;
                }
            }
        }
        int scanlineBytes = this.w * numBands;
        int[] pixels = new int[8 * scanlineBytes];
        byte[] bpixels = new byte[destScanlineBytes];
        if (!this.isTopDown) {
            int lastRow = minY + this.h;
            int row = lastRow - 1;
            while (row >= minY) {
                int rows = Math.min(8, row - minY + 1);
                Raster src = im.getData(new Rectangle(minX, row - rows + 1, this.w, rows));
                src.getPixels(minX, row - rows + 1, this.w, rows, pixels);
                int l = 0;
                int max = scanlineBytes * rows - 1;
                int i4 = 0;
                while (i4 < rows) {
                    l = max - (i4 + 1) * scanlineBytes + 1;
                    this.writePixels(l, scanlineBytes, bitsPerPixel, pixels, bpixels, padding, numBands, icm);
                    ++i4;
                }
                row -= 8;
            }
        } else {
            int lastRow = minY + this.h;
            int row = minY;
            while (row < lastRow) {
                int rows = Math.min(8, lastRow - row);
                Raster src = im.getData(new Rectangle(minX, row, this.w, rows));
                src.getPixels(minX, row, this.w, rows, pixels);
                int l = 0;
                int i5 = 0;
                while (i5 < rows) {
                    this.writePixels(l, scanlineBytes, bitsPerPixel, pixels, bpixels, padding, numBands, icm);
                    ++i5;
                }
                row += 8;
            }
        }
    }

    private void writePixels(int l, int scanlineBytes, int bitsPerPixel, int[] pixels, byte[] bpixels, int padding, int numBands, IndexColorModel icm) throws IOException {
        int pixel = 0;
        int k = 0;
        switch (bitsPerPixel) {
            case 1: {
                int j = 0;
                while (j < scanlineBytes / 8) {
                    bpixels[k++] = (byte)(pixels[l++] << 7 | pixels[l++] << 6 | pixels[l++] << 5 | pixels[l++] << 4 | pixels[l++] << 3 | pixels[l++] << 2 | pixels[l++] << 1 | pixels[l++]);
                    ++j;
                }
                if (scanlineBytes % 8 > 0) {
                    pixel = 0;
                    j = 0;
                    while (j < scanlineBytes % 8) {
                        pixel |= pixels[l++] << 7 - j;
                        ++j;
                    }
                    bpixels[k++] = (byte)pixel;
                }
                this.output.write(bpixels, 0, (scanlineBytes + 7) / 8);
                break;
            }
            case 4: {
                int j = 0;
                while (j < scanlineBytes / 2) {
                    pixel = pixels[l++] << 4 | pixels[l++];
                    bpixels[k++] = (byte)pixel;
                    ++j;
                }
                if (scanlineBytes % 2 == 1) {
                    pixel = pixels[l] << 4;
                    bpixels[k++] = (byte)pixel;
                }
                this.output.write(bpixels, 0, (scanlineBytes + 1) / 2);
                break;
            }
            case 8: {
                int j = 0;
                while (j < scanlineBytes) {
                    bpixels[j] = (byte)pixels[l++];
                    ++j;
                }
                this.output.write(bpixels, 0, scanlineBytes);
                break;
            }
            case 24: {
                int j;
                if (numBands == 3) {
                    j = 0;
                    while (j < scanlineBytes) {
                        bpixels[k++] = (byte)pixels[l + 2];
                        bpixels[k++] = (byte)pixels[l + 1];
                        bpixels[k++] = (byte)pixels[l];
                        l += 3;
                        j += 3;
                    }
                    this.output.write(bpixels, 0, scanlineBytes);
                    break;
                }
                int entries = icm.getMapSize();
                byte[] r = new byte[entries];
                byte[] g = new byte[entries];
                byte[] b = new byte[entries];
                icm.getReds(r);
                icm.getGreens(g);
                icm.getBlues(b);
                int j2 = 0;
                while (j2 < scanlineBytes) {
                    int index = pixels[l];
                    bpixels[k++] = b[index];
                    bpixels[k++] = g[index];
                    bpixels[k++] = b[index];
                    ++l;
                    ++j2;
                }
                this.output.write(bpixels, 0, scanlineBytes * 3);
            }
        }
        k = 0;
        while (k < padding) {
            this.output.write(0);
            ++k;
        }
    }

    private void writeFileHeader(int fileSize, int offset) throws IOException {
        this.output.write(66);
        this.output.write(77);
        this.writeDWord(fileSize);
        this.output.write(0);
        this.output.write(0);
        this.output.write(0);
        this.output.write(0);
        this.writeDWord(offset);
    }

    private void writeInfoHeader(int headerSize, int bitsPerPixel) throws IOException {
        this.writeDWord(headerSize);
        this.writeDWord(this.w);
        this.writeDWord(this.h);
        this.writeWord(1);
        this.writeWord(bitsPerPixel);
    }

    public void writeWord(int word) throws IOException {
        this.output.write(word & 0xFF);
        this.output.write((word & 0xFF00) >> 8);
    }

    public void writeDWord(int dword) throws IOException {
        this.output.write(dword & 0xFF);
        this.output.write((dword & 0xFF00) >> 8);
        this.output.write((dword & 0xFF0000) >> 16);
        this.output.write((dword & 0xFF000000) >> 24);
    }
}

