/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.image.codec;

import edu.cmu.cs.stage3.io.image.codec.ImageCodec;
import edu.cmu.cs.stage3.io.image.codec.JaiI18N;
import edu.cmu.cs.stage3.io.image.codec.RasterFactory;
import edu.cmu.cs.stage3.io.image.codec.SimpleRenderedImage;
import java.awt.Point;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

class BMPImage
extends SimpleRenderedImage {
    private BufferedInputStream inputStream;
    private long bitmapFileSize;
    private long bitmapOffset;
    private long compression;
    private long imageSize;
    private byte[] palette;
    private int imageType;
    private int numBands;
    private boolean isBottomUp;
    private int bitsPerPixel;
    private int redMask;
    private int greenMask;
    private int blueMask;
    private static final int VERSION_2_1_BIT = 0;
    private static final int VERSION_2_4_BIT = 1;
    private static final int VERSION_2_8_BIT = 2;
    private static final int VERSION_2_24_BIT = 3;
    private static final int VERSION_3_1_BIT = 4;
    private static final int VERSION_3_4_BIT = 5;
    private static final int VERSION_3_8_BIT = 6;
    private static final int VERSION_3_24_BIT = 7;
    private static final int VERSION_3_NT_16_BIT = 8;
    private static final int VERSION_3_NT_32_BIT = 9;
    private static final int VERSION_4_1_BIT = 10;
    private static final int VERSION_4_4_BIT = 11;
    private static final int VERSION_4_8_BIT = 12;
    private static final int VERSION_4_16_BIT = 13;
    private static final int VERSION_4_24_BIT = 14;
    private static final int VERSION_4_32_BIT = 15;
    private static final int LCS_CALIBRATED_RGB = 0;
    private static final int LCS_sRGB = 1;
    private static final int LCS_CMYK = 2;
    private static final int BI_RGB = 0;
    private static final int BI_RLE8 = 1;
    private static final int BI_RLE4 = 2;
    private static final int BI_BITFIELDS = 3;
    private int blueBits;
    private int greenBits;
    private int redBits;
    private WritableRaster theTile;

    public BMPImage(InputStream stream) {
        block69: {
            this.theTile = null;
            this.inputStream = stream instanceof BufferedInputStream ? (BufferedInputStream)stream : new BufferedInputStream(stream);
            try {
                if (this.readUnsignedByte(this.inputStream) != 66 || this.readUnsignedByte(this.inputStream) != 77) {
                    throw new RuntimeException(JaiI18N.getString("BMPImageDecoder0"));
                }
                this.bitmapFileSize = this.readDWord(this.inputStream);
                this.readWord(this.inputStream);
                this.readWord(this.inputStream);
                this.bitmapOffset = this.readDWord(this.inputStream);
                long size = this.readDWord(this.inputStream);
                if (size == 12L) {
                    this.width = this.readWord(this.inputStream);
                    this.height = this.readWord(this.inputStream);
                } else {
                    this.width = this.readLong(this.inputStream);
                    this.height = this.readLong(this.inputStream);
                }
                int planes = this.readWord(this.inputStream);
                this.bitsPerPixel = this.readWord(this.inputStream);
                this.properties.put("color_planes", new Integer(planes));
                this.properties.put("bits_per_pixel", new Integer(this.bitsPerPixel));
                this.numBands = 3;
                if (size == 12L) {
                    this.properties.put("bmp_version", "BMP v. 2.x");
                    if (this.bitsPerPixel == 1) {
                        this.imageType = 0;
                    } else if (this.bitsPerPixel == 4) {
                        this.imageType = 1;
                    } else if (this.bitsPerPixel == 8) {
                        this.imageType = 2;
                    } else if (this.bitsPerPixel == 24) {
                        this.imageType = 3;
                    }
                    int numberOfEntries = (int)((this.bitmapOffset - 14L - size) / 3L);
                    int sizeOfPalette = numberOfEntries * 3;
                    this.palette = new byte[sizeOfPalette];
                    this.inputStream.read(this.palette, 0, sizeOfPalette);
                    this.properties.put("palette", this.palette);
                    break block69;
                }
                this.compression = this.readDWord(this.inputStream);
                this.imageSize = this.readDWord(this.inputStream);
                long xPelsPerMeter = this.readLong(this.inputStream);
                long yPelsPerMeter = this.readLong(this.inputStream);
                long colorsUsed = this.readDWord(this.inputStream);
                long colorsImportant = this.readDWord(this.inputStream);
                switch ((int)this.compression) {
                    case 0: {
                        this.properties.put("compression", "BI_RGB");
                        break;
                    }
                    case 1: {
                        this.properties.put("compression", "BI_RLE8");
                        break;
                    }
                    case 2: {
                        this.properties.put("compression", "BI_RLE4");
                        break;
                    }
                    case 3: {
                        this.properties.put("compression", "BI_BITFIELDS");
                    }
                }
                this.properties.put("x_pixels_per_meter", new Long(xPelsPerMeter));
                this.properties.put("y_pixels_per_meter", new Long(yPelsPerMeter));
                this.properties.put("colors_used", new Long(colorsUsed));
                this.properties.put("colors_important", new Long(colorsImportant));
                if (size == 40L) {
                    switch ((int)this.compression) {
                        case 0: 
                        case 1: 
                        case 2: {
                            int numberOfEntries = (int)((this.bitmapOffset - 14L - size) / 4L);
                            int sizeOfPalette = numberOfEntries * 4;
                            this.palette = new byte[sizeOfPalette];
                            this.inputStream.read(this.palette, 0, sizeOfPalette);
                            this.properties.put("palette", this.palette);
                            if (this.bitsPerPixel == 1) {
                                this.imageType = 4;
                            } else if (this.bitsPerPixel == 4) {
                                this.imageType = 5;
                            } else if (this.bitsPerPixel == 8) {
                                this.imageType = 6;
                            } else if (this.bitsPerPixel == 24) {
                                this.imageType = 7;
                            } else if (this.bitsPerPixel == 16) {
                                this.imageType = 8;
                                this.redMask = 31744;
                                this.greenMask = 992;
                                this.blueMask = 31;
                                this.properties.put("red_mask", new Integer(this.redMask));
                                this.properties.put("green_mask", new Integer(this.greenMask));
                                this.properties.put("blue_mask", new Integer(this.blueMask));
                                this.computeShifts();
                            } else if (this.bitsPerPixel == 32) {
                                this.imageType = 9;
                                this.redMask = 0xFF0000;
                                this.greenMask = 65280;
                                this.blueMask = 255;
                                this.properties.put("red_mask", new Integer(this.redMask));
                                this.properties.put("green_mask", new Integer(this.greenMask));
                                this.properties.put("blue_mask", new Integer(this.blueMask));
                                this.computeShifts();
                            }
                            this.properties.put("bmp_version", "BMP v. 3.x");
                            break block69;
                        }
                        case 3: {
                            if (this.bitsPerPixel == 16) {
                                this.imageType = 8;
                            } else if (this.bitsPerPixel == 32) {
                                this.imageType = 9;
                            }
                            this.redMask = (int)this.readDWord(this.inputStream);
                            this.greenMask = (int)this.readDWord(this.inputStream);
                            this.blueMask = (int)this.readDWord(this.inputStream);
                            this.properties.put("red_mask", new Integer(this.redMask));
                            this.properties.put("green_mask", new Integer(this.greenMask));
                            this.properties.put("blue_mask", new Integer(this.blueMask));
                            this.computeShifts();
                            if (colorsUsed != 0L) {
                                int sizeOfPalette = (int)colorsUsed * 4;
                                this.palette = new byte[sizeOfPalette];
                                this.inputStream.read(this.palette, 0, sizeOfPalette);
                                this.properties.put("palette", this.palette);
                            }
                            this.properties.put("bmp_version", "BMP v. 3.x NT");
                            break block69;
                        }
                        default: {
                            throw new RuntimeException(JaiI18N.getString("BMPImageDecoder1"));
                        }
                    }
                }
                if (size == 108L) {
                    this.properties.put("bmp_version", "BMP v. 4.x");
                    this.redMask = (int)this.readDWord(this.inputStream);
                    this.greenMask = (int)this.readDWord(this.inputStream);
                    this.blueMask = (int)this.readDWord(this.inputStream);
                    int alphaMask = (int)this.readDWord(this.inputStream);
                    long csType = this.readDWord(this.inputStream);
                    int redX = this.readLong(this.inputStream);
                    int redY = this.readLong(this.inputStream);
                    int redZ = this.readLong(this.inputStream);
                    int greenX = this.readLong(this.inputStream);
                    int greenY = this.readLong(this.inputStream);
                    int greenZ = this.readLong(this.inputStream);
                    int blueX = this.readLong(this.inputStream);
                    int blueY = this.readLong(this.inputStream);
                    int blueZ = this.readLong(this.inputStream);
                    long gammaRed = this.readDWord(this.inputStream);
                    long gammaGreen = this.readDWord(this.inputStream);
                    long gammaBlue = this.readDWord(this.inputStream);
                    int numberOfEntries = (int)((this.bitmapOffset - 14L - size) / 4L);
                    int sizeOfPalette = numberOfEntries * 4;
                    this.palette = new byte[sizeOfPalette];
                    this.inputStream.read(this.palette, 0, sizeOfPalette);
                    if (this.palette != null || this.palette.length != 0) {
                        this.properties.put("palette", this.palette);
                    }
                    switch ((int)csType) {
                        case 0: {
                            this.properties.put("color_space", "LCS_CALIBRATED_RGB");
                            this.properties.put("redX", new Integer(redX));
                            this.properties.put("redY", new Integer(redY));
                            this.properties.put("redZ", new Integer(redZ));
                            this.properties.put("greenX", new Integer(greenX));
                            this.properties.put("greenY", new Integer(greenY));
                            this.properties.put("greenZ", new Integer(greenZ));
                            this.properties.put("blueX", new Integer(blueX));
                            this.properties.put("blueY", new Integer(blueY));
                            this.properties.put("blueZ", new Integer(blueZ));
                            this.properties.put("gamma_red", new Long(gammaRed));
                            this.properties.put("gamma_green", new Long(gammaGreen));
                            this.properties.put("gamma_blue", new Long(gammaBlue));
                            throw new RuntimeException(JaiI18N.getString("BMPImageDecoder2"));
                        }
                        case 1: {
                            this.properties.put("color_space", "LCS_sRGB");
                            break;
                        }
                        case 2: {
                            this.properties.put("color_space", "LCS_CMYK");
                            throw new RuntimeException(JaiI18N.getString("BMPImageDecoder2"));
                        }
                    }
                    if (this.bitsPerPixel == 1) {
                        this.imageType = 10;
                    } else if (this.bitsPerPixel == 4) {
                        this.imageType = 11;
                    } else if (this.bitsPerPixel == 8) {
                        this.imageType = 12;
                    } else if (this.bitsPerPixel == 16) {
                        this.imageType = 13;
                        if ((int)this.compression == 0) {
                            this.redMask = 31744;
                            this.greenMask = 992;
                            this.blueMask = 31;
                        }
                    } else if (this.bitsPerPixel == 24) {
                        this.imageType = 14;
                    } else if (this.bitsPerPixel == 32) {
                        this.imageType = 15;
                        if ((int)this.compression == 0) {
                            this.redMask = 0xFF0000;
                            this.greenMask = 65280;
                            this.blueMask = 255;
                        }
                    }
                    this.properties.put("red_mask", new Integer(this.redMask));
                    this.properties.put("green_mask", new Integer(this.greenMask));
                    this.properties.put("blue_mask", new Integer(this.blueMask));
                    this.properties.put("alpha_mask", new Integer(alphaMask));
                    this.computeShifts();
                    break block69;
                }
                this.properties.put("bmp_version", "BMP v. 5.x");
                throw new RuntimeException(JaiI18N.getString("BMPImageDecoder4"));
            }
            catch (IOException ioe) {
                throw new RuntimeException(JaiI18N.getString("BMPImageDecoder5"));
            }
        }
        if (this.height > 0) {
            this.isBottomUp = true;
        } else {
            this.isBottomUp = false;
            this.height = Math.abs(this.height);
        }
        this.tileWidth = this.width;
        this.tileHeight = this.height;
        if (this.bitsPerPixel == 1 || this.bitsPerPixel == 4 || this.bitsPerPixel == 8) {
            int off;
            byte[] b;
            byte[] g;
            byte[] r;
            int size;
            this.numBands = 1;
            this.sampleModel = this.bitsPerPixel == 8 ? RasterFactory.createPixelInterleavedSampleModel(0, this.width, this.height, this.numBands) : new MultiPixelPackedSampleModel(0, this.width, this.height, this.bitsPerPixel);
            if (this.imageType == 0 || this.imageType == 1 || this.imageType == 2) {
                size = this.palette.length / 3;
                if (size > 256) {
                    size = 256;
                }
                r = new byte[size];
                g = new byte[size];
                b = new byte[size];
                int i = 0;
                while (i < size) {
                    off = 3 * i;
                    b[i] = this.palette[off];
                    g[i] = this.palette[off + 1];
                    r[i] = this.palette[off + 2];
                    ++i;
                }
            } else {
                size = this.palette.length / 4;
                if (size > 256) {
                    size = 256;
                }
                r = new byte[size];
                g = new byte[size];
                b = new byte[size];
                int i = 0;
                while (i < size) {
                    off = 4 * i;
                    b[i] = this.palette[off];
                    g[i] = this.palette[off + 1];
                    r[i] = this.palette[off + 2];
                    ++i;
                }
            }
            this.colorModel = new IndexColorModel(this.bitsPerPixel, size, r, g, b);
        } else {
            this.numBands = 3;
            this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(0, this.width, this.height, this.numBands);
            this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
        }
    }

    private void read1Bit(byte[] bdata, int paletteEntries) {
        int i;
        int padding = 0;
        int bytesPerScanline = (int)Math.ceil((double)this.width / 8.0);
        int remainder = bytesPerScanline % 4;
        if (remainder != 0) {
            padding = 4 - remainder;
        }
        int imSize = (bytesPerScanline + padding) * this.height;
        byte[] values = new byte[imSize];
        try {
            int bytesRead = 0;
            while (bytesRead < imSize) {
                bytesRead += this.inputStream.read(values, bytesRead, imSize - bytesRead);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(JaiI18N.getString("BMPImageDecoder6"));
        }
        if (this.isBottomUp) {
            i = 0;
            while (i < this.height) {
                System.arraycopy(values, imSize - (i + 1) * (bytesPerScanline + padding), bdata, i * bytesPerScanline, bytesPerScanline);
                ++i;
            }
        } else {
            i = 0;
            while (i < this.height) {
                System.arraycopy(values, i * (bytesPerScanline + padding), bdata, i * bytesPerScanline, bytesPerScanline);
                ++i;
            }
        }
    }

    private void read4Bit(byte[] bdata, int paletteEntries) {
        int i;
        int padding = 0;
        int bytesPerScanline = (int)Math.ceil((double)this.width / 2.0);
        int remainder = bytesPerScanline % 4;
        if (remainder != 0) {
            padding = 4 - remainder;
        }
        int imSize = (bytesPerScanline + padding) * this.height;
        byte[] values = new byte[imSize];
        try {
            int bytesRead = 0;
            while (bytesRead < imSize) {
                bytesRead += this.inputStream.read(values, bytesRead, imSize - bytesRead);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(JaiI18N.getString("BMPImageDecoder6"));
        }
        if (this.isBottomUp) {
            i = 0;
            while (i < this.height) {
                System.arraycopy(values, imSize - (i + 1) * (bytesPerScanline + padding), bdata, i * bytesPerScanline, bytesPerScanline);
                ++i;
            }
        } else {
            i = 0;
            while (i < this.height) {
                System.arraycopy(values, i * (bytesPerScanline + padding), bdata, i * bytesPerScanline, bytesPerScanline);
                ++i;
            }
        }
    }

    private void read8Bit(byte[] bdata, int paletteEntries) {
        int i;
        int padding = 0;
        int bitsPerScanline = this.width * 8;
        if (bitsPerScanline % 32 != 0) {
            padding = (bitsPerScanline / 32 + 1) * 32 - bitsPerScanline;
            padding = (int)Math.ceil((double)padding / 8.0);
        }
        int imSize = (this.width + padding) * this.height;
        byte[] values = new byte[imSize];
        try {
            int bytesRead = 0;
            while (bytesRead < imSize) {
                bytesRead += this.inputStream.read(values, bytesRead, imSize - bytesRead);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(JaiI18N.getString("BMPImageDecoder6"));
        }
        if (this.isBottomUp) {
            i = 0;
            while (i < this.height) {
                System.arraycopy(values, imSize - (i + 1) * (this.width + padding), bdata, i * this.width, this.width);
                ++i;
            }
        } else {
            i = 0;
            while (i < this.height) {
                System.arraycopy(values, i * (this.width + padding), bdata, i * this.width, this.width);
                ++i;
            }
        }
    }

    private void read24Bit(byte[] bdata) {
        int imSize;
        int padding = 0;
        int bitsPerScanline = this.width * 24;
        if (bitsPerScanline % 32 != 0) {
            padding = (bitsPerScanline / 32 + 1) * 32 - bitsPerScanline;
            padding = (int)Math.ceil((double)padding / 8.0);
        }
        if ((imSize = (int)this.imageSize) == 0) {
            imSize = (int)(this.bitmapFileSize - this.bitmapOffset);
        }
        byte[] values = new byte[imSize];
        try {
            int bytesRead = 0;
            while (bytesRead < imSize) {
                bytesRead += this.inputStream.read(values, bytesRead, imSize - bytesRead);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
        int l = 0;
        if (this.isBottomUp) {
            int max = this.width * this.height * 3 - 1;
            int count = -padding;
            int i = 0;
            while (i < this.height) {
                l = max - (i + 1) * this.width * 3 + 1;
                count += padding;
                int j = 0;
                while (j < this.width) {
                    bdata[l++] = values[count++];
                    bdata[l++] = values[count++];
                    bdata[l++] = values[count++];
                    ++j;
                }
                ++i;
            }
        } else {
            int count = -padding;
            int i = 0;
            while (i < this.height) {
                count += padding;
                int j = 0;
                while (j < this.width) {
                    bdata[l++] = values[count++];
                    bdata[l++] = values[count++];
                    bdata[l++] = values[count++];
                    ++j;
                }
                ++i;
            }
        }
    }

    private void read16Bit(byte[] bdata) {
        int imSize;
        int padding = 0;
        int bitsPerScanline = this.width * 16;
        if (bitsPerScanline % 32 != 0) {
            padding = (bitsPerScanline / 32 + 1) * 32 - bitsPerScanline;
            padding = (int)Math.ceil((double)padding / 8.0);
        }
        if ((imSize = (int)this.imageSize) == 0) {
            imSize = (int)(this.bitmapFileSize - this.bitmapOffset);
        }
        int l = 0;
        try {
            if (this.isBottomUp) {
                int max = this.width * this.height * 3 - 1;
                int i = 0;
                while (i < this.height) {
                    l = max - (i + 1) * this.width * 3 + 1;
                    int j = 0;
                    while (j < this.width) {
                        int value = this.readWord(this.inputStream);
                        bdata[l++] = (byte)((value & this.blueMask) >> this.blueBits);
                        bdata[l++] = (byte)((value & this.greenMask) >> this.greenBits);
                        bdata[l++] = (byte)((value & this.redMask) >> this.redBits);
                        ++j;
                    }
                    int m = 0;
                    while (m < padding) {
                        this.inputStream.read();
                        ++m;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.height) {
                    int j = 0;
                    while (j < this.width) {
                        int value = this.readWord(this.inputStream);
                        bdata[l++] = (byte)((value & this.blueMask) >> this.blueBits);
                        bdata[l++] = (byte)((value & this.greenMask) >> this.greenBits);
                        bdata[l++] = (byte)((value & this.redMask) >> this.redBits);
                        ++j;
                    }
                    int m = 0;
                    while (m < padding) {
                        this.inputStream.read();
                        ++m;
                    }
                    ++i;
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(JaiI18N.getString("BMPImageDecoder6"));
        }
    }

    private void read32Bit(byte[] bdata) {
        int imSize = (int)this.imageSize;
        if (imSize == 0) {
            imSize = (int)(this.bitmapFileSize - this.bitmapOffset);
        }
        int l = 0;
        try {
            if (this.isBottomUp) {
                int max = this.width * this.height * 3 - 1;
                int i = 0;
                while (i < this.height) {
                    l = max - (i + 1) * this.width * 3 + 1;
                    int j = 0;
                    while (j < this.width) {
                        int value = (int)this.readDWord(this.inputStream);
                        bdata[l++] = (byte)((value & this.blueMask) >> this.blueBits);
                        bdata[l++] = (byte)((value & this.greenMask) >> this.greenBits);
                        bdata[l++] = (byte)((value & this.redMask) >> this.redBits);
                        ++j;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.height) {
                    int j = 0;
                    while (j < this.width) {
                        int value = (int)this.readDWord(this.inputStream);
                        bdata[l++] = (byte)((value & this.blueMask) >> this.blueBits);
                        bdata[l++] = (byte)((value & this.greenMask) >> this.greenBits);
                        bdata[l++] = (byte)((value & this.redMask) >> this.redBits);
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(JaiI18N.getString("BMPImageDecoder6"));
        }
    }

    private void readRLE8(byte[] bdata) {
        int imSize = (int)this.imageSize;
        if (imSize == 0) {
            imSize = (int)(this.bitmapFileSize - this.bitmapOffset);
        }
        int padding = 0;
        int remainder = this.width % 4;
        if (remainder != 0) {
            padding = 4 - remainder;
        }
        byte[] values = new byte[imSize];
        try {
            int bytesRead = 0;
            while (bytesRead < imSize) {
                bytesRead += this.inputStream.read(values, bytesRead, imSize - bytesRead);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(JaiI18N.getString("BMPImageDecoder6"));
        }
        byte[] val = this.decodeRLE8(imSize, padding, values);
        imSize = this.width * this.height;
        if (this.isBottomUp) {
            int bytesPerScanline = this.width;
            int i = 0;
            while (i < this.height) {
                System.arraycopy(val, imSize - (i + 1) * bytesPerScanline, bdata, i * bytesPerScanline, bytesPerScanline);
                ++i;
            }
        } else {
            bdata = val;
        }
    }

    private byte[] decodeRLE8(int imSize, int padding, byte[] values) {
        byte[] val = new byte[this.width * this.height];
        int count = 0;
        int l = 0;
        boolean flag = false;
        while (count != imSize) {
            int value;
            if ((value = values[count++] & 0xFF) == 0) {
                switch (values[count++] & 0xFF) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        flag = true;
                        break;
                    }
                    case 2: {
                        int xoff = values[count++] & 0xFF;
                        int yoff = values[count] & 0xFF;
                        l += xoff + yoff * this.width;
                        break;
                    }
                    default: {
                        int end = values[count - 1] & 0xFF;
                        int i = 0;
                        while (i < end) {
                            val[l++] = (byte)(values[count++] & 0xFF);
                            ++i;
                        }
                        if (!this.isEven(end)) {
                            ++count;
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                int i = 0;
                while (i < value) {
                    val[l++] = (byte)(values[count] & 0xFF);
                    ++i;
                }
                ++count;
            }
            if (flag) break;
        }
        return val;
    }

    private int[] readRLE4() {
        int imSize = (int)this.imageSize;
        if (imSize == 0) {
            imSize = (int)(this.bitmapFileSize - this.bitmapOffset);
        }
        int padding = 0;
        int remainder = this.width % 4;
        if (remainder != 0) {
            padding = 4 - remainder;
        }
        int[] values = new int[imSize];
        try {
            int i = 0;
            while (i < imSize) {
                values[i] = this.inputStream.read();
                ++i;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(JaiI18N.getString("BMPImageDecoder6"));
        }
        int[] val = this.decodeRLE4(imSize, padding, values);
        if (this.isBottomUp) {
            int[] inverted = val;
            val = new int[this.width * this.height];
            int l = 0;
            int i = this.height - 1;
            while (i >= 0) {
                int index = i * this.width;
                int lineEnd = l + this.width;
                while (l != lineEnd) {
                    val[l++] = inverted[index++];
                }
                --i;
            }
        }
        return val;
    }

    private int[] decodeRLE4(int imSize, int padding, int[] values) {
        int[] val = new int[this.width * this.height];
        int count = 0;
        int l = 0;
        boolean flag = false;
        while (count != imSize) {
            int value;
            if ((value = values[count++]) == 0) {
                switch (values[count++]) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        flag = true;
                        break;
                    }
                    case 2: {
                        int xoff = values[count++];
                        int yoff = values[count];
                        l += xoff + yoff * this.width;
                        break;
                    }
                    default: {
                        int end = values[count - 1];
                        int i = 0;
                        while (i < end) {
                            val[l++] = this.isEven(i) ? (values[count] & 0xF0) >> 4 : values[count++] & 0xF;
                            ++i;
                        }
                        if (!this.isEven(end)) {
                            ++count;
                        }
                        if (!this.isEven((int)Math.ceil(end / 2))) {
                            ++count;
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                int[] alternate = new int[]{(values[count] & 0xF0) >> 4, values[count] & 0xF};
                int i = 0;
                while (i < value) {
                    val[l++] = alternate[i % 2];
                    ++i;
                }
                ++count;
            }
            if (flag) break;
        }
        return val;
    }

    private boolean isEven(int number) {
        return number % 2 == 0;
    }

    private void computeShifts() {
        this.redBits = this.computeShift(this.redMask);
        this.greenBits = this.computeShift(this.greenMask);
        this.blueBits = this.computeShift(this.blueMask);
    }

    private int computeShift(int hexNumber) {
        int factor = 1;
        int result = 0;
        int count = 0;
        while (result == 0) {
            result = hexNumber & factor;
            ++count;
            factor <<= 1;
        }
        return count - 1;
    }

    private int readUnsignedByte(InputStream stream) throws IOException {
        return stream.read() & 0xFF;
    }

    private int readUnsignedShort(InputStream stream) throws IOException {
        int b1 = this.readUnsignedByte(stream);
        int b2 = this.readUnsignedByte(stream);
        return (b2 << 8 | b1) & 0xFFFF;
    }

    private int readShort(InputStream stream) throws IOException {
        int b1 = this.readUnsignedByte(stream);
        int b2 = this.readUnsignedByte(stream);
        return b2 << 8 | b1;
    }

    private int readWord(InputStream stream) throws IOException {
        return this.readUnsignedShort(stream);
    }

    private long readUnsignedInt(InputStream stream) throws IOException {
        int b1 = this.readUnsignedByte(stream);
        int b2 = this.readUnsignedByte(stream);
        int b3 = this.readUnsignedByte(stream);
        int b4 = this.readUnsignedByte(stream);
        long l = b4 << 24 | b3 << 16 | b2 << 8 | b1;
        return l & 0xFFFFFFFFFFFFFFFFL;
    }

    private int readInt(InputStream stream) throws IOException {
        int b1 = this.readUnsignedByte(stream);
        int b2 = this.readUnsignedByte(stream);
        int b3 = this.readUnsignedByte(stream);
        int b4 = this.readUnsignedByte(stream);
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    private long readDWord(InputStream stream) throws IOException {
        return this.readUnsignedInt(stream);
    }

    private int readLong(InputStream stream) throws IOException {
        return this.readInt(stream);
    }

    private synchronized Raster computeTile(int tileX, int tileY) {
        if (this.theTile != null) {
            return this.theTile;
        }
        Point org = new Point(this.tileXToX(tileX), this.tileYToY(tileY));
        WritableRaster tile = RasterFactory.createWritableRaster(this.sampleModel, org);
        DataBufferByte buffer = (DataBufferByte)tile.getDataBuffer();
        byte[] bdata = buffer.getData();
        block0 : switch (this.imageType) {
            case 0: {
                this.read1Bit(bdata, 3);
                break;
            }
            case 1: {
                this.read4Bit(bdata, 3);
                break;
            }
            case 2: {
                this.read8Bit(bdata, 3);
                break;
            }
            case 3: {
                this.read24Bit(bdata);
                break;
            }
            case 4: {
                this.read1Bit(bdata, 4);
                break;
            }
            case 5: {
                switch ((int)this.compression) {
                    case 0: {
                        this.read4Bit(bdata, 4);
                        break block0;
                    }
                    case 2: {
                        int[] pixels = this.readRLE4();
                        tile.setPixels(0, 0, this.width, this.height, pixels);
                        break block0;
                    }
                }
                throw new RuntimeException(JaiI18N.getString("BMPImageDecoder3"));
            }
            case 6: {
                switch ((int)this.compression) {
                    case 0: {
                        this.read8Bit(bdata, 4);
                        break block0;
                    }
                    case 1: {
                        this.readRLE8(bdata);
                        break block0;
                    }
                }
                throw new RuntimeException(JaiI18N.getString("BMPImageDecoder3"));
            }
            case 7: {
                this.read24Bit(bdata);
                break;
            }
            case 8: {
                this.read16Bit(bdata);
                break;
            }
            case 9: {
                this.read32Bit(bdata);
                break;
            }
            case 10: {
                this.read1Bit(bdata, 4);
                break;
            }
            case 11: {
                switch ((int)this.compression) {
                    case 0: {
                        this.read4Bit(bdata, 4);
                        break;
                    }
                    case 2: {
                        int[] pixels = this.readRLE4();
                        tile.setPixels(0, 0, this.width, this.height, pixels);
                        break;
                    }
                    default: {
                        throw new RuntimeException(JaiI18N.getString("BMPImageDecoder3"));
                    }
                }
            }
            case 12: {
                switch ((int)this.compression) {
                    case 0: {
                        this.read8Bit(bdata, 4);
                        break block0;
                    }
                    case 1: {
                        this.readRLE8(bdata);
                        break block0;
                    }
                }
                throw new RuntimeException(JaiI18N.getString("BMPImageDecoder3"));
            }
            case 13: {
                this.read16Bit(bdata);
                break;
            }
            case 14: {
                this.read24Bit(bdata);
                break;
            }
            case 15: {
                this.read32Bit(bdata);
            }
        }
        this.theTile = tile;
        return tile;
    }

    public synchronized Raster getTile(int tileX, int tileY) {
        if (tileX != 0 || tileY != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("BMPImageDecoder7"));
        }
        return this.computeTile(tileX, tileY);
    }
}

