/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io.image.codec;

import edu.cmu.cs.stage3.io.image.codec.BMPEncodeParam;
import edu.cmu.cs.stage3.io.image.codec.BMPImageDecoder;
import edu.cmu.cs.stage3.io.image.codec.BMPImageEncoder;
import edu.cmu.cs.stage3.io.image.codec.ImageCodec;
import edu.cmu.cs.stage3.io.image.codec.ImageDecodeParam;
import edu.cmu.cs.stage3.io.image.codec.ImageDecoder;
import edu.cmu.cs.stage3.io.image.codec.ImageEncodeParam;
import edu.cmu.cs.stage3.io.image.codec.ImageEncoder;
import edu.cmu.cs.stage3.io.image.codec.SeekableStream;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class BMPCodec
extends ImageCodec {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public String getFormatName() {
        return "bmp";
    }

    public Class getEncodeParamClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.cmu.cs.stage3.io.image.codec.BMPEncodeParam");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Class getDecodeParamClass() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public boolean canEncodeImage(RenderedImage im, ImageEncodeParam param) {
        SampleModel sampleModel = im.getSampleModel();
        int dataType = sampleModel.getTransferType();
        if (dataType == 1 || dataType == 2 || dataType == 3 || dataType == 4 || dataType == 5) {
            return false;
        }
        if (param != null) {
            if (!(param instanceof BMPEncodeParam)) {
                return false;
            }
            BMPEncodeParam BMPParam = (BMPEncodeParam)param;
            int version = BMPParam.getVersion();
            if (version == 0 || version == 2) {
                return false;
            }
        }
        return true;
    }

    protected ImageEncoder createImageEncoder(OutputStream dst, ImageEncodeParam param) {
        BMPEncodeParam p = null;
        if (param != null) {
            p = (BMPEncodeParam)param;
        }
        return new BMPImageEncoder(dst, p);
    }

    protected ImageDecoder createImageDecoder(InputStream src, ImageDecodeParam param) {
        return new BMPImageDecoder(src, null);
    }

    protected ImageDecoder createImageDecoder(File src, ImageDecodeParam param) throws IOException {
        return new BMPImageDecoder(new FileInputStream(src), null);
    }

    protected ImageDecoder createImageDecoder(SeekableStream src, ImageDecodeParam param) {
        return new BMPImageDecoder((InputStream)src, null);
    }

    public int getNumHeaderBytes() {
        return 2;
    }

    public boolean isFormatRecognized(byte[] header) {
        return header[0] == 66 && header[1] == 77;
    }
}

