/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer.nativerenderer;

import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;

public class ImageUtilities {
    private static ImageObserver s_imageObserver = new ImageObserver(){

        public boolean imageUpdate(Image image, int infoflags, int x, int y, int width, int height) {
            return true;
        }
    };

    private static void waitForImage(Image image) {
        while (image.getWidth(s_imageObserver) == -1 || image.getWidth(s_imageObserver) == -1) {
            Thread.yield();
        }
    }

    public static int[] getPixels(Image image) {
        ImageUtilities.waitForImage(image);
        int width = image.getWidth(s_imageObserver);
        int height = image.getHeight(s_imageObserver);
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("interrupted waiting for pixels");
        }
        if ((pg.getStatus() & 0x80) != 0) {
            throw new RuntimeException("image fetch aborted or errored");
        }
        return pixels;
    }

    public static int getWidth(Image image) {
        ImageUtilities.waitForImage(image);
        return image.getWidth(s_imageObserver);
    }

    public static int getHeight(Image image) {
        ImageUtilities.waitForImage(image);
        return image.getHeight(s_imageObserver);
    }
}

