/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer;

import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.OrthographicCamera;
import edu.cmu.cs.stage3.alice.scenegraph.PerspectiveCamera;
import edu.cmu.cs.stage3.alice.scenegraph.SymmetricPerspectiveCamera;
import edu.cmu.cs.stage3.alice.scenegraph.TextureMap;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.DisplayDevice;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.DisplayDriver;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.Renderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RenderTargetListener;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public interface RenderTarget {
    public static final boolean SUB_ELEMENT_IS_REQUIRED = true;
    public static final boolean SUB_ELEMENT_IS_NOT_REQUIRED = false;
    public static final boolean ONLY_FRONT_MOST_VISUAL_IS_REQUIRED = true;
    public static final boolean ALL_VISUALS_ARE_REQUIRED = false;

    public String getName();

    public void setName(String var1);

    public void release();

    public Renderer getRenderer();

    public void addCamera(Camera var1);

    public void removeCamera(Camera var1);

    public Camera[] getCameras();

    public void markDirty();

    public boolean clearAndRenderOffscreenIsRequired();

    public void clearAndRenderOffscreen();

    public boolean rendersOnEdgeTrianglesAsLines(OrthographicCamera var1);

    public void setRendersOnEdgeTrianglesAsLines(OrthographicCamera var1, boolean var2);

    public PickInfo pick(int var1, int var2, boolean var3, boolean var4);

    public Vector4d transformFromViewportToProjection(Vector3d var1, Camera var2);

    public Vector3d transformFromProjectionToCamera(Vector4d var1, Camera var2);

    public Vector3d transformFromViewportToCamera(Vector3d var1, Camera var2);

    public Vector4d transformFromCameraToProjection(Vector3d var1, Camera var2);

    public Vector3d transformFromProjectionToViewport(Vector4d var1, Camera var2);

    public Vector3d transformFromCameraToViewport(Vector3d var1, Camera var2);

    public Image getOffscreenImage();

    public Graphics getOffscreenGraphics();

    public Image getZBufferImage();

    public Image getImage(TextureMap var1);

    public Graphics getGraphics(TextureMap var1);

    public void copyOffscreenImageToTextureMap(TextureMap var1);

    public Dimension getSize();

    public Dimension getSize(Dimension var1);

    public double[] getActualPlane(OrthographicCamera var1);

    public double[] getActualPlane(PerspectiveCamera var1);

    public double getActualHorizontalViewingAngle(SymmetricPerspectiveCamera var1);

    public double getActualVerticalViewingAngle(SymmetricPerspectiveCamera var1);

    public Rectangle getActualViewport(Camera var1);

    public Matrix4d getProjectionMatrix(Camera var1);

    public Rectangle getViewport(Camera var1);

    public void setViewport(Camera var1, Rectangle var2);

    public boolean isLetterboxedAsOpposedToDistorted(Camera var1);

    public void setIsLetterboxedAsOpposedToDistorted(Camera var1, boolean var2);

    public void addRenderTargetListener(RenderTargetListener var1);

    public void removeRenderTargetListener(RenderTargetListener var1);

    public RenderTargetListener[] getRenderTargetListeners();

    public DisplayDriver getDisplayDriver();

    public void setDisplayDriver(DisplayDriver var1);

    public DisplayDevice getDisplayDevice();

    public void setDisplayDevice(DisplayDevice var1);

    public void setSilhouetteThickness(double var1);

    public double getSilhouetteThickness();
}

