/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer;

import edu.cmu.cs.stage3.alice.scenegraph.renderer.OffscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTargetFactory;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.Renderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RendererInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.util.RendererInfoSelector;

public class DefaultRenderTargetFactory
implements RenderTargetFactory {
    private Renderer m_renderer;

    public DefaultRenderTargetFactory() {
        this.setRendererInfo(null);
    }

    public DefaultRenderTargetFactory(Renderer renderer) {
        this.setRenderer(renderer);
    }

    public DefaultRenderTargetFactory(RendererInfo rendererInfo) {
        this.setRendererInfo(rendererInfo);
    }

    public DefaultRenderTargetFactory(String rendererInfoClassname) {
        try {
            Class<?> rendererInfoClass = Class.forName(rendererInfoClassname);
            RendererInfo rendererInfo = (RendererInfo)rendererInfoClass.newInstance();
            this.setRendererInfo(rendererInfo);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
    }

    private void setRendererInfo(RendererInfo rendererInfo) {
        if (rendererInfo == null) {
            rendererInfo = RendererInfoSelector.selectRendererInfo()[0];
        }
        Class rendererClass = rendererInfo.getRendererClass();
        try {
            Renderer renderer = (Renderer)rendererClass.newInstance();
            this.setRenderer(renderer);
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
    }

    public void setRenderer(Renderer renderer) {
        this.m_renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.m_renderer;
    }

    public OffscreenRenderTarget createOffscreenRenderTarget(long requiredCapabilities) {
        if (this.m_renderer != null) {
            return this.m_renderer.createOffscreenRenderTarget();
        }
        return null;
    }

    public OnscreenRenderTarget createOnscreenRenderTarget(long requiredCapabilities) {
        if (this.m_renderer != null) {
            return this.m_renderer.createOnscreenRenderTarget();
        }
        return null;
    }

    public void releaseOffscreenRenderTarget(OffscreenRenderTarget offscreenRenderTarget) {
        offscreenRenderTarget.release();
    }

    public void releaseOnscreenRenderTarget(OnscreenRenderTarget onscreenRenderTarget) {
        onscreenRenderTarget.release();
    }
}

