/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph.renderer;

import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.AbstractRenderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.Renderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.OnscreenRenderTargetEvent;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.OnscreenRenderTargetListener;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RenderTargetEvent;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RenderTargetListener;
import edu.cmu.cs.stage3.math.Vector3;
import edu.cmu.cs.stage3.math.Vector4;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Vector;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public abstract class AbstractRenderTarget
implements RenderTarget {
    private AbstractRenderer m_abstractRenderer;
    private Vector m_sgCameras = new Vector();
    private Camera[] m_sgCameraArray = null;
    private Vector m_renderTargetListeners = new Vector();
    private RenderTargetListener[] m_renderTargetListenerArray = null;
    private Vector m_onscreenRenderTargetListeners = new Vector();
    private OnscreenRenderTargetListener[] m_onscreenRenderTargetListenerArray = null;
    private String m_name = null;
    private boolean m_clearAndRenderOffscreenIsRequired = true;
    private boolean m_updateIsRequired = false;
    private boolean m_updateIsAutomatic = true;

    protected AbstractRenderTarget(AbstractRenderer abstractRenderer) {
        this.m_abstractRenderer = abstractRenderer;
        this.m_abstractRenderer.addRenderTarget(this);
    }

    public void release() {
        this.m_abstractRenderer.removeRenderTarget(this);
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    public Renderer getRenderer() {
        return this.m_abstractRenderer;
    }

    public Dimension getSize() {
        Dimension size = new Dimension();
        return this.getSize(size);
    }

    public boolean updateIsAutomatic() {
        return this.m_updateIsAutomatic;
    }

    public void setUpdateIsAutomatic(boolean updateIsAutomatic) {
        boolean repaintNecessary = updateIsAutomatic && !this.m_updateIsAutomatic;
        this.m_updateIsAutomatic = updateIsAutomatic;
        if (repaintNecessary) {
            this.markDirty();
        }
    }

    public boolean clearAndRenderOffscreenIsRequired() {
        return this.m_clearAndRenderOffscreenIsRequired;
    }

    public boolean updateIsRequired() {
        return this.m_updateIsRequired;
    }

    public void markDirty() {
        this.m_clearAndRenderOffscreenIsRequired = true;
        this.m_updateIsRequired = false;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void addCamera(Camera camera) {
        if (!this.m_sgCameras.contains(camera)) {
            this.m_sgCameras.addElement(camera);
            this.m_sgCameraArray = null;
        }
        this.markDirty();
    }

    public void removeCamera(Camera camera) {
        this.m_sgCameras.removeElement(camera);
        this.m_sgCameraArray = null;
        this.markDirty();
    }

    public Camera[] getCameras() {
        if (this.m_sgCameraArray == null) {
            this.m_sgCameraArray = new Camera[this.m_sgCameras.size()];
            this.m_sgCameras.copyInto(this.m_sgCameraArray);
        }
        return this.m_sgCameraArray;
    }

    public void clearCameras() {
        this.m_sgCameras.removeAllElements();
        this.markDirty();
    }

    public void addRenderTargetListener(RenderTargetListener renderTargetListener) {
        this.m_renderTargetListeners.addElement(renderTargetListener);
        this.m_renderTargetListenerArray = null;
    }

    public void removeRenderTargetListener(RenderTargetListener renderTargetListener) {
        this.m_renderTargetListeners.removeElement(renderTargetListener);
        this.m_renderTargetListenerArray = null;
    }

    public RenderTargetListener[] getRenderTargetListeners() {
        if (this.m_renderTargetListenerArray == null) {
            this.m_renderTargetListenerArray = new RenderTargetListener[this.m_renderTargetListeners.size()];
            this.m_renderTargetListeners.copyInto(this.m_renderTargetListenerArray);
        }
        return this.m_renderTargetListenerArray;
    }

    public void addOnscreenRenderTargetListener(OnscreenRenderTargetListener onscreenRenderTargetListener) {
        this.m_onscreenRenderTargetListeners.addElement(onscreenRenderTargetListener);
        this.m_onscreenRenderTargetListenerArray = null;
    }

    public void removeOnscreenRenderTargetListener(OnscreenRenderTargetListener onscreenRenderTargetListener) {
        this.m_onscreenRenderTargetListeners.removeElement(onscreenRenderTargetListener);
        this.m_onscreenRenderTargetListenerArray = null;
    }

    public OnscreenRenderTargetListener[] getOnscreenRenderTargetListeners() {
        if (this.m_onscreenRenderTargetListenerArray == null) {
            this.m_onscreenRenderTargetListenerArray = new OnscreenRenderTargetListener[this.m_onscreenRenderTargetListeners.size()];
            this.m_onscreenRenderTargetListeners.copyInto(this.m_onscreenRenderTargetListenerArray);
        }
        return this.m_onscreenRenderTargetListenerArray;
    }

    public Vector4d transformFromViewportToProjection(Vector3d xyz, Camera camera) {
        Rectangle viewport = this.getActualViewport(camera);
        double halfWidth = (double)viewport.width / 2.0;
        double halfHeight = (double)viewport.height / 2.0;
        double x = (xyz.x - halfWidth) / halfWidth;
        double y = -(xyz.y - halfHeight) / halfHeight;
        return new Vector4d(x, y, xyz.z, 1.0);
    }

    public Vector3d transformFromProjectionToCamera(Vector4d xyzw, Camera camera) {
        Matrix4d inverseProjectionMatrix = this.getProjectionMatrix(camera);
        inverseProjectionMatrix.invert();
        return new Vector3((Tuple4d)Vector4.multiply(xyzw, inverseProjectionMatrix));
    }

    public Vector3d transformFromViewportToCamera(Vector3d xyz, Camera camera) {
        return this.transformFromProjectionToCamera(this.transformFromViewportToProjection(xyz, camera), camera);
    }

    public Vector4d transformFromCameraToProjection(Vector3d xyz, Camera camera) {
        Matrix4d projectionMatrix = this.getProjectionMatrix(camera);
        return Vector4.multiply(new Vector4((Tuple3d)xyz, 1.0), projectionMatrix);
    }

    public Vector3d transformFromProjectionToViewport(Vector4d xyzw, Camera camera) {
        Rectangle viewport = this.getActualViewport(camera);
        double halfWidth = (double)viewport.width / 2.0;
        double halfHeight = (double)viewport.height / 2.0;
        Vector3 xyz = new Vector3((Tuple4d)xyzw);
        xyz.x = (xyz.x + 1.0) * halfWidth;
        xyz.y = (double)viewport.height - (xyz.y + 1.0) * halfHeight;
        return xyz;
    }

    public Vector3d transformFromCameraToViewport(Vector3d xyz, Camera camera) {
        return this.transformFromProjectionToViewport(this.transformFromCameraToProjection(xyz, camera), camera);
    }

    protected void onClear() {
        this.m_abstractRenderer.enterIgnore();
        RenderTargetEvent renderTargetEvent = new RenderTargetEvent(this);
        RenderTargetListener[] rtls = this.getRenderTargetListeners();
        int i = 0;
        while (i < rtls.length) {
            rtls[i].cleared(renderTargetEvent);
            ++i;
        }
        if (this instanceof OnscreenRenderTarget) {
            OnscreenRenderTargetListener[] ortls = ((OnscreenRenderTarget)((Object)this)).getOnscreenRenderTargetListeners();
            int i2 = 0;
            while (i2 < ortls.length) {
                ortls[i2].cleared(renderTargetEvent);
                ++i2;
            }
        }
        this.m_abstractRenderer.leaveIgnore();
    }

    protected void onRender() {
        this.m_abstractRenderer.enterIgnore();
        RenderTargetEvent renderTargetEvent = new RenderTargetEvent(this);
        RenderTargetListener[] rtls = this.getRenderTargetListeners();
        int i = 0;
        while (i < rtls.length) {
            rtls[i].rendered(renderTargetEvent);
            ++i;
        }
        if (this instanceof OnscreenRenderTarget) {
            OnscreenRenderTargetListener[] ortls = ((OnscreenRenderTarget)((Object)this)).getOnscreenRenderTargetListeners();
            int i2 = 0;
            while (i2 < ortls.length) {
                ortls[i2].rendered(renderTargetEvent);
                ++i2;
            }
        }
        this.m_abstractRenderer.leaveIgnore();
        this.m_clearAndRenderOffscreenIsRequired = false;
        this.m_updateIsRequired = true;
    }

    protected void onUpdate() {
        if (this instanceof OnscreenRenderTarget) {
            this.m_abstractRenderer.enterIgnore();
            OnscreenRenderTargetEvent renderTargetEvent = new OnscreenRenderTargetEvent((OnscreenRenderTarget)((Object)this));
            OnscreenRenderTargetListener[] ortls = ((OnscreenRenderTarget)((Object)this)).getOnscreenRenderTargetListeners();
            int i = 0;
            while (i < ortls.length) {
                ortls[i].updated(renderTargetEvent);
                ++i;
            }
            this.m_abstractRenderer.leaveIgnore();
            this.m_updateIsRequired = false;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getName() + "]";
    }
}

