/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Affector;
import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.Property;
import edu.cmu.cs.stage3.math.Box;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Sphere;
import edu.cmu.cs.stage3.math.Vector3;
import edu.cmu.cs.stage3.math.Vector4;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;

public class Visual
extends Component {
    public static final Property FRONT_FACING_APPEARANCE_PROPERTY;
    public static final Property BACK_FACING_APPEARANCE_PROPERTY;
    public static final Property GEOMETRY_PROPERTY;
    public static final Property SCALE_PROPERTY;
    public static final Property IS_SHOWING_PROPERTY;
    public static final Property DISABLED_AFFECTORS_PROPERTY;
    private Appearance m_frontFacingAppearance = null;
    private Appearance m_backFacingAppearance = null;
    private Geometry m_geometry = null;
    private Matrix3d m_scale = new Matrix3d();
    private boolean m_isShowing = true;
    private Affector[] m_disabledAffectors = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.cmu.cs.stage3.alice.scenegraph.Visual");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FRONT_FACING_APPEARANCE_PROPERTY = new Property(clazz, "FRONT_FACING_APPEARANCE");
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("edu.cmu.cs.stage3.alice.scenegraph.Visual");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BACK_FACING_APPEARANCE_PROPERTY = new Property(clazz2, "BACK_FACING_APPEARANCE");
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("edu.cmu.cs.stage3.alice.scenegraph.Visual");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GEOMETRY_PROPERTY = new Property(clazz3, "GEOMETRY");
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("edu.cmu.cs.stage3.alice.scenegraph.Visual");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SCALE_PROPERTY = new Property(clazz4, "SCALE");
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("edu.cmu.cs.stage3.alice.scenegraph.Visual");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IS_SHOWING_PROPERTY = new Property(clazz5, "IS_SHOWING");
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("edu.cmu.cs.stage3.alice.scenegraph.Visual");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DISABLED_AFFECTORS_PROPERTY = new Property(clazz6, "DISABLED_AFFECTORS");
    }

    public Visual() {
        this.m_scale.setIdentity();
    }

    protected void releasePass1() {
        if (this.m_frontFacingAppearance != null) {
            Element.warnln("WARNING: released visual " + this + " still has front facing appearance " + this.m_frontFacingAppearance + ".");
            this.setFrontFacingAppearance(null);
        }
        if (this.m_backFacingAppearance != null) {
            Element.warnln("WARNING: released visual " + this + " still has back facing appearance " + this.m_frontFacingAppearance + ".");
            this.setBackFacingAppearance(null);
        }
        if (this.m_geometry != null) {
            Element.warnln("WARNING: released visual " + this + " still has geometry " + this.m_geometry + ".");
            this.setGeometry(null);
        }
        if (this.m_disabledAffectors != null && this.m_disabledAffectors.length > 0) {
            Element.warnln("WARNING: released visual " + this + " still has disabled affectors: ");
            int i = 0;
            while (i < this.m_disabledAffectors.length) {
                Element.warnln("\t" + this.m_disabledAffectors[i]);
                ++i;
            }
            this.setDisabledAffectors(null);
        }
        super.releasePass1();
    }

    public Geometry getGeometry() {
        return this.m_geometry;
    }

    public void setGeometry(Geometry geometry) {
        if (Element.notequal(this.m_geometry, geometry)) {
            this.m_geometry = geometry;
            this.onPropertyChange(GEOMETRY_PROPERTY);
        }
    }

    public Appearance getFrontFacingAppearance() {
        return this.m_frontFacingAppearance;
    }

    public void setFrontFacingAppearance(Appearance frontFacingAppearance) {
        if (Element.notequal(this.m_frontFacingAppearance, frontFacingAppearance)) {
            this.m_frontFacingAppearance = frontFacingAppearance;
            this.onPropertyChange(FRONT_FACING_APPEARANCE_PROPERTY);
        }
    }

    public Appearance getBackFacingAppearance() {
        return this.m_backFacingAppearance;
    }

    public void setBackFacingAppearance(Appearance backFacingAppearance) {
        if (Element.notequal(this.m_backFacingAppearance, backFacingAppearance)) {
            this.m_backFacingAppearance = backFacingAppearance;
            this.onPropertyChange(BACK_FACING_APPEARANCE_PROPERTY);
        }
    }

    public Matrix3d getScale() {
        return this.m_scale;
    }

    public void setScale(Matrix3d scale) {
        if (Element.notequal(this.m_scale, scale)) {
            this.m_scale = scale;
            this.onPropertyChange(SCALE_PROPERTY);
        }
    }

    public boolean getIsShowing() {
        return this.m_isShowing;
    }

    public void setIsShowing(boolean isShowing) {
        if (this.m_isShowing != isShowing) {
            this.m_isShowing = isShowing;
            this.onPropertyChange(IS_SHOWING_PROPERTY);
        }
    }

    public Affector[] getDisabledAffectors() {
        return this.m_disabledAffectors;
    }

    public void setDisabledAffectors(Affector[] disabledAffectors) {
        if (Element.notequal(this.m_disabledAffectors, disabledAffectors)) {
            this.m_disabledAffectors = disabledAffectors;
            this.onPropertyChange(DISABLED_AFFECTORS_PROPERTY);
        }
    }

    public Box getBoundingBox() {
        if (this.m_geometry != null) {
            Box box = this.m_geometry.getBoundingBox();
            if (box != null) {
                box.scale(this.m_scale);
            }
            return box;
        }
        return null;
    }

    public Sphere getBoundingSphere() {
        if (this.m_geometry != null) {
            Sphere sphere = this.m_geometry.getBoundingSphere();
            if (sphere != null) {
                sphere.scale(this.m_scale);
            }
            return sphere;
        }
        return null;
    }

    public void transform(Matrix4d trans) {
        Geometry geometry = this.getGeometry();
        if (geometry != null) {
            geometry.transform(trans);
        }
    }

    public boolean isInProjectionVolumeOf(Camera camera) {
        Sphere boundingSphere = this.getBoundingSphere();
        if (boundingSphere != null) {
            Matrix4d cameraProjection = camera.getProjection();
            Matrix4d cameraInverse = camera.getInverseAbsoluteTransformation();
            Matrix4d absolute = this.getAbsoluteTransformation();
            Matrix44 m = Matrix44.multiply(absolute, Matrix44.multiply(cameraInverse, cameraProjection));
            Vector4 centerV4 = new Vector4((Tuple3d)boundingSphere.getCenter(), 1.0);
            centerV4 = Vector4.multiply(centerV4, m);
            Vector3 centerV3 = new Vector3(centerV4.x / centerV4.w, centerV4.y / centerV4.w, centerV4.z / centerV4.w);
            if (centerV3.x <= 1.0 && centerV3.x >= -1.0 && centerV3.y <= 1.0 && centerV3.y >= -1.0 && centerV3.z <= 1.0 && centerV3.z >= 0.0) {
                return true;
            }
        }
        return false;
    }
}

