/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.scenegraph;

import edu.cmu.cs.stage3.alice.scenegraph.Element;
import edu.cmu.cs.stage3.alice.scenegraph.PropertyValuePair;
import edu.cmu.cs.stage3.util.HowMuch;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;

public class Property {
    private Method m_getter;
    private Method m_setter;
    private Method m_setterHowMuch;
    private Class m_elementClass;
    private Class m_valueClass;
    private String m_capsAndUnderscoresName;
    private String m_mixedCaseName;
    private boolean m_isPersistent;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Property(Class elementClass, String capsAndUnderscoresName, boolean isPersistent) {
        Class[] parameterTypes;
        this.m_capsAndUnderscoresName = capsAndUnderscoresName;
        this.m_mixedCaseName = new String(Property.convertAllCapsAndUnderscoresToMixedCase(capsAndUnderscoresName));
        try {
            parameterTypes = new Class[]{};
            this.m_getter = elementClass.getDeclaredMethod("get" + this.m_mixedCaseName, parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            Element.warnln("get" + this.m_mixedCaseName);
            nsme.printStackTrace();
        }
        this.m_valueClass = this.m_getter.getReturnType();
        try {
            parameterTypes = new Class[]{this.m_valueClass};
            this.m_setter = elementClass.getDeclaredMethod("set" + this.m_mixedCaseName, parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
        try {
            Class[] classArray = new Class[2];
            classArray[0] = this.m_valueClass;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.cmu.cs.stage3.util.HowMuch");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz;
            parameterTypes = classArray;
            this.m_setterHowMuch = elementClass.getDeclaredMethod("set" + this.m_mixedCaseName, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (this.m_getter == null || this.m_setter == null) {
            throw new NullPointerException();
        }
        this.m_elementClass = elementClass;
        this.m_isPersistent = isPersistent;
    }

    public Property(Class elementClass, String capsAndUnderscoresName) {
        this(elementClass, capsAndUnderscoresName, true);
    }

    public boolean acceptsHowMuch() {
        return this.m_setterHowMuch != null;
    }

    public Object get(Object o) {
        Object[] getParameters = new Object[]{};
        try {
            return this.m_getter.invoke(o, getParameters);
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (Exception e) {
            Element.warnln(this.m_getter);
            Element.warnln(o);
            if (o != null) {
                Element.warnln(o.getClass());
            }
            e.printStackTrace();
        }
        return null;
    }

    public double getDouble(Object o) {
        return ((Number)this.get(o)).doubleValue();
    }

    public int getInt(Object o) {
        return ((Number)this.get(o)).intValue();
    }

    public boolean getBoolean(Object o) {
        return (Boolean)this.get(o);
    }

    public void set(Object o, Object value) {
        try {
            Object[] setParameters = new Object[]{value};
            this.m_setter.invoke(o, setParameters);
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (NullPointerException npe) {
            Element.warnln(npe);
        }
        catch (Exception e) {
            Element.warnln(e);
            Element.warnln(this.m_setter);
            if (o != null) {
                Element.warnln(o);
                Element.warnln(o.getClass());
            } else {
                Element.warnln("null");
            }
            if (value != null) {
                Element.warnln(value);
                Element.warnln(value.getClass());
            } else {
                Element.warnln("null");
            }
            e.printStackTrace();
        }
    }

    public void set(Object o, Object value, HowMuch howMuch) {
        try {
            if (this.m_setterHowMuch != null) {
                Object[] setParameters = new Object[]{value, howMuch};
                this.m_setterHowMuch.invoke(o, setParameters);
            } else {
                Element.warnln("ignoring howMuch");
                this.set(o, value);
            }
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (NullPointerException npe) {
            Element.warnln(npe);
        }
    }

    public Class getElementClass() {
        return this.m_elementClass;
    }

    public Class getValueClass() {
        return this.m_valueClass;
    }

    public boolean getIsPersistent() {
        return this.m_isPersistent;
    }

    public String getMixedCaseName() {
        return this.m_mixedCaseName;
    }

    public String getCapsAndUnderscoresName() {
        return this.m_capsAndUnderscoresName;
    }

    public String toString() {
        return String.valueOf(this.m_elementClass.getName()) + "." + this.m_capsAndUnderscoresName + "_PROPERTY";
    }

    public static Property valueOf(String propertyName) {
        int i = propertyName.lastIndexOf(46);
        String classPart = propertyName.substring(0, i);
        String fieldPart = propertyName.substring(i + 1);
        try {
            Object o;
            Class<?> cls = Class.forName(classPart);
            Field field = cls.getField(fieldPart);
            int modifiers = field.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isFinal(modifiers) && Modifier.isStatic(modifiers) && (o = field.get(null)) instanceof Property) {
                return (Property)o;
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (NoSuchFieldException nsfe) {
            Element.warnln("backward compatibility? skipping: " + propertyName + " " + nsfe);
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        return null;
    }

    public static Vector getProperties(Class cls, boolean persistentOnly, boolean declaredOnly) {
        Vector<Property> v = new Vector<Property>();
        Field[] fields = declaredOnly ? cls.getDeclaredFields() : cls.getFields();
        int i = 0;
        while (i < fields.length) {
            int modifiers = fields[i].getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                try {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("edu.cmu.cs.stage3.alice.scenegraph.Property");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.isAssignableFrom(fields[i].getType())) {
                        Property property = (Property)fields[i].get(null);
                        if (!persistentOnly || property.getIsPersistent()) {
                            v.addElement(property);
                        }
                    }
                }
                catch (IllegalAccessException iae) {
                    iae.printStackTrace();
                }
            }
            ++i;
        }
        return v;
    }

    public static Vector getProperties(Class cls) {
        return Property.getProperties(cls, false, false);
    }

    public static Property getPropertyMixedCaseNamed(Class cls, String mixedCaseName) {
        Enumeration enumeration = Property.getProperties(cls).elements();
        while (enumeration.hasMoreElements()) {
            Property property = (Property)enumeration.nextElement();
            if (!property.getMixedCaseName().equals(mixedCaseName)) continue;
            return property;
        }
        return null;
    }

    public static Property getPropertyCapsAndUnderscoresNamed(Class cls, String capsAndUnderscoresName) {
        Enumeration enumeration = Property.getProperties(cls).elements();
        while (enumeration.hasMoreElements()) {
            Property property = (Property)enumeration.nextElement();
            if (!property.getCapsAndUnderscoresName().equals(capsAndUnderscoresName)) continue;
            return property;
        }
        return null;
    }

    public static Vector getPropertyValuePairs(Object o, boolean persistentOnly, boolean declaredOnly) {
        Vector<PropertyValuePair> v = new Vector<PropertyValuePair>();
        Enumeration enumeration = Property.getProperties(o.getClass(), persistentOnly, declaredOnly).elements();
        while (enumeration.hasMoreElements()) {
            Property property = (Property)enumeration.nextElement();
            v.addElement(new PropertyValuePair(property, property.get(o)));
        }
        return v;
    }

    public static Vector getPropertyValuePairs(Object o) {
        return Property.getPropertyValuePairs(o, false, false);
    }

    public static StringBuffer convertAllCapsAndUnderscoresToMixedCase(String allCapsAndUnderscores) {
        StringBuffer mixedCase = new StringBuffer();
        mixedCase.append(allCapsAndUnderscores.charAt(0));
        boolean lowerCase = true;
        int lcv = 1;
        while (lcv < allCapsAndUnderscores.length()) {
            char c = allCapsAndUnderscores.charAt(lcv);
            if (c == '_') {
                lowerCase = false;
            } else {
                if (lowerCase) {
                    mixedCase.append(Character.toLowerCase(c));
                } else {
                    mixedCase.append(c);
                }
                lowerCase = true;
            }
            ++lcv;
        }
        return mixedCase;
    }

    public static StringBuffer convertMixedCaseToAllCapsAndUnderscores(String mixedCase) {
        StringBuffer allCapsAndUnderscores = new StringBuffer();
        allCapsAndUnderscores.append(mixedCase.charAt(0));
        int lcv = 1;
        while (lcv < mixedCase.length()) {
            char c = mixedCase.charAt(lcv);
            if (Character.isUpperCase(c)) {
                allCapsAndUnderscores.append("_" + c);
            } else {
                allCapsAndUnderscores.append(Character.toUpperCase(c));
            }
            ++lcv;
        }
        return allCapsAndUnderscores;
    }
}

